/*
 * Decompiled with CFR 0.152.
 */
package no.uib.jsparklines.renderers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.renderers.util.BarChartColorRenderer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class JSparklinesIntegerColorTableCellRenderer
extends JPanel
implements TableCellRenderer {
    private int labelHorizontalAlignement = 4;
    private ChartPanel chartPanel;
    private JFreeChart chart;
    private JLabel valueLabel;
    private boolean showNumbers = false;
    private boolean showNumberAndChart = false;
    private int widthOfValueLabel = 40;
    private Color plotBackgroundColor = null;
    private Color defaultColor;
    private HashMap<Integer, Color> colors;
    private HashMap<Integer, String> tooltips;

    public JSparklinesIntegerColorTableCellRenderer(Color defaultColor, HashMap<Integer, Color> colors) {
        this(defaultColor, colors, new HashMap<Integer, String>());
    }

    public JSparklinesIntegerColorTableCellRenderer(Color defaultColor, HashMap<Integer, Color> colors, HashMap<Integer, String> tooltips) {
        this.defaultColor = defaultColor;
        this.colors = colors;
        this.tooltips = tooltips;
        this.setUpRendererAndChart();
    }

    private void setUpRendererAndChart() {
        this.setName("Table.cellRenderer");
        this.setLayout(new BorderLayout());
        this.valueLabel = new JLabel("");
        this.valueLabel.setMinimumSize(new Dimension(this.widthOfValueLabel, 0));
        this.valueLabel.setHorizontalAlignment(0);
        this.valueLabel.setFont(this.valueLabel.getFont().deriveFont((float)this.valueLabel.getFont().getSize() - 2.0f));
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        this.chart = ChartFactory.createBarChart(null, null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)false, (boolean)false);
        this.chartPanel = new ChartPanel(this.chart);
        this.setLayout(new BoxLayout(this, 2));
        this.add(this.valueLabel);
        this.add((Component)this.chartPanel);
    }

    public void setBackgroundColor(Color plotBackgroundColor) {
        this.plotBackgroundColor = plotBackgroundColor;
    }

    public void showNumberAndChart(boolean showNumberAndChart, int widthOfLabel) {
        this.showNumberAndChart = showNumberAndChart;
        this.widthOfValueLabel = widthOfLabel;
    }

    public void showNumberAndChart(boolean showNumberAndChart, int widthOfLabel, Font font, int horizontalAlignement) {
        this.showNumberAndChart = showNumberAndChart;
        this.widthOfValueLabel = widthOfLabel;
        this.labelHorizontalAlignement = horizontalAlignement;
        this.valueLabel.setFont(font);
    }

    public void showNumbers(boolean showNumbers) {
        this.showNumbers = showNumbers;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value == null) {
            Color bg = c.getBackground();
            c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            return c;
        }
        if (value instanceof String) {
            Color bg = c.getBackground();
            c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            return c;
        }
        if (!(value instanceof Integer)) {
            throw new IllegalArgumentException("JSparklinesColorTableCellRenderer only supports integer values!");
        }
        if (this.showNumbers) {
            c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, (Integer)value, isSelected, hasFocus, row, column);
            ((JLabel)c).setHorizontalAlignment(4);
            Color bg = c.getBackground();
            c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            return c;
        }
        if (this.tooltips.get((Integer)value) != null) {
            this.setToolTipText(this.tooltips.get((Integer)value));
        } else {
            this.setToolTipText("" + value);
        }
        if (this.showNumberAndChart) {
            this.valueLabel.setText("" + Integer.valueOf("" + value));
            Color bg = c.getBackground();
            this.valueLabel.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            if (this.labelHorizontalAlignement == 4) {
                this.valueLabel.setText(this.valueLabel.getText() + "  ");
            } else if (this.labelHorizontalAlignement == 2) {
                this.valueLabel.setText("  " + this.valueLabel.getText());
            }
            this.valueLabel.setForeground(c.getForeground());
            this.valueLabel.setHorizontalAlignment(this.labelHorizontalAlignement);
            this.valueLabel.setMinimumSize(new Dimension(this.widthOfValueLabel, 0));
            this.valueLabel.setSize(new Dimension(this.widthOfValueLabel, this.valueLabel.getPreferredSize().height));
            this.valueLabel.setMaximumSize(new Dimension(this.widthOfValueLabel, this.valueLabel.getPreferredSize().height));
            this.valueLabel.setPreferredSize(new Dimension(this.widthOfValueLabel, this.valueLabel.getPreferredSize().height));
            this.valueLabel.setVisible(true);
        } else {
            this.valueLabel.setMinimumSize(new Dimension(0, 0));
            this.valueLabel.setSize(0, 0);
            this.valueLabel.setVisible(false);
        }
        this.setBorder(c.getBorder());
        this.setOpaque(c.isOpaque());
        this.setBackground(c.getBackground());
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue((Number)1, (Comparable)((Object)"1"), (Comparable)((Object)"1"));
        CategoryPlot plot = this.chart.getCategoryPlot();
        plot.setDataset((CategoryDataset)dataset);
        plot.setOutlineVisible(false);
        plot.getRangeAxis().setVisible(false);
        plot.getDomainAxis().setVisible(false);
        plot.setRangeGridlinesVisible(false);
        BarChartColorRenderer renderer = this.colors.get((Integer)value) == null ? new BarChartColorRenderer(this.defaultColor) : new BarChartColorRenderer(this.colors.get((Integer)value));
        if (this.plotBackgroundColor != null && !isSelected) {
            plot.setBackgroundPaint((Paint)this.plotBackgroundColor);
            this.chartPanel.setBackground(this.plotBackgroundColor);
            this.chart.setBackgroundPaint((Paint)this.plotBackgroundColor);
        } else {
            Color bg = c.getBackground();
            plot.setBackgroundPaint((Paint)new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            this.chartPanel.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            this.chart.setBackgroundPaint((Paint)new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            this.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
        }
        plot.setRenderer((CategoryItemRenderer)renderer);
        return this;
    }

    public HashMap<Integer, Color> getColors() {
        return this.colors;
    }

    public void setColors(HashMap<Integer, Color> colors) {
        this.colors = colors;
    }

    public HashMap<Integer, String> getTooltips() {
        return this.tooltips;
    }

    public void setTooltips(HashMap<Integer, String> tooltips) {
        this.tooltips = tooltips;
    }
}

