/*
 * Decompiled with CFR 0.152.
 */
package no.uib.jsparklines.renderers;

import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class JSparklinesIntegerIconTableCellRenderer
extends JPanel
implements TableCellRenderer {
    private HashMap<Integer, ImageIcon> icons;
    private HashMap<Integer, String> tooltips;
    private ImageIcon defaultIcon;
    private String defaultTooltip;

    public JSparklinesIntegerIconTableCellRenderer(HashMap<Integer, ImageIcon> icons) {
        this(null, null, icons, new HashMap<Integer, String>());
    }

    public JSparklinesIntegerIconTableCellRenderer(HashMap<Integer, ImageIcon> icons, HashMap<Integer, String> tooltips) {
        this(null, null, icons, tooltips);
    }

    public JSparklinesIntegerIconTableCellRenderer(ImageIcon defaultIcon, String defaultTooltip, HashMap<Integer, ImageIcon> icons) {
        this(defaultIcon, defaultTooltip, icons, new HashMap<Integer, String>());
    }

    public JSparklinesIntegerIconTableCellRenderer(ImageIcon defaultIcon, String defaultTooltip, HashMap<Integer, ImageIcon> icons, HashMap<Integer, String> tooltips) {
        this.defaultIcon = defaultIcon;
        this.defaultTooltip = defaultTooltip;
        this.icons = icons;
        this.tooltips = tooltips;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)new DefaultTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Color bg = label.getBackground();
        label.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
        if (value instanceof Integer) {
            label.setText(null);
            label.setHorizontalAlignment(0);
            Integer intValue = (Integer)value;
            ImageIcon icon = this.icons.get(intValue);
            if (icon != null) {
                label.setIcon(icon);
                label.setToolTipText(this.tooltips.get(intValue));
            } else {
                label.setIcon(this.defaultIcon);
                label.setToolTipText(this.defaultTooltip);
            }
        } else if (value == null) {
            label.setIcon(null);
            label.setToolTipText(null);
        }
        return label;
    }
}

