/*
 * Decompiled with CFR 0.152.
 */
package no.uib.jsparklines.renderers;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.data.XYDataPoint;
import no.uib.jsparklines.renderers.util.ReferenceArea;
import no.uib.jsparklines.renderers.util.ReferenceLine;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class JSparklinesTwoValueBarChartTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private boolean showFirstNumber = false;
    private Color backgroundColor;
    private ChartPanel chartPanel;
    private JFreeChart chart;
    private double maxValue = 0.0;
    private PlotOrientation plotOrientation;
    private Color firstValueColor = new Color(251, 51, 51);
    private Color secondValueColor = new Color(51, 51, 251);
    private Color fillColor = null;
    private HashMap<String, ReferenceLine> referenceLines;
    private HashMap<String, ReferenceArea> referenceAreas;
    private DecimalFormat numberFormat = new DecimalFormat("0.00");
    private int widthOfValueLabel = 40;
    private boolean showNumberAndChart = false;
    private boolean showNumbers = false;
    private int labelHorizontalAlignement = 4;
    private JLabel valueLabel;

    public JSparklinesTwoValueBarChartTableCellRenderer(PlotOrientation plotOrientation, Double maxValue, Color firstValueColor, Color secondValueColor, boolean showFirstNumber) {
        this(plotOrientation, maxValue, firstValueColor, secondValueColor, null, showFirstNumber);
    }

    public JSparklinesTwoValueBarChartTableCellRenderer(PlotOrientation plotOrientation, Double maxValue, Color firstValueColor, Color secondValueColor, Color fillColor, boolean showFirstNumber) {
        this.plotOrientation = plotOrientation;
        this.maxValue = maxValue;
        this.firstValueColor = firstValueColor;
        this.secondValueColor = secondValueColor;
        this.fillColor = fillColor;
        this.showFirstNumber = showFirstNumber;
        this.valueLabel = new JLabel("");
        this.valueLabel.setMinimumSize(new Dimension(this.widthOfValueLabel, 0));
        this.valueLabel.setHorizontalAlignment(0);
        this.valueLabel.setFont(this.valueLabel.getFont().deriveFont((float)this.valueLabel.getFont().getSize() - 2.0f));
        this.referenceLines = new HashMap();
        this.referenceAreas = new HashMap();
        this.setName("Table.cellRenderer");
        this.setLayout(new BorderLayout());
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        this.chart = ChartFactory.createBarChart(null, null, null, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)false, (boolean)false, (boolean)false);
        this.chartPanel = new ChartPanel(this.chart);
        this.setLayout(new BoxLayout(this, 2));
        this.add(this.valueLabel);
        this.add((Component)this.chartPanel);
    }

    public void showNumberAndChart(boolean showNumberAndChart, int widthOfLabel) {
        this.showNumberAndChart(showNumberAndChart, widthOfLabel, this.numberFormat);
    }

    public void showNumberAndChart(boolean showNumberAndChart, int widthOfLabel, DecimalFormat numberFormat) {
        this.showNumberAndChart = showNumberAndChart;
        this.widthOfValueLabel = widthOfLabel;
        this.numberFormat = numberFormat;
    }

    public void showNumberAndChart(boolean showNumberAndChart, int widthOfLabel, Font font, int horizontalAlignement) {
        this.showNumberAndChart(showNumberAndChart, widthOfLabel, font, horizontalAlignement, this.numberFormat);
    }

    public void showNumberAndChart(boolean showNumberAndChart, int widthOfLabel, Font font, int horizontalAlignement, DecimalFormat numberFormat) {
        this.showNumberAndChart = showNumberAndChart;
        this.widthOfValueLabel = widthOfLabel;
        this.labelHorizontalAlignement = horizontalAlignement;
        this.valueLabel.setFont(font);
        this.numberFormat = numberFormat;
    }

    public void showNumbers(boolean showNumbers) {
        this.showNumbers = showNumbers;
    }

    public void showFirstNumber(boolean showFirstNumber) {
        this.showFirstNumber = showFirstNumber;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        double fillValue;
        JComponent c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setBorder(c.getBorder());
        this.setOpaque(c.isOpaque());
        if (this.backgroundColor != null) {
            this.setBackground(this.backgroundColor);
        } else {
            this.setBackground(c.getBackground());
        }
        if (value == null) {
            Color bg = c.getBackground();
            c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            return c;
        }
        if (value instanceof String) {
            Color bg = c.getBackground();
            c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            return c;
        }
        if (!(value instanceof XYDataPoint)) {
            return c;
        }
        XYDataPoint xyDataPoint = (XYDataPoint)value;
        if (this.showNumberAndChart || this.showNumbers) {
            this.numberFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.US));
            double tempValue = ((XYDataPoint)value).getX() + ((XYDataPoint)value).getY();
            if (this.showFirstNumber) {
                tempValue = ((XYDataPoint)value).getX();
            }
            if (this.showNumbers) {
                c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, this.numberFormat.format(tempValue), isSelected, hasFocus, row, column);
                ((JLabel)c).setHorizontalAlignment(4);
                Color bg = c.getBackground();
                c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
                return c;
            }
            this.valueLabel.setText(this.numberFormat.format(tempValue));
            Color bg = c.getBackground();
            this.valueLabel.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            if (this.labelHorizontalAlignement == 4) {
                this.valueLabel.setText(this.valueLabel.getText() + "  ");
            } else if (this.labelHorizontalAlignement == 2) {
                this.valueLabel.setText("  " + this.valueLabel.getText());
            }
            this.valueLabel.setForeground(c.getForeground());
            this.valueLabel.setHorizontalAlignment(this.labelHorizontalAlignement);
            this.valueLabel.setMinimumSize(new Dimension(this.widthOfValueLabel, 0));
            this.valueLabel.setSize(new Dimension(this.widthOfValueLabel, this.valueLabel.getPreferredSize().height));
            this.valueLabel.setMaximumSize(new Dimension(this.widthOfValueLabel, this.valueLabel.getPreferredSize().height));
            this.valueLabel.setPreferredSize(new Dimension(this.widthOfValueLabel, this.valueLabel.getPreferredSize().height));
            this.valueLabel.setVisible(true);
        } else {
            this.valueLabel.setMinimumSize(new Dimension(0, 0));
            this.valueLabel.setSize(0, 0);
            this.valueLabel.setVisible(false);
        }
        DefaultCategoryDataset barChartDataset = new DefaultCategoryDataset();
        StackedBarRenderer renderer = new StackedBarRenderer();
        renderer.setShadowVisible(false);
        barChartDataset.addValue(xyDataPoint.getX(), (Comparable)((Object)"0"), (Comparable)((Object)"0"));
        barChartDataset.addValue(xyDataPoint.getY(), (Comparable)((Object)"1"), (Comparable)((Object)"0"));
        renderer.setSeriesPaint(0, (Paint)this.firstValueColor);
        renderer.setSeriesPaint(1, (Paint)this.secondValueColor);
        if (this.fillColor != null && (fillValue = this.maxValue - xyDataPoint.getX() + xyDataPoint.getY()) > 0.0) {
            barChartDataset.addValue(fillValue, (Comparable)((Object)"2"), (Comparable)((Object)"0"));
            renderer.setSeriesPaint(2, (Paint)this.fillColor);
        }
        String tooltip = (int)xyDataPoint.getX() + " / " + (int)(xyDataPoint.getX() + xyDataPoint.getY());
        this.chart = ChartFactory.createStackedBarChart(null, null, null, (CategoryDataset)barChartDataset, (PlotOrientation)this.plotOrientation, (boolean)false, (boolean)false, (boolean)false);
        CategoryPlot plot = this.chart.getCategoryPlot();
        plot.getDomainAxis().setUpperMargin(0.0);
        plot.getDomainAxis().setLowerMargin(0.0);
        plot.getRangeAxis().setUpperMargin(0.0);
        plot.getRangeAxis().setLowerMargin(0.0);
        Iterator<String> allReferencesLines = this.referenceLines.keySet().iterator();
        while (allReferencesLines.hasNext()) {
            ReferenceLine currentReferenceLine = this.referenceLines.get(allReferencesLines.next());
            plot.addRangeMarker((Marker)new ValueMarker(currentReferenceLine.getValue(), (Paint)currentReferenceLine.getLineColor(), (Stroke)new BasicStroke(currentReferenceLine.getLineWidth())));
        }
        Iterator<String> allReferenceAreas = this.referenceAreas.keySet().iterator();
        while (allReferenceAreas.hasNext()) {
            ReferenceArea currentReferenceArea = this.referenceAreas.get(allReferenceAreas.next());
            IntervalMarker marker = new IntervalMarker(currentReferenceArea.getStart(), currentReferenceArea.getEnd(), (Paint)currentReferenceArea.getAreaColor());
            marker.setAlpha(currentReferenceArea.getAlpha());
            plot.addRangeMarker((Marker)marker);
        }
        plot.getRangeAxis().setRange(0.0, this.maxValue);
        plot.setDataset((CategoryDataset)barChartDataset);
        plot.getRangeAxis().setVisible(false);
        plot.getDomainAxis().setVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.setDomainGridlinesVisible(false);
        plot.setRenderer(0, (CategoryItemRenderer)renderer);
        this.setToolTipText(tooltip);
        this.chart.getPlot().setOutlineVisible(false);
        if (this.backgroundColor != null) {
            this.chart.getPlot().setBackgroundPaint((Paint)this.backgroundColor);
            this.chart.setBackgroundPaint((Paint)this.backgroundColor);
        } else {
            this.chart.getPlot().setBackgroundPaint((Paint)c.getBackground());
            this.chart.setBackgroundPaint((Paint)c.getBackground());
        }
        this.chartPanel = new ChartPanel(this.chart);
        if (this.backgroundColor != null) {
            this.chartPanel.setBackground(this.backgroundColor);
        } else {
            this.chartPanel.setBackground(c.getBackground());
        }
        this.remove(1);
        this.add((Component)this.chartPanel);
        return this;
    }

    public void addReferenceLine(String label, double value, float lineWidth, Color lineColor) {
        this.referenceLines.put(label, new ReferenceLine(label, value, lineWidth, lineColor));
    }

    public void addReferenceLine(ReferenceLine referenceLine) {
        this.referenceLines.put(referenceLine.getLabel(), referenceLine);
    }

    public void removeReferenceLine(String label) {
        this.referenceLines.remove(label);
    }

    public void removeAllReferenceLines() {
        this.referenceLines = new HashMap();
    }

    public HashMap<String, ReferenceLine> getAllReferenceLines() {
        return this.referenceLines;
    }

    public void addReferenceArea(String label, double start, double end, Color areaColor, float alpha) {
        this.referenceAreas.put(label, new ReferenceArea(label, start, end, areaColor, alpha));
    }

    public void addReferenceArea(ReferenceArea referenceArea) {
        this.referenceAreas.put(referenceArea.getLabel(), referenceArea);
    }

    public void removeReferenceArea(String label) {
        this.referenceAreas.remove(label);
    }

    public void removeAllReferenceAreas() {
        this.referenceAreas = new HashMap();
    }

    public HashMap<String, ReferenceArea> getAllReferenceAreas() {
        return this.referenceAreas;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public Color getFirstValueColor() {
        return this.firstValueColor;
    }

    public void setFirstValueColor(Color firstValueColor) {
        this.firstValueColor = firstValueColor;
    }

    public Color getSecondValueColor() {
        return this.secondValueColor;
    }

    public void setSecondValueColor(Color secondValueColor) {
        this.secondValueColor = secondValueColor;
    }

    public PlotOrientation getPlotOrientation() {
        return this.plotOrientation;
    }

    public void setPlotOrientation(PlotOrientation plotOrientation) {
        this.plotOrientation = plotOrientation;
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    static {
        BarRenderer.setDefaultBarPainter((BarPainter)new StandardBarPainter());
    }
}

