/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.gsea;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.Fetcher;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.converter.LevelUpgrader;
import org.biopax.paxtools.io.gsea.GMTEntry;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.model.level3.RelationshipXref;
import org.biopax.paxtools.model.level3.SequenceEntityReference;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.util.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSEAConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GSEAConverter.class);
    private final String idType;
    private final boolean crossSpeciesCheckEnabled;
    private Set<String> allowedOrganisms;
    private final boolean skipSubPathways;
    private final Set<Provenance> skipSubPathwaysOf;
    private boolean skipOutsidePathways = false;
    private int minNumOfGenesPerEntry = 1;

    public GSEAConverter() {
        this("", true);
    }

    public GSEAConverter(String idType, boolean crossSpeciesCheckEnabled) {
        this(idType, crossSpeciesCheckEnabled, false);
    }

    public GSEAConverter(String idType, boolean crossSpeciesCheckEnabled, boolean skipSubPathways) {
        this.idType = idType;
        this.crossSpeciesCheckEnabled = crossSpeciesCheckEnabled;
        this.skipSubPathways = skipSubPathways;
        this.skipSubPathwaysOf = Collections.emptySet();
    }

    public GSEAConverter(String idType, boolean crossSpeciesCheckEnabled, Set<Provenance> skipSubPathwaysOf) {
        this.idType = idType;
        this.crossSpeciesCheckEnabled = crossSpeciesCheckEnabled;
        if (skipSubPathwaysOf == null) {
            skipSubPathwaysOf = Collections.emptySet();
        }
        this.skipSubPathwaysOf = skipSubPathwaysOf;
        this.skipSubPathways = false;
    }

    public boolean isSkipOutsidePathways() {
        return this.skipOutsidePathways;
    }

    public void setSkipOutsidePathways(boolean skipOutsidePathways) {
        this.skipOutsidePathways = skipOutsidePathways;
    }

    public Set<String> getAllowedOrganisms() {
        return this.allowedOrganisms;
    }

    public void setAllowedOrganisms(Set<String> allowedOrganisms) {
        this.allowedOrganisms = allowedOrganisms;
    }

    public int getMinNumOfGenesPerEntry() {
        return this.minNumOfGenesPerEntry;
    }

    public void setMinNumOfGenesPerEntry(int minNumOfGenesPerEntry) {
        this.minNumOfGenesPerEntry = minNumOfGenesPerEntry;
    }

    public void writeToGSEA(Model model, OutputStream out) throws IOException {
        Collection<GMTEntry> entries = this.convert(model);
        if (entries.size() > 0) {
            OutputStreamWriter writer = new OutputStreamWriter(out);
            for (GMTEntry entry : entries) {
                if ((this.minNumOfGenesPerEntry > 1 || entry.identifiers().isEmpty()) && entry.identifiers().size() < this.minNumOfGenesPerEntry) continue;
                writer.write(entry.toString() + "\n");
            }
            ((Writer)writer).flush();
        }
    }

    public Collection<GMTEntry> convert(Model model) {
        TreeSet<GMTEntry> toReturn = new TreeSet<GMTEntry>(new Comparator<GMTEntry>(){

            @Override
            public int compare(GMTEntry o1, GMTEntry o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        Model l3Model = model.getLevel() == BioPAXLevel.L2 ? new LevelUpgrader().filter(model) : model;
        HashSet<SequenceEntityReference> sequenceEntityReferences = new HashSet<SequenceEntityReference>(l3Model.getObjects(SequenceEntityReference.class));
        Set pathways = l3Model.getObjects(Pathway.class);
        for (Pathway pathway : pathways) {
            String name;
            String string = name = pathway.getDisplayName() == null ? pathway.getStandardName() : pathway.getDisplayName();
            if (name == null || name.isEmpty()) {
                name = pathway.getUri();
            }
            Pathway currentPathway = pathway;
            String currentPathwayName = name;
            boolean ignoreSubPathways = !this.skipSubPathwaysOf.isEmpty() && this.shareSomeObjects(currentPathway.getDataSource(), this.skipSubPathwaysOf) || this.skipSubPathways;
            LOG.debug("Begin converting " + currentPathwayName + " pathway, uri=" + currentPathway.getUri());
            Fetcher fetcher = new Fetcher((EditorMap)SimpleEditorMap.L3, new Filter[]{Fetcher.nextStepFilter});
            fetcher.setSkipSubPathways(ignoreSubPathways);
            Set pathwaySers = fetcher.fetch((BioPAXElement)currentPathway, SequenceEntityReference.class);
            if (pathwaySers.isEmpty()) continue;
            LOG.debug("For pathway: " + currentPathwayName + " (" + currentPathway.getUri() + "), got " + pathwaySers.size() + " sERs; now - grouping by organism...");
            Map<String, Set<SequenceEntityReference>> orgToPrsMap = this.organismToProteinRefsMap(pathwaySers);
            String dataSource = this.getDataSource(currentPathway.getDataSource());
            Collection<GMTEntry> entries = this.createGseaEntries(currentPathway.getUri(), currentPathwayName, dataSource, orgToPrsMap);
            if (!entries.isEmpty()) {
                toReturn.addAll(entries);
            }
            sequenceEntityReferences.removeAll(pathwaySers);
            LOG.debug("- collected " + entries.size() + "entries.");
        }
        if (!sequenceEntityReferences.isEmpty() && !this.skipOutsidePathways) {
            LOG.info("Creating entries for the rest of PRs (outside any pathway)...");
            Map<String, Set<SequenceEntityReference>> orgToPrsMap = this.organismToProteinRefsMap(sequenceEntityReferences);
            if (!orgToPrsMap.isEmpty()) {
                if (model.getUri() == null) {
                    toReturn.addAll(this.createGseaEntries("other", "other", this.getDataSource(l3Model.getObjects(Provenance.class)), orgToPrsMap));
                } else {
                    toReturn.addAll(this.createGseaEntries(model.getUri(), model.getName(), this.getDataSource(l3Model.getObjects(Provenance.class)), orgToPrsMap));
                }
            }
        }
        return toReturn;
    }

    private Collection<GMTEntry> createGseaEntries(String uri, String name, String dataSource, Map<String, Set<SequenceEntityReference>> orgToPrsMap) {
        ArrayList<GMTEntry> toReturn = new ArrayList<GMTEntry>();
        for (String org : orgToPrsMap.keySet()) {
            if (orgToPrsMap.get(org).size() <= 0) continue;
            GMTEntry GMTEntry2 = new GMTEntry(uri, org, this.idType, String.format("name: %s; datasource: %s", name, dataSource));
            this.processEntityReferences(orgToPrsMap.get(org), GMTEntry2);
            toReturn.add(GMTEntry2);
        }
        return toReturn;
    }

    private Map<String, Set<SequenceEntityReference>> organismToProteinRefsMap(Set<SequenceEntityReference> seqErs) {
        HashMap<String, Set<SequenceEntityReference>> map = new HashMap<String, Set<SequenceEntityReference>>();
        if (seqErs.isEmpty()) {
            throw new IllegalArgumentException("Empty set");
        }
        if (this.crossSpeciesCheckEnabled) {
            for (SequenceEntityReference r : seqErs) {
                String key = this.getOrganismKey(r.getOrganism());
                if (this.allowedOrganisms != null && !this.allowedOrganisms.isEmpty() && !this.allowedOrganisms.contains(key)) continue;
                HashSet<SequenceEntityReference> sers = (HashSet<SequenceEntityReference>)map.get(key);
                if (sers == null) {
                    sers = new HashSet<SequenceEntityReference>();
                    map.put(key, sers);
                }
                sers.add(r);
            }
        } else {
            HashSet<SequenceEntityReference> sers = new HashSet<SequenceEntityReference>();
            for (SequenceEntityReference r : seqErs) {
                String key = this.getOrganismKey(r.getOrganism());
                if (this.allowedOrganisms != null && !this.allowedOrganisms.isEmpty() && !this.allowedOrganisms.contains(key)) continue;
                sers.add(r);
            }
            map.put("", sers);
        }
        return map;
    }

    void processEntityReferences(Set<SequenceEntityReference> sers, GMTEntry targetEntry) {
        for (SequenceEntityReference ser : sers) {
            if (this.crossSpeciesCheckEnabled && !targetEntry.taxID().equals(this.getOrganismKey(ser.getOrganism()))) continue;
            if (this.idType != null && !this.idType.isEmpty()) {
                String db = this.idType.toLowerCase();
                String uri = ser.getUri();
                if (uri.startsWith("http://identifiers.org/") && uri.contains(db)) {
                    String accession = ser.getUri();
                    accession = accession.substring(accession.lastIndexOf("/") + 1);
                    targetEntry.identifiers().add(accession);
                    continue;
                }
                int added = 0;
                for (Xref aXref : ser.getXref()) {
                    if (!(aXref instanceof UnificationXref) || aXref.getId() == null || aXref.getDb() == null || !aXref.getDb().toLowerCase().startsWith(db)) continue;
                    targetEntry.identifiers().add(aXref.getId());
                    ++added;
                }
                if (added == 0) {
                    for (Xref aXref : ser.getXref()) {
                        if (!(aXref instanceof RelationshipXref) || aXref.getId() == null || aXref.getDb() == null || !aXref.getDb().toLowerCase().startsWith(db)) continue;
                        targetEntry.identifiers().add(aXref.getId());
                        ++added;
                    }
                }
                if (added <= 12) continue;
                LOG.info("In GSEA entry: " + targetEntry.taxID() + " " + targetEntry.name() + ", sER " + ser.getUri() + " got " + added + " '" + db + "' identifiers...");
                continue;
            }
            targetEntry.identifiers().add(ser.getUri());
        }
    }

    private String getDataSource(Set<Provenance> provenances) {
        if (provenances.isEmpty()) {
            return "N/A";
        }
        TreeSet<String> dsNames = new TreeSet<String>();
        for (Provenance provenance : provenances) {
            String name = provenance.getDisplayName();
            if (name == null) {
                name = provenance.getStandardName();
            }
            if (name == null && !provenance.getName().isEmpty()) {
                name = (String)provenance.getName().iterator().next();
            }
            if (name == null || name.length() <= 0) continue;
            dsNames.add(name.toLowerCase());
        }
        return StringUtils.join(dsNames, (String)";");
    }

    private String getOrganismKey(BioSource org) {
        String key = "";
        if (org != null) {
            Set xrefs = org.getXref();
            if (!xrefs.isEmpty()) {
                for (Xref xref : xrefs) {
                    if (!(xref instanceof UnificationXref) || !xref.getDb().equalsIgnoreCase("taxonomy")) continue;
                    if (key.isEmpty()) {
                        key = xref.getId();
                        continue;
                    }
                    LOG.warn("BioSource " + org + " has multiple taxonomy unification xrefs; I will use " + key);
                }
            }
            if (key.isEmpty()) {
                if (org.getStandardName() != null) {
                    key = org.getStandardName().toLowerCase();
                } else if (org.getDisplayName() != null) {
                    key = org.getDisplayName().toLowerCase();
                } else if (!org.getName().isEmpty()) {
                    key = ((String)org.getName().iterator().next()).toLowerCase();
                }
            }
        }
        return key;
    }

    private boolean shareSomeObjects(Set<?> setA, Set<?> setB) {
        return !setA.isEmpty() && !setB.isEmpty() ? !CollectionUtils.intersection(setA, setB).isEmpty() : false;
    }
}

