/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.jsonld;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.io.jsonld.JsonldConverter;
import org.biopax.paxtools.model.BioPAXLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonldBiopaxConverter
implements JsonldConverter {
    private static final Logger LOG = LoggerFactory.getLogger(JsonldBiopaxConverter.class);

    @Override
    public void convertToJsonld(InputStream in, OutputStream os) throws IOException {
        File inputProcessedFile = this.preProcessFile(in);
        LOG.info("OWl File processed successfully ");
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        LOG.info("Conversion RDF to JSONLD started " + sdf.format(Calendar.getInstance().getTime()));
        Model modelJena = ModelFactory.createDefaultModel();
        FileInputStream internalInputStream = new FileInputStream(inputProcessedFile);
        RDFDataMgr.read((Model)modelJena, (InputStream)internalInputStream, (Lang)Lang.RDFXML);
        LOG.info("Read into Model finished " + sdf.format(Calendar.getInstance().getTime()));
        try {
            ((InputStream)internalInputStream).close();
            inputProcessedFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RDFDataMgr.write((OutputStream)os, (Model)modelJena, (Lang)Lang.JSONLD);
        LOG.info("Conversion RDF to JSONLD finished " + sdf.format(Calendar.getInstance().getTime()));
        LOG.info(" JSONLD file  is written successfully.");
        try {
            os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void convertFromJsonld(InputStream in, OutputStream out) {
        Model modelJena = ModelFactory.createDefaultModel();
        if (in == null) {
            throw new IllegalArgumentException("Input File:  not found");
        }
        if (out == null) {
            throw new IllegalArgumentException("Output File:  not found");
        }
        modelJena.read(in, null, "JSONLD");
        RDFDataMgr.write((OutputStream)out, (Model)modelJena, (Lang)Lang.RDFXML);
        LOG.info(" RDF file  is written successfully.");
    }

    public File preProcessFile(InputStream in) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        LOG.info("BIOPAX Conversion started " + sdf.format(Calendar.getInstance().getTime()));
        if (in == null) {
            throw new IllegalArgumentException("Input File:  is not found");
        }
        SimpleIOHandler simpleIO = new SimpleIOHandler(BioPAXLevel.L3);
        org.biopax.paxtools.model.Model model = simpleIO.convertFromOWL(in);
        simpleIO.absoluteUris(true);
        File fullUriBiopaxInput = File.createTempFile("paxtools", ".owl");
        fullUriBiopaxInput.deleteOnExit();
        FileOutputStream outputStream = new FileOutputStream(fullUriBiopaxInput);
        simpleIO.convertToOWL(model, (OutputStream)outputStream);
        model = null;
        LOG.info("BIOPAX Conversion finished " + sdf.format(Calendar.getInstance().getTime()));
        return fullUriBiopaxInput;
    }
}

