/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.jsonld;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.io.jsonld.JsonldConverter;
import org.biopax.paxtools.model.BioPAXLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonldBiopaxConverter
implements JsonldConverter {
    private static final Logger LOG = LoggerFactory.getLogger(JsonldBiopaxConverter.class);

    @Override
    public void convertToJsonld(InputStream in, OutputStream os) throws IOException {
        File tmpFile = this.preProcessFile(in);
        Model modelJena = ModelFactory.createDefaultModel();
        in = new FileInputStream(tmpFile);
        RDFDataMgr.read((Model)modelJena, (InputStream)in, (Lang)Lang.RDFXML);
        RDFDataMgr.write((OutputStream)os, (Model)modelJena, (Lang)Lang.JSONLD);
        LOG.info("BioPAX RDFXML to JSONLD finished");
        try {
            in.close();
            os.close();
            tmpFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void convertFromJsonld(InputStream in, OutputStream out) {
        if (in == null) {
            throw new IllegalArgumentException("Input File:  not found");
        }
        if (out == null) {
            throw new IllegalArgumentException("Output File:  not found");
        }
        Model modelJena = ModelFactory.createDefaultModel();
        modelJena.read(in, null, "JSONLD");
        RDFDataMgr.write((OutputStream)out, (Model)modelJena, (Lang)Lang.RDFXML);
        LOG.info("JSONLD to RDFXML finished");
    }

    public File preProcessFile(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("Input File:  is not found");
        }
        SimpleIOHandler simpleIO = new SimpleIOHandler(BioPAXLevel.L3);
        org.biopax.paxtools.model.Model model = simpleIO.convertFromOWL(in);
        simpleIO.absoluteUris(true);
        File tmpf = File.createTempFile("paxtools", ".owl");
        tmpf.deleteOnExit();
        FileOutputStream outputStream = new FileOutputStream(tmpf);
        simpleIO.convertToOWL(model, (OutputStream)outputStream);
        return tmpf;
    }
}

