/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.normalizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.biopax.paxtools.controller.IDFetcher;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.RelationshipXref;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.XReferrable;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.normalizer.Namespace;
import org.biopax.paxtools.normalizer.Resolver;
import org.biopax.paxtools.util.ClassFilterSet;
import org.biopax.paxtools.util.HGNC;

public class ConfigurableIDFetcher
implements IDFetcher {
    private final List<String> seqDbStartsWithOrEquals = new ArrayList<String>();
    private final List<String> chemDbStartsWithOrEquals = new ArrayList<String>();
    private boolean useNameWhenNoDbMatch = false;

    public ConfigurableIDFetcher seqDbStartsWithOrEquals(String dbStartsWithOrEquals) {
        this.seqDbStartsWithOrEquals.add(dbStartsWithOrEquals.toLowerCase());
        return this;
    }

    public List<String> getSeqDbStartsWithOrEquals() {
        return Collections.unmodifiableList(this.seqDbStartsWithOrEquals);
    }

    public ConfigurableIDFetcher chemDbStartsWithOrEquals(String dbStartsWithOrEquals) {
        this.chemDbStartsWithOrEquals.add(dbStartsWithOrEquals.toLowerCase());
        return this;
    }

    public List<String> getChemDbStartsWithOrEquals() {
        return Collections.unmodifiableList(this.chemDbStartsWithOrEquals);
    }

    public ConfigurableIDFetcher useNameWhenNoDbMatch(boolean useNameWhenNoDbMatch) {
        this.useNameWhenNoDbMatch = useNameWhenNoDbMatch;
        return this;
    }

    public Set<String> fetchID(BioPAXElement ele) {
        HashSet<String> set = new HashSet<String>();
        if (ele instanceof XReferrable) {
            List<String> dbStartsWithOrEquals = ele instanceof SmallMoleculeReference || ele instanceof SmallMolecule ? this.chemDbStartsWithOrEquals : this.seqDbStartsWithOrEquals;
            for (String dbStartsWith : dbStartsWithOrEquals) {
                if (StringUtils.containsIgnoreCase((CharSequence)ele.getUri(), (CharSequence)("identifiers.org/" + dbStartsWith)) || StringUtils.containsIgnoreCase((CharSequence)ele.getUri(), (CharSequence)("bioregistry.io/" + dbStartsWith))) {
                    set.add(StringUtils.substringAfterLast((String)ele.getUri(), (String)"/"));
                } else {
                    for (UnificationXref x : new ClassFilterSet((Collection)((XReferrable)ele).getXref(), UnificationXref.class)) {
                        this.collectXrefIdIfDbLike((Xref)x, dbStartsWith, set);
                    }
                    if (set.isEmpty()) {
                        for (UnificationXref x : new ClassFilterSet((Collection)((XReferrable)ele).getXref(), RelationshipXref.class)) {
                            this.collectXrefIdIfDbLike((Xref)x, dbStartsWith, set);
                        }
                    }
                }
                if (set.isEmpty()) continue;
                break;
            }
        }
        if (set.isEmpty() && ele instanceof Named && this.useNameWhenNoDbMatch) {
            Named e = (Named)ele;
            if (e.getDisplayName() != null && !e.getDisplayName().contains("...")) {
                set.add(e.getDisplayName());
            } else if (e.getStandardName() != null && !e.getStandardName().contains("...")) {
                set.add(e.getStandardName());
            } else if (!e.getName().isEmpty()) {
                TreeSet<String> names = new TreeSet<String>();
                for (String name : e.getName()) {
                    if (name.contains("...")) continue;
                    names.add(name);
                }
                set.add(((Object)names).toString());
            }
        }
        return set;
    }

    private void collectXrefIdIfDbLike(Xref x, String dbStartsWith, Set<String> set) {
        String db = x.getDb();
        Object id = x.getId();
        if (StringUtils.isNotBlank((CharSequence)db) && StringUtils.isNotBlank((CharSequence)id)) {
            String dbName = "";
            String dbPrefix = "";
            String banana = "";
            String peel = "";
            if (Resolver.isKnownNameOrVariant(db)) {
                Namespace ns = Resolver.getNamespace(db);
                dbPrefix = ns.getPrefix();
                dbName = ns.getName();
                banana = ns.getBanana();
                peel = ns.getBanana_peel();
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)db, (CharSequence)dbStartsWith) || StringUtils.startsWithIgnoreCase((CharSequence)dbName, (CharSequence)dbStartsWith) || StringUtils.startsWithIgnoreCase((CharSequence)dbPrefix, (CharSequence)dbStartsWith)) {
                if (StringUtils.startsWithIgnoreCase((CharSequence)db, (CharSequence)"hgnc")) {
                    id = HGNC.getSymbolByHgncIdOrSym((String)id);
                }
                if (id != null) {
                    if (StringUtils.isNotBlank((CharSequence)banana) && !((String)id).startsWith(banana)) {
                        id = banana + peel + (String)id;
                    }
                    set.add((String)id);
                }
            }
        }
    }
}

