/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.normalizer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.biopax.paxtools.controller.ModelUtils;
import org.biopax.paxtools.converter.LevelUpgrader;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.ControlledVocabulary;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.NucleicAcidReference;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.model.level3.PublicationXref;
import org.biopax.paxtools.model.level3.RelationshipTypeVocabulary;
import org.biopax.paxtools.model.level3.RelationshipXref;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.XReferrable;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.normalizer.Namespace;
import org.biopax.paxtools.normalizer.NormalizerMap;
import org.biopax.paxtools.normalizer.Resolver;
import org.biopax.paxtools.util.ClassFilterSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Normalizer {
    private static final Logger log = LoggerFactory.getLogger(Normalizer.class);
    private SimpleIOHandler biopaxReader = new SimpleIOHandler(BioPAXLevel.L3);
    private String description = "";
    private boolean fixDisplayName;
    private String xmlBase;
    public static final String PROPERTY_NORMALIZER_URI_STRATEGY = "biopax.normalizer.uri.strategy";
    public static final String VALUE_NORMALIZER_URI_STRATEGY_SIMPLE = "simple";
    public static final String VALUE_NORMALIZER_URI_STRATEGY_MD5 = "md5";
    public static final Map<String, String> typeCodes = Map.ofEntries(Map.entry("BiochemicalReaction", "br"), Map.entry("TransportWithBiochemicalReaction", "tbr"), Map.entry("TemplateReaction", "tr"), Map.entry("TemplateReactionRegulation", "trr"), Map.entry("DnaRegion", "dg"), Map.entry("RnaRegion", "rg"), Map.entry("Pathway", "pw"), Map.entry("PhysicalEntity", "pe"), Map.entry("SmallMolecule", "sm"), Map.entry("Protein", "p"), Map.entry("Gene", "g"), Map.entry("Complex", "c"), Map.entry("Catalysis", "cat"), Map.entry("ChemicalStructure", "cs"), Map.entry("ComplexAssembly", "ca"), Map.entry("Control", "ct"), Map.entry("Conversion", "r"), Map.entry("Transport", "t"), Map.entry("GeneticInteraction", "gi"), Map.entry("Interaction", "i"), Map.entry("Modulation", "m"), Map.entry("MolecularInteraction", "mi"), Map.entry("Degradation", "deg"), Map.entry("BioSource", "BIO"), Map.entry("Provenance", "PRO"), Map.entry("RelationshipXref", "RX"), Map.entry("PublicationXref", "PX"), Map.entry("UnificationXref", "UX"), Map.entry("CellularLocationVocabulary", "LV"), Map.entry("ControlledVocabulary", "V"), Map.entry("CellVocabulary", "CV"), Map.entry("TissueVocabulary", "TV"), Map.entry("PhenotypeVocabulary", "PV"), Map.entry("EvidenceCodeVocabulary", "EV"), Map.entry("EntityReferenceTypeVocabulary", "ERV"), Map.entry("ExperimentalFormVocabulary", "XFV"), Map.entry("InteractionVocabulary", "IV"), Map.entry("RelationshipTypeVocabulary", "RTV"), Map.entry("SequenceModificationVocabulary", "SMV"), Map.entry("SequenceRegionVocabulary", "SRV"), Map.entry("SmallMoleculeReference", "SMR"), Map.entry("BiochemicalPathwayStep", "BPS"), Map.entry("PathwayStep", "PS"), Map.entry("DeltaG", "DG"), Map.entry("KPrime", "KP"), Map.entry("DnaReference", "DR"), Map.entry("DnaRegionReference", "DGR"), Map.entry("RnaReference", "RR"), Map.entry("RnaRegionReference", "RGR"), Map.entry("EntityFeature", "EF"), Map.entry("BindingFeature", "BF"), Map.entry("CovalentBindingFeature", "CF"), Map.entry("FragmentFeature", "FF"), Map.entry("ModificationFeature", "MF"), Map.entry("ExperimentalForm", "XF"), Map.entry("Evidence", "E"), Map.entry("ProteinReference", "PR"), Map.entry("SequenceInterval", "SI"), Map.entry("SequenceLocation", "SL"), Map.entry("SequenceSite", "SS"), Map.entry("Stoichiometry", "S"));

    public Normalizer() {
        this.biopaxReader.mergeDuplicates(true);
        this.fixDisplayName = true;
        this.xmlBase = "";
    }

    public void normalizeXrefs(Model model, boolean usePrefixAsDbName) {
        NormalizerMap map = new NormalizerMap(model);
        String xmlBase = this.getXmlBase(model);
        HashSet xrefs = new HashSet(model.getObjects(Xref.class));
        for (Xref ref : xrefs) {
            if (ref.getDb() == null || ref.getId() == null) continue;
            Namespace ns = Resolver.getNamespace(ref.getDb());
            if (ns != null) {
                if (usePrefixAsDbName) {
                    ref.setDb(ns.getPrefix());
                } else {
                    ref.setDb(ns.getName().toLowerCase());
                }
                String banana = ns.getBanana();
                if (StringUtils.isNotBlank((CharSequence)banana) && !StringUtils.startsWith((CharSequence)ref.getId(), (CharSequence)banana)) {
                    ref.setId(banana + ns.getBanana_peel() + ref.getId());
                }
            }
            String isoformName = usePrefixAsDbName ? "uniprot.isoform" : "uniprot isoform";
            Object idPart = ref.getId();
            if (ref instanceof RelationshipXref) {
                RelationshipTypeVocabulary cv = ((RelationshipXref)ref).getRelationshipType();
                if (ref.getIdVersion() != null) {
                    idPart = (String)idPart + "_" + ref.getIdVersion();
                }
                if (cv != null && !cv.getTerm().isEmpty()) {
                    idPart = (String)idPart + "_" + StringUtils.join((Iterable)cv.getTerm(), (char)'_').toLowerCase();
                }
            } else if (ref instanceof UnificationXref) {
                if (ref.getDb().startsWith("uniprot")) {
                    if (Resolver.checkRegExp(ref.getId(), "uniprot.isoform") && ref.getId().contains("-")) {
                        ref.setDb(isoformName);
                    } else if (ref.getDb().equalsIgnoreCase(isoformName)) {
                        if (ref.getIdVersion() != null && ref.getIdVersion().matches("^\\d+$")) {
                            idPart = ref.getId() + "-" + ref.getIdVersion();
                        }
                        if (Resolver.checkRegExp((String)idPart, isoformName)) {
                            ref.setId((String)idPart);
                            ref.setIdVersion(null);
                        } else if (!Resolver.checkRegExp(ref.getId(), isoformName)) {
                            ref.setDb("uniprot");
                        }
                        idPart = ref.getId();
                    }
                } else if (ns == null && ref.getIdVersion() != null) {
                    idPart = (String)idPart + "_" + ref.getIdVersion();
                }
            }
            String newUri = Normalizer.uri(xmlBase, ref.getDb(), (String)idPart, ref.getModelInterface());
            map.put((BioPAXElement)ref, newUri);
        }
        map.doSubs();
    }

    public static String uri(String xmlBase, String dbName, String idPart, Class<? extends BioPAXElement> type) {
        return Normalizer.uri(xmlBase, dbName, idPart, type, true);
    }

    public static String uri(String xmlBase, String dbName, String idPart, Class<? extends BioPAXElement> type, boolean useRegistry) {
        Namespace ns;
        if (type == null || dbName == null && idPart == null) {
            throw new IllegalArgumentException("Type is null or both dbName and idPart are null");
        }
        Object uri = null;
        if (idPart != null) {
            idPart = idPart.trim();
        }
        if (dbName != null) {
            dbName = dbName.trim().toLowerCase();
        }
        if (dbName != null && useRegistry && (ns = Resolver.getNamespace(dbName)) != null) {
            String prefix = ns.getPrefix();
            if (type.equals(RelationshipTypeVocabulary.class) || ProteinReference.class.isAssignableFrom(type) || SmallMoleculeReference.class.isAssignableFrom(type) || type.equals(BioSource.class) && "ncbitaxon".equalsIgnoreCase(prefix) && idPart != null && idPart.matches("^\\d+$")) {
                uri = Resolver.getURI(prefix, idPart);
            } else if (type.equals(UnificationXref.class) && !"pubmed".equalsIgnoreCase(prefix) || type.equals(PublicationXref.class) && "pubmed".equalsIgnoreCase(prefix)) {
                uri = Resolver.getCURIE(prefix, idPart);
            }
        }
        if (StringUtils.isNotEmpty(uri)) {
            return uri;
        }
        StringBuilder sb = new StringBuilder();
        if (dbName != null) {
            sb.append(dbName);
        }
        if (idPart != null) {
            if (dbName != null) {
                sb.append("_");
            }
            sb.append(idPart);
        }
        String localPart = sb.toString();
        String strategy = System.getProperty(PROPERTY_NORMALIZER_URI_STRATEGY, VALUE_NORMALIZER_URI_STRATEGY_MD5);
        localPart = VALUE_NORMALIZER_URI_STRATEGY_SIMPLE.equals(strategy) || Xref.class.isAssignableFrom(type) || ControlledVocabulary.class.isAssignableFrom(type) || BioSource.class.isAssignableFrom(type) ? localPart.replaceAll("[^-\\w]", "_") : ModelUtils.md5hex((String)localPart);
        String prefix = typeCodes.get(type.getSimpleName());
        if (prefix == null) {
            prefix = type.getSimpleName();
        }
        uri = (xmlBase != null ? xmlBase : "") + prefix + "_" + localPart;
        return uri;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    private void fixDisplayName(Model model) {
        log.info("Trying to auto-fix 'null' displayName...");
        for (Named e : model.getObjects(Named.class)) {
            if (e.getDisplayName() != null) continue;
            if (e.getStandardName() != null) {
                e.setDisplayName(e.getStandardName());
                log.info(String.valueOf(e) + " displayName auto-fix: " + e.getDisplayName() + ". " + this.description);
                continue;
            }
            if (e.getName().isEmpty()) continue;
            String dsp = (String)e.getName().iterator().next();
            for (String name : e.getName()) {
                if (name.length() >= dsp.length()) continue;
                dsp = name;
            }
            e.setDisplayName(dsp);
            log.info(String.valueOf(e) + " displayName auto-fix: " + dsp + ". " + this.description);
        }
        for (EntityReference er : model.getObjects(EntityReference.class)) {
            for (SimplePhysicalEntity spe : er.getEntityReferenceOf()) {
                if (spe.getDisplayName() != null && spe.getDisplayName().trim().length() != 0 || er.getDisplayName() == null || er.getDisplayName().trim().length() <= 0) continue;
                spe.setDisplayName(er.getDisplayName());
            }
        }
    }

    private String convertToOWL(Model model) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new SimpleIOHandler(model.getLevel()).convertToOWL(model, (OutputStream)out);
        return out.toString();
    }

    private Collection<UnificationXref> getUnificationXrefsSorted(XReferrable r) {
        ArrayList<UnificationXref> urefs = new ArrayList<UnificationXref>();
        for (UnificationXref ux : new ClassFilterSet((Collection)r.getXref(), UnificationXref.class)) {
            if (ux.getDb() == null || ux.getId() == null) continue;
            urefs.add(ux);
        }
        Collections.sort(urefs, (o1, o2) -> {
            String s1 = o1.getDb() + o1.getId();
            String s2 = o2.getDb() + o2.getId();
            return s1.compareTo(s2);
        });
        return urefs;
    }

    private UnificationXref findPreferredUnificationXref(XReferrable bpe) {
        UnificationXref toReturn = null;
        Collection<UnificationXref> orderedUrefs = this.getUnificationXrefsSorted(bpe);
        if (bpe instanceof ProteinReference) {
            toReturn = this.findSingleUnificationXref(orderedUrefs, "uniprot");
            if (toReturn == null) {
                toReturn = this.findSingleUnificationXref(orderedUrefs, "refseq");
            }
        } else if (bpe instanceof SmallMoleculeReference) {
            toReturn = this.findSingleUnificationXref(orderedUrefs, "chebi");
            if (toReturn == null) {
                toReturn = this.findSingleUnificationXref(orderedUrefs, "pubchem");
            }
        } else if (bpe instanceof NucleicAcidReference) {
            toReturn = this.findSingleUnificationXref(orderedUrefs, "entrez");
            if (toReturn == null) {
                toReturn = this.findSingleUnificationXref(orderedUrefs, "ncbigene");
            }
        } else if (orderedUrefs.size() == 1) {
            toReturn = orderedUrefs.iterator().next();
        }
        return toReturn;
    }

    private UnificationXref findSingleUnificationXref(Collection<UnificationXref> uXrefs, String dbStartsWith) {
        UnificationXref ret = null;
        for (Xref xref : uXrefs) {
            if (!(xref instanceof UnificationXref) || xref.getId() == null || xref.getDb() == null || !xref.getDb().toLowerCase().startsWith(dbStartsWith)) continue;
            if (ret == null) {
                ret = (UnificationXref)xref;
                continue;
            }
            if (!ret.getDb().equalsIgnoreCase(xref.getDb()) || ret.getId().equals(xref.getId())) continue;
            ret = null;
            break;
        }
        return ret;
    }

    public void normalize(Model model) {
        this.normalize(model, true);
    }

    public void normalize(Model model, boolean usePrefixAsDbName) {
        if (model.getLevel() != BioPAXLevel.L3) {
            throw new IllegalArgumentException("Not Level3 model. Consider converting it first (e.g., with the PaxTools).");
        }
        if (this.xmlBase != null && !this.xmlBase.isEmpty()) {
            model.setXmlBase(this.xmlBase);
        }
        log.info("Normalizing xrefs..." + this.description);
        this.normalizeXrefs(model, usePrefixAsDbName);
        if (this.fixDisplayName) {
            log.info("Normalizing display names..." + this.description);
            this.fixDisplayName(model);
        }
        log.info("Normalizing CVs..." + this.description);
        this.normalizeCVs(model);
        log.info("Normalizing organisms..." + this.description);
        this.normalizeBioSources(model);
        for (SimplePhysicalEntity spe : new HashSet(model.getObjects(SimplePhysicalEntity.class))) {
            ModelUtils.addMissingEntityReference((Model)model, (SimplePhysicalEntity)spe);
        }
        log.info("Normalizing entity references..." + this.description);
        this.normalizeERs(model);
        log.info("Repairing..." + this.description);
        model.repair();
        log.info("Optional tasks (reasoning)..." + this.description);
    }

    private void normalizeCVs(Model model) {
        NormalizerMap map = new NormalizerMap(model);
        for (ControlledVocabulary cv : model.getObjects(ControlledVocabulary.class)) {
            UnificationXref uref = this.findPreferredUnificationXref((XReferrable)cv);
            if (uref != null) {
                map.put((BioPAXElement)cv, Normalizer.uri(this.xmlBase, uref.getDb(), uref.getId(), cv.getModelInterface()));
                continue;
            }
            if (!cv.getTerm().isEmpty()) {
                map.put((BioPAXElement)cv, Normalizer.uri(this.xmlBase, null, (String)cv.getTerm().iterator().next(), cv.getModelInterface()));
                continue;
            }
            log.info("Cannot normalize " + cv.getModelInterface().getSimpleName() + " : no unification xrefs nor terms found in " + cv.getUri() + ". " + this.description);
        }
        map.doSubs();
    }

    private void normalizeBioSources(Model model) {
        NormalizerMap map = new NormalizerMap(model);
        for (BioSource bs : model.getObjects(BioSource.class)) {
            UnificationXref uref = this.findPreferredUnificationXref((XReferrable)bs);
            if (uref == null) {
                log.debug("BioSource: {} - no unif. xrefs; {}", (Object)bs.getUri(), (Object)this.description);
                continue;
            }
            Namespace ns = Resolver.getNamespace(uref.getDb());
            if (ns == null || !"ncbitaxon".equalsIgnoreCase(ns.getPrefix())) {
                log.debug("BioSource: {} - no taxonomy unif. xrefs; {}", (Object)bs.getUri(), (Object)this.description);
                continue;
            }
            Object idPart = uref.getId();
            if (bs.getTissue() != null && !bs.getTissue().getTerm().isEmpty()) {
                idPart = (String)idPart + "_" + (String)bs.getTissue().getTerm().iterator().next();
            }
            if (bs.getCellType() != null && !bs.getCellType().getTerm().isEmpty()) {
                idPart = (String)idPart + "_" + (String)bs.getCellType().getTerm().iterator().next();
            }
            String uri = Normalizer.uri(this.xmlBase, uref.getDb(), (String)idPart, BioSource.class);
            map.put((BioPAXElement)bs, uri);
        }
        map.doSubs();
    }

    private void normalizeERs(Model model) {
        NormalizerMap map = new NormalizerMap(model);
        for (EntityReference bpe : model.getObjects(EntityReference.class)) {
            UnificationXref uref = this.findPreferredUnificationXref((XReferrable)bpe);
            if (uref != null) {
                String uri;
                String db = uref.getDb();
                String id = uref.getId();
                try {
                    uri = Resolver.getURI(db, id);
                }
                catch (Exception e) {
                    log.error("Cannot get a Miriam standard ID for " + String.valueOf(bpe) + " (" + bpe.getModelInterface().getSimpleName() + ") , using " + db + ":" + id + ". " + e.getMessage());
                    return;
                }
                if (uri == null) continue;
                map.put((BioPAXElement)bpe, uri);
                continue;
            }
            log.info("Cannot normalize EntityReference: no unification xrefs found in " + bpe.getUri() + ". " + this.description);
        }
        map.doSubs();
    }

    public static void autoName(Provenance pro) {
        Namespace ns;
        String uri = pro.getUri();
        String key = StringUtils.startsWithIgnoreCase((CharSequence)uri, (CharSequence)"urn:miriam:") || StringUtils.containsIgnoreCase((CharSequence)uri, (CharSequence)"identifiers.org/") || StringUtils.containsIgnoreCase((CharSequence)uri, (CharSequence)"bioregistry.io/") ? StringUtils.removeEnd((String)uri, (String)"/") : (pro.getStandardName() != null ? pro.getStandardName() : pro.getDisplayName());
        if (key != null && (ns = Resolver.getNamespace(key)) != null) {
            pro.setStandardName(ns.getName());
            pro.addName(ns.getPrefix());
        }
        if (StringUtils.isBlank((CharSequence)pro.getStandardName())) {
            for (String name : pro.getName()) {
                Namespace ns2 = Resolver.getNamespace(name);
                if (ns2 == null) continue;
                String stdName = ns2.getName();
                pro.setStandardName(stdName);
                pro.addName(ns2.getPrefix());
                break;
            }
        }
        if (pro.getDisplayName() == null) {
            pro.setDisplayName(pro.getStandardName());
        }
    }

    public static String convertToLevel3(String biopaxData) {
        String toReturn = "";
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ByteArrayInputStream is = new ByteArrayInputStream(biopaxData.getBytes());
            SimpleIOHandler io = new SimpleIOHandler();
            io.mergeDuplicates(true);
            Model model = io.convertFromOWL((InputStream)is);
            if (model.getLevel() != BioPAXLevel.L3) {
                log.info("Converting to BioPAX Level3... " + model.getXmlBase());
                model = new LevelUpgrader().filter(model);
                if (model != null) {
                    io.setFactory(model.getLevel().getDefaultFactory());
                    io.convertToOWL(model, (OutputStream)os);
                    toReturn = os.toString();
                }
            } else {
                toReturn = biopaxData;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot convert to BioPAX Level3", e);
        }
        return toReturn;
    }

    private String getXmlBase(Model modelToNormalize) {
        if (this.xmlBase != null) {
            return this.xmlBase;
        }
        return "";
    }

    public boolean isFixDisplayName() {
        return this.fixDisplayName;
    }

    public void setFixDisplayName(boolean fixDisplayName) {
        this.fixDisplayName = fixDisplayName;
    }

    public String getXmlBase() {
        return this.xmlBase;
    }

    public void setXmlBase(String xmlBase) {
        this.xmlBase = xmlBase;
    }
}

