/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.constraint;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.ConversionDirectionType;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.constraint.ConstraintAdapter;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.biopax.paxtools.pattern.util.RelType;

public class ParticipatingPE
extends ConstraintAdapter {
    RelType type;

    public ParticipatingPE(RelType type, Blacklist blacklist) {
        super(3, blacklist);
        this.type = type;
    }

    public ParticipatingPE(RelType type) {
        this(type, null);
    }

    @Override
    public boolean canGenerate() {
        return true;
    }

    @Override
    public Collection<BioPAXElement> generate(Match match, int ... ind) {
        Control cont = (Control)match.get(ind[0]);
        Conversion conv = (Conversion)match.get(ind[1]);
        ConversionDirectionType dir = this.getDirection(conv, cont);
        HashSet<Set> sides = new HashSet<Set>();
        if (dir == ConversionDirectionType.LEFT_TO_RIGHT) {
            sides.add(this.type == RelType.INPUT ? conv.getLeft() : conv.getRight());
        } else if (dir == ConversionDirectionType.RIGHT_TO_LEFT) {
            sides.add(this.type == RelType.OUTPUT ? conv.getLeft() : conv.getRight());
        } else {
            sides.add(conv.getLeft());
            sides.add(conv.getRight());
        }
        HashSet<BioPAXElement> result = new HashSet<BioPAXElement>();
        if (this.blacklist == null) {
            for (Set side : sides) {
                result.addAll(side);
            }
        } else {
            for (Set side : sides) {
                result.addAll(this.blacklist.getNonUbiques(side, dir == ConversionDirectionType.REVERSIBLE ? null : this.type));
            }
        }
        return result;
    }
}

