/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.example;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.ModificationFeature;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.Pattern;
import org.biopax.paxtools.pattern.PatternBox;
import org.biopax.paxtools.pattern.Searcher;
import org.biopax.paxtools.pattern.miner.AbstractSIFMiner;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.biopax.paxtools.pattern.util.Blacklist;

public class DeltaFeatureExtractor {
    private Map<String, Map<String, Set<String>>> gainMods;
    private Map<String, Map<String, Set<String>>> lossMods;
    private Map<String, Map<String, Set<String>>> gainComps;
    private Map<String, Map<String, Set<String>>> lossComps;
    private Map<String, Map<String, Set<String>>> sourceMods;
    private Map<String, Map<String, Set<String>>> sourceComps;
    private Map<String, Map<String, Set<String>>> mediators;
    private AbstractMiner[] miners = new AbstractMiner[]{new CSCO(), new CSCO_ButPart(), new CSCO_CtrlAndPart(), new CSCO_ThrContSmMol()};
    private static final String ACTIVE_WORD = "residue modification, active";
    private static final String INACTIVE_WORD = "residue modification, inactive";

    public static void main(String[] args) throws IOException {
        Blacklist black = new Blacklist("blacklist.txt");
        DeltaFeatureExtractor dfe = new DeltaFeatureExtractor();
        dfe.setBlacklist(black);
        SimpleIOHandler io = new SimpleIOHandler();
        Model model = io.convertFromOWL((InputStream)new FileInputStream("Pathway Commons.5.Detailed_Process_Data.BIOPAX.owl"));
        dfe.mineAndCollect(model);
        dfe.writeResults("DeltaFeatures.txt");
    }

    public DeltaFeatureExtractor() {
        this.gainMods = new HashMap<String, Map<String, Set<String>>>();
        this.lossMods = new HashMap<String, Map<String, Set<String>>>();
        this.gainComps = new HashMap<String, Map<String, Set<String>>>();
        this.lossComps = new HashMap<String, Map<String, Set<String>>>();
        this.sourceMods = new HashMap<String, Map<String, Set<String>>>();
        this.sourceComps = new HashMap<String, Map<String, Set<String>>>();
        this.mediators = new HashMap<String, Map<String, Set<String>>>();
    }

    public void setBlacklist(Blacklist blacklist) {
        for (AbstractMiner miner : this.miners) {
            miner.setBlacklist(blacklist);
        }
    }

    public void mineAndCollect(Model model) {
        for (AbstractMiner miner : this.miners) {
            Map<BioPAXElement, List<Match>> matches = Searcher.search(model, miner.getPattern());
            try {
                miner.writeResult(matches, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void writeResults(String filename) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
        writer.write("Source\tType\tTarget\tSource-modifs\tSource-locs\tGained-modifs\tLost-modifs\tGained-locs\tLost-locs\tMediators");
        HashSet<String> s1s = new HashSet<String>(this.gainMods.keySet());
        s1s.addAll(this.lossMods.keySet());
        for (String s1 : s1s) {
            HashSet<String> s2s = new HashSet<String>();
            if (this.gainMods.containsKey(s1)) {
                s2s.addAll(this.gainMods.get(s1).keySet());
            }
            if (this.lossMods.containsKey(s1)) {
                s2s.addAll(this.lossMods.get(s1).keySet());
            }
            for (String s2 : s2s) {
                writer.write("\n" + s1 + "\t" + SIFEnum.CONTROLS_STATE_CHANGE_OF.getTag() + "\t" + s2);
                this.writeVal(writer, s1, s2, this.sourceMods);
                this.writeVal(writer, s1, s2, this.sourceComps);
                this.writeVal(writer, s1, s2, this.gainMods);
                this.writeVal(writer, s1, s2, this.lossMods);
                this.writeVal(writer, s1, s2, this.gainComps);
                this.writeVal(writer, s1, s2, this.lossComps);
                writer.write("\t" + this.toString(this.mediators.get(s1).get(s2)));
            }
        }
        writer.close();
    }

    private void correctForActiveAndInactive(Map<String, Map<String, Set<String>>> ... maps) {
        for (Map<String, Map<String, Set<String>>> map : maps) {
            for (Map<String, Set<String>> setMaps : map.values()) {
                for (Set<String> set : setMaps.values()) {
                    if (set.contains(ACTIVE_WORD)) {
                        set.remove(ACTIVE_WORD);
                        set.add("active");
                    }
                    if (!set.contains(INACTIVE_WORD)) continue;
                    set.remove(INACTIVE_WORD);
                    set.add("inactive");
                }
            }
        }
    }

    private void writeVal(BufferedWriter writer, String s1, String s2, Map<String, Map<String, Set<String>>> map) throws IOException {
        writer.write("\t");
        if (map.containsKey(s1) && map.get(s1).containsKey(s2)) {
            writer.write(map.get(s1).get(s2).toString());
        }
    }

    private String toString(Set<String> set) {
        String s = "";
        for (String s1 : set) {
            s = s + " " + s1;
        }
        return s.substring(1);
    }

    class CSCO_ThrContSmMol
    extends AbstractMiner {
        CSCO_ThrContSmMol() {
        }

        @Override
        public Pattern constructPattern() {
            return PatternBox.controlsStateChangeThroughControllerSmallMolecule(this.blacklist);
        }

        @Override
        String getSourceSimplePELabel() {
            return "upper controller simple PE";
        }

        @Override
        String getSourceComplexPELabel() {
            return "upper controller PE";
        }

        @Override
        public String getSourceLabel() {
            return "upper controller ER";
        }

        @Override
        public String[] getMediatorLabels() {
            return new String[]{"upper Control", "upper Conversion", "Control", "Conversion"};
        }

        @Override
        public String[] getControlLabels() {
            return new String[]{"upper Control", "Control"};
        }
    }

    class CSCO_ButPart
    extends AbstractMiner {
        CSCO_ButPart() {
        }

        @Override
        public Pattern constructPattern() {
            return PatternBox.controlsStateChangeButIsParticipant();
        }

        @Override
        public String[] getControlLabels() {
            return new String[0];
        }

        @Override
        public String[] getMediatorLabels() {
            return new String[]{"Conversion"};
        }
    }

    class CSCO_CtrlAndPart
    extends AbstractMiner {
        CSCO_CtrlAndPart() {
        }

        @Override
        public Pattern constructPattern() {
            return PatternBox.controlsStateChangeBothControlAndPart();
        }
    }

    class CSCO
    extends AbstractMiner {
        CSCO() {
        }

        @Override
        public Pattern constructPattern() {
            return PatternBox.controlsStateChange();
        }
    }

    abstract class AbstractMiner
    extends AbstractSIFMiner {
        public AbstractMiner() {
            super(SIFEnum.CONTROLS_STATE_CHANGE_OF);
        }

        @Override
        public abstract Pattern constructPattern();

        @Override
        public void writeResult(Map<BioPAXElement, List<Match>> matches, OutputStream out) throws IOException {
            for (List<Match> matchList : matches.values()) {
                for (Match m : matchList) {
                    Set<String> s1 = this.getIdentifiers(m, this.getSourceLabel());
                    Set<String> s2 = this.getIdentifiers(m, this.getTargetLabel());
                    if (s1.isEmpty() || s2.isEmpty()) continue;
                    Set<String>[] modif = this.getDeltaModifications(m, this.getInputSimplePELabel(), this.getInputComplexPELabel(), this.getOutputSimplePELabel(), this.getOutputComplexPELabel());
                    Set<String>[] comps = this.getDeltaCompartments(m, this.getInputSimplePELabel(), this.getInputComplexPELabel(), this.getOutputSimplePELabel(), this.getOutputComplexPELabel());
                    int sign = this.sign(m, this.getControlLabels());
                    if (this.labeledInactive(m, this.getSourceSimplePELabel(), this.getSourceComplexPELabel())) {
                        sign *= -1;
                    }
                    Set<String> modif0 = modif[sign == -1 ? 1 : 0];
                    Set<String> modif1 = modif[sign == -1 ? 0 : 1];
                    Set<String> comps0 = comps[sign == -1 ? 1 : 0];
                    Set<String> comps1 = comps[sign == -1 ? 0 : 1];
                    for (String s1s : s1) {
                        for (String s2s : s2) {
                            if (!modif0.isEmpty()) {
                                this.collect(s1s, s2s, modif0, DeltaFeatureExtractor.this.gainMods);
                            }
                            if (!modif1.isEmpty()) {
                                this.collect(s1s, s2s, modif1, DeltaFeatureExtractor.this.lossMods);
                            }
                            if (!comps0.isEmpty()) {
                                this.collect(s1s, s2s, comps0, DeltaFeatureExtractor.this.gainComps);
                            }
                            if (!comps1.isEmpty()) {
                                this.collect(s1s, s2s, comps1, DeltaFeatureExtractor.this.lossComps);
                            }
                            if (modif[0].isEmpty() && modif[1].isEmpty() && comps[0].isEmpty() && comps[1].isEmpty()) continue;
                            if (!DeltaFeatureExtractor.this.mediators.containsKey(s1s)) {
                                DeltaFeatureExtractor.this.mediators.put(s1s, new HashMap());
                            }
                            if (!((Map)DeltaFeatureExtractor.this.mediators.get(s1s)).containsKey(s2s)) {
                                ((Map)DeltaFeatureExtractor.this.mediators.get(s1s)).put(s2s, new HashSet());
                            }
                            List<BioPAXElement> meds = m.get(this.getMediatorLabels(), this.getPattern());
                            for (BioPAXElement med : meds) {
                                ((Set)((Map)DeltaFeatureExtractor.this.mediators.get(s1s)).get(s2s)).add(med.getRDFId());
                            }
                            Set<String> mods = this.getModifications(m, this.getSourceSimplePELabel(), this.getSourceComplexPELabel());
                            Set<String> locs = this.getCellularLocations(m, this.getSourceSimplePELabel(), this.getSourceComplexPELabel());
                            this.collect(s1s, s2s, mods, DeltaFeatureExtractor.this.sourceMods);
                            this.collect(s1s, s2s, locs, DeltaFeatureExtractor.this.sourceComps);
                        }
                    }
                }
            }
            DeltaFeatureExtractor.this.correctForActiveAndInactive(new Map[]{DeltaFeatureExtractor.this.gainMods, DeltaFeatureExtractor.this.lossMods, DeltaFeatureExtractor.this.sourceMods});
        }

        private void collect(String s1, String s2, Set<String> modificationFeatures, Map<String, Map<String, Set<String>>> map) {
            if (!map.containsKey(s1)) {
                map.put(s1, new HashMap());
            }
            if (!map.get(s1).containsKey(s2)) {
                map.get(s1).put(s2, new HashSet());
            }
            map.get(s1).get(s2).addAll(modificationFeatures);
        }

        String getSourceSimplePELabel() {
            return "controller simple PE";
        }

        String getSourceComplexPELabel() {
            return "controller PE";
        }

        String getInputSimplePELabel() {
            return "input simple PE";
        }

        String getOutputSimplePELabel() {
            return "output simple PE";
        }

        String getInputComplexPELabel() {
            return "input PE";
        }

        String getOutputComplexPELabel() {
            return "output PE";
        }

        @Override
        public String getSourceLabel() {
            return "controller ER";
        }

        @Override
        public String getTargetLabel() {
            return "changed ER";
        }

        @Override
        public String[] getMediatorLabels() {
            return new String[]{"Control", "Conversion"};
        }

        public String[] getControlLabels() {
            return new String[]{"Control"};
        }

        protected String toString(ModificationFeature mf) {
            String term = this.getModificationTerm(mf);
            if (term != null) {
                String loc = this.getPositionInString(mf);
                return term + loc;
            }
            return null;
        }
    }
}

