/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.miner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.pattern.miner.SIFInteraction;

public class OutputColumn {
    private Type type;
    private PathAccessor[] accessors;

    public OutputColumn(String field) {
        if (field == null) {
            throw new IllegalArgumentException("The field parameter has to be specified");
        }
        try {
            this.type = Type.valueOf(field.toUpperCase());
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.type == Type.CUSTOM) {
                throw new IllegalArgumentException("The \"custom\" type should be stated implicitly by passing path accessor strings as parameter.");
            }
            if (this.type == null) {
                this.type = Type.CUSTOM;
                String[] param = field.split(";");
                this.accessors = new PathAccessor[param.length];
                for (int i = 0; i < this.accessors.length; ++i) {
                    if (!param[i].contains("/")) {
                        throw new IllegalArgumentException("The parameter column field is not recognized as a pre-defined type. It also does not qualify as a path accessor argument string.");
                    }
                    this.accessors[i] = new PathAccessor(param[i]);
                }
            }
            return;
        }
    }

    public String getColumnValue(SIFInteraction inter) {
        switch (this.type) {
            case MEDIATOR: {
                return this.concat(inter.getMediatorIDs());
            }
            case PATHWAY: {
                return this.concat(inter.getPathwayNames());
            }
            case PUBMED: {
                return this.concat(inter.getPubmedIDs());
            }
            case RESOURCE: {
                return this.concat(inter.getDataSources());
            }
            case SOURCE_LOC: {
                return this.concat(inter.getCellularLocationsOfSource());
            }
            case TARGET_LOC: {
                return this.concat(inter.getCellularLocationsOfTarget());
            }
            case CUSTOM: {
                HashSet<String> set = new HashSet<String>();
                for (PathAccessor acc : this.accessors) {
                    for (Object o : acc.getValueFromBeans(inter.mediators)) {
                        set.add(o.toString());
                    }
                }
                ArrayList<String> list = new ArrayList<String>(set);
                Collections.sort(list);
                return this.concat(list);
            }
        }
        throw new RuntimeException("Unhandled type: " + (Object)((Object)this.type) + ". This shouldn't be happening.");
    }

    private String concat(Collection<String> col) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (String s : col) {
            if (first) {
                first = false;
            } else {
                b.append(";");
            }
            b.append(s);
        }
        return b.toString();
    }

    public static enum Type {
        MEDIATOR,
        PUBMED,
        PATHWAY,
        RESOURCE,
        SOURCE_LOC,
        TARGET_LOC,
        CUSTOM;


        public static Type getType(String name) {
            for (Type type : Type.values()) {
                if (!type.name().toLowerCase().equals(name.toLowerCase())) continue;
                return type;
            }
            return null;
        }
    }
}

