/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.util;

import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.CellularLocationVocabulary;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.ModificationFeature;
import org.biopax.paxtools.model.level3.PhysicalEntity;

public class PhysicalEntityChain {
    public PhysicalEntity[] pes;
    protected static final PathAccessor PE2TERM = new PathAccessor("PhysicalEntity/feature:ModificationFeature/modificationType/term");
    protected static final PathAccessor PE2FEAT = new PathAccessor("PhysicalEntity/feature:ModificationFeature");

    public PhysicalEntityChain(PhysicalEntity small, PhysicalEntity big) {
        this.pes = this.fillArray(big, small, 1, 0);
        if (this.pes == null) {
            throw new IllegalArgumentException("No link found between small PE = " + small.getRDFId() + " and big PE = " + big.getRDFId());
        }
        assert (!this.containsNull(this.pes));
    }

    private boolean containsNull(PhysicalEntity[] pes) {
        for (PhysicalEntity pe : pes) {
            if (pe != null) continue;
            return true;
        }
        return false;
    }

    protected PhysicalEntity[] fillArray(PhysicalEntity parent, PhysicalEntity target, int depth, int dir) {
        PhysicalEntity[] pes;
        if (parent == target) {
            PhysicalEntity[] pes2 = new PhysicalEntity[depth];
            pes2[0] = target;
            return pes2;
        }
        if (parent instanceof Complex) {
            for (PhysicalEntity mem : ((Complex)parent).getComponent()) {
                pes = this.fillArray(mem, target, depth + 1, 0);
                if (pes == null) continue;
                pes[pes.length - depth] = parent;
                return pes;
            }
        }
        if (dir <= 0) {
            for (PhysicalEntity mem : parent.getMemberPhysicalEntity()) {
                pes = this.fillArray(mem, target, depth + 1, -1);
                if (pes == null) continue;
                pes[pes.length - depth] = parent;
                return pes;
            }
        }
        if (dir >= 0) {
            for (PhysicalEntity grand : parent.getMemberPhysicalEntityOf()) {
                pes = this.fillArray(grand, target, depth + 1, 1);
                if (pes == null) continue;
                pes[pes.length - depth] = parent;
                return pes;
            }
        }
        return null;
    }

    public Set<String> getCellularLocations() {
        HashSet<String> locs = new HashSet<String>();
        for (PhysicalEntity pe : this.pes) {
            CellularLocationVocabulary voc = pe.getCellularLocation();
            if (voc == null) continue;
            for (String term : voc.getTerm()) {
                if (term == null || term.length() <= 0) continue;
                locs.add(term);
            }
        }
        return locs;
    }

    public boolean intersects(PhysicalEntityChain rpeh) {
        return this.intersects(rpeh, false);
    }

    public boolean intersects(PhysicalEntityChain rpeh, boolean ignoreEndPoints) {
        for (PhysicalEntity pe1 : this.pes) {
            for (PhysicalEntity pe2 : rpeh.pes) {
                if (pe1 != pe2 || ignoreEndPoints && (this.pes[0] == pe1 || this.pes[this.pes.length - 1] == pe1) && (rpeh.pes[0] == pe2 || rpeh.pes[rpeh.pes.length - 1] == pe2)) continue;
                return true;
            }
        }
        return false;
    }

    public Activity checkActivityLabel() {
        boolean active = false;
        boolean inactive = false;
        for (PhysicalEntity pe : this.pes) {
            for (Object o : PE2TERM.getValueFromBean((BioPAXElement)pe)) {
                String s = (String)o;
                if (s.contains("inactiv")) {
                    inactive = true;
                    continue;
                }
                if (!s.contains("activ")) continue;
                active = true;
            }
            for (String s : pe.getName()) {
                if (s.contains("inactiv")) {
                    inactive = true;
                    continue;
                }
                if (!s.contains("activ")) continue;
                active = true;
            }
        }
        if (active) {
            if (inactive) {
                return Activity.BOTH;
            }
            return Activity.ACTIVE;
        }
        if (inactive) {
            return Activity.INACTIVE;
        }
        return Activity.NONE;
    }

    public Set<ModificationFeature> getModifications() {
        HashSet<ModificationFeature> set = new HashSet<ModificationFeature>();
        for (PhysicalEntity pe : this.pes) {
            set.addAll(PE2FEAT.getValueFromBean((BioPAXElement)pe));
        }
        return set;
    }

    public static enum Activity {
        ACTIVE,
        INACTIVE,
        BOTH,
        NONE;

    }
}

