package org.biopax.paxtools.pattern.constraint;

import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * PathConstraint encapsulates PathAccessor of Paxtools.
 *
 * @author Ozgun Babur
 */
public class PathConstraint extends ConstraintAdapter
{
	/**
	 * Encapsulated PathAccessor.
	 */
	PathAccessor pa;

	/**
	 * Constructor with the constructor String of PathAccessor.
	 * @param path constructor String of PathAccessor
	 */
	public PathConstraint(String path)
	{
		super(2);
		this.pa = new PathAccessor(path, BioPAXLevel.L3);
	}

	/**
	 * Checks if the PathAccessor is generating the second mapped element.
	 * @param match current pattern match
	 * @param ind mapped indices
	 * @return true if second element is generated by PathAccessor
	 */
	@Override
	public boolean satisfies(Match match, int... ind)
	{
		BioPAXElement ele0 = match.get(ind[0]);
		BioPAXElement ele1 = match.get(ind[1]);

		if (ele1 == null) return false;

		Set vals = pa.getValueFromBean(ele0);
		return vals.contains(ele1);
	}

	/**
	 * This is a generative constraint.
	 * @return true
	 */
	@Override
	public boolean canGenerate()
	{
		return true;
	}

	/**
	 * Uses the encapsulated PAthAccessor to generate satisfying elements.
	 * @param match current pattern match
	 * @param ind mapped indices
	 * @return generated elements
	 */
	@Override
	public Collection<BioPAXElement> generate(Match match, int ... ind)
	{
		BioPAXElement ele0 = match.get(ind[0]);

		if (ele0 == null)
			throw new RuntimeException("Constraint cannot generate based on null value");

		Set vals = pa.getValueFromBean(ele0);
		List<BioPAXElement> list = new ArrayList<BioPAXElement>(vals.size());

		for (Object o : vals)
		{
			assert o instanceof BioPAXElement;
			list.add((BioPAXElement) o);
		}
		return list;
	}
}
