/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.constraint;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.ConversionDirectionType;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.constraint.ConstraintAdapter;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.biopax.paxtools.pattern.util.RelType;

public class Participant
extends ConstraintAdapter {
    RelType type;
    boolean considerControl;
    boolean considerPathway;

    public Participant(RelType type, Blacklist blacklist, boolean considerControl, boolean considerPathway) {
        super(considerControl && considerPathway ? 4 : (considerControl || considerPathway ? 3 : 2), blacklist);
        this.type = type;
        this.considerControl = considerControl;
        this.considerPathway = considerPathway;
    }

    public Participant(RelType type) {
        this(type, null, false, false);
    }

    public Participant(RelType type, Blacklist blacklist) {
        this(type, blacklist, false, false);
    }

    public Participant(RelType type, Blacklist blacklist, boolean considerControl) {
        this(type, blacklist, considerControl, false);
    }

    public Participant(RelType type, boolean considerControl) {
        this(type, null, considerControl, false);
    }

    public Participant(RelType type, boolean considerControl, boolean considerPathway) {
        this(type, null, considerControl, considerPathway);
    }

    @Override
    public boolean canGenerate() {
        return true;
    }

    @Override
    public Collection<BioPAXElement> generate(Match match, int ... ind) {
        ConversionDirectionType dir;
        Pathway pathway;
        Conversion cnv = (Conversion)match.get(ind[this.getVariableSize() - 2]);
        if (this.considerControl && this.considerPathway) {
            pathway = (Pathway)match.get(ind[0]);
            Control control = (Control)match.get(ind[1]);
            dir = this.getDirection(cnv, pathway, control);
        } else if (this.considerControl) {
            Control control = (Control)match.get(ind[0]);
            dir = this.getDirection(cnv, control);
        } else if (this.considerPathway) {
            pathway = (Pathway)match.get(ind[0]);
            dir = this.getDirection(cnv, pathway);
        } else {
            dir = this.getDirection(cnv);
        }
        HashSet<Set> sides = new HashSet<Set>();
        if (dir == ConversionDirectionType.REVERSIBLE) {
            sides.add(cnv.getLeft());
            sides.add(cnv.getRight());
        } else if (dir == ConversionDirectionType.RIGHT_TO_LEFT) {
            sides.add(this.type == RelType.INPUT ? cnv.getRight() : cnv.getLeft());
        } else if (dir == ConversionDirectionType.LEFT_TO_RIGHT || dir == null) {
            sides.add(this.type == RelType.OUTPUT ? cnv.getRight() : cnv.getLeft());
        }
        HashSet<BioPAXElement> result = new HashSet<BioPAXElement>();
        if (this.blacklist == null) {
            for (Set side : sides) {
                result.addAll(side);
            }
        } else {
            for (Set side : sides) {
                result.addAll(this.blacklist.getNonUbiques(side, dir == ConversionDirectionType.REVERSIBLE ? null : this.type));
            }
        }
        return result;
    }
}

