/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.constraint;

import java.util.Arrays;
import java.util.HashSet;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.pattern.Constraint;
import org.biopax.paxtools.pattern.MappedConst;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.constraint.AND;
import org.biopax.paxtools.pattern.constraint.ActivityConstraint;
import org.biopax.paxtools.pattern.constraint.ConstraintAdapter;
import org.biopax.paxtools.pattern.constraint.ConstraintChain;
import org.biopax.paxtools.pattern.constraint.Empty;
import org.biopax.paxtools.pattern.constraint.Equality;
import org.biopax.paxtools.pattern.constraint.Field;
import org.biopax.paxtools.pattern.constraint.FieldOfMultiple;
import org.biopax.paxtools.pattern.constraint.LinkedPE;
import org.biopax.paxtools.pattern.constraint.MultiPathConstraint;
import org.biopax.paxtools.pattern.constraint.NOT;
import org.biopax.paxtools.pattern.constraint.OR;
import org.biopax.paxtools.pattern.constraint.ParticipatesInConv;
import org.biopax.paxtools.pattern.constraint.PathConstraint;
import org.biopax.paxtools.pattern.constraint.SelfOrThis;
import org.biopax.paxtools.pattern.constraint.Size;
import org.biopax.paxtools.pattern.constraint.Type;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.biopax.paxtools.pattern.util.RelType;

public class ConBox {
    public static Constraint erToPE() {
        return new PathConstraint("EntityReference/entityReferenceOf");
    }

    public static Constraint peToER() {
        return new PathConstraint("SimplePhysicalEntity/entityReference");
    }

    public static Constraint peToControl() {
        return new PathConstraint("PhysicalEntity/controllerOf");
    }

    public static Constraint peToControlledConv() {
        return new PathConstraint("PhysicalEntity/controllerOf/controlled*:Conversion");
    }

    public static Constraint peToControlledInter() {
        return new PathConstraint("PhysicalEntity/controllerOf/controlled*:Interaction");
    }

    public static Constraint peToInter() {
        return new OR(new MappedConst(ConBox.peToControlledInter(), 0, 1), new MappedConst(ConBox.participatesInInter(), 0, 1));
    }

    public static Constraint simplePEToConv(RelType type) {
        return new ConstraintChain(ConBox.linkToComplex(), new ParticipatesInConv(type));
    }

    public static Constraint interToPE() {
        return new OR(new MappedConst(ConBox.interToController(), 0, 1), new MappedConst(ConBox.participant(), 0, 1));
    }

    public static Constraint controlled() {
        return new PathConstraint("Control/controlled");
    }

    public static Constraint controllerPE() {
        return new PathConstraint("Control/controller:PhysicalEntity");
    }

    public static Constraint controlToConv() {
        return new PathConstraint("Control/controlled*:Conversion");
    }

    public static Constraint controlToTempReac() {
        return new PathConstraint("Control/controlled*:TemplateReaction");
    }

    public static Constraint controlToInter() {
        return new PathConstraint("Control/controlled*:Interaction");
    }

    public static Constraint convToControl() {
        return new PathConstraint("Conversion/controlledOf*");
    }

    public static Constraint convToController() {
        return new PathConstraint("Conversion/controlledOf*/controller");
    }

    public static Constraint interToControl() {
        return new PathConstraint("Interaction/controlledOf*");
    }

    public static Constraint controlsConv() {
        return new PathConstraint("PhysicalEntity/controllerOf/controlled*:Conversion");
    }

    public static Constraint controlsInteraction() {
        return new PathConstraint("PhysicalEntity/controllerOf/controlled*:Interaction");
    }

    public static Constraint nextInteraction() {
        return new PathConstraint("Interaction/stepProcessOf/nextStep/stepProcess:Interaction");
    }

    public static Constraint genericEquiv() {
        return new SelfOrThis(new MultiPathConstraint("PhysicalEntity/memberPhysicalEntity*", "PhysicalEntity/memberPhysicalEntityOf*"));
    }

    public static Constraint complexMembers() {
        return new PathConstraint("Complex/component*");
    }

    public static Constraint simpleMembers() {
        return new PathConstraint("Complex/component*:SimplePhysicalEntity");
    }

    public static Constraint withComplexMembers() {
        return new SelfOrThis(ConBox.complexMembers());
    }

    public static Constraint withSimpleMembers() {
        return new SelfOrThis(ConBox.simpleMembers());
    }

    public static Constraint complexes() {
        return new PathConstraint("PhysicalEntity/componentOf*");
    }

    public static Constraint withComplexes() {
        return new SelfOrThis(ConBox.complexes());
    }

    public static Constraint left() {
        return new PathConstraint("Conversion/left");
    }

    public static Constraint right() {
        return new PathConstraint("Conversion/right");
    }

    public static Constraint participatesInConv() {
        return new PathConstraint("PhysicalEntity/participantOf:Conversion");
    }

    public static Constraint participatesInInter() {
        return new PathConstraint("PhysicalEntity/participantOf");
    }

    public static Constraint interToController() {
        return new PathConstraint("Interaction/controlledOf*:Control/controller:PhysicalEntity");
    }

    public static Constraint compToER() {
        return new PathConstraint("Complex/component*:SimplePhysicalEntity/entityReference");
    }

    public static Constraint nameEquals(String name) {
        return new Field("Named/name", Field.Operation.INTERSECT, name);
    }

    public static Constraint nameEquals(String ... name) {
        return new Field("Named/name", Field.Operation.INTERSECT, new HashSet<String>(Arrays.asList(name)));
    }

    public static Constraint differentialActivity(boolean activating) {
        if (activating) {
            return new AND(new MappedConst(new ActivityConstraint(true), 1), new MappedConst(new ActivityConstraint(false), 0));
        }
        return new AND(new MappedConst(new ActivityConstraint(true), 0), new MappedConst(new ActivityConstraint(false), 1));
    }

    public static Constraint participant() {
        return new PathConstraint("Interaction/participant:PhysicalEntity");
    }

    public static Constraint participantER() {
        return new ConstraintChain(ConBox.participant(), ConBox.linkToSpecific(), ConBox.peToER(), ConBox.linkedER(false));
    }

    public static Constraint product() {
        return new PathConstraint("TemplateReaction/product");
    }

    public static Constraint notControlled() {
        return new Empty(new PathConstraint("Interaction/controlledOf"));
    }

    public static Constraint isHuman() {
        return new OR(new MappedConst(new Field("SequenceEntityReference/organism/displayName", Field.Operation.INTERSECT, "Homo sapiens"), 0), new MappedConst(new Field("PhysicalEntity/entityReference/organism/displayName", Field.Operation.INTERSECT, "Homo sapiens"), 0));
    }

    public static Constraint hasXref(String xrefID) {
        return new Field("XReferrable/xref/id", Field.Operation.INTERSECT, xrefID);
    }

    public static Constraint notAParticipant() {
        return new NOT(new Field("Interaction/participant", Field.Operation.INTERSECT, Field.USE_SECOND_ARG));
    }

    public static Constraint peNotRelatedToER() {
        return new NOT(new ConstraintChain(ConBox.linkToSpecific(), ConBox.peToER()));
    }

    public static Constraint notControlsThis() {
        return new NOT(ConBox.controlToInter());
    }

    public static Constraint notLabeledInactive() {
        return new NOT(ConBox.modificationConstraint("residue modification, inactive"));
    }

    public static Constraint modificationConstraint(String modifTerm) {
        return new FieldOfMultiple(new MappedConst(new LinkedPE(LinkedPE.Type.TO_SPECIFIC), 0), "PhysicalEntity/feature:ModificationFeature/modificationType/term", Field.Operation.INTERSECT, modifTerm);
    }

    public static Constraint linkToSpecific() {
        return new LinkedPE(LinkedPE.Type.TO_SPECIFIC);
    }

    public static Constraint linkToComplex() {
        return new LinkedPE(LinkedPE.Type.TO_GENERAL);
    }

    public static Constraint linkedER(boolean up) {
        return new SelfOrThis(new PathConstraint("EntityReference/memberEntityReference" + (up ? "Of" : "") + "*"));
    }

    public static Constraint linkToSimple(Blacklist blacklist) {
        return new LinkedPE(LinkedPE.Type.TO_SPECIFIC, blacklist);
    }

    public static Constraint linkToComplex(Blacklist blacklist) {
        return new LinkedPE(LinkedPE.Type.TO_GENERAL, blacklist);
    }

    public static Constraint equal(boolean equal) {
        return new Equality(equal);
    }

    public static Constraint type(Class<? extends BioPAXElement> clazz) {
        return new Type(clazz);
    }

    public static Constraint notGeneric() {
        return new Empty(new PathConstraint("PhysicalEntity/memberPhysicalEntity"));
    }

    public static Constraint maxDegree(int limit) {
        return new Size(new PathConstraint("PhysicalEntity/participantOf:Conversion"), limit, Size.Type.LESS_OR_EQUAL);
    }

    public static Constraint source(String dbname) {
        return new Field("Entity/dataSource/displayName", Field.Operation.INTERSECT, dbname);
    }

    public static Constraint inSamePathway() {
        String s1 = "Interaction/stepProcessOf/pathwayOrderOf";
        String s2 = "Interaction/pathwayComponentOf";
        return new OR(new MappedConst(new Field(s1, s1, Field.Operation.INTERSECT), 0, 1), new MappedConst(new Field(s2, s2, Field.Operation.INTERSECT), 0, 1));
    }

    public static Constraint moreControllerThanParticipant() {
        return new ConstraintAdapter(1){
            PathAccessor partConv = new PathAccessor("PhysicalEntity/participantOf:Conversion");
            PathAccessor partCompAss = new PathAccessor("PhysicalEntity/participantOf:ComplexAssembly");
            PathAccessor effects = new PathAccessor("PhysicalEntity/controllerOf/controlled*:Conversion");

            @Override
            public boolean satisfies(Match match, int ... ind) {
                int effCnt;
                int partCACnt;
                PhysicalEntity pe = (PhysicalEntity)match.get(ind[0]);
                int partCnvCnt = this.partConv.getValueFromBean((BioPAXElement)pe).size();
                return partCnvCnt - (partCACnt = this.partCompAss.getValueFromBean((BioPAXElement)pe).size()) <= (effCnt = this.effects.getValueFromBean((BioPAXElement)pe).size());
            }
        };
    }

    public static Constraint hasDifferentCompartments() {
        String acStr = "PhysicalEntity/cellularLocation/term";
        return new Field(acStr, acStr, Field.Operation.NOT_EMPTY_AND_NOT_INTERSECT);
    }

    public static Constraint isPrey() {
        return new Field("PhysicalEntity/evidence/experimentalForm/experimentalFormDescription/term", Field.Operation.INTERSECT, "prey");
    }

    public static Constraint isBait() {
        return new Field("PhysicalEntity/evidence/experimentalForm/experimentalFormDescription/term", Field.Operation.INTERSECT, "bait");
    }
}

