/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.constraint;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.ConversionDirectionType;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.constraint.ConstraintAdapter;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.biopax.paxtools.pattern.util.RelType;

public class ConversionSide
extends ConstraintAdapter {
    Type sideType;
    RelType relType;

    public ConversionSide(Type type) {
        this(type, null, null);
    }

    public ConversionSide(Type type, Blacklist blacklist, RelType relType) {
        super(3, blacklist);
        if (type == null) {
            throw new IllegalArgumentException("The \"type\" parameter cannot be null.");
        }
        this.sideType = type;
        this.relType = relType;
    }

    @Override
    public boolean canGenerate() {
        return true;
    }

    @Override
    public Collection<BioPAXElement> generate(Match match, int ... ind) {
        Set parts;
        this.assertIndLength(ind);
        PhysicalEntity pe1 = (PhysicalEntity)match.get(ind[0]);
        Conversion conv = (Conversion)match.get(ind[1]);
        if (conv.getLeft().contains(pe1)) {
            parts = this.sideType == Type.OTHER_SIDE ? conv.getRight() : conv.getLeft();
        } else if (conv.getRight().contains(pe1)) {
            parts = this.sideType == Type.SAME_SIDE ? conv.getRight() : conv.getLeft();
        } else {
            throw new IllegalArgumentException("The PhysicalEntity has to be a participant of the Conversion.");
        }
        if (this.blacklist == null) {
            return new HashSet<BioPAXElement>(parts);
        }
        ConversionDirectionType dir = this.getDirection(conv);
        if (dir == ConversionDirectionType.LEFT_TO_RIGHT && (this.relType == RelType.INPUT && parts != conv.getLeft() || this.relType == RelType.OUTPUT && parts != conv.getRight()) || dir == ConversionDirectionType.RIGHT_TO_LEFT && (this.relType == RelType.INPUT && parts != conv.getRight() || this.relType == RelType.OUTPUT && parts != conv.getLeft())) {
            return Collections.emptySet();
        }
        return new HashSet<PhysicalEntity>(this.blacklist.getNonUbiques(parts, this.relType));
    }

    public static enum Type {
        OTHER_SIDE,
        SAME_SIDE;

    }
}

