/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.constraint;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.BiochemicalPathwayStep;
import org.biopax.paxtools.model.level3.Catalysis;
import org.biopax.paxtools.model.level3.CatalysisDirectionType;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.ConversionDirectionType;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PathwayStep;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.model.level3.StepDirection;
import org.biopax.paxtools.pattern.Constraint;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.biopax.paxtools.pattern.util.RelType;

public abstract class ConstraintAdapter
implements Constraint {
    protected int size;
    protected Blacklist blacklist;

    protected ConstraintAdapter(int size) {
        this.size = size;
    }

    protected ConstraintAdapter(int size, Blacklist blacklist) {
        this.size = size;
        this.blacklist = blacklist;
    }

    protected ConstraintAdapter() {
    }

    @Override
    public boolean canGenerate() {
        return false;
    }

    @Override
    public Collection<BioPAXElement> generate(Match match, int ... ind) {
        throw new RuntimeException("This constraint is not generative. Please check with canGenerate first.");
    }

    @Override
    public boolean satisfies(Match match, int ... ind) {
        return this.generate(match, ind).contains(match.get(ind[ind.length - 1]));
    }

    protected void assertIndLength(int[] ind) {
        assert (ind.length == this.getVariableSize());
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public int getVariableSize() {
        return this.size;
    }

    protected ConversionDirectionType getDirection(Conversion conv, Control cont) {
        return this.getDirection(conv, null, cont);
    }

    protected ConversionDirectionType getDirection(Conversion conv, Pathway pathway, Control cont) {
        for (Control ctrl : this.getControlChain(cont, (Interaction)conv)) {
            ConversionDirectionType dir = this.getCatalysisDirection(ctrl);
            if (dir == null) continue;
            return dir;
        }
        HashSet<StepDirection> dirs = new HashSet<StepDirection>();
        Set convSteps = conv.getStepProcessOf();
        for (PathwayStep step : cont.getStepProcessOf()) {
            StepDirection dir;
            if (pathway != null && !step.getPathwayOrderOf().equals(pathway) || !(step instanceof BiochemicalPathwayStep) || !convSteps.contains(step) || (dir = ((BiochemicalPathwayStep)step).getStepDirection()) == null) continue;
            dirs.add(dir);
        }
        if (dirs.size() > 1) {
            return ConversionDirectionType.REVERSIBLE;
        }
        if (!dirs.isEmpty()) {
            return this.convertStepDirection((StepDirection)dirs.iterator().next());
        }
        return this.getDirection(conv);
    }

    protected ConversionDirectionType getDirection(Conversion conv, Pathway pathway) {
        HashSet<StepDirection> dirs = new HashSet<StepDirection>();
        for (PathwayStep step : conv.getStepProcessOf()) {
            StepDirection dir;
            if (!step.getPathwayOrderOf().equals(pathway) || !(step instanceof BiochemicalPathwayStep) || (dir = ((BiochemicalPathwayStep)step).getStepDirection()) == null) continue;
            dirs.add(dir);
        }
        if (dirs.size() > 1) {
            return ConversionDirectionType.REVERSIBLE;
        }
        if (!dirs.isEmpty()) {
            return this.convertStepDirection((StepDirection)dirs.iterator().next());
        }
        return this.getDirection(conv);
    }

    protected ConversionDirectionType getCatalysisDirection(Control cont) {
        if (cont instanceof Catalysis) {
            CatalysisDirectionType catDir = ((Catalysis)cont).getCatalysisDirection();
            if (catDir == CatalysisDirectionType.LEFT_TO_RIGHT) {
                return ConversionDirectionType.LEFT_TO_RIGHT;
            }
            if (catDir == CatalysisDirectionType.RIGHT_TO_LEFT) {
                return ConversionDirectionType.RIGHT_TO_LEFT;
            }
        }
        return null;
    }

    protected List<Control> getControlChain(Control control, Interaction inter) {
        LinkedList<Control> list = new LinkedList<Control>();
        list.add(control);
        boolean found = this.search(list, inter);
        if (!found) {
            throw new RuntimeException("No link from Control to Conversion.");
        }
        return list;
    }

    private boolean search(LinkedList<Control> list, Interaction inter) {
        if (list.getLast().getControlled().contains(inter)) {
            return true;
        }
        for (Process process : list.getLast().getControlled()) {
            if (!(process instanceof Control) || list.contains(process)) continue;
            list.add((Control)process);
            if (this.search(list, inter)) {
                return true;
            }
            list.removeLast();
        }
        return false;
    }

    protected Set<PhysicalEntity> getConvParticipants(Conversion conv, RelType type) {
        ConversionDirectionType dir = this.getDirection(conv);
        if (dir == ConversionDirectionType.REVERSIBLE) {
            HashSet<PhysicalEntity> set = new HashSet<PhysicalEntity>(conv.getLeft());
            set.addAll(conv.getRight());
            return set;
        }
        if (dir == ConversionDirectionType.RIGHT_TO_LEFT) {
            return type == RelType.INPUT ? conv.getRight() : conv.getLeft();
        }
        return type == RelType.OUTPUT ? conv.getRight() : conv.getLeft();
    }

    protected ConversionDirectionType findDirectionInPathways(Conversion conv) {
        HashSet<StepDirection> dirs = new HashSet<StepDirection>();
        for (PathwayStep step : conv.getStepProcessOf()) {
            StepDirection dir;
            if (!(step instanceof BiochemicalPathwayStep) || (dir = ((BiochemicalPathwayStep)step).getStepDirection()) == null) continue;
            dirs.add(dir);
        }
        if (dirs.size() > 1) {
            return ConversionDirectionType.REVERSIBLE;
        }
        if (!dirs.isEmpty()) {
            return dirs.iterator().next() == StepDirection.LEFT_TO_RIGHT ? ConversionDirectionType.LEFT_TO_RIGHT : ConversionDirectionType.RIGHT_TO_LEFT;
        }
        return null;
    }

    protected ConversionDirectionType convertStepDirection(StepDirection sdir) {
        if (sdir == StepDirection.LEFT_TO_RIGHT) {
            return ConversionDirectionType.LEFT_TO_RIGHT;
        }
        if (sdir == StepDirection.RIGHT_TO_LEFT) {
            return ConversionDirectionType.RIGHT_TO_LEFT;
        }
        return null;
    }

    protected ConversionDirectionType findDirectionInCatalysis(Conversion conv) {
        HashSet<ConversionDirectionType> dirs = new HashSet<ConversionDirectionType>();
        for (Control control : conv.getControlledOf()) {
            ConversionDirectionType dir = this.getCatalysisDirection(control);
            if (dir == null) continue;
            dirs.add(dir);
        }
        if (dirs.size() > 1) {
            return ConversionDirectionType.REVERSIBLE;
        }
        if (!dirs.isEmpty()) {
            return (ConversionDirectionType)dirs.iterator().next();
        }
        return null;
    }

    protected ConversionDirectionType getDirection(Conversion conv) {
        if (conv.getConversionDirection() != null) {
            return conv.getConversionDirection();
        }
        ConversionDirectionType catDir = this.findDirectionInCatalysis(conv);
        ConversionDirectionType patDir = this.findDirectionInPathways(conv);
        if (catDir != null && patDir != null && catDir != patDir) {
            return ConversionDirectionType.REVERSIBLE;
        }
        if (catDir != null) {
            return catDir;
        }
        if (patDir != null) {
            return patDir;
        }
        return ConversionDirectionType.LEFT_TO_RIGHT;
    }
}

