/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.miner;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.ControlType;
import org.biopax.paxtools.model.level3.ModificationFeature;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.pattern.Constraint;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.Pattern;
import org.biopax.paxtools.pattern.constraint.HasAnID;
import org.biopax.paxtools.pattern.miner.CommonIDFetcher;
import org.biopax.paxtools.pattern.miner.IDFetcher;
import org.biopax.paxtools.pattern.miner.Miner;
import org.biopax.paxtools.pattern.miner.SIFInteraction;
import org.biopax.paxtools.pattern.miner.SIFMiner;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.biopax.paxtools.pattern.util.HGNC;
import org.biopax.paxtools.pattern.util.PhysicalEntityChain;

public abstract class MinerAdapter
implements Miner {
    protected String name;
    protected String description;
    protected Blacklist blacklist;
    protected IDFetcher idFetcher;
    protected Map<BioPAXElement, Set<String>> idMap;
    private Pattern pattern;
    private static final PathAccessor FEAT_ACC = new PathAccessor("PhysicalEntity/feature:ModificationFeature");
    private static final PathAccessor TERM_ACC = new PathAccessor("ModificationFeature/modificationType/term");
    private static final PathAccessor SITE_ACC = new PathAccessor("ModificationFeature/featureLocation:SequenceSite/sequencePosition");
    private static final PathAccessor INTERVAL_BEGIN_ACC = new PathAccessor("ModificationFeature/featureLocation:SequenceInterval/sequenceIntervalBegin/sequencePosition");
    private static final PathAccessor INTERVAL_END_ACC = new PathAccessor("ModificationFeature/featureLocation:SequenceInterval/sequenceIntervalEnd/sequencePosition");

    protected MinerAdapter(String name, String description) {
        this.name = name;
        this.description = description;
        this.idMap = Collections.synchronizedMap(new HashMap());
    }

    public void setBlacklist(Blacklist blacklist) {
        this.blacklist = blacklist;
    }

    public void setIDFetcher(IDFetcher idFetcher) {
        this.idFetcher = idFetcher;
    }

    public abstract Pattern constructPattern();

    @Override
    public Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = this.constructPattern();
            if (this instanceof SIFMiner && this.idFetcher != null && this.idMap != null) {
                this.pattern.add((Constraint)new HasAnID(this.idFetcher, this.idMap), ((SIFMiner)((Object)this)).getSourceLabel());
                this.pattern.add((Constraint)new HasAnID(this.idFetcher, this.idMap), ((SIFMiner)((Object)this)).getTargetLabel());
            }
            this.pattern.optimizeConstraintOrder();
        }
        return this.pattern;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<BioPAXElement, Set<String>> getIdMap() {
        return this.idMap;
    }

    public void setIdMap(Map<BioPAXElement, Set<String>> idMap) {
        this.idMap = Collections.synchronizedMap(new HashMap<BioPAXElement, Set<String>>(idMap));
    }

    public String toString() {
        return this.getName();
    }

    protected String getGeneSymbol(ProteinReference pr) {
        for (Xref xr : pr.getXref()) {
            String symbol;
            String id;
            String db = xr.getDb();
            if (db == null || !(db = db.toLowerCase()).startsWith("hgnc") || (id = xr.getId()) == null || (symbol = HGNC.getSymbol(id)) == null || symbol.isEmpty()) continue;
            return symbol;
        }
        return null;
    }

    protected String getUniprotNameForHuman(ProteinReference pr) {
        for (String name : pr.getName()) {
            if (!name.endsWith("_HUMAN")) continue;
            return name;
        }
        return null;
    }

    protected String getGeneSymbol(Match m, String label) {
        ProteinReference pr = (ProteinReference)m.get(label, this.getPattern());
        return this.getGeneSymbol(pr);
    }

    protected String getUniprotNameForHuman(Match m, String label) {
        ProteinReference er = (ProteinReference)m.get(label, this.getPattern());
        return this.getUniprotNameForHuman(er);
    }

    public boolean isInhibition(Control ctrl) {
        return ctrl.getControlType() != null && ctrl.getControlType().toString().startsWith("I");
    }

    public Set<String> toStringSet(Set<ModificationFeature> set) {
        ArrayList<ModificationFeature> list = new ArrayList<ModificationFeature>(set);
        Collections.sort(list, new Comparator<ModificationFeature>(){

            @Override
            public int compare(ModificationFeature o1, ModificationFeature o2) {
                String t1 = MinerAdapter.this.getModificationTerm(o1);
                String t2 = MinerAdapter.this.getModificationTerm(o2);
                Integer l1 = MinerAdapter.this.getPositionStart(o1);
                Integer l2 = MinerAdapter.this.getPositionStart(o2);
                if (t1 == null && t2 == null) {
                    return l1.compareTo(l2);
                }
                if (t1 == null) {
                    return 1;
                }
                if (t2 == null) {
                    return -1;
                }
                if (t1.equals(t2)) {
                    return l1.compareTo(l2);
                }
                return t1.compareTo(t2);
            }
        });
        return this.getInString(list);
    }

    private Set<String> getInString(List<ModificationFeature> list) {
        HashSet<String> text = new HashSet<String>(list.size());
        for (ModificationFeature mf : list) {
            String s;
            String term = this.getModificationTerm(mf);
            String loc = this.getPositionInString(mf);
            if (term == null || text.contains(s = term + loc)) continue;
            text.add(s);
        }
        return text;
    }

    public String getModificationTerm(ModificationFeature mf) {
        Set vals = TERM_ACC.getValueFromBean((BioPAXElement)mf);
        if (vals.isEmpty()) {
            return null;
        }
        return vals.iterator().next().toString();
    }

    public int getPositionStart(ModificationFeature mf) {
        Set vals = SITE_ACC.getValueFromBean((BioPAXElement)mf);
        if (!vals.isEmpty()) {
            return (Integer)vals.iterator().next();
        }
        vals = INTERVAL_BEGIN_ACC.getValueFromBean((BioPAXElement)mf);
        if (!vals.isEmpty()) {
            return (Integer)vals.iterator().next();
        }
        return -1;
    }

    public String getPositionInString(ModificationFeature mf) {
        int x;
        Set vals = SITE_ACC.getValueFromBean((BioPAXElement)mf);
        if (!vals.isEmpty() && (x = ((Integer)vals.iterator().next()).intValue()) > 0) {
            return "@" + x;
        }
        vals = INTERVAL_BEGIN_ACC.getValueFromBean((BioPAXElement)mf);
        if (!vals.isEmpty()) {
            int begin = (Integer)vals.iterator().next();
            vals = INTERVAL_END_ACC.getValueFromBean((BioPAXElement)mf);
            if (!vals.isEmpty()) {
                int end = (Integer)vals.iterator().next();
                if (begin > 0 && end > 0 && begin <= end) {
                    if (begin == end) {
                        return "@" + begin;
                    }
                    return "@[" + begin + "-" + end + "]";
                }
            }
        }
        return "";
    }

    protected Set<String> getModifications(Match m, String label) {
        PhysicalEntity pe = (PhysicalEntity)m.get(label, this.getPattern());
        return this.toStringSet(new HashSet<ModificationFeature>(FEAT_ACC.getValueFromBean((BioPAXElement)pe)));
    }

    protected Set<String> getModifications(Match m, String memLabel, String comLabel) {
        PhysicalEntityChain chain = this.getChain(m, memLabel, comLabel);
        return this.toStringSet(chain.getModifications());
    }

    protected Set<String> getCellularLocations(Match m, String memLabel, String comLabel) {
        PhysicalEntityChain chain = this.getChain(m, memLabel, comLabel);
        return chain.getCellularLocations();
    }

    protected Set<String>[] getDeltaModifications(Match m, String memLabel1, String comLabel1, String memLabel2, String comLabel2) {
        PhysicalEntityChain chain1 = this.getChain(m, memLabel1, comLabel1);
        PhysicalEntityChain chain2 = this.getChain(m, memLabel2, comLabel2);
        Set<ModificationFeature> before = chain1.getModifications();
        Set<ModificationFeature> after = chain2.getModifications();
        Set<String> afterMods = this.toStringSet(after);
        Set<String> beforeMods = this.toStringSet(before);
        this.removeCommon(afterMods, beforeMods);
        return new Set[]{afterMods, beforeMods};
    }

    protected Set<String>[] getDeltaCompartments(Match m, String memLabel1, String comLabel1, String memLabel2, String comLabel2) {
        PhysicalEntityChain chain1 = this.getChain(m, memLabel1, comLabel1);
        PhysicalEntityChain chain2 = this.getChain(m, memLabel2, comLabel2);
        Set<String> before = chain1.getCellularLocations();
        Set<String> after = chain2.getCellularLocations();
        this.removeCommon(after, before);
        return new Set[]{after, before};
    }

    protected PhysicalEntityChain getChain(Match m, String memLabel, String comLabel) {
        return new PhysicalEntityChain((PhysicalEntity)m.get(memLabel, this.getPattern()), (PhysicalEntity)m.get(comLabel, this.getPattern()));
    }

    protected void removeCommon(Set<String> set1, Set<String> set2) {
        HashSet<String> common = new HashSet<String>(set1);
        common.retainAll(set2);
        set1.removeAll(common);
        set2.removeAll(common);
    }

    protected String concat(Set<String> set, String sep) {
        String s = "";
        int i = set.size();
        for (String ss : set) {
            s = s + ss;
            if (--i <= 0) continue;
            s = s + sep;
        }
        return s;
    }

    protected int sign(Control ctrl) {
        ControlType type = ctrl.getControlType();
        if (type != null && type.name().startsWith("I")) {
            return -1;
        }
        return 1;
    }

    protected int sign(Match m, String ... ctrlLabel) {
        int sign = 1;
        for (String lab : ctrlLabel) {
            Control ctrl = (Control)m.get(lab, this.getPattern());
            sign *= this.sign(ctrl);
        }
        return sign;
    }

    protected boolean labeledInactive(Match m, String simpleLabel, String complexLabel) {
        PhysicalEntityChain chain = this.getChain(m, simpleLabel, complexLabel);
        PhysicalEntityChain.Activity activity = chain.checkActivityLabel();
        return activity == PhysicalEntityChain.Activity.INACTIVE;
    }

    protected void writeResultAsSIF(Map<BioPAXElement, List<Match>> matches, OutputStream out, boolean directed, String label1, String label2) throws IOException {
        if (matches.isEmpty()) {
            return;
        }
        if (this instanceof SIFMiner) {
            this.writeSIFsUsingSIFFramework(matches, out);
            return;
        }
        HashSet<String> mem = new HashSet<String>();
        String mid = this.getRelationType() == null ? "\t" : "\trelation\t";
        OutputStreamWriter writer = new OutputStreamWriter(out);
        String header = this.getHeader();
        writer.write(header == null ? label1 + mid + label2 : header);
        for (BioPAXElement ele : matches.keySet()) {
            for (Match m : matches.get(ele)) {
                Set<String> s1 = this.getIdentifiers(m, label1);
                Set<String> s2 = this.getIdentifiers(m, label2);
                for (String s1s : s1) {
                    for (String s2s : s2) {
                        String type = this.getRelationType();
                        String sep = type == null ? "\t" : "\t" + type + "\t";
                        String relation = s1s + sep + s2s;
                        String reverse = s2s + sep + s1s;
                        if (mem.contains(relation) || !directed && mem.contains(reverse)) continue;
                        writer.write("\n" + relation);
                        mem.add(relation);
                        if (directed) continue;
                        mem.add(reverse);
                    }
                }
            }
        }
        writer.flush();
    }

    protected void writeSIFsUsingSIFFramework(Map<BioPAXElement, List<Match>> matches, OutputStream out) throws IOException {
        HashMap<SIFInteraction, SIFInteraction> sifMap = new HashMap<SIFInteraction, SIFInteraction>();
        for (List<Match> matchList : matches.values()) {
            for (Match match : matchList) {
                for (SIFInteraction inter : this.createSIFInteraction(match, new CommonIDFetcher())) {
                    if (!inter.hasIDs()) continue;
                    if (sifMap.containsKey(inter)) {
                        ((SIFInteraction)sifMap.get(inter)).mergeWith(inter);
                        continue;
                    }
                    sifMap.put(inter, inter);
                }
            }
        }
        OutputStreamWriter writer = new OutputStreamWriter(out);
        boolean first = true;
        for (SIFInteraction inter : sifMap.keySet()) {
            if (first) {
                first = false;
            } else {
                writer.write("\n");
            }
            writer.write(inter.toString());
        }
        writer.flush();
    }

    protected String getRelationType() {
        if (this instanceof SIFMiner) {
            return ((SIFMiner)((Object)this)).getSIFType().getTag();
        }
        return null;
    }

    public String getHeader() {
        return null;
    }

    protected void writeResultDetailed(Map<BioPAXElement, List<Match>> matches, OutputStream out, int columns) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        String header = this.getHeader();
        if (header != null) {
            writer.write(header);
        } else {
            for (int i = 0; i < columns; ++i) {
                writer.write("col-" + (i + 1));
                if (i >= columns - 1) continue;
                writer.write("\t");
            }
        }
        HashSet<String> mem = new HashSet<String>();
        for (BioPAXElement ele : matches.keySet()) {
            for (Match m : matches.get(ele)) {
                String line = "";
                boolean aborted = false;
                for (int i = 0; i < columns; ++i) {
                    String s = this.getValue(m, i);
                    if (s == null) {
                        aborted = true;
                        break;
                    }
                    line = line + s + "\t";
                }
                if (aborted || mem.contains(line = line.trim())) continue;
                writer.write("\n" + line);
                mem.add(line);
            }
        }
        writer.flush();
    }

    public String getValue(Match m, int col) {
        return null;
    }

    public Set<SIFInteraction> createSIFInteraction(Match m, IDFetcher fetcher) {
        BioPAXElement sourceBpe = m.get(((SIFMiner)((Object)this)).getSourceLabel(), this.getPattern());
        BioPAXElement targetBpe = m.get(((SIFMiner)((Object)this)).getTargetLabel(), this.getPattern());
        Set<String> sources = this.fetchIDs(sourceBpe, fetcher);
        Set<String> targets = this.fetchIDs(targetBpe, fetcher);
        SIFType sifType = ((SIFMiner)((Object)this)).getSIFType();
        HashSet<SIFInteraction> set = new HashSet<SIFInteraction>();
        for (String source : sources) {
            for (String target : targets) {
                if (source.equals(target)) continue;
                if (sifType.isDirected() || source.compareTo(target) < 0) {
                    set.add(new SIFInteraction(source, target, sourceBpe, targetBpe, sifType, new HashSet<BioPAXElement>(m.get(this.getMediatorLabels(), this.getPattern())), new HashSet<BioPAXElement>(m.get(this.getSourcePELabels(), this.getPattern())), new HashSet<BioPAXElement>(m.get(this.getTargetPELabels(), this.getPattern()))));
                    continue;
                }
                set.add(new SIFInteraction(target, source, targetBpe, sourceBpe, sifType, new HashSet<BioPAXElement>(m.get(this.getMediatorLabels(), this.getPattern())), new HashSet<BioPAXElement>(m.get(this.getTargetPELabels(), this.getPattern())), new HashSet<BioPAXElement>(m.get(this.getSourcePELabels(), this.getPattern()))));
            }
        }
        return set;
    }

    protected Set<String> fetchIDs(BioPAXElement ele, IDFetcher fetcher) {
        if (!this.idMap.containsKey(ele)) {
            Set<String> ids = fetcher.fetchID(ele);
            this.idMap.put(ele, ids);
        }
        return this.idMap.get(ele);
    }

    public String[] getMediatorLabels() {
        return null;
    }

    public String[] getSourcePELabels() {
        return null;
    }

    public String[] getTargetPELabels() {
        return null;
    }

    protected Set<String> getIdentifiers(Match m, String label) {
        BioPAXElement el = m.get(label, this.getPattern());
        if (this.idFetcher != null) {
            return this.idFetcher.fetchID(el);
        }
        HashSet<String> set = new HashSet<String>();
        if (el instanceof ProteinReference) {
            set.add(this.getGeneSymbol((ProteinReference)el));
        } else if (el instanceof SmallMoleculeReference) {
            set.add(this.getCompoundName((SmallMoleculeReference)el));
        }
        return set;
    }

    protected String getCompoundName(SmallMoleculeReference smr) {
        return smr.getDisplayName();
    }
}

