/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.constraint;

import java.util.Collection;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.pattern.Constraint;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.constraint.ConstraintAdapter;

public class Size
extends ConstraintAdapter {
    Constraint con;
    int size;
    Type type;

    public Size(Constraint con, int size, Type type) {
        if (!con.canGenerate()) {
            throw new IllegalArgumentException("The parameter constraint have to be generative.");
        }
        this.con = con;
        this.size = size;
        this.type = type;
    }

    @Override
    public int getVariableSize() {
        return this.con.getVariableSize() - 1;
    }

    @Override
    public boolean satisfies(Match match, int ... ind) {
        Collection<BioPAXElement> set = this.con.generate(match, ind);
        switch (this.type.ordinal()) {
            case 0: {
                return set.size() == this.size;
            }
            case 1: {
                return set.size() > this.size;
            }
            case 3: {
                return set.size() >= this.size;
            }
            case 2: {
                return set.size() < this.size;
            }
            case 4: {
                return set.size() <= this.size;
            }
        }
        throw new RuntimeException("Should not reach here. Did somebody modify Type enum?");
    }

    public static enum Type {
        EQUAL,
        GREATER,
        LESS,
        GREATER_OR_EQUAL,
        LESS_OR_EQUAL;

    }
}

