/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.miner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Level3Element;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PublicationXref;
import org.biopax.paxtools.pattern.miner.SIFType;

public class SIFInteraction
implements Comparable {
    public Set<BioPAXElement> sourceERs;
    public Set<BioPAXElement> targetERs;
    public Set<BioPAXElement> sourcePEs;
    public Set<BioPAXElement> targetPEs;
    public String sourceID;
    public String targetID;
    public SIFType type;
    public Set<BioPAXElement> mediators;
    private static final PathAccessor xrefAcc = new PathAccessor("XReferrable/xref:PublicationXref");
    private static final PathAccessor evidAcc = new PathAccessor("Observable/evidence/xref:PublicationXref");
    private static final PathAccessor[] pathwayAcc = new PathAccessor[]{new PathAccessor("Interaction/pathwayComponentOf"), new PathAccessor("Complex/participantOf/pathwayComponentOf"), new PathAccessor("Complex/componentOf*/participantOf/pathwayComponentOf"), new PathAccessor("Complex/memberPhysicalEntityOf*/participantOf/pathwayComponentOf"), new PathAccessor("Interaction/stepProcessOf/pathwayOrderOf"), new PathAccessor("Complex/participantOf/stepProcessOf/pathwayOrderOf"), new PathAccessor("Complex/componentOf*/participantOf/stepProcessOf/pathwayOrderOf"), new PathAccessor("Complex/memberPhysicalEntityOf*/participantOf/stepProcessOf/pathwayOrderOf")};
    private static final PathAccessor dataSourceAcc = new PathAccessor("Entity/dataSource/displayName");
    private static final PathAccessor locAcc = new PathAccessor("PhysicalEntity/cellularLocation/term");

    public SIFInteraction(String sourceID, String targetID, BioPAXElement sourceER, BioPAXElement targetER, SIFType type, Set<BioPAXElement> mediators, Set<BioPAXElement> sourcePEs, Set<BioPAXElement> targetPEs) {
        this.sourceID = sourceID;
        this.targetID = targetID;
        this.sourceERs = new HashSet<BioPAXElement>();
        this.targetERs = new HashSet<BioPAXElement>();
        this.sourceERs.add(sourceER);
        this.targetERs.add(targetER);
        this.type = type;
        this.mediators = mediators;
        this.sourcePEs = sourcePEs;
        this.targetPEs = targetPEs;
    }

    public boolean hasIDs() {
        return this.sourceID != null && this.targetID != null;
    }

    public int hashCode() {
        return this.sourceID.hashCode() + this.targetID.hashCode() + this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SIFInteraction) {
            SIFInteraction i = (SIFInteraction)obj;
            return i.type.equals(this.type) && i.sourceID.equals(this.sourceID) && i.targetID.equals(this.targetID);
        }
        return false;
    }

    public int compareTo(Object o) {
        if (o instanceof SIFInteraction) {
            SIFInteraction i = (SIFInteraction)o;
            return (this.sourceID + this.targetID + this.type.getTag()).compareTo(i.sourceID + i.targetID + i.type.getTag());
        }
        return 0;
    }

    public void mergeWith(SIFInteraction equivalent) {
        if (!this.equals(equivalent)) {
            throw new IllegalArgumentException("SIF interactions are not equivalent.");
        }
        this.sourceERs.addAll(equivalent.sourceERs);
        this.targetERs.addAll(equivalent.targetERs);
        this.sourcePEs.addAll(equivalent.sourcePEs);
        this.targetPEs.addAll(equivalent.targetPEs);
        if (this.mediators == null) {
            this.mediators = equivalent.mediators;
        } else if (equivalent.mediators != null) {
            this.mediators.addAll(equivalent.mediators);
        }
    }

    public String toString() {
        return this.sourceID + "\t" + this.type.getTag() + "\t" + this.targetID;
    }

    public List<String> getMediatorIDs() {
        ArrayList<String> ids = new ArrayList<String>(this.mediators.size());
        for (BioPAXElement ele : this.mediators) {
            ids.add(ele.getUri());
        }
        return ids;
    }

    public String getMediatorsInString() {
        String m = "";
        for (String mid : this.getMediatorIDs()) {
            m = m + " " + mid;
        }
        return m.trim().replaceAll(" ", ";");
    }

    public List<String> getPublicationIDs(boolean pubmed) {
        if (this.mediators == null) {
            return Collections.emptyList();
        }
        Set<PublicationXref> xrefs = this.harvestPublicationXrefs(this.mediators.toArray(new BioPAXElement[this.mediators.size()]));
        Set<String> set = pubmed ? this.harvestPMIDs(xrefs) : this.harvestPMCIDs(xrefs);
        ArrayList<String> list = new ArrayList<String>(set);
        Collections.sort(list);
        return list;
    }

    private Set<PublicationXref> harvestPublicationXrefs(BioPAXElement ... ele) {
        HashSet<PublicationXref> set = new HashSet<PublicationXref>();
        for (Object o : xrefAcc.getValueFromBeans(Arrays.asList(ele))) {
            set.add((PublicationXref)o);
        }
        for (Object o : evidAcc.getValueFromBeans(Arrays.asList(ele))) {
            set.add((PublicationXref)o);
        }
        return set;
    }

    private Set<String> harvestPMIDs(Set<PublicationXref> xrefs) {
        return this.harvestXrefs(xrefs, "pubmed");
    }

    private Set<String> harvestPMCIDs(Set<PublicationXref> xrefs) {
        return this.harvestXrefs(xrefs, "PMC International");
    }

    private Set<String> harvestXrefs(Set<PublicationXref> xrefs, String dbID) {
        HashSet<String> set = new HashSet<String>();
        for (PublicationXref xref : xrefs) {
            if (xref.getDb() == null || !xref.getDb().equalsIgnoreCase(dbID) || xref.getId() == null || xref.getId().isEmpty()) continue;
            set.add(xref.getId());
        }
        return set;
    }

    public Set<Pathway> getPathways() {
        HashSet<Pathway> set = new HashSet<Pathway>();
        for (PathAccessor pAcc : pathwayAcc) {
            for (Object o : pAcc.getValueFromBeans(this.mediators)) {
                set.add((Pathway)o);
            }
        }
        return set;
    }

    public List<String> getPathwayNames() {
        Set<Pathway> set = this.getPathways();
        ArrayList<String> names = new ArrayList<String>();
        for (Pathway p : set) {
            String name = p.getDisplayName();
            if (names.contains(name)) continue;
            names.add(name);
        }
        Collections.sort(names);
        return names;
    }

    public List<String> getPathwayUris() {
        ArrayList<String> uris = new ArrayList<String>();
        for (Pathway p : this.getPathways()) {
            String uri = p.getUri();
            if (uris.contains(uri)) continue;
            uris.add(uri);
        }
        Collections.sort(uris);
        return uris;
    }

    public Set<String> getDataSources() {
        HashSet<String> set = new HashSet<String>();
        for (Object o : dataSourceAcc.getValueFromBeans(this.mediators)) {
            set.add((String)o);
        }
        return set;
    }

    public Set<String> getCellularLocationsOfTarget() {
        return this.getCellularLocations(this.targetPEs);
    }

    public Set<String> getCellularLocationsOfSource() {
        return this.getCellularLocations(this.sourcePEs);
    }

    private Set<String> getCellularLocations(Set<BioPAXElement> eles) {
        HashSet<String> set = new HashSet<String>();
        for (Object o : locAcc.getValueFromBeans(eles)) {
            set.add((String)o);
        }
        return set;
    }

    public Set<String> getMediatorComments() {
        HashSet<String> comments = new HashSet<String>();
        for (BioPAXElement med : this.mediators) {
            if (!(med instanceof Level3Element)) continue;
            comments.addAll(((Level3Element)med).getComment());
        }
        return comments;
    }

    public static List<String> getSortedGeneNames(Collection<SIFInteraction> sifInts, SIFType ... type) {
        HashSet<String> genes = new HashSet<String>();
        HashSet<SIFType> types = new HashSet<SIFType>(Arrays.asList(type));
        for (SIFInteraction sifInt : sifInts) {
            if (!types.isEmpty() && !types.contains(sifInt.type)) continue;
            genes.add(sifInt.sourceID);
            genes.add(sifInt.targetID);
        }
        ArrayList<String> names = new ArrayList<String>(genes);
        Collections.sort(names);
        return names;
    }

    public static boolean[][] convertToAdjacencyMatrix(Collection<SIFInteraction> sifInts, SIFType ... type) {
        HashSet<SIFType> types = new HashSet<SIFType>(Arrays.asList(type));
        List<String> names = SIFInteraction.getSortedGeneNames(sifInts, type);
        HashMap<String, Integer> name2ind = new HashMap<String, Integer>();
        int i = 0;
        for (String name : names) {
            name2ind.put(name, i++);
        }
        boolean[][] matrix = new boolean[names.size()][names.size()];
        for (boolean[] m : matrix) {
            Arrays.fill(m, false);
        }
        Object object = sifInts.iterator();
        while (object.hasNext()) {
            SIFInteraction sifInt = (SIFInteraction)object.next();
            if (!types.isEmpty() && !types.contains(sifInt.type)) continue;
            matrix[((Integer)name2ind.get((Object)sifInt.sourceID)).intValue()][((Integer)name2ind.get((Object)sifInt.targetID)).intValue()] = true;
            if (sifInt.type.isDirected()) continue;
            matrix[((Integer)name2ind.get((Object)sifInt.targetID)).intValue()][((Integer)name2ind.get((Object)sifInt.sourceID)).intValue()] = true;
        }
        return matrix;
    }
}

