/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.model.level3.BiochemicalReaction;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.ComplexAssembly;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.ModificationFeature;
import org.biopax.paxtools.model.level3.NucleicAcid;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.SequenceEntity;
import org.biopax.paxtools.model.level3.SequenceEntityReference;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.pattern.Constraint;
import org.biopax.paxtools.pattern.MappedConst;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.Pattern;
import org.biopax.paxtools.pattern.constraint.AND;
import org.biopax.paxtools.pattern.constraint.ActivityConstraint;
import org.biopax.paxtools.pattern.constraint.ActivityModificationChangeConstraint;
import org.biopax.paxtools.pattern.constraint.ConBox;
import org.biopax.paxtools.pattern.constraint.ConstraintAdapter;
import org.biopax.paxtools.pattern.constraint.ConstraintChain;
import org.biopax.paxtools.pattern.constraint.ConversionSide;
import org.biopax.paxtools.pattern.constraint.Empty;
import org.biopax.paxtools.pattern.constraint.InterToPartER;
import org.biopax.paxtools.pattern.constraint.ModificationChangeConstraint;
import org.biopax.paxtools.pattern.constraint.NOT;
import org.biopax.paxtools.pattern.constraint.NonUbique;
import org.biopax.paxtools.pattern.constraint.OR;
import org.biopax.paxtools.pattern.constraint.PEChainsIntersect;
import org.biopax.paxtools.pattern.constraint.Participant;
import org.biopax.paxtools.pattern.constraint.ParticipatesInConv;
import org.biopax.paxtools.pattern.constraint.PathConstraint;
import org.biopax.paxtools.pattern.constraint.RelatedControl;
import org.biopax.paxtools.pattern.constraint.Size;
import org.biopax.paxtools.pattern.constraint.Type;
import org.biopax.paxtools.pattern.constraint.XOR;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.biopax.paxtools.pattern.util.RelType;

public class PatternBox {
    public static Pattern controlsStateChange() {
        Pattern p = new Pattern(SequenceEntityReference.class, "controller ER");
        p.add(ConBox.linkedER(true), "controller ER", "generic controller ER");
        p.add(ConBox.erToPE(), "generic controller ER", "controller simple PE");
        p.add(ConBox.linkToComplex(), "controller simple PE", "controller PE");
        p.add(ConBox.peToControl(), "controller PE", "Control");
        p.add(ConBox.controlToConv(), "Control", "Conversion");
        p.add((Constraint)new NOT(ConBox.participantER()), "Conversion", "controller ER");
        p.add((Constraint)new Participant(RelType.INPUT, true), "Control", "Conversion", "input PE");
        p.add((Constraint)new NOT(new ConversionSide(ConversionSide.Type.OTHER_SIDE)), "input PE", "Conversion", "input PE");
        p.add(ConBox.linkToSpecific(), "input PE", "input simple PE");
        p.add((Constraint)new Type(SequenceEntity.class), "input simple PE");
        p.add(ConBox.peToER(), "input simple PE", "changed generic ER");
        p.add((Constraint)new ConversionSide(ConversionSide.Type.OTHER_SIDE), "input PE", "Conversion", "output PE");
        p.add((Constraint)new NOT(new ConversionSide(ConversionSide.Type.OTHER_SIDE)), "output PE", "Conversion", "output PE");
        p.add(ConBox.equal(false), "input PE", "output PE");
        p.add(ConBox.linkToSpecific(), "output PE", "output simple PE");
        p.add(ConBox.peToER(), "output simple PE", "changed generic ER");
        p.add(ConBox.linkedER(false), "changed generic ER", "changed ER");
        return p;
    }

    public static Pattern controlsTransport() {
        Pattern p = PatternBox.controlsStateChange();
        p.add((Constraint)new OR(new MappedConst(ConBox.hasDifferentCompartments(), 0, 1), new MappedConst(ConBox.hasDifferentCompartments(), 2, 3)), "input simple PE", "output simple PE", "input PE", "output PE");
        return p;
    }

    public static Pattern controlsTransportOfChemical(Blacklist blacklist) {
        Pattern p = new Pattern(SequenceEntityReference.class, "controller ER");
        p.add(ConBox.linkedER(true), "controller ER", "controller generic ER");
        p.add(ConBox.erToPE(), "controller generic ER", "controller simple PE");
        p.add(ConBox.linkToComplex(), "controller simple PE", "controller PE");
        p.add(ConBox.peToControl(), "controller PE", "Control");
        p.add(ConBox.controlToConv(), "Control", "Conversion");
        p.add((Constraint)new Participant(RelType.INPUT, blacklist, true), "Control", "Conversion", "input PE");
        p.add(ConBox.linkToSimple(blacklist), "input PE", "input simple PE");
        p.add((Constraint)new Type(SmallMolecule.class), "input simple PE");
        p.add(ConBox.notGeneric(), "input simple PE");
        p.add(ConBox.peToER(), "input simple PE", "changed generic SMR");
        p.add((Constraint)new ConversionSide(ConversionSide.Type.OTHER_SIDE, blacklist, RelType.OUTPUT), "input PE", "Conversion", "output PE");
        p.add(ConBox.equal(false), "input PE", "output PE");
        p.add(ConBox.linkToSimple(blacklist), "output PE", "output simple PE");
        p.add((Constraint)new Type(SmallMolecule.class), "output simple PE");
        p.add(ConBox.notGeneric(), "output simple PE");
        p.add(ConBox.peToER(), "output simple PE", "changed generic SMR");
        p.add(ConBox.linkedER(false), "changed generic SMR", "changed SMR");
        p.add((Constraint)new OR(new MappedConst(ConBox.hasDifferentCompartments(), 0, 1), new MappedConst(ConBox.hasDifferentCompartments(), 2, 3)), "input simple PE", "output simple PE", "input PE", "output PE");
        return p;
    }

    public static Pattern controlsStateChangeBothControlAndPart() {
        Pattern p = new Pattern(SequenceEntityReference.class, "controller ER");
        p.add(ConBox.linkedER(true), "controller ER", "controller generic ER");
        p.add(ConBox.erToPE(), "controller generic ER", "controller simple PE");
        p.add(ConBox.linkToComplex(), "controller simple PE", "controller PE");
        p.add(ConBox.peToControl(), "controller PE", "Control");
        p.add(ConBox.controlToConv(), "Control", "Conversion");
        p.add((Constraint)new ParticipatesInConv(RelType.INPUT), "controller PE", "Conversion");
        p.add(ConBox.linkToComplex(), "controller simple PE", "special output PE");
        p.add(ConBox.equal(false), "special output PE", "controller PE");
        p.add((Constraint)new ParticipatesInConv(RelType.OUTPUT), "special output PE", "Conversion");
        PatternBox.stateChange(p, "Control");
        p.add(ConBox.equal(false), "input simple PE", "output simple PE");
        p.add((Constraint)new NOT(ConBox.simplePEToConv(RelType.OUTPUT)), "input simple PE", "Conversion");
        p.add((Constraint)new NOT(ConBox.simplePEToConv(RelType.INPUT)), "output simple PE", "Conversion");
        p.add(ConBox.equal(false), "controller ER", "changed ER");
        p.add(ConBox.type(SequenceEntityReference.class), "changed ER");
        return p;
    }

    public static Pattern controlsStateChangeButIsParticipant() {
        Pattern p = new Pattern(SequenceEntityReference.class, "controller ER");
        p.add(ConBox.linkedER(true), "controller ER", "controller generic ER");
        p.add(ConBox.erToPE(), "controller generic ER", "controller simple PE");
        p.add(ConBox.linkToComplex(), "controller simple PE", "controller PE");
        p.add(ConBox.participatesInConv(), "controller PE", "Conversion");
        p.add(ConBox.left(), "Conversion", "controller PE");
        p.add(ConBox.right(), "Conversion", "controller PE");
        p.add((Constraint)new NOT(new InterToPartER(1)), "Conversion", "controller PE", "controller ER");
        PatternBox.stateChange(p, null);
        p.add(ConBox.equal(false), "controller ER", "changed ER");
        p.add(ConBox.equal(false), "controller PE", "input PE");
        p.add(ConBox.equal(false), "controller PE", "output PE");
        return p;
    }

    public static Pattern stateChange(Pattern p, String ctrlLabel) {
        if (p == null) {
            p = new Pattern(Conversion.class, "Conversion");
        }
        if (ctrlLabel == null) {
            p.add((Constraint)new Participant(RelType.INPUT), "Conversion", "input PE");
        } else {
            p.add((Constraint)new Participant(RelType.INPUT, true), ctrlLabel, "Conversion", "input PE");
        }
        p.add(ConBox.linkToSpecific(), "input PE", "input simple PE");
        p.add(ConBox.peToER(), "input simple PE", "changed generic ER");
        p.add((Constraint)new ConversionSide(ConversionSide.Type.OTHER_SIDE), "input PE", "Conversion", "output PE");
        p.add(ConBox.equal(false), "input PE", "output PE");
        p.add(ConBox.linkToSpecific(), "output PE", "output simple PE");
        p.add(ConBox.peToER(), "output simple PE", "changed generic ER");
        p.add(ConBox.linkedER(false), "changed generic ER", "changed ER");
        return p;
    }

    public static Pattern controlsStateChangeThroughControllerSmallMolecule(Blacklist blacklist) {
        Pattern p = new Pattern(SequenceEntityReference.class, "upper controller ER");
        p.add(ConBox.linkedER(true), "upper controller ER", "upper controller generic ER");
        p.add(ConBox.erToPE(), "upper controller generic ER", "upper controller simple PE");
        p.add(ConBox.linkToComplex(), "upper controller simple PE", "upper controller PE");
        p.add(ConBox.peToControl(), "upper controller PE", "upper Control");
        p.add(ConBox.controlToConv(), "upper Control", "upper Conversion");
        p.add((Constraint)new NOT(ConBox.participantER()), "upper Conversion", "upper controller ER");
        p.add((Constraint)new Participant(RelType.OUTPUT, blacklist), "upper Conversion", "controller PE");
        p.add(ConBox.type(SmallMolecule.class), "controller PE");
        if (blacklist != null) {
            p.add((Constraint)new NonUbique(blacklist), "controller PE");
        }
        p.add((Constraint)new NOT(new ConstraintChain(new ConversionSide(ConversionSide.Type.OTHER_SIDE), ConBox.linkToSpecific())), "controller PE", "upper Conversion", "controller PE");
        p.add(ConBox.peToControl(), "controller PE", "Control");
        p.add(ConBox.controlToConv(), "Control", "Conversion");
        p.add(ConBox.equal(false), "upper Conversion", "Conversion");
        PatternBox.stateChange(p, "Control");
        p.add(ConBox.type(SequenceEntityReference.class), "changed ER");
        p.add(ConBox.equal(false), "upper controller ER", "changed ER");
        p.add((Constraint)new NOT(ConBox.participantER()), "Conversion", "upper controller ER");
        return p;
    }

    public static Pattern controlsStateChangeThroughBindingSmallMolecule(Blacklist blacklist) {
        Pattern p = new Pattern(SequenceEntityReference.class, "upper controller ER");
        p.add(ConBox.linkedER(true), "upper controller ER", "upper controller generic ER");
        p.add(ConBox.erToPE(), "upper controller ER", "upper controller simple PE");
        p.add(ConBox.linkToComplex(), "upper controller simple PE", "upper controller PE");
        p.add(ConBox.peToControl(), "upper controller PE", "upper Control");
        p.add(ConBox.controlToConv(), "upper Control", "upper Conversion");
        p.add((Constraint)new NOT(ConBox.participantER()), "upper Conversion", "upper controller ER");
        p.add((Constraint)new Participant(RelType.OUTPUT, blacklist, true), "upper Control", "upper Conversion", "SM");
        p.add(ConBox.type(SmallMolecule.class), "SM");
        if (blacklist != null) {
            p.add((Constraint)new NonUbique(blacklist), "SM");
        }
        p.add((Constraint)new NOT(new ConstraintChain(new ConversionSide(ConversionSide.Type.OTHER_SIDE), ConBox.linkToSpecific())), "SM", "upper Conversion", "SM");
        p.add((Constraint)new ParticipatesInConv(RelType.INPUT), "SM", "Conversion");
        p.add(ConBox.peToER(), "SM", "SM ER");
        p.add(ConBox.equal(false), "upper Conversion", "Conversion");
        PatternBox.stateChange(p, null);
        p.add(ConBox.type(SequenceEntityReference.class), "changed ER");
        p.add(ConBox.equal(false), "upper controller ER", "changed ER");
        p.add((Constraint)new NOT(ConBox.participantER()), "Conversion", "upper controller ER");
        p.add(ConBox.compToER(), "output PE", "SM ER");
        return p;
    }

    public static Pattern controlsStateChangeThroughDegradation() {
        Pattern p = new Pattern(SequenceEntityReference.class, "upstream ER");
        p.add(ConBox.linkedER(true), "upstream ER", "upstream generic ER");
        p.add(ConBox.erToPE(), "upstream generic ER", "upstream SPE");
        p.add(ConBox.linkToComplex(), "upstream SPE", "upstream PE");
        p.add(ConBox.peToControl(), "upstream PE", "Control");
        p.add(ConBox.controlToConv(), "Control", "Conversion");
        p.add((Constraint)new NOT(ConBox.participantER()), "Conversion", "upstream ER");
        p.add((Constraint)new Empty(new Participant(RelType.OUTPUT)), "Conversion");
        p.add((Constraint)new Participant(RelType.INPUT), "Conversion", "input PE");
        p.add(ConBox.linkToSpecific(), "input PE", "input SPE");
        p.add(ConBox.peToER(), "input SPE", "downstream generic ER");
        p.add(ConBox.type(SequenceEntityReference.class), "downstream generic ER");
        p.add(ConBox.linkedER(false), "downstream generic ER", "downstream ER");
        return p;
    }

    public static Pattern controlsPhosphorylation() {
        Pattern p = PatternBox.controlsStateChange();
        p.add((Constraint)new NOT(ConBox.linkToSpecific()), "input PE", "output simple PE");
        p.add((Constraint)new NOT(ConBox.linkToSpecific()), "output PE", "input simple PE");
        p.add((Constraint)new ModificationChangeConstraint(ModificationChangeConstraint.Type.ANY, "phospho"), "input simple PE", "output simple PE");
        return p;
    }

    public static Pattern controlsMetabolicCatalysis(Blacklist blacklist, boolean consumption) {
        Pattern p = new Pattern(SequenceEntityReference.class, "controller ER");
        p.add(ConBox.linkedER(true), "controller ER", "controller generic ER");
        p.add(ConBox.erToPE(), "controller generic ER", "controller simple PE");
        p.add(ConBox.linkToComplex(), "controller simple PE", "controller PE");
        p.add(ConBox.peToControl(), "controller PE", "Control");
        p.add(ConBox.controlToConv(), "Control", "Conversion");
        p.add((Constraint)new NOT(ConBox.participantER()), "Conversion", "controller ER");
        p.add((Constraint)new Participant(consumption ? RelType.INPUT : RelType.OUTPUT, blacklist, true), "Control", "Conversion", "part PE");
        p.add(ConBox.linkToSimple(blacklist), "part PE", "part SM");
        p.add(ConBox.notGeneric(), "part SM");
        p.add(ConBox.type(SmallMolecule.class), "part SM");
        p.add(ConBox.peToER(), "part SM", "part SMR");
        p.add((Constraint)new XOR(new MappedConst(new InterToPartER(InterToPartER.Direction.LEFT), 0, 1), new MappedConst(new InterToPartER(InterToPartER.Direction.RIGHT), 0, 1)), "Conversion", "part SMR");
        return p;
    }

    public static Pattern catalysisPrecedes(Blacklist blacklist) {
        Pattern p = new Pattern(SequenceEntityReference.class, "first ER");
        p.add(ConBox.linkedER(true), "first ER", "first generic ER");
        p.add(ConBox.erToPE(), "first generic ER", "first simple controller PE");
        p.add(ConBox.linkToComplex(), "first simple controller PE", "first controller PE");
        p.add(ConBox.peToControl(), "first controller PE", "first Control");
        p.add(ConBox.controlToConv(), "first Control", "first Conversion");
        p.add((Constraint)new Participant(RelType.OUTPUT, blacklist, true), "first Control", "first Conversion", "linker PE");
        p.add((Constraint)new NOT(new ConstraintChain(new ConversionSide(ConversionSide.Type.OTHER_SIDE), ConBox.linkToSpecific())), "linker PE", "first Conversion", "linker PE");
        p.add(ConBox.type(SmallMolecule.class), "linker PE");
        p.add((Constraint)new ParticipatesInConv(RelType.INPUT, blacklist), "linker PE", "second Conversion");
        p.add((Constraint)new NOT(new ConstraintChain(new ConversionSide(ConversionSide.Type.OTHER_SIDE), ConBox.linkToSpecific())), "linker PE", "second Conversion", "linker PE");
        p.add(ConBox.equal(false), "first Conversion", "second Conversion");
        p.add((Constraint)new ConstraintAdapter(3, blacklist){

            @Override
            public boolean satisfies(Match match, int ... ind) {
                Set output2;
                Conversion cnv1 = (Conversion)match.get(ind[0]);
                Conversion cnv2 = (Conversion)match.get(ind[1]);
                SmallMolecule linker = (SmallMolecule)match.get(ind[2]);
                Set input1 = cnv1.getLeft().contains(linker) ? cnv1.getRight() : cnv1.getLeft();
                Set input2 = cnv2.getLeft().contains(linker) ? cnv2.getLeft() : cnv2.getRight();
                Set output1 = cnv1.getLeft().contains(linker) ? cnv1.getLeft() : cnv1.getRight();
                Set set = output2 = cnv2.getLeft().contains(linker) ? cnv2.getRight() : cnv2.getLeft();
                if (input1.equals(input2) && output1.equals(output2)) {
                    return false;
                }
                if (input1.equals(output2) && output1.equals(input2)) {
                    return false;
                }
                if (this.blacklist != null) {
                    Set<PhysicalEntity> set2 = new HashSet<PhysicalEntity>(input1);
                    set2 = this.blacklist.getNonUbiques(set2, RelType.INPUT);
                    set2.removeAll(output2);
                    if (set2.isEmpty()) {
                        set2.addAll(output2);
                        set2 = this.blacklist.getNonUbiques(set2, RelType.OUTPUT);
                        set2.removeAll(input1);
                        if (set2.isEmpty()) {
                            return false;
                        }
                    }
                }
                return true;
            }
        }, "first Conversion", "second Conversion", "linker PE");
        p.add((Constraint)new RelatedControl(RelType.INPUT, blacklist), "linker PE", "second Conversion", "second Control");
        p.add(ConBox.controllerPE(), "second Control", "second controller PE");
        p.add((Constraint)new NOT(ConBox.compToER()), "second controller PE", "first ER");
        p.add(ConBox.linkToSpecific(), "second controller PE", "second simple controller PE");
        p.add(ConBox.type(SequenceEntity.class), "second simple controller PE");
        p.add(ConBox.peToER(), "second simple controller PE", "second generic ER");
        p.add(ConBox.linkedER(false), "second generic ER", "second ER");
        p.add(ConBox.equal(false), "first ER", "second ER");
        return p;
    }

    public static Pattern controlsExpressionWithTemplateReac() {
        Pattern p = new Pattern(SequenceEntityReference.class, "TF ER");
        p.add(ConBox.linkedER(true), "TF ER", "TF generic ER");
        p.add(ConBox.erToPE(), "TF generic ER", "TF SPE");
        p.add(ConBox.linkToComplex(), "TF SPE", "TF PE");
        p.add(ConBox.peToControl(), "TF PE", "Control");
        p.add(ConBox.controlToTempReac(), "Control", "TempReac");
        p.add(ConBox.product(), "TempReac", "product PE");
        p.add(ConBox.linkToSpecific(), "product PE", "product SPE");
        p.add((Constraint)new Type(SequenceEntity.class), "product SPE");
        p.add(ConBox.peToER(), "product SPE", "product generic ER");
        p.add(ConBox.linkedER(false), "product generic ER", "product ER");
        p.add(ConBox.equal(false), "TF ER", "product ER");
        return p;
    }

    public static Pattern controlsExpressionWithConversion() {
        Pattern p = new Pattern(SequenceEntityReference.class, "TF ER");
        p.add(ConBox.linkedER(true), "TF ER", "TF generic ER");
        p.add(ConBox.erToPE(), "TF generic ER", "TF SPE");
        p.add(ConBox.linkToComplex(), "TF SPE", "TF PE");
        p.add(ConBox.peToControl(), "TF PE", "Control");
        p.add(ConBox.controlToConv(), "Control", "Conversion");
        p.add((Constraint)new Size(ConBox.right(), 1, Size.Type.EQUAL), "Conversion");
        p.add((Constraint)new OR(new MappedConst(new Empty(ConBox.left()), 0), new MappedConst(new ConstraintAdapter(1){

            @Override
            public boolean satisfies(Match match, int ... ind) {
                Conversion cnv = (Conversion)match.get(ind[0]);
                Set left = cnv.getLeft();
                if (left.size() > 1) {
                    return false;
                }
                if (left.isEmpty()) {
                    return true;
                }
                PhysicalEntity pe = (PhysicalEntity)left.iterator().next();
                if (pe instanceof NucleicAcid) {
                    PhysicalEntity rPE = (PhysicalEntity)cnv.getRight().iterator().next();
                    return rPE instanceof Protein;
                }
                return false;
            }
        }, 0)), "Conversion");
        p.add(ConBox.right(), "Conversion", "right PE");
        p.add(ConBox.linkToSpecific(), "right PE", "right SPE");
        p.add((Constraint)new Type(SequenceEntity.class), "right SPE");
        p.add(ConBox.peToER(), "right SPE", "product generic ER");
        p.add(ConBox.linkedER(false), "product generic ER", "product ER");
        p.add(ConBox.equal(false), "TF ER", "product ER");
        return p;
    }

    public static Pattern controlsDegradationIndirectly() {
        Pattern p = PatternBox.controlsStateChange();
        p.add((Constraint)new Size(new ParticipatesInConv(RelType.INPUT), 1, Size.Type.EQUAL), "output PE");
        p.add((Constraint)new Empty(ConBox.peToControl()), "output PE");
        p.add((Constraint)new ParticipatesInConv(RelType.INPUT), "output PE", "degrading Conv");
        p.add((Constraint)new NOT(ConBox.type(ComplexAssembly.class)), "degrading Conv");
        p.add((Constraint)new Size(ConBox.participant(), 1, Size.Type.EQUAL), "degrading Conv");
        p.add((Constraint)new Empty(new Participant(RelType.OUTPUT)), "degrading Conv");
        p.add((Constraint)new Empty(ConBox.convToControl()), "degrading Conv");
        p.add(ConBox.equal(false), "degrading Conv", "Conversion");
        return p;
    }

    public static Pattern inComplexWith() {
        Pattern p = new Pattern(SequenceEntityReference.class, "Protein 1");
        p.add(ConBox.linkedER(true), "Protein 1", "generic Protein 1");
        p.add(ConBox.erToPE(), "generic Protein 1", "SPE1");
        p.add(ConBox.linkToComplex(), "SPE1", "PE1");
        p.add((Constraint)new PathConstraint("PhysicalEntity/componentOf"), "PE1", "Complex");
        p.add((Constraint)new PathConstraint("Complex/component"), "Complex", "PE2");
        p.add(ConBox.equal(false), "PE1", "PE2");
        p.add(ConBox.linkToSpecific(), "PE2", "SPE2");
        p.add(ConBox.peToER(), "SPE2", "generic Protein 2");
        p.add(ConBox.linkedER(false), "generic Protein 2", "Protein 2");
        p.add(ConBox.equal(false), "Protein 1", "Protein 2");
        p.add((Constraint)new Type(SequenceEntityReference.class), "Protein 2");
        return p;
    }

    public static Pattern chemicalAffectsProteinThroughBinding(Blacklist blacklist) {
        Pattern p = new Pattern(SmallMoleculeReference.class, "SMR");
        p.add(ConBox.erToPE(), "SMR", "SPE1");
        p.add(ConBox.notGeneric(), "SPE1");
        if (blacklist != null) {
            p.add((Constraint)new NonUbique(blacklist), "SPE1");
        }
        p.add(ConBox.linkToComplex(), "SPE1", "PE1");
        p.add((Constraint)new PathConstraint("PhysicalEntity/componentOf"), "PE1", "Complex");
        p.add((Constraint)new PathConstraint("Complex/component"), "Complex", "PE2");
        p.add(ConBox.equal(false), "PE1", "PE2");
        p.add(ConBox.linkToSpecific(), "PE2", "SPE2");
        p.add((Constraint)new Type(SequenceEntity.class), "SPE2");
        p.add(ConBox.peToER(), "SPE2", "generic ER");
        p.add(ConBox.linkedER(false), "generic ER", "ER");
        return p;
    }

    public static Pattern chemicalAffectsProteinThroughControl() {
        Pattern p = new Pattern(SmallMoleculeReference.class, "controller SMR");
        p.add(ConBox.erToPE(), "controller SMR", "controller simple PE");
        p.add(ConBox.notGeneric(), "controller simple PE");
        p.add(ConBox.linkToComplex(), "controller simple PE", "controller PE");
        p.add(ConBox.peToControl(), "controller PE", "Control");
        p.add(ConBox.controlToInter(), "Control", "Interaction");
        p.add((Constraint)new NOT(ConBox.participantER()), "Interaction", "controller SMR");
        p.add(ConBox.participant(), "Interaction", "affected PE");
        p.add(ConBox.linkToSpecific(), "affected PE", "affected simple PE");
        p.add((Constraint)new Type(SequenceEntity.class), "affected simple PE");
        p.add(ConBox.peToER(), "affected simple PE", "affected generic ER");
        p.add(ConBox.linkedER(false), "affected generic ER", "affected ER");
        return p;
    }

    public static Pattern neighborOf() {
        Pattern p = new Pattern(SequenceEntityReference.class, "Protein 1");
        p.add(ConBox.linkedER(true), "Protein 1", "generic Protein 1");
        p.add(ConBox.erToPE(), "generic Protein 1", "SPE1");
        p.add(ConBox.linkToComplex(), "SPE1", "PE1");
        p.add(ConBox.peToInter(), "PE1", "Inter");
        p.add(ConBox.interToPE(), "Inter", "PE2");
        p.add(ConBox.linkToSpecific(), "PE2", "SPE2");
        p.add(ConBox.equal(false), "SPE1", "SPE2");
        p.add(ConBox.type(SequenceEntity.class), "SPE2");
        p.add(ConBox.peToER(), "SPE2", "generic Protein 2");
        p.add(ConBox.linkedER(false), "generic Protein 2", "Protein 2");
        p.add(ConBox.equal(false), "Protein 1", "Protein 2");
        return p;
    }

    public static Pattern reactsWith(Blacklist blacklist) {
        Pattern p = new Pattern(SmallMoleculeReference.class, "SMR1");
        p.add(ConBox.erToPE(), "SMR1", "SPE1");
        p.add(ConBox.notGeneric(), "SPE1");
        p.add(ConBox.linkToComplex(blacklist), "SPE1", "PE1");
        p.add((Constraint)new ParticipatesInConv(RelType.INPUT, blacklist), "PE1", "Conv");
        p.add(ConBox.type(BiochemicalReaction.class), "Conv");
        p.add((Constraint)new InterToPartER(InterToPartER.Direction.ONESIDERS), "Conv", "SMR1");
        p.add((Constraint)new ConversionSide(ConversionSide.Type.SAME_SIDE, blacklist, RelType.INPUT), "PE1", "Conv", "PE2");
        p.add(ConBox.type(SmallMolecule.class), "PE2");
        p.add(ConBox.linkToSpecific(), "PE2", "SPE2");
        p.add(ConBox.notGeneric(), "SPE2");
        p.add((Constraint)new PEChainsIntersect(false), "SPE1", "PE1", "SPE2", "PE2");
        p.add(ConBox.peToER(), "SPE2", "SMR2");
        p.add(ConBox.equal(false), "SMR1", "SMR2");
        p.add((Constraint)new InterToPartER(InterToPartER.Direction.ONESIDERS), "Conv", "SMR2");
        return p;
    }

    public static Pattern usedToProduce(Blacklist blacklist) {
        Pattern p = new Pattern(SmallMoleculeReference.class, "SMR1");
        p.add(ConBox.erToPE(), "SMR1", "SPE1");
        p.add(ConBox.notGeneric(), "SPE1");
        p.add(ConBox.linkToComplex(blacklist), "SPE1", "PE1");
        p.add((Constraint)new ParticipatesInConv(RelType.INPUT, blacklist), "PE1", "Conv");
        p.add(ConBox.type(BiochemicalReaction.class), "Conv");
        p.add((Constraint)new InterToPartER(InterToPartER.Direction.ONESIDERS), "Conv", "SMR1");
        p.add((Constraint)new ConversionSide(ConversionSide.Type.OTHER_SIDE, blacklist, RelType.OUTPUT), "PE1", "Conv", "PE2");
        p.add(ConBox.type(SmallMolecule.class), "PE2");
        p.add(ConBox.linkToSimple(blacklist), "PE2", "SPE2");
        p.add(ConBox.notGeneric(), "SPE2");
        p.add(ConBox.equal(false), "SPE1", "SPE2");
        p.add(ConBox.peToER(), "SPE2", "SMR2");
        p.add(ConBox.equal(false), "SMR1", "SMR2");
        p.add((Constraint)new InterToPartER(InterToPartER.Direction.ONESIDERS), "Conv", "SMR2");
        return p;
    }

    public static Pattern molecularInteraction() {
        Pattern p = new Pattern(SequenceEntityReference.class, "Protein 1");
        p.add(ConBox.linkedER(true), "Protein 1", "generic Protein 1");
        p.add(ConBox.erToPE(), "generic Protein 1", "SPE1");
        p.add(ConBox.linkToComplex(), "SPE1", "PE1");
        p.add((Constraint)new PathConstraint("PhysicalEntity/participantOf:MolecularInteraction"), "PE1", "MI");
        p.add(ConBox.participant(), "MI", "PE2");
        p.add(ConBox.equal(false), "PE1", "PE2");
        p.add((Constraint)new NOT(new AND(new MappedConst(ConBox.isPrey(), 0), new MappedConst(ConBox.isPrey(), 1))), "PE1", "PE2");
        p.add((Constraint)new NOT(new AND(new MappedConst(ConBox.isBait(), 0), new MappedConst(ConBox.isBait(), 1))), "PE1", "PE2");
        p.add(ConBox.linkToSpecific(), "PE2", "SPE2");
        p.add(ConBox.type(SequenceEntity.class), "SPE2");
        p.add((Constraint)new PEChainsIntersect(false), "SPE1", "PE1", "SPE2", "PE2");
        p.add(ConBox.peToER(), "SPE2", "generic Protein 2");
        p.add(ConBox.linkedER(false), "generic Protein 2", "Protein 2");
        p.add(ConBox.equal(false), "Protein 1", "Protein 2");
        return p;
    }

    public static Pattern relatedProteinRefOfInter(Class<? extends Interaction> ... seedType) {
        Pattern p = new Pattern(Interaction.class, "Interaction");
        if (seedType.length == 1) {
            p.add((Constraint)new Type(seedType[0]), "Interaction");
        } else if (seedType.length > 1) {
            MappedConst[] mc = new MappedConst[seedType.length];
            for (int i = 0; i < mc.length; ++i) {
                mc[i] = new MappedConst(new Type(seedType[i]), 0);
            }
            p.add((Constraint)new OR(mc), "Interaction");
        }
        p.add((Constraint)new OR(new MappedConst(ConBox.participant(), 0, 1), new MappedConst(new PathConstraint("Interaction/controlledOf*/controller:PhysicalEntity"), 0, 1)), "Interaction", "PE");
        p.add(ConBox.linkToSpecific(), "PE", "SPE");
        p.add(ConBox.peToER(), "SPE", "generic PR");
        p.add((Constraint)new Type(ProteinReference.class), "generic PR");
        p.add(ConBox.linkedER(false), "generic PR", "PR");
        return p;
    }

    public static Pattern inSameComplex() {
        Pattern p = new Pattern(EntityReference.class, "first ER");
        p.add(ConBox.erToPE(), "first ER", "first simple PE");
        p.add(ConBox.linkToComplex(), "first simple PE", "Complex");
        p.add((Constraint)new Type(Complex.class), "Complex");
        p.add(ConBox.linkToSpecific(), "Complex", "second simple PE");
        p.add(ConBox.equal(false), "first simple PE", "second simple PE");
        p.add((Constraint)new PEChainsIntersect(false, true), "first simple PE", "Complex", "second simple PE", "Complex");
        p.add(ConBox.peToER(), "second simple PE", "second ER");
        p.add(ConBox.equal(false), "first ER", "second ER");
        return p;
    }

    public static Pattern inSameActiveComplex() {
        Pattern p = PatternBox.inSameComplex();
        p.add((Constraint)new ActivityConstraint(true), "Complex");
        return p;
    }

    public static Pattern inSameComplexHavingTransActivity() {
        Pattern p = PatternBox.inSameComplex();
        p.add(ConBox.peToControl(), "Complex", "Control");
        p.add(ConBox.controlToTempReac(), "Control", "TR");
        p.add((Constraint)new NOT(ConBox.participantER()), "TR", "first ER");
        p.add((Constraint)new NOT(ConBox.participantER()), "TR", "second ER");
        return p;
    }

    public static Pattern inSameComplexEffectingConversion() {
        Pattern p = PatternBox.inSameComplex();
        p.add(ConBox.peToControl(), "Complex", "Control");
        p.add(ConBox.controlToConv(), "Control", "Conversion");
        p.add((Constraint)new NOT(ConBox.participantER()), "Control", "first ER");
        p.add((Constraint)new NOT(ConBox.participantER()), "Control", "second ER");
        return p;
    }

    public static Pattern peInOut() {
        Pattern p = new Pattern(EntityReference.class, "changed ER");
        p.add(ConBox.erToPE(), "changed ER", "input simple PE");
        p.add(ConBox.linkToComplex(), "input simple PE", "input PE");
        p.add((Constraint)new ParticipatesInConv(RelType.INPUT), "input PE", "Conversion");
        p.add((Constraint)new ConversionSide(ConversionSide.Type.OTHER_SIDE), "input PE", "Conversion", "output PE");
        p.add(ConBox.equal(false), "input PE", "output PE");
        p.add(ConBox.linkToSpecific(), "output PE", "output simple PE");
        p.add(ConBox.peToER(), "output simple PE", "changed ER");
        return p;
    }

    public static Pattern modifiedPESimple() {
        Pattern p = new Pattern(EntityReference.class, "modified ER");
        p.add(ConBox.erToPE(), "modified ER", "first PE");
        p.add(ConBox.participatesInConv(), "first PE", "Conversion");
        p.add((Constraint)new ConversionSide(ConversionSide.Type.OTHER_SIDE), "first PE", "Conversion", "second PE");
        p.add(ConBox.equal(false), "first PE", "second PE");
        p.add(ConBox.peToER(), "second PE", "modified ER");
        return p;
    }

    public static Pattern actChange(boolean activating, Map<EntityReference, Set<ModificationFeature>> activityFeat, Map<EntityReference, Set<ModificationFeature>> inactivityFeat) {
        Pattern p = PatternBox.peInOut();
        p.add((Constraint)new OR(new MappedConst(ConBox.differentialActivity(activating), 0, 1), new MappedConst(new ActivityModificationChangeConstraint(activating, activityFeat, inactivityFeat), 0, 1)), "input simple PE", "output simple PE");
        return p;
    }

    public static Pattern modifierConv() {
        Pattern p = new Pattern(EntityReference.class, "ER");
        p.add(ConBox.erToPE(), "ER", "SPE");
        p.add(ConBox.linkToComplex(), "SPE", "PE");
        p.add(ConBox.participatesInConv(), "PE", "Conversion");
        return p;
    }

    public static Pattern hasNonSelfEffect() {
        Pattern p = new Pattern(PhysicalEntity.class, "SPE");
        p.add(ConBox.peToER(), "SPE", "ER");
        p.add(ConBox.linkToComplex(), "SPE", "PE");
        p.add(ConBox.peToControl(), "PE", "Control");
        p.add(ConBox.controlToInter(), "Control", "Inter");
        p.add((Constraint)new NOT(ConBox.participantER()), "Inter", "ER");
        return p;
    }

    public static Pattern bindsTo() {
        Pattern p = new Pattern(ProteinReference.class, "first PR");
        p.add(ConBox.erToPE(), "first PR", "first simple PE");
        p.add(ConBox.linkToComplex(), "first simple PE", "Complex");
        p.add((Constraint)new Type(Complex.class), "Complex");
        p.add(ConBox.linkToSpecific(), "Complex", "second simple PE");
        p.add(ConBox.peToER(), "second simple PE", "second PR");
        p.add(ConBox.equal(false), "first PR", "second PR");
        return p;
    }
}

