/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.constraint;

import java.util.Collection;
import java.util.HashSet;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.pattern.MappedConst;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.constraint.Field;

public class FieldOfMultiple
extends Field {
    protected MappedConst con1;
    protected MappedConst con2;

    public FieldOfMultiple(MappedConst con, String accessorString, Field.Operation oper, Object value) {
        super(accessorString, oper, value);
        this.con1 = con;
    }

    public FieldOfMultiple(MappedConst con1, String accessorString1, MappedConst con2, String accessorString2, Field.Operation oper) {
        super(accessorString1, accessorString2, oper);
        this.con1 = con1;
        this.con2 = con2;
    }

    @Override
    public int getVariableSize() {
        return this.con1.getVariableSize() + (this.con2 != null ? this.con2.getVariableSize() - 2 : -1);
    }

    @Override
    public boolean satisfies(Match match, int ... ind) {
        this.assertIndLength(ind);
        HashSet values = new HashSet();
        for (BioPAXElement gen : this.con1.generate(match, ind)) {
            values.addAll(this.pa1.getValueFromBean(gen));
        }
        if (this.value == EMPTY) {
            return values.isEmpty();
        }
        if (this.oper == Field.Operation.NOT_EMPTY_AND_NOT_INTERSECT && values.isEmpty()) {
            return false;
        }
        if (this.value == USE_SECOND_ARG) {
            BioPAXElement q = match.get(ind[1]);
            return this.oper == Field.Operation.INTERSECT ? values.contains(q) : !values.contains(q);
        }
        if (this.value instanceof Collection) {
            Collection query = (Collection)this.value;
            values.retainAll(query);
            if (this.oper == Field.Operation.INTERSECT) {
                return !values.isEmpty();
            }
            return values.isEmpty();
        }
        if (this.pa2 != null) {
            HashSet others = new HashSet();
            for (BioPAXElement gen : this.con2.generate(match, ind)) {
                others.addAll(this.pa2.getValueFromBean(gen));
            }
            switch (this.oper) {
                case INTERSECT: {
                    others.retainAll(values);
                    return !others.isEmpty();
                }
                case NOT_INTERSECT: {
                    others.retainAll(values);
                    return others.isEmpty();
                }
                case NOT_EMPTY_AND_NOT_INTERSECT: {
                    if (others.isEmpty()) {
                        return false;
                    }
                    others.retainAll(values);
                    return others.isEmpty();
                }
            }
            throw new RuntimeException("Unhandled operation: " + String.valueOf((Object)this.oper));
        }
        if (this.oper == Field.Operation.INTERSECT) {
            return values.contains(this.value);
        }
        return !values.contains(this.value);
    }
}

