/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.miner;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.biopax.paxtools.controller.IDFetcher;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.NucleicAcid;
import org.biopax.paxtools.model.level3.NucleicAcidReference;
import org.biopax.paxtools.model.level3.PublicationXref;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.model.level3.XReferrable;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.normalizer.Resolver;
import org.biopax.paxtools.util.HGNC;

public class CommonIDFetcher
implements IDFetcher {
    boolean useUniprotIDs = false;

    public Set<String> fetchID(BioPAXElement ele) {
        String id;
        String db;
        HashSet<String> set;
        block13: {
            block11: {
                Named e;
                block14: {
                    block12: {
                        set = new HashSet<String>();
                        if (!(ele instanceof SmallMoleculeReference) && !(ele instanceof SmallMolecule)) break block11;
                        e = (Named)ele;
                        if (e.getDisplayName() == null || e.getDisplayName().contains("...")) break block12;
                        set.add(e.getDisplayName());
                        break block13;
                    }
                    if (e.getStandardName() == null || e.getStandardName().contains("...")) break block14;
                    set.add(e.getStandardName());
                    break block13;
                }
                if (e.getName().isEmpty()) break block13;
                TreeSet<String> names = new TreeSet<String>();
                for (String name : e.getName()) {
                    if (name.contains("...")) continue;
                    names.add(name);
                }
                set.add(((Object)names).toString());
                break block13;
            }
            if (this.useUniprotIDs && (StringUtils.containsIgnoreCase((CharSequence)ele.getUri(), (CharSequence)"identifiers.org/uniprot") || StringUtils.containsIgnoreCase((CharSequence)ele.getUri(), (CharSequence)"bioregistry.io/uniprot"))) {
                String ac = StringUtils.substringAfterLast((String)ele.getUri(), (String)"/");
                if (StringUtils.contains((CharSequence)ac, (CharSequence)":")) {
                    ac = StringUtils.substringAfter((String)ac, (String)":");
                }
                set.add(ac);
            } else if (ele instanceof XReferrable) {
                for (Xref xr : ((XReferrable)ele).getXref()) {
                    if (xr instanceof PublicationXref) continue;
                    db = xr.getDb();
                    id = xr.getId();
                    if (!StringUtils.isNotBlank((CharSequence)db) || !StringUtils.isNotBlank((CharSequence)id)) continue;
                    if (Resolver.isKnownNameOrVariant((String)(db = db.toLowerCase()))) {
                        db = Resolver.getNamespace((String)db).getPrefix();
                    }
                    if (!this.useUniprotIDs && db.startsWith("hgnc")) {
                        String symbol = HGNC.getSymbolByHgncIdOrSym((String)id);
                        if (!StringUtils.isNotEmpty((CharSequence)symbol)) continue;
                        set.add(symbol);
                        continue;
                    }
                    if (!this.useUniprotIDs || !db.startsWith("uniprot")) continue;
                    set.add(id);
                }
            }
        }
        if (set.isEmpty() && (ele instanceof NucleicAcidReference || ele instanceof NucleicAcid)) {
            for (Xref xr : ((XReferrable)ele).getXref()) {
                if (xr instanceof PublicationXref) continue;
                db = xr.getDb();
                id = xr.getId();
                if (!StringUtils.isNotBlank((CharSequence)db) || !StringUtils.isNotBlank((CharSequence)id)) continue;
                if (Resolver.isKnownNameOrVariant((String)db)) {
                    db = Resolver.getNamespace((String)db).getPrefix();
                }
                if (!StringUtils.equalsAnyIgnoreCase((CharSequence)db, (CharSequence[])new CharSequence[]{"mirbase", "mirbase sequence"})) continue;
                set.add(id);
            }
        }
        return set;
    }

    public void setUseUniprotIDs(boolean useUniprotIDs) {
        this.useUniprotIDs = useUniprotIDs;
    }
}

