/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.ConversionDirectionType;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.pattern.util.RelType;

public class Blacklist {
    private Map<String, RelType> context = new HashMap<String, RelType>();
    private Map<String, Integer> score = new HashMap<String, Integer>();
    private static final String DELIM = "\t";

    public Blacklist() {
    }

    public Blacklist(String filename) {
        this();
        this.load(filename);
    }

    public Blacklist(InputStream is) {
        this();
        this.load(is);
    }

    private void load(String filename) {
        try {
            this.load(new FileInputStream(filename));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void load(InputStream is) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = reader.readLine();
            while (line != null) {
                String[] tok = line.split(DELIM);
                if (tok.length >= 3) {
                    this.addEntry(tok[0], Integer.parseInt(tok[1]), this.convertContext(tok[2]));
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.context = null;
            this.score = null;
        }
    }

    public void addEntry(String id, int score, RelType context) {
        this.score.put(id, score);
        this.context.put(id, context);
    }

    public Set<String> getListed() {
        return this.score.keySet();
    }

    public void write(String filename) {
        try {
            this.write(new FileOutputStream(filename));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void write(OutputStream os) {
        ArrayList<String> ids = new ArrayList<String>(this.score.keySet());
        final Map<String, Integer> score = this.score;
        Collections.sort(ids, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return ((Integer)score.get(o2)).compareTo((Integer)score.get(o1));
            }
        });
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
            boolean notFirst = false;
            for (String id : ids) {
                if (notFirst) {
                    writer.write("\n");
                } else {
                    notFirst = true;
                }
                writer.write(id + DELIM + String.valueOf(score.get(id)) + DELIM + this.convertContext(this.context.get(id)));
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String convertContext(RelType type) {
        if (type == null) {
            return "B";
        }
        switch (type) {
            case INPUT: {
                return "I";
            }
            case OUTPUT: {
                return "O";
            }
        }
        return "B";
    }

    private RelType convertContext(String type) {
        if (type.equals("I")) {
            return RelType.INPUT;
        }
        if (type.equals("O")) {
            return RelType.OUTPUT;
        }
        if (type.equals("B")) {
            return null;
        }
        throw new IllegalArgumentException("Unknown context: " + type);
    }

    private Set<String> getLeastUbique(Collection<String> ids) {
        HashSet<String> select = new HashSet<String>();
        int s = this.getLeastScore(ids);
        for (String id : ids) {
            if (this.score.get(id) != s) continue;
            select.add(id);
        }
        return select;
    }

    private int getLeastScore(Collection<String> ids) {
        int s = Integer.MAX_VALUE;
        for (String id : ids) {
            if (this.score.get(id) >= s) continue;
            s = this.score.get(id);
        }
        return s;
    }

    public RelType getContext(String id) {
        return this.context.get(id);
    }

    private boolean isUbique(String id) {
        return this.isUbique(id, null);
    }

    private boolean isUbiqueInBothContexts(String id) {
        return this.context.containsKey(id) && this.context.get(id) == null;
    }

    private boolean isUbique(String id, RelType context) {
        if (context == null) {
            return this.context.containsKey(id);
        }
        if (!this.isUbique(id)) {
            return false;
        }
        RelType ctx = this.context.get(id);
        return ctx == null || ctx.equals((Object)context);
    }

    public boolean isUbique(PhysicalEntity pe) {
        String id = this.getSMRID(pe);
        return id != null && this.isUbique(id);
    }

    public boolean isUbiqueInBothContexts(PhysicalEntity pe) {
        String id = this.getSMRID(pe);
        return id != null && this.isUbiqueInBothContexts(id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isUbique(PhysicalEntity pe, Conversion conv, ConversionDirectionType dir, RelType context) {
        Set parts;
        String id = this.getSMRID(pe);
        if (id == null) {
            return false;
        }
        if (dir == null) {
            throw new IllegalArgumentException("The conversion direction has to be specified.");
        }
        if (context == null) {
            throw new IllegalArgumentException("The context has to be only one type.");
        }
        if (dir == ConversionDirectionType.REVERSIBLE) {
            if (conv.getLeft().contains(pe)) {
                parts = conv.getLeft();
            } else {
                if (!conv.getRight().contains(pe)) throw new IllegalArgumentException("The PhysicalEntity has to be at least one side of the Conversion");
                parts = conv.getRight();
            }
        } else {
            Set set = dir == ConversionDirectionType.LEFT_TO_RIGHT ? (context == RelType.INPUT ? conv.getLeft() : conv.getRight()) : (parts = context == RelType.OUTPUT ? conv.getLeft() : conv.getRight());
        }
        if (dir != ConversionDirectionType.REVERSIBLE) return this.getUbiques(parts, context).contains(pe);
        return this.getUbiques(parts, null).contains(pe);
    }

    private String getSMRID(PhysicalEntity pe) {
        EntityReference er;
        if (pe instanceof SmallMolecule && (er = ((SmallMolecule)pe).getEntityReference()) != null) {
            return er.getUri();
        }
        return null;
    }

    public Collection<SmallMolecule> getUbiques(Set<PhysicalEntity> entities, RelType context) {
        HashMap<String, SmallMolecule> ubiques = new HashMap<String, SmallMolecule>();
        boolean allUbiques = true;
        for (PhysicalEntity pe : entities) {
            if (pe instanceof SmallMolecule) {
                EntityReference er = ((SmallMolecule)pe).getEntityReference();
                if (er != null && this.isUbique(er.getUri(), context)) {
                    ubiques.put(er.getUri(), (SmallMolecule)pe);
                    continue;
                }
                allUbiques = false;
                continue;
            }
            allUbiques = false;
        }
        if (allUbiques && !ubiques.isEmpty()) {
            Set<String> least = this.getLeastUbique(ubiques.keySet());
            for (String id : least) {
                ubiques.remove(id);
            }
        }
        return ubiques.values();
    }

    public Set<PhysicalEntity> getNonUbiques(Set<PhysicalEntity> entities, RelType ctx) {
        Collection<SmallMolecule> ubiques = this.getUbiques(entities, ctx);
        if (ubiques.isEmpty()) {
            return entities;
        }
        HashSet<PhysicalEntity> result = new HashSet<PhysicalEntity>(entities);
        result.removeAll(ubiques);
        return result;
    }

    public Set getNonUbiqueObjects(Set objects) {
        HashSet result = new HashSet();
        for (Object o : objects) {
            if (!(o instanceof SmallMolecule) || this.isUbique((PhysicalEntity)((SmallMolecule)o))) continue;
            result.add(o);
        }
        return result;
    }
}

