/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.biopax.paxtools.client.BiopaxValidatorClient;
import org.biopax.paxtools.controller.Cloner;
import org.biopax.paxtools.controller.Completer;
import org.biopax.paxtools.controller.Fetcher;
import org.biopax.paxtools.controller.Integrator;
import org.biopax.paxtools.controller.Merger;
import org.biopax.paxtools.controller.ModelUtils;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.converter.LevelUpgrader;
import org.biopax.paxtools.converter.psi.PsiToBiopax3Converter;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.io.gsea.GSEAConverter;
import org.biopax.paxtools.io.sbgn.L3ToSBGNPDConverter;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.entity;
import org.biopax.paxtools.model.level3.ControlledVocabulary;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Gene;
import org.biopax.paxtools.model.level3.NucleicAcid;
import org.biopax.paxtools.model.level3.NucleicAcidReference;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.model.level3.PublicationXref;
import org.biopax.paxtools.model.level3.SequenceEntityReference;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.pattern.miner.BlacklistGenerator3;
import org.biopax.paxtools.pattern.miner.ConfigurableIDFetcher;
import org.biopax.paxtools.pattern.miner.CustomFormat;
import org.biopax.paxtools.pattern.miner.Dialog;
import org.biopax.paxtools.pattern.miner.ExtendedSIFWriter;
import org.biopax.paxtools.pattern.miner.IDFetcher;
import org.biopax.paxtools.pattern.miner.OutputColumn;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.biopax.paxtools.pattern.miner.SIFInteraction;
import org.biopax.paxtools.pattern.miner.SIFSearcher;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.biopax.paxtools.query.QueryExecuter;
import org.biopax.paxtools.query.algorithm.Direction;
import org.biopax.paxtools.query.wrapperL3.Filter;
import org.biopax.paxtools.util.ClassFilterSet;
import org.biopax.validator.jaxb.Behavior;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxtoolsMain {
    static final Logger log = LoggerFactory.getLogger(PaxtoolsMain.class);
    private static SimpleIOHandler io;
    private static final Object NULL;
    private static final Object EMPTY;

    public static void main(String[] argv) throws Exception {
        io = new SimpleIOHandler();
        io.mergeDuplicates(true);
        if (argv.length == 0) {
            PaxtoolsMain.help();
        } else {
            String command = argv[0];
            Command.valueOf(command).run(argv);
        }
    }

    public static void toGSEA(String[] argv) throws IOException {
        boolean crossSpecies = false;
        boolean subPathways = false;
        boolean notPathways = false;
        HashSet<String> organisms = new HashSet<String>();
        if (argv.length < 4) {
            throw new IllegalArgumentException("Not enough arguments: " + argv);
        }
        if (argv.length > 4) {
            for (int i = 4; i < argv.length; ++i) {
                if ("-crossSpecies".equalsIgnoreCase(argv[i])) {
                    crossSpecies = true;
                    continue;
                }
                if ("-subPathways".equalsIgnoreCase(argv[i])) {
                    subPathways = true;
                    continue;
                }
                if ("-notPathway".equalsIgnoreCase(argv[i])) {
                    notPathways = true;
                    continue;
                }
                if (!argv[i].startsWith("organisms=")) continue;
                for (String o : argv[i].substring(10).split(",")) {
                    organisms.add(o.trim().toLowerCase());
                }
            }
        }
        GSEAConverter gseaConverter = new GSEAConverter(argv[3], !crossSpecies, !subPathways);
        gseaConverter.setSkipOutsidePathways(!notPathways);
        gseaConverter.setAllowedOrganisms(organisms);
        gseaConverter.writeToGSEA(io.convertFromOWL(PaxtoolsMain.getInputStream(argv[1])), new FileOutputStream(argv[2]));
    }

    public static void getNeighbors(String[] argv) throws IOException {
        String in = argv[1];
        String[] ids = argv[2].split(",");
        String out = argv[3];
        Model model = io.convertFromOWL(PaxtoolsMain.getInputStream(in));
        HashSet<BioPAXElement> elements = new HashSet<BioPAXElement>();
        for (String id : ids) {
            BioPAXElement e = model.getByID(id.toString());
            if (e != null && (e instanceof Entity || e instanceof entity)) {
                elements.add(e);
                continue;
            }
            log.warn("Source element not found: " + id);
        }
        Set<BioPAXElement> result = QueryExecuter.runNeighborhood(elements, model, 1, Direction.BOTHSTREAM, new Filter[0]);
        Completer c = new Completer(io.getEditorMap());
        result = c.complete(result, model);
        Cloner cln = new Cloner(io.getEditorMap(), io.getFactory());
        model = cln.clone(model, result);
        if (model != null) {
            log.info("Elements in the result model: " + model.getObjects().size());
            io.convertToOWL(model, new FileOutputStream(out));
        } else {
            log.error("NULL model returned.");
        }
    }

    public static void fetch(String[] argv) throws IOException {
        String in = argv[1];
        String out = argv[2];
        String[] uris = new String[]{};
        boolean absoluteUris = false;
        if (argv.length > 3) {
            for (int i = 3; i < argv.length; ++i) {
                String param = argv[i];
                if (param.startsWith("uris=")) {
                    uris = param.substring(5).split(",");
                    continue;
                }
                if (!param.startsWith("-absolute")) continue;
                absoluteUris = true;
            }
        }
        log.info("Loading the BioPAX model from " + in);
        Model model = io.convertFromOWL(PaxtoolsMain.getInputStream(in));
        log.info("Successfully loaded the BioPAX model. Writing to the output: " + out);
        SimpleIOHandler biopaxWriter = new SimpleIOHandler(model.getLevel());
        biopaxWriter.absoluteUris(absoluteUris);
        if (uris.length > 0) {
            biopaxWriter.convertToOWL(model, new FileOutputStream(out), uris);
        } else {
            biopaxWriter.convertToOWL(model, new FileOutputStream(out));
        }
        log.info("Done.");
    }

    public static void toLevel3(String[] argv) throws IOException {
        String input = argv[1];
        String output = argv[2];
        InputStream is = PaxtoolsMain.getInputStream(input);
        FileOutputStream os = new FileOutputStream(output);
        boolean forcePsiInteractionToComplex = false;
        if (argv.length > 3) {
            for (int i = 3; i < argv.length; ++i) {
                String param = argv[i];
                if (!param.equalsIgnoreCase("-psimiToComplexes")) continue;
                forcePsiInteractionToComplex = true;
            }
        }
        Type type = PaxtoolsMain.detect(input);
        try {
            switch (type) {
                case BIOPAX: {
                    Model model = io.convertFromOWL(is);
                    model = new LevelUpgrader().filter(model);
                    if (model != null) {
                        io.setFactory(model.getLevel().getDefaultFactory());
                        io.convertToOWL(model, os);
                    }
                    break;
                }
                case PSIMI: {
                    PsiToBiopax3Converter psimiConverter = new PsiToBiopax3Converter();
                    psimiConverter.convert(is, (OutputStream)os, forcePsiInteractionToComplex);
                    os.close();
                    break;
                }
                default: {
                    PsiToBiopax3Converter psimiConverter = new PsiToBiopax3Converter();
                    psimiConverter.convertTab(is, os, forcePsiInteractionToComplex);
                    os.close();
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert " + input + "to BioPAX L3", e);
        }
    }

    private static Type detect(String input) {
        StringBuilder sb = new StringBuilder();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(input));
            int linesToCheck = 20;
            while (linesToCheck-- > 0) {
                sb.append(reader.readLine()).append('\n');
            }
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String buf = sb.toString();
        if (buf.contains("<rdf:RDF") && buf.contains("http://www.biopax.org/release/biopax")) {
            return Type.BIOPAX;
        }
        if (buf.contains("<entrySet") && buf.contains("http://psidev.sourceforge.net/mi/rel25/")) {
            return Type.PSIMI;
        }
        return Type.PSIMITAB;
    }

    public static void toSbgn(String[] argv) throws IOException {
        String input = argv[1];
        String output = argv[2];
        Model model = io.convertFromOWL(PaxtoolsMain.getInputStream(input));
        L3ToSBGNPDConverter l3ToSBGNPDConverter = new L3ToSBGNPDConverter();
        l3ToSBGNPDConverter.writeSBGN(model, output);
    }

    public static void validate(String[] argv) throws IOException {
        block16: {
            String input = argv[1];
            String output = argv[2];
            BiopaxValidatorClient.RetFormat outf = BiopaxValidatorClient.RetFormat.HTML;
            boolean fix = false;
            Integer maxErrs = null;
            Behavior level = null;
            String profile = null;
            for (int i = 3; i < argv.length; ++i) {
                if ("html".equalsIgnoreCase(argv[i])) {
                    outf = BiopaxValidatorClient.RetFormat.HTML;
                    continue;
                }
                if ("xml".equalsIgnoreCase(argv[i])) {
                    outf = BiopaxValidatorClient.RetFormat.XML;
                    continue;
                }
                if ("biopax".equalsIgnoreCase(argv[i])) {
                    outf = BiopaxValidatorClient.RetFormat.OWL;
                    continue;
                }
                if ("auto-fix".equalsIgnoreCase(argv[i])) {
                    fix = true;
                    continue;
                }
                if ("only-errors".equalsIgnoreCase(argv[i])) {
                    level = Behavior.ERROR;
                    continue;
                }
                if (argv[i].toLowerCase().startsWith("maxerrors=")) {
                    String num = argv[i].substring(10);
                    maxErrs = Integer.valueOf(num);
                    continue;
                }
                if (!"notstrict".equalsIgnoreCase(argv[i])) continue;
                profile = "notstrict";
            }
            HashSet<File> files = new HashSet<File>();
            File fileOrDir = new File(input);
            if (!fileOrDir.canRead()) {
                System.out.println("Cannot read " + input);
            }
            if (fileOrDir.isDirectory()) {
                FilenameFilter filter = new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".owl");
                    }
                };
                for (String s : fileOrDir.list(filter)) {
                    files.add(new File(fileOrDir.getCanonicalPath() + File.separator + s));
                }
            } else {
                files.add(fileOrDir);
            }
            FileOutputStream os = new FileOutputStream(output);
            try {
                if (files.isEmpty()) break block16;
                BiopaxValidatorClient val = new BiopaxValidatorClient();
                val.validate(fix, profile, outf, level, maxErrs, null, files.toArray(new File[0]), os);
            }
            catch (Exception ex) {
                String msg = "Unable to check with the biopax-validator web service: \n " + ex.toString() + "\n Fall-back: trying to parse the file(s) with paxtools (up to the first syntax error in each file)...\n";
                log.error(msg, ex);
                ((OutputStream)os).write(msg.getBytes());
                for (File f : files) {
                    try {
                        Model m = io.convertFromOWL(PaxtoolsMain.getInputStream(f.getPath()));
                        msg = "Model that contains " + m.getObjects().size() + " elements is successfully created from " + f.getPath() + " (check the console output for warnings).\n";
                        ((OutputStream)os).write(msg.getBytes());
                    }
                    catch (Exception e) {
                        msg = "Error: " + e + " in building a BioPAX Model from: " + f.getPath() + "\n";
                        ((OutputStream)os).write(msg.getBytes());
                        e.printStackTrace();
                        log.error(msg);
                    }
                    os.flush();
                }
            }
        }
    }

    public static void toSifnx(String[] argv) throws IOException {
        boolean extended = false;
        boolean andSif = false;
        boolean mergeInteractions = true;
        boolean useNameIfNoId = false;
        HashSet<SIFEnum> include = new HashSet<SIFEnum>();
        HashSet<SIFEnum> exclude = new HashSet<SIFEnum>();
        ConfigurableIDFetcher idFetcher = new ConfigurableIDFetcher();
        ArrayList<String> customFieldList = new ArrayList<String>();
        if (argv.length > 3) {
            for (int i = 3; i < argv.length; ++i) {
                String param = argv[i];
                if (param.startsWith("seqDb=")) {
                    for (String db : param.substring(6).split(",")) {
                        idFetcher.seqDbStartsWithOrEquals(db);
                    }
                    continue;
                }
                if (param.startsWith("chemDb=")) {
                    for (String db : param.substring(7).split(",")) {
                        idFetcher.chemDbStartsWithOrEquals(db);
                    }
                    continue;
                }
                if (param.equalsIgnoreCase("-andSif")) {
                    andSif = true;
                    continue;
                }
                if (param.equalsIgnoreCase("-extended")) {
                    extended = true;
                    continue;
                }
                if (param.equalsIgnoreCase("-dontMergeInteractions")) {
                    mergeInteractions = false;
                    continue;
                }
                if (param.equalsIgnoreCase("-useNameIfNoId")) {
                    useNameIfNoId = true;
                    continue;
                }
                if (param.startsWith("include=")) {
                    for (String t : param.substring(8).split(",")) {
                        include.add(SIFEnum.valueOf(t.toUpperCase()));
                    }
                    continue;
                }
                if (param.startsWith("exclude=")) {
                    for (String t : param.substring(8).split(",")) {
                        exclude.add(SIFEnum.valueOf(t.toUpperCase()));
                    }
                    continue;
                }
                Object type = OutputColumn.Type.getType(param.toUpperCase());
                if ((type == null || type == OutputColumn.Type.CUSTOM) && !param.contains("/")) continue;
                if (!param.contains("/")) {
                    customFieldList.add(param.toUpperCase());
                    continue;
                }
                customFieldList.add(param);
            }
        }
        if (idFetcher.getChemDbStartsWithOrEquals().isEmpty()) {
            idFetcher.chemDbStartsWithOrEquals("chebi");
        }
        if (idFetcher.getSeqDbStartsWithOrEquals().isEmpty()) {
            idFetcher.chemDbStartsWithOrEquals("hgnc");
        }
        idFetcher.useNameWhenNoDbMatch(useNameIfNoId);
        Model model = PaxtoolsMain.getModel(io, argv[1]);
        if (mergeInteractions) {
            ModelUtils.mergeEquivalentInteractions(model);
        }
        HashSet<SIFEnum> sifTypes = include.isEmpty() ? new HashSet<SIFEnum>(Arrays.asList(SIFEnum.values())) : include;
        for (SIFType sIFType : exclude) {
            sifTypes.remove(sIFType);
        }
        SIFSearcher searcher = new SIFSearcher((IDFetcher)idFetcher, (SIFType[])sifTypes.toArray(new SIFEnum[0]));
        log.info("toSIF: using SIFTypes: " + sifTypes);
        File file = new File("blacklist.txt");
        if (file.exists()) {
            log.info("toSIF: using blacklist.txt from current directory");
            searcher.setBlacklist(new Blacklist(new FileInputStream(file)));
        } else {
            log.info("toSIF: not blacklisting ubiquitous molecules (no blacklist.txt found)");
        }
        File outputFile = new File(argv[2]);
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        if (extended) {
            Set<SIFInteraction> binaryInts = searcher.searchSIF(model);
            ExtendedSIFWriter.write(binaryInts, outputStream);
        } else if (customFieldList.isEmpty()) {
            searcher.searchSIF(model, outputStream);
        } else {
            log.info("toSIF: using custom fields (extra columns): " + customFieldList);
            searcher.searchSIF(model, (OutputStream)outputStream, new CustomFormat(customFieldList.toArray(new String[0])));
        }
        if (extended && andSif) {
            PaxtoolsMain.sifnxToSif(outputFile.getPath(), outputFile.getPath() + ".sif");
        }
        log.info("toSIF: done.");
    }

    public static void sifnxToSif(String inputFile, String outputFile) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(PaxtoolsMain.getInputStream(inputFile)));
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(outputFile));
        if (reader.ready()) {
            reader.readLine();
        }
        while (reader.ready() && (line = reader.readLine()) != null && !line.isEmpty()) {
            writer.write(StringUtils.join((Object[])Arrays.copyOfRange(line.split("\t", 4), 0, 3), '\t') + '\n');
        }
        reader.close();
        writer.close();
    }

    public static void integrate(String[] argv) throws IOException {
        Model model1 = PaxtoolsMain.getModel(io, argv[1]);
        Model model2 = PaxtoolsMain.getModel(io, argv[2]);
        Integrator integrator = new Integrator(SimpleEditorMap.get(model1.getLevel()), model1, model2);
        integrator.integrate();
        io.setFactory(model1.getLevel().getDefaultFactory());
        io.convertToOWL(model1, new FileOutputStream(argv[3]));
    }

    public static void merge(String[] argv) throws IOException {
        Model model1 = PaxtoolsMain.getModel(io, argv[1]);
        Model model2 = PaxtoolsMain.getModel(io, argv[2]);
        Merger merger = new Merger(SimpleEditorMap.get(model1.getLevel()));
        merger.merge(model1, model2);
        io.setFactory(model1.getLevel().getDefaultFactory());
        io.convertToOWL(model1, new FileOutputStream(argv[3]));
    }

    public static void blacklist(String[] argv) throws IOException {
        Model model = PaxtoolsMain.getModel(io, argv[1]);
        BlacklistGenerator3 gen = new BlacklistGenerator3();
        Blacklist blacklist = gen.generateBlacklist(model);
        blacklist.write(new FileOutputStream(argv[2]));
    }

    public static void help() {
        System.out.println("(Paxtools Console) Available Operations:\n");
        for (Command cmd : Command.values()) {
            System.out.println(cmd.name() + " " + cmd.description);
        }
        System.out.println("Commands can also use compressed input files (only '.gz').\n");
    }

    public static void pattern(String[] argv) {
        Dialog.main(argv);
    }

    private static Model getModel(BioPAXIOHandler io, String fName) throws IOException {
        return io.convertFromOWL(PaxtoolsMain.getInputStream(fName));
    }

    public static void summarize(String[] argv) throws IOException {
        log.debug("Importing the input model from " + argv[1] + "...");
        Model model = PaxtoolsMain.getModel(io, argv[1]);
        PrintStream out = new PrintStream(argv[2]);
        if (argv.length > 3) {
            for (int i = 3; i < argv.length; ++i) {
                if (argv[i].equals("--model")) {
                    PaxtoolsMain.summarize(model, out);
                    continue;
                }
                if (argv[i].equals("--pathways")) {
                    PaxtoolsMain.summarizePathways(model, out);
                    continue;
                }
                if (argv[i].equals("--hgnc-ids")) {
                    PaxtoolsMain.summarizeHgncIds(model, out);
                    continue;
                }
                if (argv[i].equals("--uniprot-ids")) {
                    PaxtoolsMain.summarizeUniprotIds(model, out);
                    continue;
                }
                if (!argv[i].equals("--chebi-ids")) continue;
                PaxtoolsMain.summarizeChebiIds(model, out);
            }
        } else {
            PaxtoolsMain.summarize(model, out);
        }
        out.close();
    }

    private static void summarizePathways(Model model, PrintStream out) throws IOException {
        PathAccessor directChildPathwaysAccessor = new PathAccessor("Pathway/pathwayComponent:Pathway");
        PathAccessor pathwayComponentAccessor = new PathAccessor("Pathway/pathwayComponent");
        PathAccessor pathwayOrderStepProcessAccessor = new PathAccessor("Pathway/pathwayOrder/stepProcess");
        Set<Pathway> pathways = model.getObjects(Pathway.class);
        out.println("PATHWAY_URI\tDISPLAY_NAME\tDIRECT_SUB_PATHWAY_URIS\tALL_SUB_PATHWAY_URIS");
        for (Pathway pathway2 : pathways) {
            Pathway p;
            Object o2;
            StringBuilder sb = new StringBuilder();
            sb.append(pathway2.getUri()).append('\t').append(pathway2.getDisplayName()).append('\t');
            for (Object o2 : directChildPathwaysAccessor.getValueFromBean(pathway2)) {
                p = (Pathway)o2;
                sb.append(p.getUri()).append(";");
            }
            sb.append("\t");
            Fetcher fetcher = new Fetcher(SimpleEditorMap.L3, Fetcher.nextStepFilter);
            o2 = fetcher.fetch((BioPAXElement)pathway2, Pathway.class).iterator();
            while (o2.hasNext()) {
                p = (Pathway)o2.next();
                sb.append(p.getUri()).append(";");
            }
            out.println(sb.toString());
        }
        out.println("\nPATHWAY_URI\tDATASOURCE\tDISPLAY_NAME\tALL_NAMES\tNUM_DIRECT_COMPONENT_OR_STEP_PROCESSES");
        for (Pathway pathway2 : pathways) {
            int size = pathwayComponentAccessor.getValueFromBean(pathway2).size() + pathwayOrderStepProcessAccessor.getValueFromBean(pathway2).size();
            String datasource = pathway2.getDataSource().iterator().next().getDisplayName();
            StringBuilder sb = new StringBuilder();
            sb.append(pathway2.getUri()).append('\t').append(datasource).append('\t').append(pathway2.getDisplayName()).append('\t');
            for (String name : pathway2.getName()) {
                sb.append('\"').append(name).append('\"').append(";");
            }
            sb.append('\t').append(size);
            out.println(sb.toString());
        }
    }

    private static void summarizeHgncIds(Model model, PrintStream out) {
        boolean verbose = true;
        HashSet<SequenceEntityReference> haveMultipleHgnc = new HashSet<SequenceEntityReference>();
        HashMap<Provenance, MutableInt> numErs = new HashMap<Provenance, MutableInt>();
        HashMap<Provenance, MutableInt> numProblematicErs = new HashMap<Provenance, MutableInt>();
        PathAccessor pa = new PathAccessor("EntityReference/entityReferenceOf/dataSource", model.getLevel());
        TreeSet<String> problemErs = new TreeSet<String>();
        for (EntityReference ser : model.getObjects(EntityReference.class)) {
            if (ser instanceof SmallMoleculeReference || !ser.getMemberEntityReference().isEmpty()) continue;
            HashSet<Object> hgncSymbols = new HashSet<Object>();
            HashSet<Object> hgncIds = new HashSet<Object>();
            if (ser.getUri().startsWith("http://identifiers.org/hgnc")) {
                String s = ser.getUri().substring(ser.getUri().lastIndexOf("/") + 1);
                if (s.startsWith("HGNC:")) {
                    hgncIds.add(s);
                } else {
                    hgncSymbols.add(s);
                }
            }
            for (Xref x : ser.getXref()) {
                if (x instanceof PublicationXref || x.getDb() == null || x.getId() == null) continue;
                if (x.getDb().toLowerCase().startsWith("hgnc") && !x.getId().toLowerCase().startsWith("hgnc:")) {
                    hgncSymbols.add(x.getId().toLowerCase());
                    continue;
                }
                if (!x.getDb().toLowerCase().startsWith("hgnc") || !x.getId().toLowerCase().startsWith("hgnc:")) continue;
                hgncIds.add(x.getId().toLowerCase());
            }
            if (hgncIds.size() > 1 || hgncSymbols.size() > 1) {
                haveMultipleHgnc.add((SequenceEntityReference)ser);
            }
            for (Object provenance : pa.getValueFromBean(ser)) {
                MutableInt tot;
                if (hgncSymbols.isEmpty() && hgncIds.isEmpty()) {
                    MutableInt n;
                    if (verbose) {
                        problemErs.add(String.format("%s\t%s\t%s", ((Provenance)provenance).getDisplayName(), ser.getDisplayName(), ser.getUri()));
                    }
                    if ((n = (MutableInt)numProblematicErs.get(provenance)) == null) {
                        numProblematicErs.put((Provenance)provenance, new MutableInt(1));
                    } else {
                        n.increment();
                    }
                }
                if ((tot = (MutableInt)numErs.get(provenance)) == null) {
                    numErs.put((Provenance)provenance, new MutableInt(1));
                    continue;
                }
                tot.increment();
            }
        }
        if (verbose) {
            out.println("SequenceEntityReferences (not generics) without any HGNC Symbol:");
            for (String line : problemErs) {
                out.println(line);
            }
        }
        out.println("The number of SERs (not generic) having more than one HGNC Symbols: " + haveMultipleHgnc.size());
        out.println("\nNumber of SequenceEntityReferences (not generics) without any HGNC ID, by data source:");
        int totalPrs = 0;
        int numPrsNoHgnc = 0;
        for (Provenance ds : numProblematicErs.keySet()) {
            int n = ((MutableInt)numProblematicErs.get(ds)).intValue();
            numPrsNoHgnc += n;
            int t = ((MutableInt)numErs.get(ds)).intValue();
            totalPrs += t;
            out.println(String.format("%s\t\t%d\t(%3.1f%%)", ds.getUri(), n, Float.valueOf((float)n / (float)t * 100.0f)));
        }
        out.println(String.format("Total\t\t%d\t(%3.1f%%)", numPrsNoHgnc, Float.valueOf((float)numPrsNoHgnc / (float)totalPrs * 100.0f)));
    }

    private static void summarizeUniprotIds(Model model, PrintStream out) {
        boolean verbose = true;
        HashMap<Provenance, MutableInt> numErs = new HashMap<Provenance, MutableInt>();
        HashMap<Provenance, MutableInt> numProblematicErs = new HashMap<Provenance, MutableInt>();
        PathAccessor pa = new PathAccessor("EntityReference/entityReferenceOf:Protein/dataSource", model.getLevel());
        TreeSet<String> problemErs = new TreeSet<String>();
        for (ProteinReference pr : model.getObjects(ProteinReference.class)) {
            if (!pr.getMemberEntityReference().isEmpty()) continue;
            for (Object provenance : pa.getValueFromBean(pr)) {
                MutableInt tot;
                if (!pr.getUri().startsWith("http://identifiers.org/uniprot") && !pr.getXref().toString().toLowerCase().contains("uniprot")) {
                    MutableInt n;
                    if (verbose) {
                        problemErs.add(String.format("%s\t%s\t%s", ((Provenance)provenance).getDisplayName(), pr.getDisplayName(), pr.getUri()));
                    }
                    if ((n = (MutableInt)numProblematicErs.get(provenance)) == null) {
                        numProblematicErs.put((Provenance)provenance, new MutableInt(1));
                    } else {
                        n.increment();
                    }
                }
                if ((tot = (MutableInt)numErs.get(provenance)) == null) {
                    numErs.put((Provenance)provenance, new MutableInt(1));
                    continue;
                }
                tot.increment();
            }
        }
        if (verbose) {
            out.println("\nProteinReferences (not generics) without any UniProt AC:");
            for (String line : problemErs) {
                out.println(line);
            }
        }
        out.println("\nNumber of ProteinReferences (not generics) without any UniProt AC, by data source:");
        int totalErs = 0;
        int problematicErs = 0;
        for (Provenance ds : numProblematicErs.keySet()) {
            int n = ((MutableInt)numProblematicErs.get(ds)).intValue();
            problematicErs += n;
            int t = ((MutableInt)numErs.get(ds)).intValue();
            totalErs += t;
            out.println(String.format("%s\t\t%d\t(%3.1f%%)", ds.getUri(), n, Float.valueOf((float)n / (float)t * 100.0f)));
        }
        out.println(String.format("Total\t\t%d\t(%3.1f%%)", problematicErs, Float.valueOf((float)problematicErs / (float)totalErs * 100.0f)));
    }

    private static void summarizeChebiIds(Model model, PrintStream out) {
        boolean verbose = true;
        HashMap<Provenance, MutableInt> numErs = new HashMap<Provenance, MutableInt>();
        HashMap<Provenance, MutableInt> numProblematicErs = new HashMap<Provenance, MutableInt>();
        PathAccessor pa = new PathAccessor("EntityReference/entityReferenceOf:SmallMolecule/dataSource", model.getLevel());
        TreeSet<String> problemErs = new TreeSet<String>();
        for (SmallMoleculeReference smr : model.getObjects(SmallMoleculeReference.class)) {
            if (!smr.getMemberEntityReference().isEmpty()) continue;
            for (Object provenance : pa.getValueFromBean(smr)) {
                MutableInt tot;
                if (!smr.getUri().startsWith("http://identifiers.org/chebi/CHEBI:") && !smr.getXref().toString().contains("CHEBI:")) {
                    MutableInt n;
                    if (verbose) {
                        problemErs.add(String.format("%s\t%s\t%s", ((Provenance)provenance).getDisplayName(), smr.getDisplayName(), smr.getUri()));
                    }
                    if ((n = (MutableInt)numProblematicErs.get(provenance)) == null) {
                        numProblematicErs.put((Provenance)provenance, new MutableInt(1));
                    } else {
                        n.increment();
                    }
                }
                if ((tot = (MutableInt)numErs.get(provenance)) == null) {
                    numErs.put((Provenance)provenance, new MutableInt(1));
                    continue;
                }
                tot.increment();
            }
        }
        if (verbose) {
            out.println("\nSmallMoleculeReferences (not generics) without any ChEBI ID:");
            for (String line : problemErs) {
                out.println(line);
            }
        }
        out.println("\nNumber of SmallMoleculeReferences (not generics) without any ChEBI ID, by data source:");
        int totalSmrs = 0;
        int numSmrsNoChebi = 0;
        for (Provenance ds : numProblematicErs.keySet()) {
            int n = ((MutableInt)numProblematicErs.get(ds)).intValue();
            numSmrsNoChebi += n;
            int t = ((MutableInt)numErs.get(ds)).intValue();
            totalSmrs += t;
            out.println(String.format("%s\t\t%d\t(%3.1f%%)", ds.getUri(), n, Float.valueOf((float)n / (float)t * 100.0f)));
        }
        out.println(String.format("Total\t\t%d\t(%3.1f%%)", numSmrsNoChebi, Float.valueOf((float)numSmrsNoChebi / (float)totalSmrs * 100.0f)));
    }

    /*
     * WARNING - void declaration
     */
    public static void summarize(Model model, PrintStream out) throws IOException {
        void var16_34;
        void var5_8;
        String[] props;
        String[] stringArray;
        HashMap<String, Integer> hm = new HashMap<String, Integer>();
        SimpleEditorMap em = SimpleEditorMap.get(model.getLevel());
        for (Class<? extends BioPAXElement> clazz : PaxtoolsMain.sortToName(em.getKnownSubClassesOf(BioPAXElement.class))) {
            Set<? extends BioPAXElement> set = model.getObjects(clazz);
            int initialSize = set.size();
            set = PaxtoolsMain.filterToExactClass(set, clazz);
            String s = clazz.getSimpleName() + " = " + set.size();
            if (initialSize != set.size()) {
                s = s + " (and " + (initialSize - set.size()) + " children)";
            }
            out.println(s);
            Set<PropertyEditor> editors = em.getEditorsOf(clazz);
            for (PropertyEditor editor : editors) {
                Set values;
                Method getMethod = editor.getGetMethod();
                Iterator<Object> returnType = getMethod.getReturnType();
                HashMap<Object, Integer> cnt = new HashMap<Object, Integer>();
                if (((Class)((Object)returnType)).isEnum() || PaxtoolsMain.implementsInterface((Class)((Object)returnType), ControlledVocabulary.class)) {
                    for (BioPAXElement bioPAXElement : set) {
                        values = editor.getValueFromBean(bioPAXElement);
                        if (values.isEmpty()) {
                            PaxtoolsMain.increaseCnt(cnt, NULL);
                            continue;
                        }
                        PaxtoolsMain.increaseCnt(cnt, values.iterator().next());
                    }
                } else if (returnType.equals(Set.class) && PaxtoolsMain.implementsInterface(editor.getRange(), ControlledVocabulary.class)) {
                    for (BioPAXElement bioPAXElement : set) {
                        values = editor.getValueFromBean(bioPAXElement);
                        if (values.isEmpty()) {
                            PaxtoolsMain.increaseCnt(cnt, EMPTY);
                        }
                        for (Object val : values) {
                            PaxtoolsMain.increaseCnt(cnt, val);
                        }
                    }
                }
                if (cnt.isEmpty()) continue;
                String name = "-" + (returnType.equals(Set.class) ? editor.getRange().getSimpleName() : ((Class)((Object)returnType)).getSimpleName());
                out.print("\t" + name + ":");
                for (Object key : PaxtoolsMain.getOrdering(cnt)) {
                    out.print("\t" + key + " = " + cnt.get(key));
                }
                out.println();
            }
        }
        out.println("\nOther property counts\n");
        if (model.getLevel() == BioPAXLevel.L3) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "UnificationXref/db";
            stringArray = stringArray2;
            stringArray2[1] = "RelationshipXref/db";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "unificationXref/DB";
            stringArray = stringArray3;
            stringArray3[1] = "relationshipXref/DB";
        }
        for (String prop : props = stringArray) {
            HashMap<Object, Integer> cnt = new HashMap<Object, Integer>();
            ArrayList<String> valList = new ArrayList<String>();
            PathAccessor acc = new PathAccessor(prop, model.getLevel());
            boolean isString = false;
            for (Object o : acc.getValueFromModel(model)) {
                if (o instanceof String) {
                    isString = true;
                }
                String s = o.toString();
                valList.add(s);
                if (!cnt.containsKey(s)) {
                    cnt.put(s, 1);
                    continue;
                }
                cnt.put(s, (Integer)cnt.get(s) + 1);
            }
            out.println(prop + "\t(" + cnt.size() + " distinct values):");
            hm.put(prop, cnt.size());
            if (isString) {
                Collections.sort(valList);
                for (String s : valList) {
                    out.print("\t" + s);
                }
            } else {
                for (Object key : PaxtoolsMain.getOrdering(cnt)) {
                    out.print("\t" + key + " = " + cnt.get(key));
                }
            }
            out.println();
        }
        boolean bl = false;
        int genericSpeLackingEr = 0;
        int speLackingErAndId = 0;
        int protLackingErAndId = 0;
        int molLackingErAndId = 0;
        int naLackingErAndId = 0;
        TreeMap<String, Integer> numSpeLackErByProvider = new TreeMap<String, Integer>();
        for (SimplePhysicalEntity spe : model.getObjects(SimplePhysicalEntity.class)) {
            String providers;
            Integer n;
            if (spe.getEntityReference() != null) continue;
            ++var5_8;
            if (!spe.getMemberPhysicalEntity().isEmpty()) {
                ++genericSpeLackingEr;
            }
            n = (n = (Integer)numSpeLackErByProvider.get(providers = spe.getDataSource().toString())) == null ? 1 : n + 1;
            numSpeLackErByProvider.put(providers, n);
            if (!spe.getXref().isEmpty() && new ClassFilterSet<Xref, PublicationXref>(spe.getXref(), PublicationXref.class).size() != spe.getXref().size()) continue;
            ++speLackingErAndId;
            if (spe instanceof Protein) {
                ++protLackingErAndId;
                continue;
            }
            if (spe instanceof SmallMolecule) {
                ++molLackingErAndId;
                continue;
            }
            if (!(spe instanceof NucleicAcid)) continue;
            ++naLackingErAndId;
        }
        out.println("\n" + (int)var5_8 + " simple physical entities have NULL 'entityReference';\n");
        out.println("\n\t-" + genericSpeLackingEr + " of which have member physical entities (are generic).\n");
        out.println("\n\t- by data source:\n");
        for (Object key : numSpeLackErByProvider.keySet()) {
            out.println(String.format("\n\t\t-- %s -> %d\n", key, numSpeLackErByProvider.get(key)));
        }
        out.println("\n\t- " + speLackingErAndId + " neither have 'entityReference' nor xref/id (except publications):\n");
        if (speLackingErAndId > 0) {
            out.println("\n\t\t-- proteins: " + protLackingErAndId + "\n");
            out.println("\n\t\t-- small molecules: " + molLackingErAndId + "\n");
            out.println("\n\t\t-- nucl. acids: " + naLackingErAndId + "\n");
        }
        int erLackingId = 0;
        for (EntityReference er : model.getObjects(EntityReference.class)) {
            if (!er.getMemberEntityReference().isEmpty() || !er.getXref().isEmpty() && new ClassFilterSet<Xref, PublicationXref>(er.getXref(), PublicationXref.class).size() != er.getXref().size()) continue;
            ++erLackingId;
        }
        out.println("\n" + erLackingId + " non-generic entity references have no xref/id.\n");
        int genesLackingOrganism = 0;
        int pwLackingOrganism = 0;
        int serLackingOrganism = 0;
        boolean bl2 = false;
        for (BioPAXElement bpe : model.getObjects()) {
            if (bpe instanceof Gene && ((Gene)bpe).getOrganism() == null) {
                ++genesLackingOrganism;
                continue;
            }
            if (bpe instanceof Pathway && ((Pathway)bpe).getOrganism() == null) {
                ++pwLackingOrganism;
                continue;
            }
            if (!(bpe instanceof SequenceEntityReference) || ((SequenceEntityReference)bpe).getOrganism() != null) continue;
            ++serLackingOrganism;
            if (!(bpe instanceof NucleicAcidReference)) continue;
            ++var16_34;
        }
        out.println(String.format("\n%d Genes, %d Pathways, %d SequenceEntityReferences (%d in NucleicAcidRef. and %d in PRs) have NULL 'organism'.\n", genesLackingOrganism, pwLackingOrganism, serLackingOrganism, (int)var16_34, serLackingOrganism - var16_34));
    }

    private static List<Class<? extends BioPAXElement>> sortToName(Set<? extends Class<? extends BioPAXElement>> classes) {
        ArrayList<Class<? extends BioPAXElement>> list = new ArrayList<Class<? extends BioPAXElement>>(classes);
        Collections.sort(list, new Comparator<Class<? extends BioPAXElement>>(){

            @Override
            public int compare(Class<? extends BioPAXElement> clazz1, Class<? extends BioPAXElement> clazz2) {
                return clazz1.getName().substring(clazz1.getName().lastIndexOf(".") + 1).compareTo(clazz2.getName().substring(clazz2.getName().lastIndexOf(".") + 1));
            }
        });
        return list;
    }

    private static List<Object> getOrdering(final Map<Object, Integer> map) {
        ArrayList<Object> list = new ArrayList<Object>(map.keySet());
        Collections.sort(list, new Comparator<Object>(){

            @Override
            public int compare(Object key1, Object key2) {
                int cnt2;
                int cnt1 = (Integer)map.get(key1);
                if (cnt1 == (cnt2 = ((Integer)map.get(key2)).intValue())) {
                    return key1.toString().compareTo(key2.toString());
                }
                return cnt2 - cnt1;
            }
        });
        return list;
    }

    private static Set<BioPAXElement> filterToExactClass(Set<? extends BioPAXElement> classSet, Class<?> clazz) {
        HashSet<BioPAXElement> exact = new HashSet<BioPAXElement>();
        for (BioPAXElement bioPAXElement : classSet) {
            if (!bioPAXElement.getModelInterface().equals(clazz)) continue;
            exact.add(bioPAXElement);
        }
        return exact;
    }

    private static boolean implementsInterface(Class clazz, Class inter) {
        for (Class<?> anInter : clazz.getInterfaces()) {
            if (!anInter.equals(inter)) continue;
            return true;
        }
        return false;
    }

    private static void increaseCnt(Map<Object, Integer> cnt, Object key) {
        if (!cnt.containsKey(key)) {
            cnt.put(key, 0);
        }
        cnt.put(key, cnt.get(key) + 1);
    }

    private static InputStream getInputStream(String path) throws IOException {
        FileInputStream is = new FileInputStream(path);
        return path.endsWith(".gz") ? new GZIPInputStream(is) : is;
    }

    static {
        NULL = new Object(){

            public String toString() {
                return "NULL";
            }
        };
        EMPTY = new Object(){

            public String toString() {
                return "EMPTY";
            }
        };
    }

    static enum Command {
        merge("<file1> <file2> <output>\n\t- merges file2 into file1 and writes it into output"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.merge(argv);
            }
        }
        ,
        toSIF("<input> <output> [-extended] [-andSif] [\"include=SIFType,..\"] [\"exclude=SIFType,..\"] [\"seqDb=db,..\"] [\"chemDb=db,..\"] [-dontMergeInteractions] [-useNameIfNoId] [\"mediator\"] [\"pubmed\"] [\"pathway\"] [\"resource\"] [\"source_loc\"] [\"target_loc\"] [\"path/to/a/mediator/field\"]\n\t- exports a BioPAX model to classic SIF (default, has 3 columns) or customizable SIF format;\n\t  will use blacklist.txt file in the current directory, if present;\n\t  one can list one or more relationship types to include or exclude to/from the analysis\n\t  using 'include=' and/or 'exclude=', respectively, e.g., exclude=NEIGHBOR_OF,INTERACTS_WITH\n\t  (mind using underscore instead of minus sign in the SIF type names; the default is to use all types);\n\t  using 'seqDb=' and 'chemDb=', you can specify standard sequence/gene/chemical ID type(s)\n\t  (can be just a unique prefix) to match actual xref.db values in the BioPAX model,\n\t  e.g., \"seqDb=uniprot,hgnc,refseq\", and in that order, means: if a UniProt entity ID is found,\n\t  other ID types ain't used; otherwise, if an 'hgnc' ID/Symbol is found... and so on;\n\t  when not specified, then 'hgnc' (in fact, 'HGNC Symbol') for bio-polymers - \n\t  and ChEBI IDs or name (if '-useNameIfNoId' is set) for chemicals - are selected;\n\t  if '-extended' is used then the output will be the Pathway Commons' EXTENDED_BINARY_SIF format:\n\t  one file - two sections separated with a single blank line - first come inferred SIF-like interactions -\n\t  3 classic SIF and 4 extra colums, followed by interactors/nodes description section; comment lines start with #)\n\t  if also '-andSif' flag is present (which only makes sense together with -extended), then the second\n\t  output file, classic SIF, is also created (with the same name as the output's, plus '.sif' extension)"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.toSifnx(argv);
            }
        }
        ,
        toSBGN("<biopax.owl> <output.sbgn>\n\t- converts model to the SBGN format."){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.toSbgn(argv);
            }
        }
        ,
        validate("<path> <out> [xml|html|biopax] [auto-fix] [only-errors] [maxerrors=n] [notstrict]\n\t- validate BioPAX file/directory (up to ~25MB in total size, -\n\totherwise download and run the stand-alone validator)\n\tin the directory using the online validator service\n\t(generates html or xml report, or gets the processed biopax\n\t(cannot be perfect though) see http://www.biopax.org/validator)"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.validate(argv);
            }
        }
        ,
        integrate("<file1> <file2> <output>\n\t- integrates file2 into file1 and writes it into output (experimental)"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.integrate(argv);
            }
        }
        ,
        toLevel3("<input> <output> [-psimiToComplexes]\n\t- converts BioPAX level 1 or 2, PSI-MI 2.5 and PSI-MITAB to the level 3 file;\n\t-psimiToComplexes forces PSI-MI Interactions become BioPAX Complexes instead MolecularInteractions."){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.toLevel3(argv);
            }
        }
        ,
        toGSEA("<input> <output> <db> [-crossSpecies] [-subPathways] [-notPathway] [organisms=9606,human,rat,..]\n\t- converts BioPAX data to the GSEA software format (GMT); options/flags:\n\t<db> - gene/protein ID type; values: uniprot, hgnc, refseq, etc. (a name or prefix to match\n\t  ProteinReference/xref/db property values in the input BioPAX model).\n\t-crossSpecies - allows printing on the same line gene/protein IDs from different species;\n\t-subPathways - traverse into sub-pathways to collect all protein IDs for a pathway.\n\t-notPathway - also list those protein/gene IDs that cannot be reached from pathways.\n\torganisms - optional filter; a comma-separated list of taxonomy IDs and/or names\n"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.toGSEA(argv);
            }
        }
        ,
        fetch("<input> <output> [uris=URI1,..] [-absolute] \n\t- extracts a self-integral BioPAX sub-model from file1 and writes to the output; options:\n\turi=... - an optional list of existing in the model BioPAX elements' full URIs;\n\t-absolute - set this flag to write full/absolute URIs to the output (i.e., 'rdf:about' instead 'rdf:ID')."){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.fetch(argv);
            }
        }
        ,
        getNeighbors("<input> <id1,id2,..> <output>\n\t- nearest neighborhood graph query (id1,id2 - of Entity sub-class only)"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.getNeighbors(argv);
            }
        }
        ,
        summarize("<input> <output> [--model] [--pathways] [--hgnc-ids] [--uniprot-ids] [--chebi-ids]\n\t- (experimental/troubleshooting) command to summarize the input BioPAX model;\n \truns one or several selected analyses and writes to the output text file;\n \t'--model' - the default mode, is about BioPAX classes, properties and values;\n \t'--pathways' - pathways and their sub-pathways summary;\n \t'--hgnc-ids' - about HGNC IDs/Symbols in the sequence entity references;\n \t'--uniprot-ids' - about UniProt IDs in the protein references;\n \t'--chebi-ids' - about ChEBI IDs in the small molecule references;\n \tthe options' order defines the results output order."){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.summarize(argv);
            }
        }
        ,
        blacklist("<input> <output>\n\t- creates a blacklist of ubiquitous small molecules, like ATP, \n\tfrom the BioPAX model and writes it to the output file. The blacklist can be used with\n \tpaxtools graph queries or when converting from the SAME BioPAX data to the SIF formats."){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.blacklist(argv);
            }
        }
        ,
        pattern("\n\t- BioPAX pattern search tool (opens a new dialog window)"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.pattern(argv);
            }
        }
        ,
        help("\n\t- prints this screen and exits\n"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.help();
            }
        };

        String description;
        int params;

        private Command(String description) {
            this.description = description;
        }

        public abstract void run(String[] var1) throws IOException;
    }

    private static enum Type {
        BIOPAX,
        PSIMI,
        PSIMITAB;

    }
}

