/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.gsea;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.biopax.paxtools.controller.AbstractTraverser;
import org.biopax.paxtools.controller.Fetcher;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.controller.Traverser;
import org.biopax.paxtools.converter.LevelUpgrader;
import org.biopax.paxtools.io.gsea.GSEAEntry;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.model.level3.RelationshipXref;
import org.biopax.paxtools.model.level3.SequenceEntityReference;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.util.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSEAConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GSEAConverter.class);
    private final String database;
    private final boolean crossSpeciesCheckEnabled;
    private Set<String> allowedOrganisms;
    private final boolean skipSubPathways;
    private final Set<Provenance> skipSubPathwaysOf;
    private boolean skipOutsidePathways = false;
    private int minNumOfGenesPerEntry = 1;

    public GSEAConverter() {
        this("", true);
    }

    public GSEAConverter(String database, boolean crossSpeciesCheckEnabled) {
        this(database, crossSpeciesCheckEnabled, false);
    }

    public GSEAConverter(String database, boolean crossSpeciesCheckEnabled, boolean skipSubPathways) {
        this.database = database;
        this.crossSpeciesCheckEnabled = crossSpeciesCheckEnabled;
        this.skipSubPathways = skipSubPathways;
        this.skipSubPathwaysOf = Collections.emptySet();
    }

    public GSEAConverter(String database, boolean crossSpeciesCheckEnabled, Set<Provenance> skipSubPathwaysOf) {
        this.database = database;
        this.crossSpeciesCheckEnabled = crossSpeciesCheckEnabled;
        if (skipSubPathwaysOf == null) {
            skipSubPathwaysOf = Collections.emptySet();
        }
        this.skipSubPathwaysOf = skipSubPathwaysOf;
        this.skipSubPathways = false;
    }

    public boolean isSkipOutsidePathways() {
        return this.skipOutsidePathways;
    }

    public void setSkipOutsidePathways(boolean skipOutsidePathways) {
        this.skipOutsidePathways = skipOutsidePathways;
    }

    public Set<String> getAllowedOrganisms() {
        return this.allowedOrganisms;
    }

    public void setAllowedOrganisms(Set<String> allowedOrganisms) {
        this.allowedOrganisms = allowedOrganisms;
    }

    public int getMinNumOfGenesPerEntry() {
        return this.minNumOfGenesPerEntry;
    }

    public void setMinNumOfGenesPerEntry(int minNumOfGenesPerEntry) {
        this.minNumOfGenesPerEntry = minNumOfGenesPerEntry;
    }

    public void writeToGSEA(Model model, OutputStream out) throws IOException {
        Collection<GSEAEntry> entries = this.convert(model);
        if (entries.size() > 0) {
            OutputStreamWriter writer = new OutputStreamWriter(out);
            for (GSEAEntry entry : entries) {
                if ((this.minNumOfGenesPerEntry > 1 || entry.getIdentifiers().isEmpty()) && entry.getIdentifiers().size() < this.minNumOfGenesPerEntry) continue;
                writer.write(entry.toString() + "\n");
            }
            ((Writer)writer).flush();
        }
    }

    public Collection<GSEAEntry> convert(Model model) {
        TreeSet<GSEAEntry> toReturn = new TreeSet<GSEAEntry>(new Comparator<GSEAEntry>(){

            @Override
            public int compare(GSEAEntry o1, GSEAEntry o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        Model l3Model = model.getLevel() == BioPAXLevel.L2 ? new LevelUpgrader().filter(model) : model;
        HashSet<SequenceEntityReference> sequenceEntityReferences = new HashSet<SequenceEntityReference>(l3Model.getObjects(SequenceEntityReference.class));
        Set<Pathway> pathways = l3Model.getObjects(Pathway.class);
        for (Pathway pathway2 : pathways) {
            String name;
            String string = name = pathway2.getDisplayName() == null ? pathway2.getStandardName() : pathway2.getDisplayName();
            if (name == null || name.isEmpty()) {
                name = pathway2.getUri();
            }
            Pathway currentPathway = pathway2;
            String currentPathwayName = name;
            final boolean ignoreSubPathways = !this.skipSubPathwaysOf.isEmpty() && this.shareSomeObjects(currentPathway.getDataSource(), this.skipSubPathwaysOf) || this.skipSubPathways;
            LOG.debug("Begin converting " + currentPathwayName + " pathway, uri=" + currentPathway.getUri());
            final HashSet<SequenceEntityReference> pathwaySers = new HashSet<SequenceEntityReference>();
            AbstractTraverser traverser = new AbstractTraverser(SimpleEditorMap.L3, new Filter[]{Fetcher.nextStepFilter, Fetcher.objectPropertiesOnlyFilter}){

                protected void visit(Object range, BioPAXElement domain, Model model, PropertyEditor editor) {
                    BioPAXElement bpe = (BioPAXElement)range;
                    if (bpe instanceof SequenceEntityReference) {
                        pathwaySers.add((SequenceEntityReference)bpe);
                    }
                    if (bpe instanceof Pathway) {
                        if (ignoreSubPathways) {
                            LOG.debug("Skipping sub-pathway: " + bpe.getUri());
                        } else {
                            this.traverse(bpe, model);
                        }
                    } else {
                        this.traverse(bpe, model);
                    }
                }
            };
            ((Traverser)traverser).traverse(currentPathway, null);
            if (pathwaySers.isEmpty()) continue;
            if (pathwaySers.size() > 199) {
                LOG.debug("Pathway " + currentPathwayName + " (" + currentPathway.getUri() + ") has lots of PRs: " + pathwaySers.size());
            }
            LOG.debug("- fetched PRs: " + pathwaySers.size() + "; now grouping by organism...");
            Map<String, Set<SequenceEntityReference>> orgToPrsMap = this.organismToProteinRefsMap(pathwaySers);
            String dataSource2 = this.getDataSource(currentPathway.getDataSource());
            LOG.debug("- creating GSEA/GMT entries...");
            Collection<GSEAEntry> entries = this.createGseaEntries(currentPathwayName, dataSource2, orgToPrsMap);
            if (!entries.isEmpty()) {
                toReturn.addAll(entries);
            }
            sequenceEntityReferences.removeAll(pathwaySers);
            LOG.debug("- collected " + entries.size() + "entries.");
        }
        if (!sequenceEntityReferences.isEmpty() && !this.skipOutsidePathways) {
            LOG.info("Creating entries for the rest of PRs (outside any pathway)...");
            Map<String, Set<SequenceEntityReference>> orgToPrsMap = this.organismToProteinRefsMap(sequenceEntityReferences);
            if (!orgToPrsMap.isEmpty()) {
                toReturn.addAll(this.createGseaEntries("Not pathway", this.getDataSource(l3Model.getObjects(Provenance.class)), orgToPrsMap));
            }
        }
        return toReturn;
    }

    private Collection<GSEAEntry> createGseaEntries(String name, String dataSource2, Map<String, Set<SequenceEntityReference>> orgToPrsMap) {
        ArrayList<GSEAEntry> toReturn = new ArrayList<GSEAEntry>();
        for (String org : orgToPrsMap.keySet()) {
            if (orgToPrsMap.get(org).size() <= 0) continue;
            LOG.debug("adding " + this.database + " IDs of " + org + " proteins (PRs) from '" + name + "', " + dataSource2 + " pathway...");
            GSEAEntry gseaEntry = new GSEAEntry(name, org, this.database, "datasource: " + dataSource2);
            this.processEntityReferences(orgToPrsMap.get(org), gseaEntry);
            toReturn.add(gseaEntry);
        }
        return toReturn;
    }

    private Map<String, Set<SequenceEntityReference>> organismToProteinRefsMap(Set<SequenceEntityReference> seqErs) {
        HashMap<String, Set<SequenceEntityReference>> map = new HashMap<String, Set<SequenceEntityReference>>();
        if (seqErs.isEmpty()) {
            throw new IllegalArgumentException("Empty set");
        }
        if (this.crossSpeciesCheckEnabled) {
            for (SequenceEntityReference r : seqErs) {
                String key = this.getOrganismKey(r.getOrganism());
                if (this.allowedOrganisms != null && !this.allowedOrganisms.isEmpty() && !this.allowedOrganisms.contains(key)) continue;
                HashSet<SequenceEntityReference> sers = (HashSet<SequenceEntityReference>)map.get(key);
                if (sers == null) {
                    sers = new HashSet<SequenceEntityReference>();
                    map.put(key, sers);
                }
                sers.add(r);
            }
        } else {
            HashSet<SequenceEntityReference> sers = new HashSet<SequenceEntityReference>();
            for (SequenceEntityReference r : seqErs) {
                String key = this.getOrganismKey(r.getOrganism());
                if (this.allowedOrganisms != null && !this.allowedOrganisms.isEmpty() && !this.allowedOrganisms.contains(key)) continue;
                sers.add(r);
            }
            map.put("", sers);
        }
        return map;
    }

    void processEntityReferences(Set<SequenceEntityReference> sers, GSEAEntry targetEntry) {
        for (SequenceEntityReference ser : sers) {
            if (this.crossSpeciesCheckEnabled && !targetEntry.taxID().equals(this.getOrganismKey(ser.getOrganism()))) continue;
            if (this.database != null && !this.database.isEmpty()) {
                String db = this.database.toLowerCase();
                String uri = ser.getUri();
                if (uri.startsWith("http://identifiers.org/") && uri.contains(db)) {
                    String accession = ser.getUri();
                    accession = accession.substring(accession.lastIndexOf("/") + 1);
                    targetEntry.getIdentifiers().add(accession);
                    continue;
                }
                int added = 0;
                for (Xref aXref : ser.getXref()) {
                    if (!(aXref instanceof UnificationXref) || aXref.getId() == null || aXref.getDb() == null || !aXref.getDb().toLowerCase().startsWith(db)) continue;
                    targetEntry.getIdentifiers().add(aXref.getId());
                    ++added;
                }
                if (added == 0) {
                    for (Xref aXref : ser.getXref()) {
                        if (!(aXref instanceof RelationshipXref) || aXref.getId() == null || aXref.getDb() == null || !aXref.getDb().toLowerCase().startsWith(db)) continue;
                        targetEntry.getIdentifiers().add(aXref.getId());
                        ++added;
                    }
                }
                if (added <= 12) continue;
                LOG.info("In GSEA entry: " + targetEntry.taxID() + " " + targetEntry.name() + ", sER " + ser.getUri() + " got " + added + " '" + db + "' identifiers...");
                continue;
            }
            targetEntry.getIdentifiers().add(ser.getUri());
        }
    }

    private String getDataSource(Set<Provenance> provenances) {
        if (provenances.isEmpty()) {
            return "N/A";
        }
        TreeSet<String> dsNames = new TreeSet<String>();
        for (Provenance provenance : provenances) {
            String name = provenance.getDisplayName();
            if (name == null) {
                name = provenance.getStandardName();
            }
            if (name == null && !provenance.getName().isEmpty()) {
                name = provenance.getName().iterator().next();
            }
            if (name == null || name.length() <= 0) continue;
            dsNames.add(name.toLowerCase());
        }
        return StringUtils.join(dsNames, ";");
    }

    private String getOrganismKey(BioSource org) {
        String key = "";
        if (org != null) {
            Set<Xref> xrefs = org.getXref();
            if (!xrefs.isEmpty()) {
                for (Xref xref2 : xrefs) {
                    if (!(xref2 instanceof UnificationXref) || !xref2.getDb().equalsIgnoreCase("taxonomy")) continue;
                    if (key.isEmpty()) {
                        key = xref2.getId();
                        continue;
                    }
                    LOG.warn("BioSource " + org + " has multiple taxonomy unification xrefs; I will use " + key);
                }
            }
            if (key.isEmpty()) {
                if (org.getStandardName() != null) {
                    key = org.getStandardName().toLowerCase();
                } else if (org.getDisplayName() != null) {
                    key = org.getDisplayName().toLowerCase();
                } else if (!org.getName().isEmpty()) {
                    key = org.getName().iterator().next().toLowerCase();
                }
            }
        }
        return key;
    }

    private boolean shareSomeObjects(Set<?> setA, Set<?> setB) {
        return !setA.isEmpty() && !setB.isEmpty() ? !CollectionUtils.intersection(setA, setB).isEmpty() : false;
    }
}

