/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.constraint;

import java.util.Collection;
import java.util.HashSet;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.ConversionDirectionType;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.constraint.ConstraintAdapter;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.biopax.paxtools.pattern.util.RelType;

public class RelatedControl
extends ConstraintAdapter {
    RelType peType;
    PathAccessor controlledOf = new PathAccessor("Conversion/controlledOf*:Control");

    public RelatedControl(RelType peType) {
        this(peType, null);
    }

    public RelatedControl(RelType peType, Blacklist blacklist) {
        super(3, blacklist);
        this.peType = peType;
    }

    @Override
    public boolean canGenerate() {
        return true;
    }

    @Override
    public Collection<BioPAXElement> generate(Match match, int ... ind) {
        PhysicalEntity pe = (PhysicalEntity)match.get(ind[0]);
        Conversion conv = (Conversion)match.get(ind[1]);
        if (!(this.peType == RelType.INPUT && this.getConvParticipants(conv, RelType.INPUT).contains(pe) || this.peType == RelType.OUTPUT && this.getConvParticipants(conv, RelType.OUTPUT).contains(pe))) {
            throw new IllegalArgumentException("peType = " + (Object)((Object)this.peType) + ", and related participant set does not contain this PE. Conv dir = " + (Object)((Object)this.getDirection(conv)) + " conv.id=" + conv.getUri() + " pe.id=" + pe.getUri());
        }
        boolean rightContains = conv.getRight().contains(pe);
        boolean leftContains = conv.getLeft().contains(pe);
        assert (rightContains || leftContains) : "PE is not a participant.";
        HashSet<BioPAXElement> result = new HashSet<BioPAXElement>();
        ConversionDirectionType avoidDir = leftContains && rightContains ? null : (this.peType == RelType.OUTPUT ? (leftContains ? ConversionDirectionType.LEFT_TO_RIGHT : ConversionDirectionType.RIGHT_TO_LEFT) : (rightContains ? ConversionDirectionType.LEFT_TO_RIGHT : ConversionDirectionType.RIGHT_TO_LEFT));
        for (Object o : this.controlledOf.getValueFromBean(conv)) {
            Control ctrl = (Control)o;
            ConversionDirectionType dir = this.getDirection(conv, ctrl);
            if (avoidDir != null && dir == avoidDir || this.blacklist != null && this.blacklist.isUbique(pe, conv, dir, this.peType)) continue;
            result.add(ctrl);
        }
        return result;
    }
}

