/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.miner;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.pattern.miner.ChemicalAffectsThroughControlMiner;
import org.biopax.paxtools.pattern.miner.CommonIDFetcher;
import org.biopax.paxtools.pattern.miner.IDFetcher;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.biopax.paxtools.pattern.miner.SIFInteraction;
import org.biopax.paxtools.pattern.miner.SIFSearcher;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.biopax.paxtools.pattern.util.RelType;

public class BlacklistGenerator2 {
    private Decider decider;
    final String MAPPING_FILE = "chem-name-mapping.txt";
    final String WHITELIST_FILE = "whitelist.txt";

    public BlacklistGenerator2(Decider decider) {
        this.decider = decider;
    }

    public BlacklistGenerator2() {
        this(new Decider(){

            @Override
            public boolean isUbique(int neighborSize, int upstrOnly, int dwstrOnly) {
                return neighborSize >= 50;
            }

            @Override
            public int getScore(int neighborSize, int upstrOnly, int dwstrOnly) {
                return neighborSize;
            }

            @Override
            public RelType getContext(int neighborSize, int upstrOnly, int dwstrOnly) {
                if (upstrOnly > 10 * dwstrOnly) {
                    return RelType.OUTPUT;
                }
                if (dwstrOnly > 10 * upstrOnly) {
                    return RelType.INPUT;
                }
                return null;
            }
        });
    }

    public Blacklist generateBlacklist(Model model) throws IOException {
        Map<String, String> nameMapping = this.readNameMapping();
        if (nameMapping == null) {
            this.generateNameMappingFileToCurate(model);
            throw new RuntimeException("Small molecule name mapping file not found. Generated a mapping file, but it needs manual curation before use.\nPlease go over some top portion of this file and delete invalid lines and any uncurated bottom part.\nAfter that, you can rerun this method.");
        }
        SIFSearcher searcher = new SIFSearcher((IDFetcher)new Fetcher(nameMapping), SIFEnum.USED_TO_PRODUCE);
        Set<SIFInteraction> sifs = searcher.searchSIF(model);
        HashMap upstrMap = new HashMap();
        HashMap dwstrMap = new HashMap();
        HashMap neighMap = new HashMap();
        for (SIFInteraction sif : sifs) {
            String source = sif.sourceID;
            String target = sif.targetID;
            if (!neighMap.containsKey(source)) {
                neighMap.put(source, new HashSet());
            }
            if (!neighMap.containsKey(target)) {
                neighMap.put(target, new HashSet());
            }
            if (!dwstrMap.containsKey(source)) {
                dwstrMap.put(source, new HashSet());
            }
            if (!dwstrMap.containsKey(target)) {
                dwstrMap.put(target, new HashSet());
            }
            if (!upstrMap.containsKey(source)) {
                upstrMap.put(source, new HashSet());
            }
            if (!upstrMap.containsKey(target)) {
                upstrMap.put(target, new HashSet());
            }
            ((Set)neighMap.get(source)).add(target);
            ((Set)neighMap.get(target)).add(source);
            ((Set)dwstrMap.get(source)).add(target);
            ((Set)upstrMap.get(target)).add(source);
        }
        for (String name : neighMap.keySet()) {
            if (!upstrMap.containsKey(name) || !dwstrMap.containsKey(name)) continue;
            Set upstr = (Set)upstrMap.get(name);
            Set dwstr = (Set)dwstrMap.get(name);
            HashSet temp = new HashSet(upstr);
            upstr.removeAll(dwstr);
            dwstr.removeAll(temp);
        }
        Set<String> white = this.readWhitelist();
        Blacklist blacklist = new Blacklist();
        Fetcher nameFetcher = new Fetcher(nameMapping);
        for (SmallMoleculeReference smr : model.getObjects(SmallMoleculeReference.class)) {
            int dwstrOnly;
            int upstrOnly;
            int neighSize;
            Set<String> names = nameFetcher.fetchID(smr);
            if (names.isEmpty()) continue;
            String name = names.iterator().next();
            if (white != null && white.contains(name) || !this.decider.isUbique(neighSize = neighMap.containsKey(name) ? ((Set)neighMap.get(name)).size() : 0, upstrOnly = upstrMap.containsKey(name) ? ((Set)upstrMap.get(name)).size() : 0, dwstrOnly = dwstrMap.containsKey(name) ? ((Set)dwstrMap.get(name)).size() : 0)) continue;
            blacklist.addEntry(smr.getUri(), this.decider.getScore(neighSize, upstrOnly, dwstrOnly), this.decider.getContext(neighSize, upstrOnly, dwstrOnly));
        }
        return blacklist;
    }

    private void writeTheGuideRankingToTuneTheDecider(Model model, Map<String, String> nameMapping, Map<String, Set<String>> upstrMap, Map<String, Set<String>> dwstrMap, final Map<String, Set<String>> neighMap) throws IOException {
        ArrayList<String> names = new ArrayList<String>(neighMap.keySet());
        Collections.sort(names, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return new Integer(((Set)neighMap.get(o2)).size()).compareTo(((Set)neighMap.get(o1)).size());
            }
        });
        SIFSearcher searcher2 = new SIFSearcher((IDFetcher)new Fetcher(nameMapping), new ChemicalAffectsThroughControlMiner());
        Set<SIFInteraction> sifs2 = searcher2.searchSIF(model);
        HashMap affectMap = new HashMap();
        for (SIFInteraction sif : sifs2) {
            String source = sif.sourceID;
            String target = sif.targetID;
            if (!affectMap.containsKey(source)) {
                affectMap.put(source, new HashSet());
            }
            ((Set)affectMap.get(source)).add(target);
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter("ubique-stats.txt"));
        for (String name : names) {
            writer.write(name + "\t" + neighMap.get(name).size() + "\t" + upstrMap.get(name).size() + "\t" + dwstrMap.get(name).size() + "\t|\t" + (affectMap.containsKey(name) ? ((Set)affectMap.get(name)).size() : 0) + "\n");
        }
        writer.close();
    }

    private void generateNameMappingFileToCurate(Model model) throws IOException {
        SIFSearcher searcher = new SIFSearcher((IDFetcher)new Fetcher(null), SIFEnum.USED_TO_PRODUCE);
        Set<SIFInteraction> sifs = searcher.searchSIF(model);
        final HashMap neighMap = new HashMap();
        for (SIFInteraction sif : sifs) {
            String source = sif.sourceID;
            String target = sif.targetID;
            if (!neighMap.containsKey(source)) {
                neighMap.put(source, new HashSet());
            }
            if (!neighMap.containsKey(target)) {
                neighMap.put(target, new HashSet());
            }
            ((Set)neighMap.get(source)).add(target);
            ((Set)neighMap.get(target)).add(source);
        }
        ArrayList names = new ArrayList(neighMap.keySet());
        Collections.sort(names, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return new Integer(((Set)neighMap.get(o2)).size()).compareTo(((Set)neighMap.get(o1)).size());
            }
        });
        Set<Set<String>> bag = this.collectNameSets(model);
        Map<String, Set<Set<String>>> nameToSets = this.getNameToSetsMap(bag);
        Map<Set<String>, Set<Set<String>>> intersectionMap = this.getIntersectionMap(bag);
        String dir = System.getProperty("java.io.tmpdir") + File.separator;
        BufferedWriter writer = new BufferedWriter(new FileWriter(dir + "chem-name-mapping.txt"));
        ArrayList<String> remaining = new ArrayList<String>();
        for (String name : names) {
            remaining.add(name.toLowerCase());
        }
        for (String name : names) {
            name = name.toLowerCase();
            remaining.remove(name);
            Map<String, Set<String>[]> mappings = this.getMappingsAndBasis(name, remaining, nameToSets, intersectionMap);
            for (String mapped : mappings.keySet()) {
                Set<String>[] s = mappings.get(mapped);
                writer.write(name + "\t" + mapped + "\t" + s[0] + "\t" + s[1] + "\t" + s[2] + "\n");
            }
        }
        writer.close();
        System.out.println("A small molecule name mapping file is generated (" + dir + "chem-name-mapping.txt" + "). Please curate the top portion of this file, delete invalid lines, copy the curated file into the working directory, and re-run this code.");
    }

    private Set<Set<String>> collectNameSets(Model model) {
        HashSet<Set<String>> bag = new HashSet<Set<String>>();
        for (SmallMoleculeReference smr : model.getObjects(SmallMoleculeReference.class)) {
            HashSet<String> set = new HashSet<String>();
            for (String name : smr.getName()) {
                set.add(name.toLowerCase());
            }
            for (SimplePhysicalEntity sm : smr.getEntityReferenceOf()) {
                for (String name : sm.getName()) {
                    set.add(name.toLowerCase());
                }
            }
            this.doSomeCleaning(set);
            this.enrichWithModifications(set);
            bag.add(set);
        }
        return bag;
    }

    private void doSomeCleaning(Set<String> set) {
        HashSet<String> rem = new HashSet<String>();
        for (String s : set) {
            if (!s.contains("pathway") && !s.contains("participant")) continue;
            rem.add(s);
        }
        set.removeAll(rem);
    }

    private void enrichWithModifications(Set<String> set) {
        for (String s : new HashSet<String>(set)) {
            if (s.endsWith("-)") || s.endsWith("+)")) {
                set.add(s.substring(0, s.lastIndexOf("(")).trim());
                continue;
            }
            if (!s.endsWith(" zwitterion")) continue;
            set.add(s.substring(0, s.lastIndexOf(" ")).trim());
        }
    }

    private Map<String, Set<Set<String>>> getNameToSetsMap(Set<Set<String>> bag) {
        HashMap<String, Set<Set<String>>> map = new HashMap<String, Set<Set<String>>>();
        for (Set<String> set : bag) {
            for (String name : set) {
                if (!map.containsKey(name)) {
                    map.put(name, new HashSet());
                }
                ((Set)map.get(name)).add(set);
            }
        }
        return map;
    }

    private Set<String> getCommon(Set<String> set1, Set<String> set2) {
        HashSet<String> comm = new HashSet<String>(set1);
        comm.retainAll(set2);
        return comm;
    }

    private List<String> getCommon(List<String> list1, Set<String> set2) {
        ArrayList<String> comm = new ArrayList<String>();
        for (String s : list1) {
            if (!set2.contains(s)) continue;
            comm.add(s);
        }
        return comm;
    }

    private Map<Set<String>, Set<Set<String>>> getIntersectionMap(Set<Set<String>> bag) {
        HashMap<Set<String>, Set<Set<String>>> map = new HashMap<Set<String>, Set<Set<String>>>();
        for (Set<String> set : bag) {
            for (Set<String> oth : bag) {
                if (set == oth || this.getCommon(set, oth).isEmpty()) continue;
                if (!map.containsKey(set)) {
                    map.put(set, new HashSet());
                }
                ((Set)map.get(set)).add(oth);
            }
        }
        return map;
    }

    private Map<String, Set<String>[]> getMappingsAndBasis(String name, List<String> consider, Map<String, Set<Set<String>>> nameToSets, Map<Set<String>, Set<Set<String>>> intersectionMap) {
        HashMap<String, Set<String>[]> map = new HashMap<String, Set<String>[]>();
        for (Set<String> set : nameToSets.get(name)) {
            if (!intersectionMap.containsKey(set)) continue;
            for (Set<String> other : intersectionMap.get(set)) {
                List<String> common = this.getCommon(consider, other);
                for (String target : common) {
                    map.put(target, new Set[]{this.getCommon(set, other), set, other});
                }
            }
        }
        return map;
    }

    private Map<String, String> readNameMapping() throws FileNotFoundException {
        if (!new File("chem-name-mapping.txt").exists()) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Scanner sc = new Scanner(new File("chem-name-mapping.txt"));
        while (sc.hasNextLine()) {
            String[] token = sc.nextLine().split("\t");
            map.put(token[1], token[0]);
        }
        return map;
    }

    private Set<String> readWhitelist() throws FileNotFoundException {
        if (!new File("whitelist.txt").exists()) {
            System.out.println("No whitelist file found (whitelist.txt). Not whitelisting anything.");
            return null;
        }
        HashSet<String> names = new HashSet<String>();
        Scanner sc = new Scanner(new File("whitelist.txt"));
        while (sc.hasNextLine()) {
            String name = sc.nextLine().split("\t")[0];
            names.add(name);
        }
        return names;
    }

    static interface Decider {
        public boolean isUbique(int var1, int var2, int var3);

        public int getScore(int var1, int var2, int var3);

        public RelType getContext(int var1, int var2, int var3);
    }

    class Fetcher
    extends CommonIDFetcher {
        Map<String, String> nameMap;

        public Fetcher(Map<String, String> nameMap) {
            this.nameMap = nameMap;
        }

        @Override
        public Set<String> fetchID(BioPAXElement ele) {
            if (ele instanceof SmallMoleculeReference) {
                SmallMoleculeReference smr = (SmallMoleculeReference)ele;
                String name = null;
                if (smr.getDisplayName() != null) {
                    name = smr.getDisplayName();
                } else if (smr.getStandardName() != null) {
                    name = smr.getStandardName();
                } else if (!smr.getName().isEmpty()) {
                    name = smr.getName().iterator().next();
                }
                if (name != null) {
                    name = name.toLowerCase();
                    if (this.nameMap != null && this.nameMap.containsKey(name)) {
                        name = this.nameMap.get(name);
                    }
                    return Collections.singleton(name);
                }
            }
            return super.fetchID(ele);
        }
    }
}

