/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.ivis.layout.Cluster;

public class ClusterManager {
    protected ArrayList clusters = new ArrayList();
    protected boolean polygonUsed = false;
    public static int idCounter = 1;

    public ArrayList<Cluster> getClusters() {
        return this.clusters;
    }

    public void setPolygonUsed(boolean polygonUsed) {
        this.polygonUsed = polygonUsed;
    }

    public ArrayList<Integer> getClusterIDs() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Cluster cluster : this.clusters) {
            if (cluster.getClusterID() <= 0) continue;
            result.add(cluster.getClusterID());
        }
        Collections.sort(result);
        return result;
    }

    public void createCluster(int clusterID, String clusterName) {
        Cluster cluster = new Cluster(this, clusterID, clusterName);
        this.clusters.add(cluster);
    }

    public void createCluster(String clusterName) {
        Cluster lCluster = new Cluster(this, clusterName);
        this.clusters.add(lCluster);
    }

    public void addCluster(Cluster cluster) {
        cluster.setClusterManager(this);
        this.clusters.add(cluster);
    }

    public void removeCluster(Cluster cluster) {
        cluster.delete();
    }

    public boolean isClusterIDUsed(int clusterID) {
        for (Cluster cluster : this.clusters) {
            if (cluster.getClusterID() != clusterID) continue;
            return true;
        }
        return false;
    }

    public Cluster getClusterByID(int clusterID) {
        for (Cluster cluster : this.clusters) {
            if (cluster.getClusterID() != clusterID) continue;
            return cluster;
        }
        return null;
    }

    public void clearClusters() {
        ArrayList<Integer> clusterIDs = new ArrayList<Integer>();
        Iterator iter = this.clusters.iterator();
        while (iter.hasNext()) {
            clusterIDs.add(((Cluster)iter.next()).getClusterID());
        }
        for (Integer id : clusterIDs) {
            this.getClusterByID(id).delete();
        }
    }
}

