/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.ivis.layout.Cluster;
import org.ivis.layout.LEdge;
import org.ivis.layout.LGraph;
import org.ivis.layout.LNode;
import org.ivis.layout.LayoutConstants;
import org.ivis.layout.LayoutOptionsPack;
import org.ivis.layout.cose.CoSEEdge;
import org.ivis.layout.cose.CoSELayout;
import org.ivis.layout.cose.CoSENode;

public class ClusterLayout
extends CoSELayout {
    public int graphMargin = LayoutConstants.DEFAULT_GRAPH_MARGIN;
    public static final int DEFAULT_CLUSTER_SEPARATION = 40;

    @Override
    public void initParameters() {
        super.initParameters();
        if (!this.isSubLayout) {
            LayoutOptionsPack.Cluster layoutOptionsPack = LayoutOptionsPack.getInstance().getCluster();
            this.idealEdgeLength = layoutOptionsPack.idealEdgeLength < 10 ? 50.0 : (double)layoutOptionsPack.idealEdgeLength;
            this.graphMargin = (int)ClusterLayout.transform(layoutOptionsPack.clusterSeperation, 40.0);
            this.compoundGravityConstant = ClusterLayout.transform(layoutOptionsPack.clusterGravityStrength, 6.0);
        }
        this.springConstant = 0.45;
        this.repulsionConstant = 4500.0;
        this.gravityConstant = 0.4;
    }

    private String getRegionName(LNode node) {
        String result = "";
        ArrayList<Integer> clusterIDs = new ArrayList<Integer>();
        List clusters = node.getClusters();
        for (Cluster cluster : clusters) {
            if (clusterIDs.contains(cluster.getClusterID())) continue;
            clusterIDs.add(cluster.getClusterID());
        }
        Collections.sort(clusterIDs);
        result = result + clusterIDs.get(0);
        for (int i = 1; i < clusterIDs.size(); ++i) {
            result = result + "," + clusterIDs.get(i);
        }
        return result;
    }

    @Override
    protected void calcIdealEdgeLengths() {
        super.calcIdealEdgeLengths();
        for (Object obj : this.graphManager.getAllEdges()) {
            CoSEEdge edge = (CoSEEdge)obj;
            if (edge.getTarget().getChild() == null || edge.getSource().getChild() == null) continue;
            edge.idealLength /= 4.0;
        }
    }

    private boolean isSubSequence(String key1, String key2) {
        block7: {
            int i;
            int size2;
            int size1;
            ArrayList<Integer> seq2;
            ArrayList<Integer> seq1;
            block6: {
                seq1 = new ArrayList<Integer>();
                seq2 = new ArrayList<Integer>();
                String[] ids1 = key1.split(",");
                String[] ids2 = key2.split(",");
                for (String idString : ids1) {
                    if (idString.equals("")) continue;
                    seq1.add(Integer.parseInt(idString));
                }
                for (String idString : ids2) {
                    if (idString.equals("")) continue;
                    seq2.add(Integer.parseInt(idString));
                }
                size1 = seq1.size();
                if (size1 >= (size2 = seq2.size())) break block6;
                for (i = 0; i < size2 - size1 + 1; ++i) {
                    boolean found = false;
                    for (int j = i; j < i + size1; ++j) {
                        if (((Integer)seq1.get(j - i)).equals(seq2.get(j))) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return true;
                }
                break block7;
            }
            if (size1 <= size2) break block7;
            for (i = 0; i < size1 - size2 + 1; ++i) {
                boolean found = false;
                for (int j = i; j < i + size2; ++j) {
                    if (((Integer)seq2.get(j - i)).equals(seq1.get(j))) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean layout() {
        LNode clusterNode;
        HashMap<Object, LNode> clusterMap = new HashMap<Object, LNode>();
        ArrayList edgesToAdd = new ArrayList();
        LGraph rootGraph = this.getGraphManager().getRoot();
        ArrayList<LNode> nodeList = new ArrayList<LNode>();
        for (Object obj : rootGraph.getNodes()) {
            LNode node = (LNode)obj;
            nodeList.add(node);
        }
        for (LNode node : nodeList) {
            if (node.getClusters().isEmpty()) continue;
            String regionName = this.getRegionName(node);
            clusterNode = (LNode)clusterMap.get(regionName);
            if (clusterNode == null) {
                clusterNode = this.newNode(node.vGraphObject);
                LGraph childGraph = this.newGraph(null);
                childGraph.setMargin(this.graphMargin);
                this.getGraphManager().add(childGraph, clusterNode);
                clusterMap.put(regionName, clusterNode);
                rootGraph.add(clusterNode);
            }
            edgesToAdd.addAll(node.getEdges());
            rootGraph.remove(node);
            clusterNode.getChild().add(node);
        }
        for (String key1 : clusterMap.keySet()) {
            for (String key2 : clusterMap.keySet()) {
                if (!this.isSubSequence(key1, key2)) continue;
                CoSENode source = (CoSENode)clusterMap.get(key1);
                CoSENode destination = (CoSENode)clusterMap.get(key2);
                CoSEEdge newEdge = new CoSEEdge(source, destination, null);
                this.graphManager.add(newEdge, source, destination);
            }
        }
        for (LEdge edge : edgesToAdd) {
            this.graphManager.add(edge, edge.getSource(), edge.getTarget());
        }
        this.graphManager.resetAllEdges();
        edgesToAdd.clear();
        boolean result = super.layout();
        for (Cluster cluster : this.graphManager.getClusterManager().getClusters()) {
            cluster.calculatePolygon();
        }
        for (String key : clusterMap.keySet()) {
            clusterNode = (LNode)clusterMap.get(key);
            nodeList.clear();
            for (Object obj : clusterNode.getChild().getNodes()) {
                LNode node = (LNode)obj;
                nodeList.add(node);
            }
            for (LNode node : nodeList) {
                edgesToAdd.addAll(node.getEdges());
                clusterNode.getChild().remove(node);
                rootGraph.add(node);
            }
            rootGraph.remove(clusterNode);
        }
        for (LEdge edge : edgesToAdd) {
            this.graphManager.add(edge, edge.getSource(), edge.getTarget());
        }
        this.graphManager.resetAllEdges();
        return result;
    }
}

