/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.sbgn;

import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.bind.JAXBException;
import org.ivis.io.xml.XmlIOHandler;
import org.ivis.layout.Layout;
import org.ivis.layout.cose.CoSEEdge;
import org.ivis.layout.cose.CoSELayout;
import org.ivis.layout.cose.CoSENode;
import org.ivis.layout.sbgn.SbgnPDConstants;
import org.ivis.layout.sbgn.SbgnPDEdge;
import org.ivis.layout.sbgn.SbgnPDLayout;
import org.ivis.layout.sbgn.SbgnPDNode;
import org.ivis.layout.sbgn.SbgnProcessNode;
import org.ivis.util.IGeometry;
import org.ivis.util.PointD;
import org.ivis.util.RectangleD;

public class TestApplet
extends Applet
implements MouseListener {
    public final int RUN_COUNT = 1;
    private ArrayList<SbgnPDNode> sbgnNodes;
    private ArrayList<SbgnPDEdge> sbgnEdges;
    private ArrayList<CoSENode> cosenodes;
    private ArrayList<CoSEEdge> coseedges;
    private ArrayList<CoSENode> prodNodes;
    private ArrayList<CoSENode> consNodes;
    private ArrayList<CoSENode> effNodes;
    private ArrayList<String> fileList;
    private ArrayList<SbgnProcessNode.Orientation> orientationList;
    private Button layoutButton;
    private Button exitButton;
    private double zoomLevel = 1.3;
    private double properlyOrientedCoSEEdgeCnt;
    double totalEdgeCount = 0.0;
    Object myLayout;
    Graphics g2;

    @Override
    public void init() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(dim.width, dim.height);
        this.setBackground(Color.WHITE);
        this.g2 = this.getGraphics();
        this.sbgnNodes = new ArrayList();
        this.sbgnEdges = new ArrayList();
        this.cosenodes = new ArrayList();
        this.coseedges = new ArrayList();
        this.prodNodes = new ArrayList();
        this.consNodes = new ArrayList();
        this.effNodes = new ArrayList();
        this.fileList = new ArrayList();
        this.orientationList = new ArrayList();
        this.orientationList.add(SbgnProcessNode.Orientation.LEFT_TO_RIGHT);
        this.orientationList.add(SbgnProcessNode.Orientation.RIGHT_TO_LEFT);
        this.orientationList.add(SbgnProcessNode.Orientation.TOP_TO_BOTTOM);
        this.orientationList.add(SbgnProcessNode.Orientation.BOTTOM_TO_TOP);
        this.layoutButton = new Button("sbgn");
        this.exitButton = new Button("exit");
        this.layoutButton.addMouseListener(this);
        this.exitButton.addMouseListener(this);
        this.add(this.layoutButton);
        this.add(this.exitButton);
        this.loadFiles();
    }

    private void loadFiles() {
        this.fileList.add("../graphs/sbgn/test2/glycolysis.xml");
    }

    @Override
    public void paint(Graphics g2) {
        Graphics2D g = (Graphics2D)g2;
        Dimension d = this.getSize();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, (int)d.getWidth(), (int)d.getHeight());
        if (this.sbgnNodes.size() <= 0) {
            g.drawString("Click on a button", 2 * this.getWidth() / 5, (int)((double)this.getHeight() / this.zoomLevel));
        }
        if (this.myLayout instanceof SbgnPDLayout) {
            this.drawSBGNNodes(g);
            this.drawSBGNEdges(g);
        } else if (this.myLayout instanceof CoSELayout) {
            this.drawCoseNodes(g);
            this.drawCoseEdges(g);
        }
    }

    private void drawCoseNodes(Graphics2D g) {
        for (int i = 0; i < this.cosenodes.size(); ++i) {
            CoSENode node = this.cosenodes.get(i);
            g.setColor(Color.DARK_GRAY);
            g.drawRect((int)(node.getLeft() / this.zoomLevel), (int)(node.getTop() / this.zoomLevel), (int)(node.getWidth() / this.zoomLevel), (int)(node.getHeight() / this.zoomLevel));
        }
    }

    private void drawCoseEdges(Graphics2D g) {
        for (int i = 0; i < this.coseedges.size(); ++i) {
            if (this.coseedges.get((int)i).type.equals("production")) {
                g.setColor(Color.RED);
            } else if (this.coseedges.get((int)i).type.equals("consumption")) {
                g.setColor(Color.GREEN);
            } else if (this.isEffector(this.coseedges.get(i))) {
                g.setColor(Color.ORANGE);
            }
            double[] clipPointCoordinates = new double[4];
            RectangleD rectTarget = this.coseedges.get(i).getTarget().getRect();
            RectangleD rectSource = this.coseedges.get(i).getSource().getRect();
            IGeometry.getIntersection(rectTarget, rectSource, clipPointCoordinates);
            g.drawLine((int)(clipPointCoordinates[0] / this.zoomLevel), (int)(clipPointCoordinates[1] / this.zoomLevel), (int)(clipPointCoordinates[2] / this.zoomLevel), (int)(clipPointCoordinates[3] / this.zoomLevel));
            g.setColor(Color.BLACK);
            g.setFont(new Font("TimesRoman", 0, 10));
        }
    }

    private void drawSBGNNodes(Graphics2D g) {
        for (int i = 0; i < this.sbgnNodes.size(); ++i) {
            SbgnPDNode node = this.sbgnNodes.get(i);
            if (node.type != null) {
                if (node.type.equals("complex") && node.visited) {
                    g.setColor(Color.ORANGE);
                } else if (node.type.equals("complex") && !node.visited) {
                    g.setColor(Color.BLUE);
                } else if (node.type.equals("input_port")) {
                    g.setColor(Color.GREEN);
                } else if (node.type.equals("output_port")) {
                    g.setColor(Color.RED);
                } else if (node.isDummyCompound) {
                    g.setColor(Color.MAGENTA);
                } else if (node.getChild() != null) {
                    g.setColor(Color.PINK);
                } else {
                    g.setColor(Color.DARK_GRAY);
                }
            }
            g.drawRect((int)(node.getLeft() / this.zoomLevel), (int)(node.getTop() / this.zoomLevel), (int)(node.getWidth() / this.zoomLevel), (int)(node.getHeight() / this.zoomLevel));
            g.setColor(Color.BLACK);
        }
    }

    private void drawSBGNEdges(Graphics2D g) {
        for (int i = 0; i < this.sbgnEdges.size(); ++i) {
            if (this.sbgnEdges.get((int)i).type.equals("production")) {
                if (this.sbgnEdges.get((int)i).isProperlyOriented) {
                    g.setColor(Color.LIGHT_GRAY);
                } else {
                    g.setColor(Color.RED);
                }
            } else if (this.sbgnEdges.get((int)i).type.equals("consumption")) {
                if (this.sbgnEdges.get((int)i).isProperlyOriented) {
                    g.setColor(Color.LIGHT_GRAY);
                } else {
                    g.setColor(Color.GREEN);
                }
            } else if (this.sbgnEdges.get(i).isRigidEdge()) {
                g.setColor(Color.BLUE);
            } else if (this.sbgnEdges.get(i).isEffector()) {
                if (this.sbgnEdges.get((int)i).isProperlyOriented) {
                    g.setColor(Color.LIGHT_GRAY);
                } else {
                    g.setColor(Color.MAGENTA);
                }
            } else {
                g.setColor(Color.BLACK);
            }
            double[] clipPointCoordinates = new double[4];
            RectangleD rectTarget = this.sbgnEdges.get(i).getTarget().getRect();
            RectangleD rectSource = this.sbgnEdges.get(i).getSource().getRect();
            IGeometry.getIntersection(rectTarget, rectSource, clipPointCoordinates);
            g.drawLine((int)(clipPointCoordinates[0] / this.zoomLevel), (int)(clipPointCoordinates[1] / this.zoomLevel), (int)(clipPointCoordinates[2] / this.zoomLevel), (int)(clipPointCoordinates[3] / this.zoomLevel));
            g.setColor(Color.BLACK);
            g.setFont(new Font("TimesRoman", 0, 10));
            int x = (int)((clipPointCoordinates[0] / this.zoomLevel + clipPointCoordinates[2] / this.zoomLevel) / 2.0);
            int n = (int)((clipPointCoordinates[1] / this.zoomLevel + clipPointCoordinates[3] / this.zoomLevel) / 2.0);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        try {
            if (e.getSource() == this.layoutButton) {
                FileWriter writer = new FileWriter("results.csv");
                writer.append("SBGNGraphSize,effectorCnt,processNodeCnt,totalEdgeCntToOrient,SBGNEffResult,SBGNEnhancedResult,SBGNTime,CoSEGraphSize,CoSEAngleResult,CoSEEdgeResult,CoSETime\n");
                this.performSbgnPDLayout(writer);
                writer.flush();
                writer.close();
            } else if (e.getSource() == this.exitButton) {
                System.exit(0);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void performSbgnPDLayout(Writer writer) {
        int i;
        for (int j = 0; j < this.fileList.size(); ++j) {
            try {
                for (int i2 = 0; i2 < 1; ++i2) {
                    this.myLayout = new SbgnPDLayout();
                    XmlIOHandler xih = new XmlIOHandler((SbgnPDLayout)this.myLayout);
                    Layout l = xih.test(this.fileList.get(j));
                    writer.append("" + (((SbgnPDLayout)this.myLayout).getAllNodes().length + ((SbgnPDLayout)this.myLayout).getAllEdges().length));
                    writer.append(',');
                    writer.append("" + ((SbgnPDLayout)this.myLayout).totalEffCount);
                    writer.append(',');
                    writer.append("" + ((SbgnPDLayout)this.myLayout).processNodeList.size());
                    writer.append(',');
                    writer.append("" + ((SbgnPDLayout)this.myLayout).totalEdgeCountToBeOriented);
                    writer.append(',');
                    writer.append("" + ((SbgnPDLayout)this.myLayout).successRatio);
                    writer.append(',');
                    writer.append("" + ((SbgnPDLayout)this.myLayout).enhancedRatio);
                    writer.append(',');
                    writer.append("" + ((SbgnPDLayout)this.myLayout).executionTime);
                    writer.append('\n');
                    writer.flush();
                }
                continue;
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        Object[] allNodes = ((SbgnPDLayout)this.myLayout).getAllNodes();
        Object[] allEdges = ((SbgnPDLayout)this.myLayout).getAllEdges();
        this.sbgnNodes.clear();
        this.sbgnEdges.clear();
        for (i = 0; i < allNodes.length; ++i) {
            this.sbgnNodes.add((SbgnPDNode)allNodes[i]);
        }
        for (i = 0; i < allEdges.length; ++i) {
            this.sbgnEdges.add((SbgnPDEdge)allEdges[i]);
        }
        this.repaint();
    }

    private void performCoSELayout(Writer writer, int method) {
        for (int j = 0; j < this.fileList.size(); ++j) {
            try {
                for (int i = 0; i < 1; ++i) {
                    int k;
                    this.myLayout = new CoSELayout();
                    XmlIOHandler xih = new XmlIOHandler((CoSELayout)this.myLayout);
                    Layout l = xih.test(this.fileList.get(j));
                    Object[] allNodes = ((CoSELayout)this.myLayout).getAllNodes();
                    Object[] allEdges = ((CoSELayout)this.myLayout).getAllEdges();
                    this.cosenodes.clear();
                    this.coseedges.clear();
                    for (k = 0; k < allNodes.length; ++k) {
                        this.cosenodes.add((CoSENode)allNodes[k]);
                    }
                    for (k = 0; k < allEdges.length; ++k) {
                        this.coseedges.add((CoSEEdge)allEdges[k]);
                    }
                    writer.append("" + (this.cosenodes.size() + this.coseedges.size()));
                    writer.append(",");
                    this.calcPropOrientedEdgesByAngleAmount();
                    writer.append("" + this.properlyOrientedCoSEEdgeCnt / this.totalEdgeCount);
                    writer.append(",");
                    this.calcPropOrientedCoSEEdgesByNumber();
                    writer.append("" + this.properlyOrientedCoSEEdgeCnt / this.totalEdgeCount);
                    writer.append(",");
                    writer.append("" + ((CoSELayout)this.myLayout).executionTime);
                    writer.append("\n");
                }
                continue;
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        this.repaint();
    }

    private void testParameters() throws Exception {
        SbgnPDLayout sLayout = null;
        int[] appDistance = new int[]{10, 20, 30, 50, 70};
        double[] rot90 = new double[]{40.0, 50.0, 55.0, 60.0, 65.0, 70.0, 90.0};
        int[] approxPeriod = new int[]{59, 101, 211, 307};
        int[] iterCount = new int[]{2, 5, 10, 20, 50};
        double avgResult = 0.0;
        long avgExecTime = 0L;
        double avgPhase2IterCnt = 0.0;
        FileWriter writer = new FileWriter("parameterTest2.csv");
        writer.append("appDistance,rot90,iterCount,apprxPeriod,phase2IterCnt,nodeCnt,edgeCnt,avgResult,avgExecTime\n");
        for (int i = 0; i < appDistance.length; ++i) {
            SbgnPDConstants.APPROXIMATION_DISTANCE = appDistance[i];
            System.out.println("app dist: " + appDistance[i]);
            for (int j = 0; j < iterCount.length; ++j) {
                SbgnPDConstants.ROTATIONAL_FORCE_ITERATION_COUNT = iterCount[j];
                for (int k = 0; k < rot90.length; ++k) {
                    SbgnPDConstants.ROTATION_90_DEGREE = rot90[k];
                    for (int u = 0; u < approxPeriod.length; ++u) {
                        SbgnPDConstants.APPROXIMATION_PERIOD = approxPeriod[u];
                        System.out.println("running for: " + i + " " + j + " " + k + " " + u + " ");
                        avgResult = 0.0;
                        avgExecTime = 0L;
                        avgPhase2IterCnt = 0.0;
                        for (int fileIndex = 0; fileIndex < this.fileList.size(); ++fileIndex) {
                            System.out.println(this.fileList.get(fileIndex));
                            for (int w = 0; w < 1; ++w) {
                                System.out.print(w + " ");
                                this.myLayout = new SbgnPDLayout();
                                try {
                                    XmlIOHandler xih = new XmlIOHandler((SbgnPDLayout)this.myLayout);
                                    Layout x = xih.test(this.fileList.get(fileIndex));
                                    sLayout = (SbgnPDLayout)x;
                                    avgExecTime += sLayout.executionTime;
                                    avgPhase2IterCnt += (double)sLayout.phase2IterationCount;
                                    continue;
                                }
                                catch (JAXBException e) {
                                    e.printStackTrace();
                                }
                            }
                            System.out.println();
                        }
                        writer.append("" + SbgnPDConstants.APPROXIMATION_DISTANCE);
                        writer.append(',');
                        writer.append("" + SbgnPDConstants.ROTATION_90_DEGREE);
                        writer.append(',');
                        writer.append("" + SbgnPDConstants.ROTATIONAL_FORCE_ITERATION_COUNT);
                        writer.append(',');
                        writer.append("" + SbgnPDConstants.APPROXIMATION_PERIOD);
                        writer.append(',');
                        writer.append("" + avgPhase2IterCnt / (double)(1 * this.fileList.size()));
                        writer.append(',');
                        writer.append("" + sLayout.getAllNodes().length);
                        writer.append(',');
                        writer.append("" + sLayout.getAllEdges().length);
                        writer.append(',');
                        writer.append("" + avgResult / (double)(1 * this.fileList.size()));
                        writer.append(',');
                        writer.append("" + avgExecTime / (long)(1 * this.fileList.size()));
                        writer.append('\n');
                        writer.flush();
                    }
                }
            }
        }
        writer.close();
    }

    private double calculateEffectorAngle(SbgnProcessNode.Orientation orient, PointD centerPt, CoSENode eff) {
        double idealEdgeLength = ((CoSELayout)this.myLayout).idealEdgeLength;
        PointD targetPnt = new PointD();
        PointD centerPnt = centerPt;
        if (orient.equals((Object)SbgnProcessNode.Orientation.LEFT_TO_RIGHT) || orient.equals((Object)SbgnProcessNode.Orientation.RIGHT_TO_LEFT)) {
            targetPnt.x = centerPnt.x;
            targetPnt.y = eff.getCenterY() > centerPnt.y ? centerPnt.y + idealEdgeLength : centerPnt.y - idealEdgeLength;
        } else if (orient.equals((Object)SbgnProcessNode.Orientation.BOTTOM_TO_TOP) || orient.equals((Object)SbgnProcessNode.Orientation.TOP_TO_BOTTOM)) {
            targetPnt.y = centerPnt.y;
            targetPnt.x = eff.getCenterX() > centerPnt.x ? centerPnt.x + idealEdgeLength : centerPnt.x - idealEdgeLength;
        }
        double angle = IGeometry.calculateAngle(targetPnt, centerPnt, eff.getCenter());
        return angle;
    }

    private PointD findPortLocation(boolean isInputPort, PointD centerPoint, SbgnProcessNode.Orientation orientation) {
        if (orientation.equals((Object)SbgnProcessNode.Orientation.LEFT_TO_RIGHT)) {
            if (isInputPort) {
                return new PointD(centerPoint.x - 10.0, centerPoint.y);
            }
            return new PointD(centerPoint.x + 10.0, centerPoint.y);
        }
        if (orientation.equals((Object)SbgnProcessNode.Orientation.RIGHT_TO_LEFT)) {
            if (isInputPort) {
                return new PointD(centerPoint.x + 10.0, centerPoint.y);
            }
            return new PointD(centerPoint.x - 10.0, centerPoint.y);
        }
        if (orientation.equals((Object)SbgnProcessNode.Orientation.TOP_TO_BOTTOM)) {
            if (isInputPort) {
                return new PointD(centerPoint.x, centerPoint.y - 10.0);
            }
            return new PointD(centerPoint.x, centerPoint.y + 10.0);
        }
        if (orientation.equals((Object)SbgnProcessNode.Orientation.BOTTOM_TO_TOP)) {
            if (isInputPort) {
                return new PointD(centerPoint.x, centerPoint.y + 10.0);
            }
            return new PointD(centerPoint.x, centerPoint.y - 10.0);
        }
        return null;
    }

    private PointD findPortTargetPoint(boolean isInputPort, SbgnProcessNode.Orientation orientation, PointD inputPort, PointD outputPort) {
        double idealEdgeLength = ((CoSELayout)this.myLayout).idealEdgeLength;
        if (orientation.equals((Object)SbgnProcessNode.Orientation.LEFT_TO_RIGHT)) {
            if (isInputPort) {
                return new PointD(inputPort.x - idealEdgeLength, inputPort.y);
            }
            return new PointD(outputPort.x + idealEdgeLength, outputPort.y);
        }
        if (orientation.equals((Object)SbgnProcessNode.Orientation.RIGHT_TO_LEFT)) {
            if (isInputPort) {
                return new PointD(inputPort.x + idealEdgeLength, inputPort.y);
            }
            return new PointD(outputPort.x - idealEdgeLength, outputPort.y);
        }
        if (orientation.equals((Object)SbgnProcessNode.Orientation.TOP_TO_BOTTOM)) {
            if (isInputPort) {
                return new PointD(inputPort.x, inputPort.y - idealEdgeLength);
            }
            return new PointD(outputPort.x, outputPort.y + idealEdgeLength);
        }
        if (orientation.equals((Object)SbgnProcessNode.Orientation.BOTTOM_TO_TOP)) {
            if (isInputPort) {
                return new PointD(inputPort.x, inputPort.y + idealEdgeLength);
            }
            return new PointD(outputPort.x, outputPort.y - idealEdgeLength);
        }
        return null;
    }

    private void calcPropOrientedEdgesByAngleAmount() {
        this.properlyOrientedCoSEEdgeCnt = 0.0;
        this.totalEdgeCount = 0.0;
        PointD inputPort = new PointD();
        PointD outputPort = new PointD();
        PointD inputPortTarget = new PointD();
        PointD outputPortTarget = new PointD();
        double bestResult = Double.MIN_VALUE;
        double minAngleSum = Double.MAX_VALUE;
        double angleSum = 0.0;
        double angle = 0.0;
        double appropriateEdgeCnt = 0.0;
        double approprEffectorCount = 0.0;
        double notAppropriateEffCnt = 0.0;
        double notAppropriateEdgeCnt = 0.0;
        PointD centerPointD = new PointD();
        for (CoSENode node : this.cosenodes) {
            int i;
            if (!node.type.equals("process")) continue;
            centerPointD = node.getCenter();
            this.prodNodes.clear();
            this.consNodes.clear();
            this.effNodes.clear();
            for (Object edgeObj : node.getEdges()) {
                if (((CoSEEdge)edgeObj).type.equals("production")) {
                    this.prodNodes.add((CoSENode)((CoSEEdge)edgeObj).getTarget());
                    continue;
                }
                if (((CoSEEdge)edgeObj).type.equals("consumption")) {
                    this.consNodes.add((CoSENode)((CoSEEdge)edgeObj).getSource());
                    continue;
                }
                if (!this.isEffector((CoSEEdge)edgeObj)) continue;
                this.effNodes.add((CoSENode)((CoSEEdge)edgeObj).getSource());
            }
            bestResult = Double.MIN_VALUE;
            double bestEffCnt = Double.MIN_VALUE;
            minAngleSum = Double.MAX_VALUE;
            ArrayList<Boolean> rememberPropList = new ArrayList<Boolean>();
            ArrayList bestPropList = new ArrayList();
            for (SbgnProcessNode.Orientation orient : this.orientationList) {
                appropriateEdgeCnt = 0.0;
                notAppropriateEdgeCnt = 0.0;
                approprEffectorCount = 0.0;
                notAppropriateEffCnt = 0.0;
                angleSum = 0.0;
                angle = 0.0;
                inputPort = this.findPortLocation(true, centerPointD, orient);
                outputPort = this.findPortLocation(false, centerPointD, orient);
                inputPortTarget = this.findPortTargetPoint(true, orient, inputPort, outputPort);
                outputPortTarget = this.findPortTargetPoint(false, orient, inputPort, outputPort);
                rememberPropList = new ArrayList();
                for (CoSENode node2 : this.consNodes) {
                    angle = IGeometry.calculateAngle(inputPortTarget, inputPort, node2.getCenter());
                    angleSum += angle;
                    if (angle <= 100.0) {
                        appropriateEdgeCnt += 1.0;
                        rememberPropList.add(true);
                        continue;
                    }
                    notAppropriateEdgeCnt += 1.0;
                    rememberPropList.add(false);
                }
                for (CoSENode node2 : this.prodNodes) {
                    angle = IGeometry.calculateAngle(outputPortTarget, outputPort, node2.getCenter());
                    angleSum += angle;
                    if (angle <= 100.0) {
                        appropriateEdgeCnt += 1.0;
                        rememberPropList.add(true);
                        continue;
                    }
                    notAppropriateEdgeCnt += 1.0;
                    rememberPropList.add(false);
                }
                for (CoSENode eff : this.effNodes) {
                    angle = this.calculateEffectorAngle(orient, centerPointD, eff);
                    angleSum += angle;
                    if (angle <= 45.0) {
                        approprEffectorCount += 1.0;
                        rememberPropList.add(true);
                        continue;
                    }
                    notAppropriateEffCnt += 1.0;
                    rememberPropList.add(false);
                }
                if (!(angleSum < minAngleSum)) continue;
                minAngleSum = angleSum;
                bestResult = appropriateEdgeCnt;
                bestEffCnt = approprEffectorCount;
                bestPropList = rememberPropList;
                node.orient = orient;
                node.OKCount = bestResult;
            }
            for (i = 0; i < this.consNodes.size(); ++i) {
                this.consNodes.get((int)i).isOrientationProper = (Boolean)bestPropList.get(i);
            }
            for (i = 0; i < this.prodNodes.size(); ++i) {
                this.prodNodes.get((int)i).isOrientationProper = (Boolean)bestPropList.get(i + this.consNodes.size());
            }
            for (i = 0; i < this.effNodes.size(); ++i) {
                this.effNodes.get((int)i).isOrientationProper = (Boolean)bestPropList.get(i + (this.consNodes.size() + this.prodNodes.size()));
            }
            this.properlyOrientedCoSEEdgeCnt += bestResult + bestEffCnt;
            this.totalEdgeCount += appropriateEdgeCnt + notAppropriateEdgeCnt + approprEffectorCount + notAppropriateEffCnt;
        }
    }

    private void calcPropOrientedCoSEEdgesByNumber() {
        this.properlyOrientedCoSEEdgeCnt = 0.0;
        this.totalEdgeCount = 0.0;
        PointD inputPort = new PointD();
        PointD outputPort = new PointD();
        PointD inputPortTarget = new PointD();
        PointD outputPortTarget = new PointD();
        double bestResult = Double.MIN_VALUE;
        double appropriateEdgeCnt = 0.0;
        double approprEffectorCount = 0.0;
        double notAppropriateEffCnt = 0.0;
        double notAppropriateEdgeCnt = 0.0;
        PointD centerPointD = new PointD();
        for (CoSENode node : this.cosenodes) {
            int i;
            if (!node.type.equals("process")) continue;
            centerPointD = node.getCenter();
            this.prodNodes.clear();
            this.consNodes.clear();
            this.effNodes.clear();
            for (Object edgeObj : node.getEdges()) {
                if (((CoSEEdge)edgeObj).type.equals("production")) {
                    this.prodNodes.add((CoSENode)((CoSEEdge)edgeObj).getTarget());
                    continue;
                }
                if (((CoSEEdge)edgeObj).type.equals("consumption")) {
                    this.consNodes.add((CoSENode)((CoSEEdge)edgeObj).getSource());
                    continue;
                }
                if (!this.isEffector((CoSEEdge)edgeObj)) continue;
                this.effNodes.add((CoSENode)((CoSEEdge)edgeObj).getSource());
            }
            bestResult = Double.MIN_VALUE;
            double bestEffCnt = Double.MIN_VALUE;
            ArrayList<Boolean> rememberPropList = new ArrayList<Boolean>();
            ArrayList bestPropList = new ArrayList();
            for (SbgnProcessNode.Orientation orient : this.orientationList) {
                appropriateEdgeCnt = 0.0;
                notAppropriateEdgeCnt = 0.0;
                approprEffectorCount = 0.0;
                notAppropriateEffCnt = 0.0;
                inputPort = this.findPortLocation(true, centerPointD, orient);
                outputPort = this.findPortLocation(false, centerPointD, orient);
                inputPortTarget = this.findPortTargetPoint(true, orient, inputPort, outputPort);
                outputPortTarget = this.findPortTargetPoint(false, orient, inputPort, outputPort);
                rememberPropList = new ArrayList();
                for (CoSENode node2 : this.consNodes) {
                    if (IGeometry.calculateAngle(inputPortTarget, inputPort, node2.getCenter()) <= 100.0) {
                        appropriateEdgeCnt += 1.0;
                        rememberPropList.add(true);
                        continue;
                    }
                    notAppropriateEdgeCnt += 1.0;
                    rememberPropList.add(false);
                }
                for (CoSENode node2 : this.prodNodes) {
                    if (IGeometry.calculateAngle(outputPortTarget, outputPort, node2.getCenter()) <= 100.0) {
                        appropriateEdgeCnt += 1.0;
                        rememberPropList.add(true);
                        continue;
                    }
                    notAppropriateEdgeCnt += 1.0;
                    rememberPropList.add(false);
                }
                for (CoSENode eff : this.effNodes) {
                    if (this.calculateEffectorAngle(orient, centerPointD, eff) <= 45.0) {
                        approprEffectorCount += 1.0;
                        rememberPropList.add(true);
                        continue;
                    }
                    notAppropriateEffCnt += 1.0;
                    rememberPropList.add(false);
                }
                if (!(appropriateEdgeCnt > bestResult)) continue;
                bestResult = appropriateEdgeCnt;
                bestEffCnt = approprEffectorCount;
                bestPropList = rememberPropList;
                node.orient = orient;
                node.OKCount = bestResult;
            }
            for (i = 0; i < this.consNodes.size(); ++i) {
                this.consNodes.get((int)i).isOrientationProper = (Boolean)bestPropList.get(i);
            }
            for (i = 0; i < this.prodNodes.size(); ++i) {
                this.prodNodes.get((int)i).isOrientationProper = (Boolean)bestPropList.get(i + this.consNodes.size());
            }
            for (i = 0; i < this.effNodes.size(); ++i) {
                this.effNodes.get((int)i).isOrientationProper = (Boolean)bestPropList.get(i + (this.consNodes.size() + this.prodNodes.size()));
            }
            this.properlyOrientedCoSEEdgeCnt += bestResult + bestEffCnt;
            this.totalEdgeCount += appropriateEdgeCnt + notAppropriateEdgeCnt + approprEffectorCount + notAppropriateEffCnt;
        }
    }

    private boolean isEffector(CoSEEdge edge) {
        return edge.type.equals("modulation") || edge.type.equals("stimulation") || edge.type.equals("catalysis") || edge.type.equals("inhibition") || edge.type.equals("necessary stimulation");
    }

    private void reportCoSEResult() {
        System.out.println("CoSE: " + this.properlyOrientedCoSEEdgeCnt + " out of " + this.totalEdgeCount + ": " + this.properlyOrientedCoSEEdgeCnt / this.totalEdgeCount);
    }

    private void reportSBGNResult() {
        System.out.println("SBGN: " + ((SbgnPDLayout)this.myLayout).properlyOrientedEdgeCount + " out of " + ((SbgnPDLayout)this.myLayout).totalEdgeCountToBeOriented + ": " + ((SbgnPDLayout)this.myLayout).successRatio + " -> " + ((SbgnPDLayout)this.myLayout).enhancedRatio);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

