/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.sgym;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.ivis.layout.LEdge;
import org.ivis.layout.LGraph;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LNode;
import org.ivis.layout.Layout;
import org.ivis.layout.LayoutOptionsPack;
import org.ivis.layout.sgym.SgymNode;
import org.ivis.util.DimensionD;
import org.ivis.util.PointD;
import org.ivis.util.RectangleD;

public class SgymLayout
extends Layout {
    protected final boolean verbose = false;
    protected int gridAreaSize = Integer.MIN_VALUE;
    Vector movements = null;
    int movementsMax = Integer.MIN_VALUE;
    int iteration = 0;
    protected boolean vertical = true;
    private int horizontalSpacing = 100;
    private int verticalSpacing = 80;

    @Override
    public LNode newNode(Object vNode) {
        return new SgymNode(this.graphManager, vNode);
    }

    public void perform(LGraph graph, boolean bends) {
        if (graph == null) {
            return;
        }
        ArrayList<PointD> spacing = new ArrayList<PointD>();
        List nodes = graph.getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            this.perform(((SgymNode)nodes.get(i)).getChild(), bends);
        }
        Vector roots = this.searchRoots(nodes);
        if (roots.size() == 0) {
            return;
        }
        ArrayList<SgymNode> topological = new ArrayList<SgymNode>();
        this.topologicalSortWithDFS(topological, roots);
        Vector levels = this.fillLevels(topological);
        this.pushUpNodes(levels);
        for (int i = levels.size() - 2; i >= 0; --i) {
            spacing.add(new PointD(this.horizontalSpacing, this.verticalSpacing));
            Vector v = (Vector)levels.remove(i);
            levels.add(v);
        }
        spacing.add(new PointD(this.horizontalSpacing, this.verticalSpacing));
        if (bends) {
            this.createBendpoints(levels);
            this.graphManager.resetAllEdges();
        }
        this.solveEdgeCrosses(nodes, levels);
        this.moveToBarycenter(nodes, levels);
        PointD min = this.findMinimumAndSpacing(nodes, spacing);
        this.drawGraph(nodes, levels, min, spacing);
        if (this.vertical) {
            this.shiftLayers(levels);
        }
        graph.getParent().updateBounds();
    }

    public Vector fillLevels(List<SgymNode> topological) {
        Vector<Vector> levels = new Vector<Vector>();
        SgymNode node = topological.get(0);
        node.rank = 0;
        Vector v = new Vector();
        levels.add(v);
        node.addToEdgeCrossesIndicator(v.size());
        v.add(node);
        for (int i = 1; i < topological.size(); ++i) {
            node = topological.get(i);
            Iterator iter = node.getSuccessors().iterator();
            int max = -1;
            while (iter.hasNext()) {
                SgymNode next = (SgymNode)iter.next();
                if (next.rank <= max) continue;
                max = next.rank;
            }
            node.rank = max + 1;
            if (levels.size() == node.rank) {
                v = new Vector();
                levels.add(v);
            } else {
                v = (Vector)levels.elementAt(node.rank);
            }
            node.addToEdgeCrossesIndicator(v.size());
            v.add(node);
        }
        SgymNode.levelSize = levels.size();
        return levels;
    }

    public void createBendpoints(Vector levels) {
        int lev = 0;
        for (Vector curLev : levels) {
            for (SgymNode topV : curLev) {
                HashSet tempSet = new HashSet();
                tempSet.addAll(topV.getOutEdges());
                for (LEdge e : tempSet) {
                    SgymNode botV = (SgymNode)e.getTarget();
                    int botLev = botV.getLevel();
                    if (botLev <= lev + 1) continue;
                    int dummyNo = botLev - lev - 1;
                    for (int i = 0; i < dummyNo; ++i) {
                        e.getBendpoints().add(new PointD());
                    }
                    List dummies = this.createDummyNodesForBendpoints(e);
                    for (int i = 0; i < dummyNo; ++i) {
                        int level = i + lev + 1;
                        SgymNode dummy = (SgymNode)dummies.get(i);
                        dummy.setLevel(level);
                        dummy.visited = true;
                        Vector v = (Vector)levels.get(level);
                        dummy.addToEdgeCrossesIndicator(v.size());
                        v.add(dummy);
                    }
                }
            }
            ++lev;
        }
    }

    public void shiftLayers(Vector levels) {
        int j;
        double cur;
        double sign;
        double left;
        double right;
        double amtShifted;
        double prev;
        Vector curLayer;
        int i;
        for (i = 0; i < levels.size(); ++i) {
            curLayer = (Vector)levels.elementAt(i);
            prev = this.averageTension(curLayer);
            this.shiftLayer(curLayer, 5.0);
            amtShifted = 5.0;
            right = this.averageTension(curLayer);
            this.shiftLayer(curLayer, -10.0);
            amtShifted += -10.0;
            left = this.averageTension(curLayer);
            sign = 1.0;
            if (left < right) {
                sign *= -1.0;
            }
            while (true) {
                this.shiftLayer(curLayer, sign * 5.0);
                amtShifted += sign * 5.0;
                cur = this.averageTension(curLayer);
                if (cur > prev) {
                    this.shiftLayer(curLayer, sign * -1.0 * 5.0);
                    amtShifted += -1.0 * sign * 5.0;
                    break;
                }
                if (cur == 0.0 && prev == 0.0) break;
                prev = cur;
            }
            for (j = i - 1; j >= 0; --j) {
                curLayer = (Vector)levels.elementAt(j);
                this.shiftLayer(curLayer, amtShifted);
            }
        }
        for (i = levels.size() - 1; i > 0; --i) {
            curLayer = (Vector)levels.elementAt(i);
            prev = this.averageTension(curLayer);
            this.shiftLayer(curLayer, 5.0);
            amtShifted = 5.0;
            right = this.averageTension(curLayer);
            this.shiftLayer(curLayer, -10.0);
            amtShifted += -10.0;
            left = this.averageTension(curLayer);
            sign = 1.0;
            if (left < right) {
                sign *= -1.0;
            }
            while (true) {
                this.shiftLayer(curLayer, sign * 5.0);
                amtShifted += sign * 5.0;
                cur = this.averageTension(curLayer);
                if (cur > prev) {
                    this.shiftLayer(curLayer, sign * -1.0 * 5.0);
                    amtShifted += -1.0 * sign * 5.0;
                    break;
                }
                if (cur == 0.0 && prev == 0.0) break;
                prev = cur;
            }
            for (j = i + 1; j < levels.size(); ++j) {
                curLayer = (Vector)levels.elementAt(j);
                this.shiftLayer(curLayer, amtShifted);
            }
        }
    }

    public void shiftLayer(Vector curLayer, double inc) {
        if (curLayer == null) {
            return;
        }
        for (int n = 0; n < curLayer.size(); ++n) {
            SgymNode nh = (SgymNode)curLayer.elementAt(n);
            nh.getRect().x += inc;
            this.transformChildren(nh, new DimensionD((int)inc, 0.0));
        }
    }

    public double averageTension(Vector curLayer) {
        int segments = 0;
        double totallength = 0.0;
        for (int n = 0; n < curLayer.size(); ++n) {
            SgymNode v = (SgymNode)curLayer.elementAt(n);
            for (SgymNode neig : v.getNeighborsList()) {
                if (neig == null) continue;
                double length = Math.sqrt((v.getRect().x - neig.getRect().x) * (v.getRect().x - neig.getRect().x) + (v.getRect().y - neig.getRect().y) * (v.getRect().y - neig.getRect().y));
                totallength += length;
                ++segments;
            }
        }
        if (segments == 0) {
            return 0.0;
        }
        return totallength / (double)segments;
    }

    protected void displayEdgeCrossesValues(Vector levels) {
        System.out.println("----------------Edge Crosses Indicator Values");
        for (int i = 0; i < levels.size() - 1; ++i) {
            Vector currentLevel = (Vector)levels.get(i);
            System.out.print("Level (" + i + "):");
            for (int j = 0; j < currentLevel.size(); ++j) {
                SgymNode sourceWrapper = (SgymNode)currentLevel.get(j);
                System.out.print(NumberFormat.getNumberInstance().format(sourceWrapper.getEdgeCrossesIndicator()) + " - ");
            }
            System.out.println();
        }
    }

    protected void displayGridPositions(Vector levels) {
        System.out.println("----------------GridPositions");
        for (int i = 0; i < levels.size() - 1; ++i) {
            Vector currentLevel = (Vector)levels.get(i);
            System.out.print("Level (" + i + "):");
            for (int j = 0; j < currentLevel.size(); ++j) {
                SgymNode sourceWrapper = (SgymNode)currentLevel.get(j);
                System.out.print(NumberFormat.getNumberInstance().format(sourceWrapper.getGridPosition()) + " - ");
            }
            System.out.println();
        }
    }

    protected void displayPriorities(Vector levels) {
        System.out.println("----------------down Priorities");
        for (int i = 0; i < levels.size() - 1; ++i) {
            Vector currentLevel = (Vector)levels.get(i);
            System.out.print("Level (" + i + "):");
            for (int j = 0; j < currentLevel.size(); ++j) {
                SgymNode sourceWrapper = (SgymNode)currentLevel.get(j);
                System.out.print(sourceWrapper.getPriority() + " - ");
            }
            System.out.println();
        }
    }

    protected Vector searchRoots(List<SgymNode> nodes) {
        Set set;
        int i;
        Vector<SgymNode> roots = new Vector<SgymNode>();
        int[] incomingEdgeCount = new int[nodes.size()];
        int[] outgoingEdgeCount = new int[nodes.size()];
        ArrayList<Integer> rootCountPerDisconnected = new ArrayList<Integer>();
        ArrayList disconnected = new ArrayList();
        for (int i2 = 0; i2 < nodes.size(); ++i2) {
            nodes.get(i2).setVisited(false);
            incomingEdgeCount[i2] = 0;
            outgoingEdgeCount[i2] = 0;
        }
        int count = 0;
        for (i = 0; i < nodes.size(); ++i) {
            if (nodes.get(i).isVisited()) continue;
            set = new HashSet();
            this.searchRoots(nodes, nodes.get(i), roots, incomingEdgeCount, outgoingEdgeCount, set);
            rootCountPerDisconnected.add(roots.size() - count);
            disconnected.add(set);
            count = roots.size();
        }
        for (i = 0; i < disconnected.size(); ++i) {
            if ((Integer)rootCountPerDisconnected.get(i) != 0) continue;
            set = (Set)disconnected.get(i);
            int min = incomingEdgeCount.length;
            int index = -1;
            for (LNode node : set) {
                int loc = nodes.indexOf(node);
                if (outgoingEdgeCount[loc] <= 0 || incomingEdgeCount[loc] >= min) continue;
                min = incomingEdgeCount[loc];
                index = loc;
            }
            if (index <= -1) continue;
            roots.add(nodes.get(index));
        }
        return roots;
    }

    protected void searchRoots(List<SgymNode> nodes, SgymNode node, Vector roots, int[] incomingEdgeCount, int[] outgoingEdgeCount, Set set) {
        if (node.isVisited()) {
            return;
        }
        node.setVisited(true);
        set.add(node);
        boolean isRoot = true;
        for (LEdge edge : node.getEdges()) {
            if (edge.isInterGraph()) continue;
            if (edge.getTarget() == node) {
                SgymNode source = (SgymNode)edge.getSource();
                this.searchRoots(nodes, source, roots, incomingEdgeCount, outgoingEdgeCount, set);
                int n = nodes.indexOf(node);
                incomingEdgeCount[n] = incomingEdgeCount[n] + 1;
                isRoot = false;
                continue;
            }
            SgymNode target = (SgymNode)edge.getTarget();
            this.searchRoots(nodes, target, roots, incomingEdgeCount, outgoingEdgeCount, set);
            int n = nodes.indexOf(node);
            outgoingEdgeCount[n] = outgoingEdgeCount[n] + 1;
        }
        if (isRoot) {
            roots.add(node);
        }
    }

    protected void topologicalSortWithDFS(List<SgymNode> topological, Vector roots) {
        for (SgymNode root : roots) {
            if (root.color != 0) continue;
            this.dfsVisit(topological, root);
        }
    }

    private void dfsVisit(List<SgymNode> topological, SgymNode root) {
        root.color = 1;
        for (LEdge edge : root.getEdges()) {
            if (edge.isInterGraph() || root != edge.getSource()) continue;
            SgymNode target = (SgymNode)edge.getTarget();
            if (target.color == 0) {
                target.ancestor = root;
                this.dfsVisit(topological, target);
                continue;
            }
            if (target.color != 1) continue;
            this.solveCycle(edge);
        }
        root.color = 2;
        topological.add(root);
    }

    public void solveCycle(LEdge edge) {
        this.getGraphManager().getRoot().reverse(edge);
    }

    protected PointD findMinimumAndSpacing(List<SgymNode> nodes, List<PointD> spacing) {
        try {
            int min_x = 1000000;
            int min_y = 1000000;
            for (int i = 0; i < nodes.size(); ++i) {
                SgymNode node = nodes.get(i);
                RectangleD nodeBounds = node.getRect();
                try {
                    if (nodeBounds.x < (double)min_x) {
                        min_x = (int)nodeBounds.x;
                    }
                    if (nodeBounds.y < (double)min_y) {
                        min_y = (int)nodeBounds.y;
                    }
                    if (nodeBounds.width > spacing.get((int)node.getLevel()).x) {
                        spacing.get((int)node.getLevel()).x = (int)nodeBounds.width + this.horizontalSpacing;
                    }
                    if (!(nodeBounds.height > spacing.get((int)node.getLevel()).y)) continue;
                    spacing.get((int)node.getLevel()).y = (int)nodeBounds.height + this.verticalSpacing;
                    continue;
                }
                catch (Exception e) {
                    System.err.println("---------> ERROR in calculateValues.");
                    e.printStackTrace();
                }
            }
            return new PointD(min_x, min_y);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void solveEdgeCrosses(List<SgymNode> nodes, Vector levels) {
        this.movements = new Vector(100);
        int movementsCurrentLoop = -1;
        this.movementsMax = Integer.MIN_VALUE;
        this.iteration = 0;
        while (movementsCurrentLoop != 0) {
            int i;
            movementsCurrentLoop = 0;
            for (i = 0; i < levels.size() - 1; ++i) {
                movementsCurrentLoop += this.solveEdgeCrosses(nodes, true, levels, i);
            }
            for (i = levels.size() - 1; i >= 1; --i) {
                movementsCurrentLoop += this.solveEdgeCrosses(nodes, false, levels, i);
            }
        }
    }

    protected int solveEdgeCrosses(List<SgymNode> jgraph, boolean down, Vector levels, int levelIndex) {
        int j;
        Vector currentLevel = (Vector)levels.get(levelIndex);
        int movements = 0;
        Object[] levelSortBefore = currentLevel.toArray();
        Collections.sort(currentLevel);
        for (j = 0; j < levelSortBefore.length; ++j) {
            if (((SgymNode)levelSortBefore[j]).getEdgeCrossesIndicator() == ((SgymNode)currentLevel.get(j)).getEdgeCrossesIndicator()) continue;
            ++movements;
        }
        for (j = currentLevel.size() - 1; j >= 0; --j) {
            SgymNode source = (SgymNode)currentLevel.get(j);
            for (LEdge edge : source.getEdges()) {
                if (edge.isInterGraph()) continue;
                SgymNode target = null;
                if (down && source == edge.getSource()) {
                    target = (SgymNode)edge.getTarget();
                }
                if (!down && source == edge.getTarget()) {
                    target = (SgymNode)edge.getSource();
                }
                if (target == null) continue;
                if (down && target != null && target.getLevel() > levelIndex) {
                    target.addToEdgeCrossesIndicator(source.getEdgeCrossesIndicator());
                }
                if (down || target == null || target.getLevel() >= levelIndex) continue;
                target.addToEdgeCrossesIndicator(source.getEdgeCrossesIndicator());
            }
        }
        return movements;
    }

    /*
     * WARNING - void declaration
     */
    protected void moveToBarycenter(List<SgymNode> nodes, Vector levels) {
        for (int i = 0; i < nodes.size(); ++i) {
            if (!(nodes.get(i) instanceof SgymNode)) continue;
            SgymNode node = nodes.get(i);
            for (LEdge edge : node.getEdges()) {
                void var7_9;
                SgymNode neighbor;
                if (edge.isInterGraph()) continue;
                if (node == edge.getSource()) {
                    neighbor = (SgymNode)edge.getTarget();
                } else {
                    if (node != edge.getTarget()) continue;
                    neighbor = (SgymNode)edge.getSource();
                }
                if (var7_9 == node || node == null || node == null || node.getLevel() == var7_9.getLevel()) continue;
                ++node.priority;
            }
        }
        for (int j = 0; j < levels.size(); ++j) {
            Vector level = (Vector)levels.get(j);
            for (int i = 0; i < level.size(); ++i) {
                SgymNode wrapper = (SgymNode)level.get(i);
                wrapper.setGridPosition(i);
            }
        }
        this.movements = new Vector(100);
        int movementsCurrentLoop = -1;
        this.movementsMax = Integer.MIN_VALUE;
        this.iteration = 0;
        while (movementsCurrentLoop != 0) {
            int i;
            movementsCurrentLoop = 0;
            for (i = 1; i < levels.size(); ++i) {
                movementsCurrentLoop += this.moveToBarycenter(nodes, levels, i);
            }
            for (i = levels.size() - 1; i >= 0; --i) {
                movementsCurrentLoop += this.moveToBarycenter(nodes, levels, i);
            }
        }
    }

    protected int moveToBarycenter(List<SgymNode> nodes, Vector levels, int levelIndex) {
        int movements = 0;
        Vector currentLevel = (Vector)levels.get(levelIndex);
        for (int currentIndexInTheLevel = 0; currentIndexInTheLevel < currentLevel.size(); ++currentIndexInTheLevel) {
            SgymNode source = (SgymNode)currentLevel.get(currentIndexInTheLevel);
            float gridPositionsSum = 0.0f;
            float countNodes = 0.0f;
            for (LEdge edge : source.getEdges()) {
                SgymNode target;
                SgymNode neighbor;
                if (edge.isInterGraph()) continue;
                if (source == edge.getSource()) {
                    neighbor = (SgymNode)edge.getTarget();
                } else {
                    if (source != edge.getTarget()) continue;
                    neighbor = (SgymNode)edge.getSource();
                }
                if ((target = neighbor) == source || target == null || target.getLevel() == levelIndex) continue;
                gridPositionsSum += (float)target.getGridPosition();
                countNodes += 1.0f;
            }
            if (!(countNodes > 0.0f)) continue;
            float tmp = gridPositionsSum / countNodes;
            int newGridPosition = Math.round(tmp);
            boolean toRight = newGridPosition > source.getGridPosition();
            boolean moved = true;
            while (newGridPosition != source.getGridPosition() && moved) {
                int tmpGridPos = source.getGridPosition();
                moved = this.move(toRight, currentLevel, currentIndexInTheLevel, source.getPriority());
                if (!moved) continue;
                ++movements;
            }
        }
        return movements;
    }

    protected boolean move(boolean toRight, Vector currentLevel, int currentIndexInTheLevel, int currentPriority) {
        boolean moved;
        SgymNode currentWrapper = (SgymNode)currentLevel.get(currentIndexInTheLevel);
        int neighborIndexInTheLevel = currentIndexInTheLevel + (toRight ? 1 : -1);
        int newGridPosition = currentWrapper.getGridPosition() + (toRight ? 1 : -1);
        if (0 > newGridPosition || newGridPosition >= this.gridAreaSize) {
            return false;
        }
        if (toRight && currentIndexInTheLevel == currentLevel.size() - 1 || !toRight && currentIndexInTheLevel == 0) {
            moved = true;
        } else {
            SgymNode neighborWrapper = (SgymNode)currentLevel.get(neighborIndexInTheLevel);
            int neighborPriority = neighborWrapper.getPriority();
            if (neighborWrapper.getGridPosition() == newGridPosition) {
                if (neighborPriority >= currentPriority) {
                    return false;
                }
                moved = this.move(toRight, currentLevel, neighborIndexInTheLevel, currentPriority);
            } else {
                moved = true;
            }
        }
        if (moved) {
            currentWrapper.setGridPosition(newGridPosition);
        }
        return moved;
    }

    protected void drawGraph(List<SgymNode> jgraph, Vector levels, PointD min, List<PointD> spacing) {
        for (int rowCellCount = 0; rowCellCount < levels.size(); ++rowCellCount) {
            Vector level = (Vector)levels.get(rowCellCount);
            for (int colCellCount = 0; colCellCount < level.size(); ++colCellCount) {
                SgymNode node = (SgymNode)level.get(colCellCount);
                RectangleD bounds = new RectangleD((int)node.getRect().x, (int)node.getRect().y, (int)node.getRect().width, (int)node.getRect().height);
                PointD prev = new PointD(bounds.x, bounds.y);
                PointD space = this.getSpacing(spacing, node.getLevel(), node.getGridPosition());
                bounds.x = min.x + space.x;
                bounds.y = min.y + space.y;
                node.setLocation(bounds.x, bounds.y);
                DimensionD diff = new PointD(bounds.x, bounds.y).getDifference(prev);
                this.transformChildren(node, diff);
            }
        }
    }

    public PointD getSpacing(List<PointD> spacing, int level, int gridPos) {
        PointD space = new PointD(0.0, 0.0);
        if (this.vertical) {
            for (int i = 0; i < level; ++i) {
                space.y += spacing.get((int)i).y;
            }
            space.x += spacing.get((int)level).x * (double)gridPos;
        } else {
            for (int i = 0; i < level; ++i) {
                space.x += spacing.get((int)i).x;
            }
            space.y += spacing.get((int)level).y * (double)gridPos;
        }
        return space;
    }

    public void transformChildren(LNode wrapper, DimensionD difference) {
        if (wrapper.getChild() != null) {
            for (int i = 0; i < wrapper.getChild().getNodes().size(); ++i) {
                SgymNode node = (SgymNode)wrapper.getChild().getNodes().get(i);
                PointD prev = node.getLocation().getCopy();
                PointD newLoc = node.getLocation().translate(difference);
                node.setLocation(newLoc.x, newLoc.y);
                DimensionD diff = node.getLocation().getDifference(prev);
                this.transformChildren(node, diff);
            }
        }
    }

    public void reassignEdges(LGraph graph) {
        int i;
        List edges = graph.getEdges();
        ArrayList copyList = new ArrayList(graph.getEdges());
        ArrayList<LEdge> removeList = new ArrayList<LEdge>();
        for (i = 0; i < copyList.size(); ++i) {
            LEdge edge = (LEdge)copyList.get(i);
            if (!edge.isInterGraph()) continue;
            Iterator parents = edge.getTarget().getAllParents().iterator();
            boolean done = false;
            LNode prevParent = null;
            LNode parent = (LNode)parents.next();
            while (parent != null) {
                if (parent == graph.getParent()) {
                    LNode newTarget = prevParent;
                    this.graphManager.remove(edge);
                    LEdge newEdge = this.newEdge(edge.vGraphObject);
                    this.graphManager.add(newEdge, edge.getSource(), newTarget);
                    done = true;
                    break;
                }
                prevParent = parent;
                if (parents.hasNext()) {
                    parent = (LNode)parents.next();
                    continue;
                }
                parent = null;
            }
            if (done) continue;
            LNode oldSource = edge.getSource();
            LNode newSource = graph.getParent();
            LEdge newEdge = this.newEdge(edge.vGraphObject);
            this.graphManager.add(newEdge, newSource, edge.getTarget());
            oldSource.getEdges().remove(edge);
            removeList.add(edge);
        }
        for (i = 0; i < removeList.size(); ++i) {
            removeList.get(i);
            graph.remove((LNode)removeList.get(i));
        }
    }

    @Override
    public boolean layout() {
        if (this.graphManager.getGraphs().size() > 1) {
            return false;
        }
        boolean createBendsAsNeeded = LayoutOptionsPack.getInstance().getGeneral().createBendsAsNeeded;
        this.perform(this.graphManager.getRoot(), createBendsAsNeeded);
        return true;
    }

    @Override
    public void initParameters() {
        super.initParameters();
        LayoutOptionsPack.Sgym layoutOptionsPack = LayoutOptionsPack.getInstance().getSgym();
        this.horizontalSpacing = layoutOptionsPack.horizontalSpacing;
        this.verticalSpacing = layoutOptionsPack.verticalSpacing;
        this.vertical = layoutOptionsPack.vertical;
    }

    public boolean check() {
        LEdge edge;
        int i;
        Object[] lEdges = this.getGraphManager().getAllEdges();
        for (i = 0; i < lEdges.length; ++i) {
            edge = (LEdge)lEdges[i];
            if (LGraphManager.isOneAncestorOfOther(edge.getSource(), edge.getTarget())) {
                return false;
            }
            if (((SgymNode)edge.getSource()).getLevel() < ((SgymNode)edge.getTarget()).getLevel()) continue;
            return false;
        }
        if (!this.createBendsAsNeeded) {
            for (i = 0; i < lEdges.length; ++i) {
                edge = (LEdge)lEdges[i];
                if (edge.getBendpoints().size() == 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean pushUpNodes(Vector levels) {
        boolean hasRankChanged = false;
        for (int i = levels.size() - 3; i >= 0; --i) {
            Vector vector = (Vector)levels.get(i);
            ArrayList<SgymNode> list = new ArrayList<SgymNode>();
            for (int j = 0; j < vector.size(); ++j) {
                SgymNode node = (SgymNode)vector.get(j);
                boolean hasThisNodeChangedRank = node.pushNodeUp();
                if (hasThisNodeChangedRank) {
                    list.add(node);
                }
                hasRankChanged |= hasThisNodeChangedRank;
            }
            for (int k = 0; k < list.size(); ++k) {
                SgymNode node = (SgymNode)list.get(k);
                vector.remove(node);
                Vector temp = (Vector)levels.get(node.rank);
                temp.add(node);
            }
        }
        return hasRankChanged;
    }
}

