/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.io.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import psidev.psi.mi.xml.PsimiXmlWriterException;
import psidev.psi.mi.xml.io.PsimiXmlLightweightWriter;
import psidev.psi.mi.xml.io.impl.PsimiXmlStringWriter254;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.Availability;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsimiXmlLightweightWriter254
implements PsimiXmlLightweightWriter {
    private static final String LINE_RETURN = System.getProperty("line.separator");
    private static final String INDENT = "    ";
    private PsimiXmlStringWriter254 stringWriter = null;
    private BufferedWriter buffer;
    private boolean writerProvided = false;
    private boolean wasInteractionListWritten = false;

    public PsimiXmlLightweightWriter254(File outputFile) throws PsimiXmlWriterException {
        if (outputFile == null) {
            throw new IllegalArgumentException("You must provide a non null output file");
        }
        if (!outputFile.exists()) {
            if (!outputFile.getParentFile().canWrite()) {
                throw new IllegalArgumentException("You must provide writeable parent directory for the output file");
            }
        } else if (!outputFile.canWrite()) {
            throw new IllegalArgumentException("You must provide a writeable output file");
        }
        try {
            this.buffer = new BufferedWriter(new FileWriter(outputFile));
        }
        catch (IOException e) {
            throw new PsimiXmlWriterException("Error while setting up the writer", e);
        }
        this.stringWriter = new PsimiXmlStringWriter254();
    }

    public PsimiXmlLightweightWriter254(Writer writer) {
        if (writer == null) {
            throw new IllegalArgumentException("You must provide a non null writer");
        }
        this.buffer = new BufferedWriter(writer);
        this.writerProvided = true;
        this.stringWriter = new PsimiXmlStringWriter254();
    }

    @Override
    public void writeStartDocument() throws PsimiXmlWriterException {
        this.writeln("<entrySet version=\"5\" minorVersion=\"4\" level=\"2\" xsi:schemaLocation=\"http://psi.hupo.org/mi/mif http://psidev.sourceforge.net/mi/rel25/src/MIF254.xsd\" xmlns=\"http://psi.hupo.org/mi/mif\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
    }

    @Override
    public void writeStartEntry(Source source, List<Availability> availabilities) throws PsimiXmlWriterException {
        this.writeln("    <entry>");
        if (source != null) {
            this.write(this.stringWriter.write(source) + LINE_RETURN);
        }
        if (availabilities != null && !availabilities.isEmpty()) {
            this.writeln("        <availabilityList>");
            for (Availability availability : availabilities) {
                this.write("            " + this.stringWriter.write(availability));
            }
            this.writeln("        </availabilityList>");
        }
    }

    @Override
    public void writeInteraction(Interaction interaction2) throws PsimiXmlWriterException {
        if (!this.wasInteractionListWritten) {
            this.writeln("<interactionList>");
            this.wasInteractionListWritten = true;
        }
        this.write(this.stringWriter.write(interaction2) + LINE_RETURN);
    }

    @Override
    public void writeEndEntry(List<Attribute> attributes) throws PsimiXmlWriterException {
        this.writeln("        </interactionList>");
        if (attributes != null && !attributes.isEmpty()) {
            this.writeln("        <attributeList>");
            for (Attribute attribute : attributes) {
                this.writeln("            " + this.stringWriter.write(attribute));
            }
            this.writeln("        </attributeList>");
        }
        this.writeln("    </entry>");
        this.wasInteractionListWritten = false;
    }

    @Override
    public void writeEndDocument() throws PsimiXmlWriterException {
        this.writeln("</entrySet>");
        this.closeOutputFile();
    }

    @Override
    public void closeOutputFile() throws PsimiXmlWriterException {
        try {
            this.buffer.flush();
            if (!this.writerProvided) {
                this.buffer.close();
            }
        }
        catch (Exception e) {
            throw new PsimiXmlWriterException("An error occured while closing the output buffer");
        }
    }

    private void writeln(String s) throws PsimiXmlWriterException {
        try {
            this.buffer.write(s + LINE_RETURN);
        }
        catch (IOException e) {
            throw new PsimiXmlWriterException("Error while writing to the output", e);
        }
    }

    private void write(String s) throws PsimiXmlWriterException {
        try {
            this.buffer.write(s);
        }
        catch (IOException e) {
            throw new PsimiXmlWriterException("Error while writing to the output", e);
        }
    }
}

