/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.gsea;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;

final class GMTEntry {
    private final String name;
    private final String taxID;
    private final String idType;
    private final String description;
    private final Set<String> identifiers;

    public GMTEntry(String name, String taxID, String idType, String description) {
        if (name == null || taxID == null || idType == null || description == null) {
            throw new IllegalArgumentException("Null paraneter (not allowed)");
        }
        this.name = name;
        this.taxID = taxID;
        this.idType = idType;
        this.description = description;
        this.identifiers = new TreeSet<String>();
    }

    public String name() {
        return this.name;
    }

    public String taxID() {
        return this.taxID;
    }

    public String description() {
        return this.description;
    }

    public Collection<String> identifiers() {
        return this.identifiers;
    }

    public String idType() {
        return this.idType;
    }

    public String toString() {
        StringBuilder toReturn = new StringBuilder();
        toReturn.append(this.name).append("\t").append(this.description);
        if (!this.taxID.isEmpty()) {
            toReturn.append("; organism: ").append(this.taxID);
        }
        if (!this.idType.isEmpty()) {
            toReturn.append("; idtype: ").append(this.idType);
        }
        for (String id : this.identifiers) {
            toReturn.append("\t").append(id);
        }
        return toReturn.toString();
    }
}

