/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.constraint;

import java.util.Collection;
import java.util.HashSet;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.ConversionDirectionType;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.constraint.ConstraintAdapter;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.biopax.paxtools.pattern.util.RelType;

public class ParticipatesInConv
extends ConstraintAdapter {
    private RelType type;

    public ParticipatesInConv(RelType type, Blacklist blacklist) {
        super(2, blacklist);
        this.type = type;
    }

    public ParticipatesInConv(RelType type) {
        this(type, null);
    }

    @Override
    public boolean canGenerate() {
        return true;
    }

    @Override
    public Collection<BioPAXElement> generate(Match match, int ... ind) {
        HashSet<BioPAXElement> result = new HashSet<BioPAXElement>();
        PhysicalEntity pe = (PhysicalEntity)match.get(ind[0]);
        for (Interaction inter : pe.getParticipantOf()) {
            if (!(inter instanceof Conversion)) continue;
            Conversion cnv = (Conversion)inter;
            ConversionDirectionType dir = this.getDirection(cnv);
            if (this.blacklist != null && this.blacklist.isUbique(pe, cnv, dir, this.type)) continue;
            if (dir == ConversionDirectionType.REVERSIBLE) {
                result.add(cnv);
                continue;
            }
            if (dir == ConversionDirectionType.RIGHT_TO_LEFT && (this.type == RelType.INPUT ? cnv.getRight().contains(pe) : cnv.getLeft().contains(pe))) {
                result.add(cnv);
                continue;
            }
            if (dir != ConversionDirectionType.LEFT_TO_RIGHT && dir != null || !(this.type == RelType.INPUT ? cnv.getLeft().contains(pe) : cnv.getRight().contains(pe))) continue;
            result.add(cnv);
        }
        return result;
    }
}

