/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.ivis.layout.LEdge;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LGraphObject;
import org.ivis.layout.LNode;
import org.ivis.layout.Layout;
import org.ivis.layout.LayoutConstants;

public class LGraph
extends LGraphObject {
    private List nodes;
    private List edges;
    private LGraphManager graphManager;
    protected LNode parent;
    private int top;
    private int left;
    private int bottom;
    private int right;
    protected int estimatedSize = Integer.MIN_VALUE;
    private int margin = LayoutConstants.DEFAULT_GRAPH_MARGIN;
    private boolean isConnected = false;

    protected LGraph(LNode parent, LGraphManager graphMgr, Object vGraph) {
        this(vGraph);
        this.parent = parent;
        this.graphManager = graphMgr;
    }

    protected LGraph(LNode parent, Layout layout, Object vGraph) {
        this(vGraph);
        this.parent = parent;
        this.graphManager = layout.graphManager;
    }

    private LGraph(Object vGraph) {
        super(vGraph);
        this.edges = new ArrayList();
        this.nodes = new ArrayList();
    }

    public List getNodes() {
        return this.nodes;
    }

    public List getEdges() {
        return this.edges;
    }

    public LGraphManager getGraphManager() {
        return this.graphManager;
    }

    public LNode getParent() {
        return this.parent;
    }

    public int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }

    public int getTop() {
        return this.top;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getBiggerDimension() {
        assert (this.right - this.left >= 0 && this.bottom - this.top >= 0);
        return Math.max(this.right - this.left, this.bottom - this.top);
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public LNode add(LNode newNode) {
        assert (this.graphManager != null) : "Graph has no graph mgr!";
        assert (!this.getNodes().contains(newNode)) : "Node already in graph!";
        newNode.setOwner(this);
        this.getNodes().add(newNode);
        return newNode;
    }

    public LEdge add(LEdge newEdge, LNode sourceNode, LNode targetNode) {
        assert (this.getNodes().contains(sourceNode) && this.getNodes().contains(targetNode)) : "Source or target not in graph!";
        assert (sourceNode.owner == targetNode.owner && sourceNode.owner == this) : "Both owners must be this graph!";
        if (sourceNode.owner != targetNode.owner) {
            return null;
        }
        newEdge.source = sourceNode;
        newEdge.target = targetNode;
        newEdge.isInterGraph = false;
        this.getEdges().add(newEdge);
        sourceNode.edges.add(newEdge);
        if (targetNode != sourceNode) {
            targetNode.edges.add(newEdge);
        }
        return newEdge;
    }

    public void remove(LNode node) {
        assert (node != null) : "Node is null!";
        assert (node.owner != null && node.owner == this) : "Owner graph is invalid!";
        assert (this.graphManager != null) : "Owner graph manager is invalid!";
        ArrayList edgesToBeRemoved = new ArrayList();
        edgesToBeRemoved.addAll(node.edges);
        for (Object obj : edgesToBeRemoved) {
            LEdge edge = (LEdge)obj;
            if (edge.isInterGraph) {
                this.graphManager.remove(edge);
                continue;
            }
            edge.source.owner.remove(edge);
        }
        assert (this.nodes.contains(node)) : "Node not in owner node list!";
        this.nodes.remove(node);
    }

    public void remove(LEdge edge) {
        assert (edge != null) : "Edge is null!";
        assert (edge.source != null && edge.target != null) : "Source and/or target is null!";
        assert (edge.source.owner != null && edge.target.owner != null && edge.source.owner == this && edge.target.owner == this) : "Source and/or target owner is invalid!";
        assert (edge.source.edges.contains(edge) && edge.target.edges.contains(edge)) : "Source and/or target doesn't know this edge!";
        edge.source.edges.remove(edge);
        if (edge.target != edge.source) {
            edge.target.edges.remove(edge);
        }
        assert (edge.source.owner.getEdges().contains(edge)) : "Not in owner's edge list!";
        edge.source.owner.getEdges().remove(edge);
    }

    public Point updateLeftTop() {
        int top = Integer.MAX_VALUE;
        int left = Integer.MAX_VALUE;
        for (LNode lNode : this.getNodes()) {
            int nodeTop = (int)lNode.getTop();
            int nodeLeft = (int)lNode.getLeft();
            if (top > nodeTop) {
                top = nodeTop;
            }
            if (left <= nodeLeft) continue;
            left = nodeLeft;
        }
        if (top == Integer.MAX_VALUE) {
            return null;
        }
        this.left = left - this.margin;
        this.top = top - this.margin;
        return new Point(this.left, this.top);
    }

    public void updateBounds(boolean recursive) {
        int left = Integer.MAX_VALUE;
        int right = -2147483647;
        int top = Integer.MAX_VALUE;
        int bottom = -2147483647;
        for (LNode lNode : this.nodes) {
            if (recursive && lNode.child != null) {
                lNode.updateBounds();
            }
            int nodeLeft = (int)lNode.getLeft();
            int nodeRight = (int)lNode.getRight();
            int nodeTop = (int)lNode.getTop();
            int nodeBottom = (int)lNode.getBottom();
            if (left > nodeLeft) {
                left = nodeLeft;
            }
            if (right < nodeRight) {
                right = nodeRight;
            }
            if (top > nodeTop) {
                top = nodeTop;
            }
            if (bottom >= nodeBottom) continue;
            bottom = nodeBottom;
        }
        if (left == Integer.MAX_VALUE) {
            left = (int)this.parent.getLeft();
            right = (int)this.parent.getRight();
            top = (int)this.parent.getTop();
            bottom = (int)this.parent.getBottom();
        }
        Rectangle boundingRect = new Rectangle(left, top, right - left, bottom - top);
        this.left = boundingRect.x - this.margin;
        this.right = boundingRect.x + boundingRect.width + this.margin;
        this.top = boundingRect.y - this.margin;
        this.bottom = boundingRect.y + boundingRect.height + this.margin;
    }

    public static Rectangle calculateBounds(List<LNode> nodes) {
        int left = Integer.MAX_VALUE;
        int right = -2147483647;
        int top = Integer.MAX_VALUE;
        int bottom = -2147483647;
        for (LNode lNode : nodes) {
            int nodeLeft = (int)lNode.getLeft();
            int nodeRight = (int)lNode.getRight();
            int nodeTop = (int)lNode.getTop();
            int nodeBottom = (int)lNode.getBottom();
            if (left > nodeLeft) {
                left = nodeLeft;
            }
            if (right < nodeRight) {
                right = nodeRight;
            }
            if (top > nodeTop) {
                top = nodeTop;
            }
            if (bottom >= nodeBottom) continue;
            bottom = nodeBottom;
        }
        Rectangle boundingRect = new Rectangle(left, top, right - left, bottom - top);
        return boundingRect;
    }

    public int getInclusionTreeDepth() {
        if (this == this.graphManager.getRoot()) {
            return 1;
        }
        return this.parent.getInclusionTreeDepth();
    }

    public int getEstimatedSize() {
        assert (this.estimatedSize != Integer.MIN_VALUE);
        return this.estimatedSize;
    }

    public void setEstimatedSize(int size) {
        this.estimatedSize = size;
    }

    public int calcEstimatedSize() {
        int size = 0;
        for (LNode lNode : this.nodes) {
            size += lNode.calcEstimatedSize();
        }
        this.estimatedSize = size == 0 ? 40 : (int)((double)size / Math.sqrt(this.nodes.size()));
        return this.estimatedSize;
    }

    public void updateConnected() {
        if (this.nodes.size() == 0) {
            this.isConnected = true;
            return;
        }
        LinkedList<LNode> toBeVisited = new LinkedList<LNode>();
        HashSet<LNode> visited = new HashSet<LNode>();
        LNode currentNode = (LNode)this.nodes.get(0);
        toBeVisited.addAll(currentNode.withChildren());
        while (!toBeVisited.isEmpty()) {
            currentNode = (LNode)toBeVisited.removeFirst();
            visited.add(currentNode);
            List neighborEdges = currentNode.getEdges();
            for (LEdge neighborEdge : neighborEdges) {
                LNode currentNeighbor = neighborEdge.getOtherEndInGraph(currentNode, this);
                if (currentNeighbor == null || visited.contains(currentNeighbor)) continue;
                toBeVisited.addAll(currentNeighbor.withChildren());
            }
        }
        this.isConnected = false;
        if (visited.size() >= this.nodes.size()) {
            int noOfVisitedInThisGraph = 0;
            for (LNode visitedNode : visited) {
                if (visitedNode.owner != this) continue;
                ++noOfVisitedInThisGraph;
            }
            if (noOfVisitedInThisGraph == this.nodes.size()) {
                this.isConnected = true;
            }
        }
    }

    public void reverse(LEdge edge) {
        edge.source.getOwner().getEdges().remove(edge);
        edge.target.getOwner().getEdges().add(edge);
        LNode swap = edge.source;
        edge.source = edge.target;
        edge.target = swap;
    }

    void printTopology() {
        System.out.print((this.label == null ? "?" : this.label) + ": ");
        System.out.print("Nodes: ");
        for (Object obj : this.nodes) {
            LNode node = (LNode)obj;
            node.printTopology();
        }
        System.out.print("Edges: ");
        for (Object obj : this.edges) {
            LEdge edge = (LEdge)obj;
            edge.printTopology();
        }
        System.out.println();
    }
}

