/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.sbgn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.ivis.layout.LEdge;
import org.ivis.layout.LGraph;
import org.ivis.layout.LNode;
import org.ivis.layout.cose.CoSELayout;
import org.ivis.layout.cose.CoSENode;
import org.ivis.layout.fd.FDLayoutEdge;
import org.ivis.layout.fd.FDLayoutNode;
import org.ivis.layout.sbgn.Compaction;
import org.ivis.layout.sbgn.SbgnPDConstants;
import org.ivis.layout.sbgn.SbgnPDEdge;
import org.ivis.layout.sbgn.SbgnPDNode;
import org.ivis.layout.sbgn.SbgnProcessNode;
import org.ivis.layout.util.MemberPack;
import org.ivis.layout.util.RectProc;
import org.ivis.util.IGeometry;
import org.ivis.util.PointD;
import org.ivis.util.RectangleD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SbgnPDLayout
extends CoSELayout {
    private static final Logger log = LoggerFactory.getLogger(SbgnPDLayout.class);
    Map<SbgnPDNode, LGraph> childGraphMap;
    Map<SbgnPDNode, MemberPack> memberPackMap;
    LinkedList<SbgnPDNode> dummyComplexList;
    Map<SbgnPDNode, LGraph> emptiedDummyComplexMap;
    LinkedList<SbgnPDNode> complexOrder;
    private DefaultCompactionAlgorithm compactionMethod = DefaultCompactionAlgorithm.TILING;
    public double properlyOrientedEdgeCount;
    public double totalEdgeCountToBeOriented;
    private int phaseNumber;
    public int phase1IterationCount;
    public int phase2IterationCount;
    public int rotationRandomizationMethod = 1;
    public ArrayList<SbgnProcessNode> processNodeList;
    public double successRatio;
    public double enhancedRatio = 0.0;
    public int totalEffCount = 0;

    public SbgnPDLayout() {
        this.childGraphMap = new HashMap<SbgnPDNode, LGraph>();
        this.complexOrder = new LinkedList();
        this.dummyComplexList = new LinkedList();
        this.emptiedDummyComplexMap = new HashMap<SbgnPDNode, LGraph>();
        this.processNodeList = new ArrayList();
        if (this.compactionMethod == DefaultCompactionAlgorithm.TILING) {
            this.memberPackMap = new HashMap<SbgnPDNode, MemberPack>();
        }
    }

    @Override
    public void runSpringEmbedder() {
        log.info("SBGN-PD Layout phase1...");
        this.phaseNumber = 1;
        this.doPhase1();
        log.info("SBGN-PD Layout phase2...");
        this.phaseNumber = 2;
        this.doPhase2();
        this.recalcProperlyOrientedEdges(true);
        log.info("success ratio: " + this.successRatio);
        this.finalEnhancement();
        log.info("enhanced ratio: " + this.enhancedRatio);
        this.removeDummyCompounds();
    }

    private void doPhase1() {
        this.maxIterations = 200;
        this.totalIterations = 0;
        do {
            ++this.totalIterations;
            if (this.totalIterations % 100 == 0) {
                if (this.isConverged()) break;
                this.coolingFactor = this.initialCoolingFactor * ((double)(this.maxIterations - this.totalIterations) / (double)this.maxIterations);
            }
            this.totalDisplacement = 0.0;
            this.graphManager.updateBounds();
            this.calcSpringForces();
            this.calcRepulsionForces();
            this.calcGravitationalForces();
            this.moveNodes();
            this.animate();
        } while (this.totalIterations < this.maxIterations);
        this.graphManager.updateBounds();
        this.phase1IterationCount = this.totalIterations;
    }

    private void doPhase2() {
        this.maxIterations = (int)Math.log(this.getAllEdges().length + this.getAllNodes().length) * 400;
        this.coolingFactor = this.initialCoolingFactor = 0.3;
        this.totalIterations = 0;
        do {
            ++this.totalIterations;
            if (this.totalIterations % 100 == 0) {
                this.successRatio = this.properlyOrientedEdgeCount / this.totalEdgeCountToBeOriented;
                if (this.isConverged() && this.successRatio >= 1.0) break;
                this.coolingFactor = this.initialCoolingFactor * ((double)(this.maxIterations - this.totalIterations) / (double)this.maxIterations);
            }
            this.totalDisplacement = 0.0;
            this.graphManager.updateBounds();
            this.calcSpringForces();
            this.calcRepulsionForces();
            this.calcGravitationalForces();
            this.moveNodes();
            this.animate();
        } while (this.totalIterations < this.maxIterations && this.totalIterations < 2500);
        this.phase2IterationCount = this.totalIterations;
        this.graphManager.updateBounds();
    }

    @Override
    public void moveNodes() {
        this.properlyOrientedEdgeCount = 0.0;
        this.totalEdgeCountToBeOriented = 0.0;
        if (this.hasApproximationPeriodReached() && this.coolingFactor > 0.02) {
            for (SbgnProcessNode p : this.processNodeList) {
                p.applyApproximations();
            }
        }
        for (SbgnProcessNode p : this.processNodeList) {
            if (this.phaseNumber == 2) {
                p.calcRotationalForces();
                this.properlyOrientedEdgeCount += p.properEdgeCount;
                this.totalEdgeCountToBeOriented += (double)(p.consumptionEdges.size() + p.productEdges.size() + p.effectorEdges.size());
                this.successRatio = this.properlyOrientedEdgeCount / this.totalEdgeCountToBeOriented;
            }
            p.transferForces();
            p.resetForces();
            p.inputPort.resetForces();
            p.outputPort.resetForces();
        }
        if (this.totalIterations % SbgnPDConstants.ROTATIONAL_FORCE_ITERATION_COUNT == 0 && this.phaseNumber == 2) {
            this.rotateAProcess();
        }
        super.moveNodes();
    }

    private boolean hasApproximationPeriodReached() {
        return this.totalIterations % 100 == SbgnPDConstants.APPROXIMATION_PERIOD;
    }

    private void rotateAProcess() {
        ArrayList<SbgnProcessNode> processNodesToBeRotated = new ArrayList<SbgnProcessNode>();
        for (SbgnProcessNode p : this.processNodeList) {
            if (!p.isRotationNecessary()) continue;
            processNodesToBeRotated.add(p);
        }
        if (processNodesToBeRotated.size() > 0) {
            SbgnProcessNode p;
            int randomIndex = 0;
            if (this.rotationRandomizationMethod == 0) {
                randomIndex = this.rouletteWheelSelection(processNodesToBeRotated);
                if (randomIndex == -1) {
                    System.out.println("ERROR: no nodes have been selected for rotation");
                }
            } else {
                randomIndex = (int)(Math.random() * (double)processNodesToBeRotated.size());
            }
            p = processNodesToBeRotated.get(randomIndex);
            p.applyRotation();
        }
    }

    private void finalEnhancement() {
        SbgnProcessNode.Orientation bestOrientation = null;
        double stepAppropriateEdgeCnt = 0.0;
        double totalProperEdges = 0.0;
        ArrayList<SbgnProcessNode.Orientation> orientationList = new ArrayList<SbgnProcessNode.Orientation>();
        orientationList.add(SbgnProcessNode.Orientation.LEFT_TO_RIGHT);
        orientationList.add(SbgnProcessNode.Orientation.RIGHT_TO_LEFT);
        orientationList.add(SbgnProcessNode.Orientation.TOP_TO_BOTTOM);
        orientationList.add(SbgnProcessNode.Orientation.BOTTOM_TO_TOP);
        for (SbgnProcessNode p : this.processNodeList) {
            int i;
            double bestStepResult = p.properEdgeCount;
            bestOrientation = null;
            ArrayList<Boolean> rememberPropList = new ArrayList<Boolean>();
            ArrayList bestPropList = new ArrayList();
            for (SbgnProcessNode.Orientation orient : orientationList) {
                double angle;
                SbgnPDNode node;
                stepAppropriateEdgeCnt = 0.0;
                PointD inputPortTarget = p.findPortTargetPoint(true, orient);
                PointD outputPortTarget = p.findPortTargetPoint(false, orient);
                rememberPropList = new ArrayList();
                for (SbgnPDEdge edge : p.consumptionEdges) {
                    node = (SbgnPDNode)edge.getSource();
                    angle = IGeometry.calculateAngle(inputPortTarget, p.inputPort.getCenter(), node.getCenter());
                    if (angle <= 100.0) {
                        stepAppropriateEdgeCnt += 1.0;
                        rememberPropList.add(true);
                        continue;
                    }
                    rememberPropList.add(false);
                }
                for (SbgnPDEdge edge : p.productEdges) {
                    node = (SbgnPDNode)edge.getTarget();
                    angle = IGeometry.calculateAngle(outputPortTarget, p.outputPort.getCenter(), node.getCenter());
                    if (angle <= 100.0) {
                        stepAppropriateEdgeCnt += 1.0;
                        rememberPropList.add(true);
                        continue;
                    }
                    rememberPropList.add(false);
                }
                for (SbgnPDEdge edge : p.effectorEdges) {
                    node = (SbgnPDNode)edge.getSource();
                    angle = this.calcEffectorAngle(orient, p.getCenter(), node);
                    if (angle <= 45.0) {
                        stepAppropriateEdgeCnt += 1.0;
                        rememberPropList.add(true);
                        continue;
                    }
                    rememberPropList.add(false);
                }
                if (!(stepAppropriateEdgeCnt > bestStepResult)) continue;
                bestStepResult = stepAppropriateEdgeCnt;
                bestOrientation = orient;
                bestPropList = rememberPropList;
            }
            totalProperEdges += bestStepResult;
            if (!(bestStepResult > p.properEdgeCount)) continue;
            p.setOrientation(bestOrientation);
            p.properEdgeCount = bestStepResult;
            for (i = 0; i < p.consumptionEdges.size(); ++i) {
                p.consumptionEdges.get((int)i).isProperlyOriented = (Boolean)bestPropList.get(i);
            }
            for (i = 0; i < p.productEdges.size(); ++i) {
                p.productEdges.get((int)i).isProperlyOriented = (Boolean)bestPropList.get(i + p.consumptionEdges.size());
            }
            for (i = 0; i < p.effectorEdges.size(); ++i) {
                p.effectorEdges.get((int)i).isProperlyOriented = (Boolean)bestPropList.get(i + (p.consumptionEdges.size() + p.productEdges.size()));
            }
        }
        this.properlyOrientedEdgeCount = totalProperEdges;
        this.enhancedRatio = totalProperEdges / this.totalEdgeCountToBeOriented;
        for (SbgnProcessNode p : this.processNodeList) {
            this.totalEffCount += p.effectorEdges.size();
        }
    }

    private int rouletteWheelSelection(ArrayList<SbgnProcessNode> processNodesToBeRotated) {
        double randomNumber = Math.random();
        double[] fitnessValues = new double[processNodesToBeRotated.size()];
        double totalSum = 0.0;
        double sumOfProbabilities = 0.0;
        int i = 0;
        for (SbgnProcessNode p : processNodesToBeRotated) {
            totalSum += Math.abs(p.netRotationalForce);
        }
        for (SbgnProcessNode p : processNodesToBeRotated) {
            fitnessValues[i] = sumOfProbabilities + Math.abs(p.netRotationalForce) / totalSum;
            sumOfProbabilities = fitnessValues[i];
            ++i;
        }
        if (randomNumber < fitnessValues[0]) {
            return 0;
        }
        for (int j = 0; j < fitnessValues.length - 1; ++j) {
            if (!(randomNumber >= fitnessValues[j]) || !(randomNumber < fitnessValues[j + 1])) continue;
            return j + 1;
        }
        return -1;
    }

    private double calcEffectorAngle(SbgnProcessNode.Orientation orient, PointD centerPt, CoSENode eff) {
        PointD targetPnt = new PointD();
        PointD centerPnt = centerPt;
        if (orient.equals((Object)SbgnProcessNode.Orientation.LEFT_TO_RIGHT) || orient.equals((Object)SbgnProcessNode.Orientation.RIGHT_TO_LEFT)) {
            targetPnt.x = centerPnt.x;
            targetPnt.y = eff.getCenterY() > centerPnt.y ? centerPnt.y + this.idealEdgeLength : centerPnt.y - this.idealEdgeLength;
        } else if (orient.equals((Object)SbgnProcessNode.Orientation.BOTTOM_TO_TOP) || orient.equals((Object)SbgnProcessNode.Orientation.TOP_TO_BOTTOM)) {
            targetPnt.y = centerPnt.y;
            targetPnt.x = eff.getCenterX() > centerPnt.x ? centerPnt.x + this.idealEdgeLength : centerPnt.x - this.idealEdgeLength;
        }
        double angle = IGeometry.calculateAngle(targetPnt, centerPnt, eff.getCenter());
        return angle;
    }

    private int calcGraphDegree(SbgnPDNode parentNode) {
        int degree = 0;
        if (parentNode.getChild() == null) {
            degree = parentNode.getEdges().size();
            return degree;
        }
        for (Object o : parentNode.getChild().getNodes()) {
            degree = degree + parentNode.getEdges().size() + this.calcGraphDegree((SbgnPDNode)o);
        }
        return degree;
    }

    private void recalcProperlyOrientedEdges(boolean isLastIteration) {
        this.properlyOrientedEdgeCount = 0.0;
        this.totalEdgeCountToBeOriented = 0.0;
        for (SbgnProcessNode p : this.processNodeList) {
            p.calcProperlyOrientedEdges();
            this.properlyOrientedEdgeCount += p.properEdgeCount;
            this.totalEdgeCountToBeOriented += (double)(p.consumptionEdges.size() + p.productEdges.size() + p.effectorEdges.size());
            this.successRatio = this.properlyOrientedEdgeCount / this.totalEdgeCountToBeOriented;
        }
    }

    private void groupZeroDegreeMembers() {
        HashMap<SbgnPDNode, LGraph> childComplexMap = new HashMap<SbgnPDNode, LGraph>();
        for (Object graphObj : this.getGraphManager().getGraphs()) {
            ArrayList<SbgnPDNode> zeroDegreeNodes = new ArrayList<SbgnPDNode>();
            LGraph ownerGraph = (LGraph)graphObj;
            if (ownerGraph.getParent().type != null && ((SbgnPDNode)ownerGraph.getParent()).isComplex()) continue;
            for (Object nodeObj : ownerGraph.getNodes()) {
                SbgnPDNode node = (SbgnPDNode)nodeObj;
                if (this.calcGraphDegree(node) != 0) continue;
                zeroDegreeNodes.add(node);
            }
            if (zeroDegreeNodes.size() <= 1) continue;
            SbgnPDNode complex2 = (SbgnPDNode)this.newNode(null);
            complex2.type = "complex";
            complex2.label = "DummyComplex_" + ownerGraph.getParent().label;
            ownerGraph.add(complex2);
            LGraph childGraph = this.newGraph(null);
            for (SbgnPDNode zeroNode : zeroDegreeNodes) {
                ownerGraph.remove(zeroNode);
                childGraph.add(zeroNode);
            }
            this.dummyComplexList.add(complex2);
            childComplexMap.put(complex2, childGraph);
        }
        for (SbgnPDNode complex3 : this.dummyComplexList) {
            this.graphManager.add((LGraph)childComplexMap.get(complex3), complex3);
        }
        this.getGraphManager().updateBounds();
        this.graphManager.resetAllNodes();
        this.graphManager.resetAllNodesToApplyGravitation();
        this.graphManager.resetAllEdges();
        this.calculateNodesToApplyGravitationTo();
    }

    private void createPortNodes() {
        for (Object o : this.getAllNodes()) {
            SbgnPDNode originalProcessNode = (SbgnPDNode)o;
            if (!originalProcessNode.type.equals("process")) continue;
            LGraph ownerGraph = originalProcessNode.getOwner();
            SbgnProcessNode processNode = (SbgnProcessNode)this.newProcessNode(null);
            SbgnPDNode inputPort = (SbgnPDNode)this.newPortNode(null, "input_port");
            SbgnPDNode outputPort = (SbgnPDNode)this.newPortNode(null, "output_port");
            SbgnPDNode compoundNode = (SbgnPDNode)this.newNode(null);
            compoundNode.type = "dummy compound";
            compoundNode.label = "DummyCompound_" + originalProcessNode.label;
            inputPort.label = "InputPort_" + originalProcessNode.label;
            outputPort.label = "OutputPort_" + originalProcessNode.label;
            LGraph childGraph = this.newGraph(null);
            ownerGraph.add(processNode);
            processNode.copyFromSBGNPDNode(originalProcessNode, this.getGraphManager());
            processNode.connectNodes(compoundNode, inputPort, outputPort);
            processNode.reconnectEdges(this.idealEdgeLength);
            SbgnPDEdge rigidToProduction = (SbgnPDEdge)this.newRigidEdge(null);
            rigidToProduction.label = "" + (this.graphManager.getAllEdges().length + 1);
            SbgnPDEdge rigidToConsumption = (SbgnPDEdge)this.newRigidEdge(null);
            rigidToConsumption.label = "" + (this.graphManager.getAllEdges().length + 2);
            ownerGraph.remove(processNode);
            childGraph.add(processNode);
            childGraph.add(inputPort);
            childGraph.add(outputPort);
            childGraph.add(rigidToProduction, inputPort, processNode);
            childGraph.add(rigidToConsumption, outputPort, processNode);
            compoundNode.setOwner(ownerGraph);
            compoundNode.setCenter(processNode.getCenterX(), processNode.getCenterY());
            ownerGraph.add(compoundNode);
            this.graphManager.add(childGraph, compoundNode);
            ownerGraph.remove(originalProcessNode);
            this.processNodeList.add(processNode);
            this.graphManager.updateBounds();
        }
        this.graphManager.resetAllNodes();
        this.graphManager.resetAllNodesToApplyGravitation();
        this.graphManager.resetAllEdges();
        this.calculateNodesToApplyGravitationTo();
    }

    private boolean arePortNodesCreated() {
        boolean flag = false;
        for (Object o : this.getAllNodes()) {
            SbgnPDNode s = (SbgnPDNode)o;
            if (!s.type.equals("process")) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return true;
        }
        for (Object o : this.getAllNodes()) {
            if (!((SbgnPDNode)o).type.equals("input_port") && !((SbgnPDNode)o).type.equals("output_port")) continue;
            return true;
        }
        return false;
    }

    private void removeDummyCompounds() {
        for (SbgnProcessNode processNode : this.processNodeList) {
            SbgnPDNode dummyNode = processNode.parentCompound;
            LGraph childGraph = dummyNode.getChild();
            LGraph owner = dummyNode.getOwner();
            for (Object s : childGraph.getNodes()) {
                owner.add((SbgnPDNode)s);
            }
            for (Object e : childGraph.getEdges()) {
                SbgnPDEdge edge = (SbgnPDEdge)e;
                owner.add(edge, edge.getSource(), edge.getTarget());
            }
            for (int i = 0; i < dummyNode.getEdges().size(); ++i) {
                SbgnPDEdge edge = (SbgnPDEdge)dummyNode.getEdges().get(i);
                dummyNode.getEdges().remove(edge);
                edge.setTarget(processNode);
                processNode.getEdges().add(edge);
                --i;
            }
            this.getGraphManager().getGraphs().remove(childGraph);
            dummyNode.setChild(null);
            owner.remove(dummyNode);
        }
        this.getGraphManager().resetAllNodes();
        this.getGraphManager().resetAllNodesToApplyGravitation();
        this.getGraphManager().resetAllEdges();
        this.calculateNodesToApplyGravitationTo();
    }

    private void clearComplex(SbgnPDNode comp) {
        MemberPack pack = null;
        LGraph childGr = comp.getChild();
        this.childGraphMap.put(comp, childGr);
        if (childGr == null) {
            return;
        }
        if (this.compactionMethod == DefaultCompactionAlgorithm.POLYOMINO_PACKING) {
            this.applyPolyomino(comp);
        } else if (this.compactionMethod == DefaultCompactionAlgorithm.TILING) {
            pack = new MemberPack(childGr);
            this.memberPackMap.put(comp, pack);
        }
        if (this.dummyComplexList.contains(comp)) {
            for (Object o : comp.getChild().getNodes()) {
                this.clearDummyComplexGraphs((SbgnPDNode)o);
            }
        }
        this.getGraphManager().getGraphs().remove(childGr);
        comp.setChild(null);
        if (this.compactionMethod == DefaultCompactionAlgorithm.TILING) {
            comp.setWidth(pack.getWidth());
            comp.setHeight(pack.getHeight());
        }
        if (childGr != null) {
            for (Object ch : childGr.getNodes()) {
                SbgnPDNode chNd = (SbgnPDNode)ch;
                for (Object obj : new ArrayList(chNd.getEdges())) {
                    LEdge edge = (LEdge)obj;
                    if (edge.getSource() == chNd) {
                        chNd.getEdges().remove(edge);
                        edge.setSource(comp);
                        comp.getEdges().add(edge);
                        continue;
                    }
                    if (edge.getTarget() != chNd) continue;
                    chNd.getEdges().remove(edge);
                    edge.setTarget(comp);
                    comp.getEdges().add(edge);
                }
            }
        }
    }

    private void applyDFSOnComplexes() {
        for (Object o : this.getAllNodes()) {
            if (!(o instanceof SbgnPDNode) || !((SbgnPDNode)o).isComplex()) continue;
            SbgnPDNode comp = (SbgnPDNode)o;
            if (comp.visited) continue;
            this.DFSVisitComplex(comp);
        }
        for (SbgnPDNode o : this.complexOrder) {
            this.clearComplex(o);
        }
        this.getGraphManager().updateBounds();
        this.getGraphManager().resetAllNodes();
        this.getGraphManager().resetAllNodesToApplyGravitation();
        this.getGraphManager().resetAllEdges();
    }

    private void DFSVisitComplex(SbgnPDNode node) {
        if (node.getChild() != null) {
            for (Object n : node.getChild().getNodes()) {
                SbgnPDNode sbgnChild = (SbgnPDNode)n;
                this.DFSVisitComplex(sbgnChild);
            }
        }
        if (node.isComplex() && !node.containsUnmarkedComplex()) {
            this.complexOrder.add(node);
            node.visited = true;
            return;
        }
    }

    private void applyPolyomino(SbgnPDNode parent) {
        LGraph childGr = parent.getChild();
        if (childGr == null) {
            log.info("Child graph is empty (Polyomino)");
        } else {
            SbgnPDNode[] mpArray = new SbgnPDNode[childGr.getNodes().size()];
            for (int i = 0; i < childGr.getNodes().size(); ++i) {
                SbgnPDNode s;
                mpArray[i] = s = (SbgnPDNode)childGr.getNodes().get(i);
            }
            RectProc.packRectanglesMino(5.0, mpArray.length, mpArray);
            Compaction c = new Compaction((ArrayList)childGr.getNodes());
            c.perform();
            RectangleD r = this.calculateBounds(true, (ArrayList)childGr.getNodes());
            parent.setWidth(r.getWidth());
            parent.setHeight(r.getHeight());
        }
    }

    protected void repopulateComplexes() {
        LGraph chGr;
        for (SbgnPDNode comp : this.emptiedDummyComplexMap.keySet()) {
            chGr = this.emptiedDummyComplexMap.get(comp);
            comp.setChild(chGr);
            this.getGraphManager().getGraphs().add(chGr);
        }
        for (int i = this.complexOrder.size() - 1; i >= 0; --i) {
            SbgnPDNode comp;
            comp = this.complexOrder.get(i);
            chGr = this.childGraphMap.get(comp);
            comp.setChild(chGr);
            if (chGr == null) continue;
            if (this.compactionMethod == DefaultCompactionAlgorithm.POLYOMINO_PACKING) {
                this.adjustLocation(comp, chGr);
                this.getGraphManager().getGraphs().add(chGr);
                continue;
            }
            if (this.compactionMethod != DefaultCompactionAlgorithm.TILING) continue;
            this.getGraphManager().getGraphs().add(chGr);
            MemberPack pack = this.memberPackMap.get(comp);
            pack.adjustLocations(comp.getLeft(), comp.getTop());
        }
        for (SbgnPDNode comp : this.emptiedDummyComplexMap.keySet()) {
            chGr = this.emptiedDummyComplexMap.get(comp);
            this.adjustLocation(comp, chGr);
        }
        this.removeDummyComplexes();
        this.getGraphManager().resetAllNodes();
        this.getGraphManager().resetAllNodesToApplyGravitation();
        this.getGraphManager().resetAllEdges();
        this.calculateNodesToApplyGravitationTo();
    }

    private void adjustLocation(SbgnPDNode comp, LGraph chGr) {
        RectangleD rect = this.calculateBounds(false, (ArrayList)chGr.getNodes());
        int differenceX = (int)(rect.x - comp.getLeft());
        int differenceY = (int)(rect.y - comp.getTop());
        if (!comp.type.equals("complex")) {
            differenceX -= 5;
            differenceY -= 5;
        }
        for (int j = 0; j < chGr.getNodes().size(); ++j) {
            SbgnPDNode s = (SbgnPDNode)chGr.getNodes().get(j);
            s.setLocation(s.getLeft() - (double)differenceX + 5.0, s.getTop() - (double)differenceY + 5.0);
            if (s.getChild() == null) continue;
            this.adjustLocation(s, s.getChild());
        }
    }

    private void clearDummyComplexGraphs(SbgnPDNode comp) {
        if (comp.getChild() == null || comp.isDummyCompound) {
            return;
        }
        for (Object o : comp.getChild().getNodes()) {
            SbgnPDNode childNode = (SbgnPDNode)o;
            if (childNode.getChild() == null || childNode.getEdges().size() != 0) continue;
            this.clearDummyComplexGraphs(childNode);
        }
        if (this.graphManager.getGraphs().contains(comp.getChild()) && this.calcGraphDegree(comp) == 0) {
            this.emptiedDummyComplexMap.put(comp, comp.getChild());
            this.getGraphManager().getGraphs().remove(comp.getChild());
            comp.setChild(null);
        }
    }

    private void removeDummyComplexes() {
        for (SbgnPDNode dummyComplex : this.dummyComplexList) {
            LGraph childGraph = dummyComplex.getChild();
            LGraph owner = dummyComplex.getOwner();
            this.getGraphManager().getGraphs().remove(childGraph);
            dummyComplex.setChild(null);
            owner.remove(dummyComplex);
            for (Object s : childGraph.getNodes()) {
                owner.add((SbgnPDNode)s);
            }
        }
    }

    protected RectangleD calculateBounds(boolean isMarginIncluded, ArrayList<SbgnPDNode> nodes) {
        int boundLeft = Integer.MAX_VALUE;
        int boundRight = Integer.MIN_VALUE;
        int boundTop = Integer.MAX_VALUE;
        int boundBottom = Integer.MIN_VALUE;
        for (LNode lNode : nodes) {
            int nodeLeft = (int)lNode.getLeft();
            int nodeRight = (int)lNode.getRight();
            int nodeTop = (int)lNode.getTop();
            int nodeBottom = (int)lNode.getBottom();
            if (boundLeft > nodeLeft) {
                boundLeft = nodeLeft;
            }
            if (boundRight < nodeRight) {
                boundRight = nodeRight;
            }
            if (boundTop > nodeTop) {
                boundTop = nodeTop;
            }
            if (boundBottom >= nodeBottom) continue;
            boundBottom = nodeBottom;
        }
        if (isMarginIncluded) {
            return new RectangleD(boundLeft - 20, boundTop - 20, boundRight - boundLeft + 40, boundBottom - boundTop + 40);
        }
        return new RectangleD(boundLeft, boundTop, boundRight - boundLeft, boundBottom - boundTop);
    }

    protected void calculateFullnessOfComplexes() {
        LNode largestComplex = null;
        double totalArea = 0.0;
        double usedArea = 0.0;
        double maxArea = Double.MIN_VALUE;
        for (int i = 0; i < this.getAllNodes().length; ++i) {
            SbgnPDNode s = (SbgnPDNode)this.getAllNodes()[i];
            if (!s.type.equals("complex") || !(s.getWidth() * s.getHeight() > maxArea)) continue;
            maxArea = s.getWidth() * s.getHeight();
            largestComplex = s;
        }
        usedArea = this.calculateUsedArea((SbgnPDNode)largestComplex);
        totalArea = largestComplex.getWidth() * largestComplex.getHeight();
        if (this.compactionMethod == DefaultCompactionAlgorithm.TILING) {
            log.info("Tiling results");
        } else if (this.compactionMethod == DefaultCompactionAlgorithm.POLYOMINO_PACKING) {
            log.info("Polyomino Packing results");
        }
        log.info(" = " + usedArea / totalArea);
    }

    protected double calculateUsedArea(SbgnPDNode parent) {
        int totalArea = 0;
        if (parent.getChild() == null) {
            return 0.0;
        }
        for (int i = 0; i < parent.getChild().getNodes().size(); ++i) {
            SbgnPDNode node = (SbgnPDNode)parent.getChild().getNodes().get(i);
            totalArea = !node.type.equalsIgnoreCase("complex") ? (int)((double)totalArea + node.getWidth() * node.getHeight()) : (int)((double)totalArea + this.calculateUsedArea(node));
        }
        return totalArea;
    }

    @Override
    public LNode newNode(Object vNode) {
        return new SbgnPDNode(this.graphManager, vNode);
    }

    @Override
    public LEdge newEdge(Object vEdge) {
        return new SbgnPDEdge(null, null, vEdge);
    }

    @Override
    public boolean layout() {
        boolean b = false;
        this.groupZeroDegreeMembers();
        this.applyDFSOnComplexes();
        b = super.layout();
        this.repopulateComplexes();
        this.getAllNodes();
        return b;
    }

    @Override
    protected boolean classicLayout() {
        this.calculateNodesToApplyGravitationTo();
        this.graphManager.calcLowestCommonAncestors();
        this.graphManager.calcInclusionTreeDepths();
        this.graphManager.getRoot().calcEstimatedSize();
        this.calcIdealEdgeLengths();
        if (!this.incremental) {
            List<List<LNode>> forest = this.getFlatForest();
            if (forest.size() > 0) {
                this.positionNodesRadially(forest);
            } else {
                this.positionNodesRandomly();
            }
        }
        if (!this.arePortNodesCreated()) {
            this.createPortNodes();
            this.graphManager.resetAllNodes();
            this.graphManager.resetAllNodesToApplyGravitation();
            this.graphManager.resetAllEdges();
            this.calculateNodesToApplyGravitationTo();
        }
        this.initSpringEmbedder();
        this.runSpringEmbedder();
        return true;
    }

    @Override
    public void calcSpringForces() {
        Object[] lEdges = this.getAllEdges();
        for (int i = 0; i < lEdges.length; ++i) {
            FDLayoutEdge edge = (FDLayoutEdge)lEdges[i];
            if (edge.type.equals("rigid edge")) continue;
            this.calcSpringForce(edge, edge.idealLength);
        }
    }

    @Override
    public void calcRepulsionForces() {
        Object[] lNodes = this.getAllNodes();
        if (this.useFRGridVariant) {
            FDLayoutNode nodeA;
            int i;
            if (this.totalIterations % 10 == 1) {
                this.grid = this.calcGrid(this.graphManager.getRoot());
                for (i = 0; i < lNodes.length; ++i) {
                    nodeA = (FDLayoutNode)lNodes[i];
                    this.addNodeToGrid(nodeA, this.grid, this.graphManager.getRoot().getLeft(), this.graphManager.getRoot().getTop());
                }
            }
            HashSet<FDLayoutNode> processedNodeSet = new HashSet<FDLayoutNode>();
            for (i = 0; i < lNodes.length; ++i) {
                nodeA = (FDLayoutNode)lNodes[i];
                this.calculateRepulsionForceOfANode(this.grid, nodeA, processedNodeSet);
                processedNodeSet.add(nodeA);
            }
        } else {
            for (int i = 0; i < lNodes.length; ++i) {
                FDLayoutNode nodeA = (FDLayoutNode)lNodes[i];
                for (int j = i + 1; j < lNodes.length; ++j) {
                    FDLayoutNode nodeB = (FDLayoutNode)lNodes[j];
                    if (nodeA.getOwner() != nodeB.getOwner() || nodeA.type != null && nodeB.type != null && nodeA.getOwner().equals(nodeB.getOwner()) && (nodeA.type.equals("input_port") || nodeA.type.equals("output_port") || nodeB.type.equals("input_port") || nodeB.type.equals("output_port"))) continue;
                    this.calcRepulsionForce(nodeA, nodeB);
                }
            }
        }
    }

    @Override
    protected void calculateRepulsionForceOfANode(Vector[][] grid, FDLayoutNode nodeA, HashSet<FDLayoutNode> processedNodeSet) {
        int i;
        if (this.totalIterations % 10 == 1) {
            HashSet<FDLayoutNode> surrounding = new HashSet<FDLayoutNode>();
            for (i = nodeA.startX - 1; i < nodeA.finishX + 2; ++i) {
                for (int j = nodeA.startY - 1; j < nodeA.finishY + 2; ++j) {
                    if (i < 0 || j < 0 || i >= grid.length || j >= grid[0].length) continue;
                    for (Object obj : grid[i][j]) {
                        FDLayoutNode nodeB = (FDLayoutNode)obj;
                        if (nodeA.getOwner() != nodeB.getOwner() || nodeA == nodeB || nodeA.type != null && nodeB.type != null && nodeA.getOwner().equals(nodeB.getOwner()) && (nodeA.type.equals("input_port") || nodeA.type.equals("output_port") || nodeB.type.equals("input_port") || nodeB.type.equals("output_port")) || processedNodeSet.contains(nodeB) || surrounding.contains(nodeB)) continue;
                        double distanceX = Math.abs(nodeA.getCenterX() - nodeB.getCenterX()) - (nodeA.getWidth() / 2.0 + nodeB.getWidth() / 2.0);
                        double distanceY = Math.abs(nodeA.getCenterY() - nodeB.getCenterY()) - (nodeA.getHeight() / 2.0 + nodeB.getHeight() / 2.0);
                        if (!(distanceX <= this.repulsionRange) || !(distanceY <= this.repulsionRange)) continue;
                        surrounding.add(nodeB);
                    }
                }
            }
            nodeA.surrounding = surrounding.toArray();
        }
        for (i = 0; i < nodeA.surrounding.length; ++i) {
            this.calcRepulsionForce(nodeA, (FDLayoutNode)nodeA.surrounding[i]);
        }
    }

    public LNode newPortNode(Object vNode, String type) {
        SbgnPDNode n = new SbgnPDNode(this.graphManager, vNode);
        n.type = type;
        n.setWidth(3.0);
        n.setHeight(3.0);
        return n;
    }

    public LNode newProcessNode(Object vNode) {
        return new SbgnProcessNode(this.graphManager, vNode);
    }

    public LEdge newRigidEdge(Object vEdge) {
        SbgnPDEdge e = new SbgnPDEdge(null, null, vEdge);
        e.type = "rigid edge";
        return e;
    }

    public static enum DefaultCompactionAlgorithm {
        TILING,
        POLYOMINO_PACKING;

    }
}

