/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.xml2tab;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.converter.IdentifierGenerator;
import psidev.psi.mi.tab.converter.tab2xml.InteractorNameBuilder;
import psidev.psi.mi.tab.converter.tab2xml.InteractorUniprotIdBuilder;
import psidev.psi.mi.tab.converter.tab2xml.XmlConversionException;
import psidev.psi.mi.tab.converter.xml2tab.CvConverter;
import psidev.psi.mi.tab.converter.xml2tab.RangeUtils;
import psidev.psi.mi.tab.converter.xml2tab.TabConversionException;
import psidev.psi.mi.tab.converter.xml2tab.XrefUtils;
import psidev.psi.mi.tab.model.AliasImpl;
import psidev.psi.mi.tab.model.Annotation;
import psidev.psi.mi.tab.model.AnnotationImpl;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.Checksum;
import psidev.psi.mi.tab.model.ChecksumImpl;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.CrossReferenceImpl;
import psidev.psi.mi.tab.model.FeatureImpl;
import psidev.psi.mi.tab.model.OrganismImpl;
import psidev.psi.mi.xml.model.Alias;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.BiologicalRole;
import psidev.psi.mi.xml.model.DbReference;
import psidev.psi.mi.xml.model.ExperimentalRole;
import psidev.psi.mi.xml.model.Feature;
import psidev.psi.mi.xml.model.FeatureType;
import psidev.psi.mi.xml.model.Interactor;
import psidev.psi.mi.xml.model.InteractorType;
import psidev.psi.mi.xml.model.Names;
import psidev.psi.mi.xml.model.Organism;
import psidev.psi.mi.xml.model.Participant;
import psidev.psi.mi.xml.model.ParticipantIdentificationMethod;
import psidev.psi.mi.xml.model.Xref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InteractorConverter<T extends psidev.psi.mi.tab.model.Interactor> {
    public static final String IDENTITY = "identity";
    public static final String IDENTITY_REF = "MI:0356";
    public static final String SOURCE_REFERENCE = "source reference";
    public static final String SOURCE_REFERENCE_REF = "MI:0685";
    public static final String UNIPROT = "uniprotkb";
    public static final String UNIPROT_MI = "MI:0486";
    public static final String INTACT = "intact";
    public static final String INTACT_MI = "MI:0469";
    public static final String CHEBI = "chebi";
    public static final String CHEBI_MI = "MI:0474";
    public static final String PSIMI = "psi-mi";
    public static final String PSIMI_MI = "MI:0488";
    public static final String UNKNOWN = "unknown";
    private static final List<String> uniprotKeys = new ArrayList<String>(Arrays.asList("gene name", "gene name synonym", "isoform synonym", "locus name", "ordered locus name", "open reading frame name"));
    private static final List<String> checksumNames = new ArrayList<String>(Arrays.asList("checksum", "smiles string", "standard inchi", "inchi key", "standard inchi key", "rogid", "rigid", "crogid", "crc"));
    public static final String SHORT_LABEL = "shortLabel";
    private static final String FULL_NAME = "fullName";
    @Deprecated
    private CrossReference overrideAliasSourceDatabase;
    public static final Log log = LogFactory.getLog(InteractorConverter.class);
    private CvConverter cvConverter = new CvConverter();
    private InteractorNameBuilder interactorNameBuilder;

    private CrossReference buildCrossReference(DbReference ref) {
        return new CrossReferenceImpl(ref.getDb(), ref.getId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public psidev.psi.mi.tab.model.Interactor toMitab(Participant xmlParticipant) throws TabConversionException {
        String text;
        String name;
        CrossReference cr;
        if (xmlParticipant == null) {
            throw new IllegalArgumentException("Participant must not be null");
        }
        Interactor xmlInteractor = xmlParticipant.getInteractor();
        if (xmlInteractor == null) {
            throw new IllegalArgumentException("Interactor must not be null");
        }
        ArrayList<CrossReference> identifiers = new ArrayList<CrossReference>();
        ArrayList<CrossReference> altIdentifiers = new ArrayList<CrossReference>();
        ArrayList<CrossReference> xrefs = new ArrayList<CrossReference>();
        if (xmlInteractor.getXref() != null) {
            CrossReference cr2;
            Collection<DbReference> identityRefs = XrefUtils.searchByType(xmlInteractor.getXref(), IDENTITY, IDENTITY_REF);
            if (!identityRefs.isEmpty()) {
                CrossReference primaryIdentifier = this.selectBestIdentfier(identityRefs);
                if (primaryIdentifier != null) {
                    identifiers.add(primaryIdentifier);
                }
                for (DbReference ref : identityRefs) {
                    cr = this.buildCrossReference(ref);
                    if (altIdentifiers.contains(cr)) continue;
                    altIdentifiers.add(cr);
                }
                altIdentifiers.remove(primaryIdentifier);
                List<DbReference> allRefs = XrefUtils.getAllDbReferences(xmlInteractor.getXref());
                if (allRefs != null) {
                    for (DbReference ref : allRefs) {
                        if (ref.hasRefType() && (!ref.hasRefType() || ref.getRefType().equalsIgnoreCase(IDENTITY)) || xrefs.contains(cr2 = this.buildCrossReference(ref))) continue;
                        xrefs.add(cr2);
                    }
                }
            } else {
                List<DbReference> allRefs = XrefUtils.getAllDbReferences(xmlInteractor.getXref());
                if (identifiers.isEmpty() && !allRefs.isEmpty()) {
                    allRefs = XrefUtils.sortByIdentifier(allRefs);
                    CrossReference primaryIdentifier = this.buildCrossReference(allRefs.iterator().next());
                    identifiers.add(primaryIdentifier);
                    for (DbReference ref : allRefs) {
                        cr2 = this.buildCrossReference(ref);
                        if (xrefs.contains(cr2)) continue;
                        xrefs.add(cr2);
                    }
                    xrefs.remove(primaryIdentifier);
                }
            }
            if (identifiers.isEmpty()) {
                throw new TabConversionException("Could not find any identifiers for interactor " + xmlInteractor.getId());
            }
        }
        T tabInteractor = this.newInteractor(identifiers);
        if (!altIdentifiers.isEmpty()) {
            ((psidev.psi.mi.tab.model.Interactor)tabInteractor).setAlternativeIdentifiers(altIdentifiers);
        }
        if (!xrefs.isEmpty()) {
            ((psidev.psi.mi.tab.model.Interactor)tabInteractor).setXrefs(xrefs);
        }
        if (xmlInteractor.getNames() != null) {
            String fullName;
            String shortLabel;
            ArrayList<psidev.psi.mi.tab.model.Alias> tabAliases = new ArrayList<psidev.psi.mi.tab.model.Alias>();
            Collection<Alias> aliases = xmlInteractor.getNames().getAliases();
            if (aliases != null) {
                for (Alias alias : aliases) {
                    String aliasValue = alias.getValue();
                    if (aliasValue != null && aliasValue.trim().length() > 0) {
                        String db = uniprotKeys.contains(alias.getType()) ? UNIPROT : UNKNOWN;
                        AliasImpl a = new AliasImpl(db, aliasValue);
                        a.setAliasType(alias.getType());
                        tabAliases.add(a);
                        continue;
                    }
                    log.warn("Found alias without value. Ignoring alias");
                }
            }
            if ((shortLabel = xmlInteractor.getNames().getShortLabel()) != null) {
                AliasImpl a = new AliasImpl(UNKNOWN, shortLabel);
                a.setAliasType(SHORT_LABEL);
                tabAliases.add(a);
            }
            if ((fullName = xmlInteractor.getNames().getFullName()) != null) {
                AliasImpl a = new AliasImpl(UNKNOWN, fullName);
                a.setAliasType(FULL_NAME);
                tabAliases.add(a);
            }
            if (!tabAliases.isEmpty()) {
                ((psidev.psi.mi.tab.model.Interactor)tabInteractor).setAliases(tabAliases);
            }
        }
        if (xmlInteractor.hasOrganism()) {
            Organism o = xmlInteractor.getOrganism();
            ArrayList<CrossReference> organismXrefs = new ArrayList<CrossReference>();
            String taxId = String.valueOf(o.getNcbiTaxId());
            if (o.hasNames()) {
                String fullName;
                String shortLabel = o.getNames().getShortLabel();
                if (shortLabel != null) {
                    organismXrefs.add(new CrossReferenceImpl("taxid", taxId, shortLabel));
                }
                if ((fullName = o.getNames().getFullName()) != null && !shortLabel.equalsIgnoreCase(fullName)) {
                    organismXrefs.add(new CrossReferenceImpl("taxid", taxId, fullName));
                }
                if (shortLabel == null && fullName == null) {
                    organismXrefs.add(new CrossReferenceImpl("taxid", taxId));
                }
            } else {
                organismXrefs.add(new CrossReferenceImpl("taxid", taxId));
            }
            ((psidev.psi.mi.tab.model.Interactor)tabInteractor).setOrganism(new OrganismImpl(organismXrefs));
        }
        if (xmlParticipant.hasBiologicalRole()) {
            ArrayList<CrossReference> tabBioRole = new ArrayList<CrossReference>();
            BiologicalRole xmlBioRole = xmlParticipant.getBiologicalRole();
            cr = this.cvConverter.toMitab(xmlBioRole);
            if (cr != null) {
                tabBioRole.add(cr);
            }
            if (!tabBioRole.isEmpty()) {
                ((psidev.psi.mi.tab.model.Interactor)tabInteractor).setBiologicalRoles(tabBioRole);
            }
        }
        if (xmlParticipant.hasExperimentalRoles()) {
            ArrayList<CrossReference> tabExpRoles = new ArrayList<CrossReference>();
            Collection<ExperimentalRole> xmlExpRoles = xmlParticipant.getExperimentalRoles();
            for (ExperimentalRole xmlExpRole : xmlExpRoles) {
                CrossReference cr3 = this.cvConverter.toMitab(xmlExpRole);
                if (cr3 == null || tabExpRoles.contains(cr3)) continue;
                tabExpRoles.add(cr3);
            }
            if (!tabExpRoles.isEmpty()) {
                ((psidev.psi.mi.tab.model.Interactor)tabInteractor).setExperimentalRoles(tabExpRoles);
            }
        }
        if (xmlInteractor.getInteractorType() != null) {
            ArrayList<CrossReference> tabInteractorType = new ArrayList<CrossReference>();
            InteractorType xmlInteractorType = xmlInteractor.getInteractorType();
            cr = this.cvConverter.toMitab(xmlInteractorType);
            if (cr != null) {
                tabInteractorType.add(cr);
            }
            if (!tabInteractorType.isEmpty()) {
                ((psidev.psi.mi.tab.model.Interactor)tabInteractor).setInteractorTypes(tabInteractorType);
            }
        }
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        ArrayList<Checksum> checksums = new ArrayList<Checksum>();
        if (xmlInteractor.getAttributes() != null) {
            Collection<Attribute> xmlInteractorAttributes = xmlInteractor.getAttributes();
            for (Attribute xmlInteractorAttribute : xmlInteractorAttributes) {
                name = xmlInteractorAttribute.getName();
                text = xmlInteractorAttribute.getValue();
                if (checksumNames.contains(name.toLowerCase())) {
                    checksums.add(new ChecksumImpl(name, text));
                    continue;
                }
                annotations.add(new AnnotationImpl(name, text));
            }
        }
        if (xmlParticipant.getAttributes() != null) {
            Collection<Attribute> xmlParticipantAttributes = xmlParticipant.getAttributes();
            for (Attribute xmlParticipantAttribute : xmlParticipantAttributes) {
                name = xmlParticipantAttribute.getName();
                text = xmlParticipantAttribute.getValue();
                if (checksumNames.contains(name.toLowerCase())) {
                    checksums.add(new ChecksumImpl(name, text));
                    continue;
                }
                annotations.add(new AnnotationImpl(name, text));
            }
        }
        if (!annotations.isEmpty()) {
            ((psidev.psi.mi.tab.model.Interactor)tabInteractor).setAnnotations(annotations);
        }
        if (!checksums.isEmpty()) {
            ((psidev.psi.mi.tab.model.Interactor)tabInteractor).setChecksums(checksums);
        }
        if (xmlParticipant.getFeatures() != null) {
            Collection<Feature> xmlFeatures = xmlParticipant.getFeatures();
            ArrayList<psidev.psi.mi.tab.model.Feature> tabFeatures = new ArrayList<psidev.psi.mi.tab.model.Feature>();
            for (Feature xmlFeature : xmlFeatures) {
                String tabFeatureType;
                List<String> ranges = null;
                String text2 = null;
                if (xmlFeature.getRanges() != null && !xmlFeature.getRanges().isEmpty()) {
                    ranges = RangeUtils.toMitab(xmlFeature.getRanges());
                }
                if (!xmlFeature.hasFeatureType()) throw new TabConversionException("The feature need a feature type");
                FeatureType featureType = xmlFeature.getFeatureType();
                if (!featureType.hasNames()) throw new TabConversionException("The feature need a feature type");
                String shortLabel = featureType.getNames().getShortLabel();
                String fullName = featureType.getNames().getFullName();
                if (shortLabel != null) {
                    tabFeatureType = shortLabel;
                } else {
                    if (fullName == null) throw new TabConversionException("The feature need a feature type");
                    tabFeatureType = fullName;
                }
                if (xmlFeature.hasNames()) {
                    String shortLabel2 = xmlFeature.getNames().getShortLabel();
                    String fullName2 = xmlFeature.getNames().getFullName();
                    if (shortLabel2 != null) {
                        text2 = shortLabel2;
                    } else if (fullName2 != null) {
                        text2 = fullName2;
                    }
                }
                tabFeatures.add(new FeatureImpl(tabFeatureType, ranges, text2));
            }
            if (!tabFeatures.isEmpty()) {
                ((psidev.psi.mi.tab.model.Interactor)tabInteractor).setFeatures(tabFeatures);
            }
        }
        if (xmlParticipant.getAttributes() != null) {
            Collection<Attribute> attributes = xmlParticipant.getAttributes();
            ArrayList<Integer> tabStoichiometry = new ArrayList<Integer>();
            for (Attribute attribute : attributes) {
                if (!attribute.getName().equals("comment") && !attribute.getNameAc().equals("MI:0612") || attribute.getValue() == null || !attribute.getValue().contains("Stoichiometry:")) continue;
                String[] s = attribute.getValue().split(" ");
                try {
                    if (s.length != 2) continue;
                    Float st = Float.valueOf(Float.parseFloat(s[1]));
                    tabStoichiometry.add(st.intValue());
                }
                catch (NumberFormatException e) {
                    log.error("The stoichiometry can not be converted, " + attribute.toString(), e);
                }
            }
            if (!tabStoichiometry.isEmpty()) {
                ((psidev.psi.mi.tab.model.Interactor)tabInteractor).setStoichiometry(tabStoichiometry);
            }
        }
        if (xmlParticipant.getParticipantIdentificationMethods() == null) return tabInteractor;
        ArrayList<CrossReference> tabPartIdentMethods = new ArrayList<CrossReference>();
        Collection<ParticipantIdentificationMethod> xmlPartIdentMethodsRoles = xmlParticipant.getParticipantIdentificationMethods();
        for (ParticipantIdentificationMethod xmlPartIdentMethodsRole : xmlPartIdentMethodsRoles) {
            CrossReference cr4 = this.cvConverter.toMitab(xmlPartIdentMethodsRole);
            if (cr4 == null || tabPartIdentMethods.contains(cr4)) continue;
            tabPartIdentMethods.add(cr4);
        }
        if (tabPartIdentMethods.isEmpty()) return tabInteractor;
        ((psidev.psi.mi.tab.model.Interactor)tabInteractor).setParticipantIdentificationMethods(tabPartIdentMethods);
        return tabInteractor;
    }

    private CrossReference selectBestIdentfier(Collection<DbReference> identityRefs) {
        Iterator<DbReference> iterator = identityRefs.iterator();
        boolean found = false;
        CrossReference reference = null;
        while (iterator.hasNext() && !found) {
            DbReference ref = iterator.next();
            if (ref.getDb().equals(UNIPROT)) {
                found = true;
                reference = this.buildCrossReference(ref);
                continue;
            }
            if (ref.getDb().equals(CHEBI)) {
                found = true;
                reference = this.buildCrossReference(ref);
                continue;
            }
            if (!ref.getDb().equals(INTACT)) continue;
            found = true;
            reference = this.buildCrossReference(ref);
        }
        if (!found && !identityRefs.isEmpty()) {
            reference = this.buildCrossReference(identityRefs.iterator().next());
        }
        return reference;
    }

    protected T newInteractor(List<CrossReference> identifiers) {
        return (T)new psidev.psi.mi.tab.model.Interactor(identifiers);
    }

    public InteractorNameBuilder getInteractorNameBuilder() {
        return this.interactorNameBuilder;
    }

    public void setInteractorNameBuilder(InteractorNameBuilder interactorNameBuilder) {
        this.interactorNameBuilder = interactorNameBuilder;
    }

    public Interactor fromMitab(psidev.psi.mi.tab.model.Interactor tabInteractor) throws XmlConversionException {
        List<Checksum> checksums;
        Names interactorName;
        if (tabInteractor == null) {
            throw new IllegalArgumentException("Interactor must not be null");
        }
        Interactor xmlInteractor = new Interactor();
        xmlInteractor.setId(IdentifierGenerator.getInstance().nextId());
        if (this.interactorNameBuilder != null) {
            interactorName = this.interactorNameBuilder.select(tabInteractor);
        } else {
            log.debug("No InteractorNameBuilder choosen. default = " + InteractorUniprotIdBuilder.class);
            InteractorUniprotIdBuilder builder = new InteractorUniprotIdBuilder();
            interactorName = builder.select(tabInteractor);
        }
        if (interactorName != null) {
            xmlInteractor.setNames(interactorName);
        }
        if (tabInteractor.hasOrganism()) {
            CrossReference first;
            psidev.psi.mi.tab.model.Organism o = tabInteractor.getOrganism();
            Iterator<CrossReference> idIterator = o.getIdentifiers().iterator();
            String shortlabel = null;
            if (idIterator.hasNext() && (first = idIterator.next()).hasText()) {
                shortlabel = first.getText();
            }
            if (o.getTaxid() != null) {
                int ncbiTaxId;
                try {
                    ncbiTaxId = Integer.parseInt(o.getTaxid());
                }
                catch (NumberFormatException e) {
                    String msg = "Could not parse taxid " + o.getTaxid() + ", it doesn't seem to be a valid integer value.";
                    throw new XmlConversionException(msg);
                }
                Organism organism = new Organism();
                Names names = new Names();
                organism.setNames(names);
                if (shortlabel != null) {
                    names.setShortLabel(shortlabel);
                } else {
                    switch (ncbiTaxId) {
                        case -1: {
                            names.setShortLabel("in vitro");
                            break;
                        }
                        case -2: {
                            names.setShortLabel("chemical synthesis");
                            break;
                        }
                        case -3: {
                            names.setShortLabel(UNKNOWN);
                            break;
                        }
                        case -4: {
                            names.setShortLabel("in vivo");
                            break;
                        }
                        case -5: {
                            names.setShortLabel("in silico");
                            break;
                        }
                        default: {
                            names.setShortLabel(String.valueOf(ncbiTaxId));
                        }
                    }
                }
                organism.setNcbiTaxId(ncbiTaxId);
                xmlInteractor.setOrganism(organism);
            }
        }
        DbReference primaryReferece = null;
        ArrayList<DbReference> secondaryRefs = new ArrayList<DbReference>();
        List<CrossReference> tabIdentifiers = tabInteractor.getIdentifiers();
        if (!tabIdentifiers.isEmpty()) {
            CrossReference primaryIdentifier;
            Iterator identifierIterator = tabIdentifiers.iterator();
            this.overrideAliasSourceDatabase = primaryIdentifier = (CrossReference)identifierIterator.next();
            String primaryDatabase = primaryIdentifier.getDatabase();
            String primaryId = primaryIdentifier.getIdentifier();
            primaryReferece = new DbReference(primaryId, primaryDatabase);
            if (primaryDatabase.equals(UNIPROT)) {
                primaryReferece.setDbAc(UNIPROT_MI);
                primaryReferece.setRefType(IDENTITY);
                primaryReferece.setRefTypeAc(IDENTITY_REF);
            } else if (primaryDatabase.equals(CHEBI)) {
                primaryReferece.setDbAc(CHEBI_MI);
                primaryReferece.setRefType(IDENTITY);
                primaryReferece.setRefTypeAc(IDENTITY_REF);
            } else if (primaryDatabase.equals(INTACT)) {
                primaryReferece.setDbAc(INTACT_MI);
                primaryReferece.setRefType(IDENTITY);
                primaryReferece.setRefTypeAc(IDENTITY_REF);
            }
            while (identifierIterator.hasNext()) {
                CrossReference secondaryIdentifier = (CrossReference)identifierIterator.next();
                DbReference secondaryRef = this.createSecondaryRef(secondaryIdentifier);
                secondaryRefs.add(secondaryRef);
            }
        }
        if (!tabInteractor.getXrefs().isEmpty()) {
            for (CrossReference secondaryIdentifier : tabInteractor.getXrefs()) {
                DbReference secondaryRef = this.createSecondaryRef(secondaryIdentifier);
                secondaryRefs.add(secondaryRef);
            }
        }
        if (primaryReferece != null) {
            Xref interactorXref;
            if (!secondaryRefs.isEmpty()) {
                interactorXref = new Xref(primaryReferece, secondaryRefs);
                xmlInteractor.setXref(interactorXref);
            } else {
                interactorXref = new Xref(primaryReferece);
                xmlInteractor.setXref(interactorXref);
            }
        } else {
            throw new XmlConversionException("No Xref found");
        }
        InteractorType interactorType = null;
        if (tabInteractor.getInteractorTypes() != null && !tabInteractor.getInteractorTypes().isEmpty()) {
            List<CrossReference> interactorTypes = tabInteractor.getInteractorTypes();
            interactorType = this.cvConverter.fromMitab(interactorTypes, InteractorType.class);
            if (!interactorType.hasNames() && interactorType.getXref() != null && interactorType.getXref().getPrimaryRef() != null) {
                String id = interactorType.getXref().getPrimaryRef().getId();
                Names interactorTypeName = new Names();
                if (id.equals("MI:0326")) {
                    interactorTypeName.setShortLabel("protein");
                    interactorTypeName.setFullName("protein");
                } else if (id.equals("MI:0328")) {
                    interactorTypeName.setShortLabel("small molecule");
                    interactorTypeName.setFullName("small molecule");
                } else if (id.equals("MI:0317")) {
                    interactorTypeName.setShortLabel("interaction");
                    interactorTypeName.setFullName("interaction");
                } else if (id.equals("MI:0329")) {
                    interactorTypeName.setShortLabel("unknown participant");
                    interactorTypeName.setFullName("unknown participant");
                } else {
                    interactorTypeName.setShortLabel(id);
                    interactorTypeName.setFullName(id);
                }
                interactorType.setNames(interactorTypeName);
            }
            xmlInteractor.setInteractorType(interactorType);
        } else {
            Xref interactorTypeXref;
            Names interactorTypeName = new Names();
            if (xmlInteractor.hasXref()) {
                DbReference dbRef;
                interactorType = new InteractorType();
                String xrefPrimaryDB = xmlInteractor.getXref().getPrimaryRef().getDb();
                if (xrefPrimaryDB.equals(UNIPROT)) {
                    interactorTypeName.setShortLabel("protein");
                    interactorTypeName.setFullName("protein");
                    dbRef = new DbReference("MI:0326", PSIMI);
                    dbRef.setDbAc(PSIMI_MI);
                    dbRef.setRefType(IDENTITY);
                    dbRef.setRefTypeAc(IDENTITY_REF);
                    interactorTypeXref = new Xref(dbRef);
                } else if (xrefPrimaryDB.equals(CHEBI)) {
                    interactorTypeName.setShortLabel("small molecule");
                    interactorTypeName.setFullName("small molecule");
                    dbRef = new DbReference("MI:0328", PSIMI);
                    dbRef.setDbAc(PSIMI_MI);
                    dbRef.setRefType(IDENTITY);
                    dbRef.setRefTypeAc(IDENTITY_REF);
                    interactorTypeXref = new Xref(dbRef);
                } else {
                    interactorTypeName.setShortLabel("unknown participant");
                    interactorTypeName.setFullName("unknown participant");
                    dbRef = new DbReference("MI:0329", PSIMI);
                    dbRef.setDbAc(PSIMI_MI);
                    dbRef.setRefType(IDENTITY);
                    dbRef.setRefTypeAc(IDENTITY_REF);
                    interactorTypeXref = new Xref(dbRef);
                    log.debug("Interactor type is unknown");
                }
            } else {
                interactorTypeName.setShortLabel("unknown participant");
                interactorTypeName.setFullName("unknown participant");
                DbReference dbRef = new DbReference("MI:0329", PSIMI);
                dbRef.setDbAc(PSIMI_MI);
                dbRef.setRefType(IDENTITY);
                dbRef.setRefTypeAc(IDENTITY_REF);
                interactorTypeXref = new Xref(dbRef);
                log.debug("Interactor type is unknown");
            }
            interactorType.setNames(interactorTypeName);
            interactorType.setXref(interactorTypeXref);
            xmlInteractor.setInteractorType(interactorType);
        }
        if (tabInteractor.getAnnotations() != null && !tabInteractor.getAnnotations().isEmpty()) {
            for (Annotation annotation : tabInteractor.getAnnotations()) {
                Attribute attribute = new Attribute(annotation.getTopic(), annotation.getText());
                xmlInteractor.getAttributes().add(attribute);
            }
        }
        if (!(checksums = tabInteractor.getChecksums()).isEmpty()) {
            for (Checksum checksum : checksums) {
                Attribute attribute = new Attribute(checksum.getMethodName(), checksum.getChecksum());
                if (xmlInteractor.getAttributes().contains(attribute)) continue;
                xmlInteractor.getAttributes().add(attribute);
            }
        }
        return xmlInteractor;
    }

    private DbReference createSecondaryRef(CrossReference secondaryIdentifier) {
        String database = secondaryIdentifier.getDatabase();
        String id = secondaryIdentifier.getIdentifier();
        return new DbReference(id, database);
    }

    public abstract Participant buildParticipantA(Interactor var1, BinaryInteraction var2, int var3) throws XmlConversionException;

    public abstract Participant buildParticipantB(Interactor var1, BinaryInteraction var2, int var3) throws XmlConversionException;
}

