/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.expansion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.converter.xml2tab.XrefUtils;
import psidev.psi.mi.tab.expansion.BinaryExpansionStrategy;
import psidev.psi.mi.tab.expansion.InteractionCategory;
import psidev.psi.mi.xml.model.ExperimentalRole;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Participant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpokeExpansion
extends BinaryExpansionStrategy {
    public static final String EXPANSION_NAME = "Spoke";
    public static final String BAIT_MI_REF = "MI:0496";
    public static final Log log = LogFactory.getLog(SpokeExpansion.class);

    @Override
    public Collection<Interaction> expand(Interaction interaction2) {
        ArrayList<Interaction> interactions = new ArrayList<Interaction>();
        if (interaction2.getParticipants().isEmpty()) {
            return interactions;
        }
        InteractionCategory category = this.findInteractionCategory(interaction2);
        if (category == null) {
            return interactions;
        }
        if (this.isBinary(interaction2) || category.equals((Object)InteractionCategory.self_intra_molecular)) {
            log.debug("interaction " + interaction2.getId() + "/" + interaction2.getImexId() + " was binary or intra molecular, no further processing involved.");
            interactions.add(interaction2);
        }
        if (category.equals((Object)InteractionCategory.self_inter_molecular)) {
            log.debug("interaction " + interaction2.getId() + "/" + interaction2.getImexId() + " was inter molecular, reset stoichiometry of one of interactors");
            interactions.add(interaction2);
        } else {
            Collection<Participant> participants = interaction2.getParticipants();
            log.debug(participants.size() + " participant(s) found.");
            Participant bait = this.searchBaitParticipant(participants);
            if (bait != null) {
                ArrayList<Participant> preys = new ArrayList<Participant>(participants.size() - 1);
                preys.addAll(participants);
                preys.remove(bait);
                for (Participant prey : preys) {
                    if (log.isDebugEnabled()) {
                        String baitStr = this.displayParticipant(bait);
                        String preyStr = this.displayParticipant(prey);
                        log.debug("Build new binary interaction [" + baitStr + "," + preyStr + "]");
                    }
                    Interaction i = this.buildInteraction(interaction2, bait, prey);
                    interactions.add(i);
                }
            } else {
                Collection<Interaction> noBaitExpandedInteractions = this.processNoBaitExpansion(interaction2);
                interactions.addAll(noBaitExpandedInteractions);
            }
            log.debug("After expansion: " + interactions.size() + " binary interaction(s) were generated.");
        }
        return interactions;
    }

    protected Collection<Interaction> processNoBaitExpansion(Interaction interaction2) {
        log.debug("Could not find a bait participant. No further processing involved.");
        return Collections.EMPTY_LIST;
    }

    protected String displayParticipant(Participant p) {
        String role = "";
        for (ExperimentalRole aRole : p.getExperimentalRoles()) {
            if (role.length() > 0) {
                role = role + "&";
            }
            if (aRole.hasNames()) {
                role = role + aRole.getNames().getShortLabel();
                continue;
            }
            role = role + "?";
        }
        String interactor = p.getInteractor().getNames().getShortLabel();
        return interactor + ":" + role;
    }

    protected boolean isBait(Participant participant) {
        if (participant == null) {
            throw new IllegalArgumentException("Participant must not be null.");
        }
        if (participant.hasExperimentalRoles()) {
            for (ExperimentalRole role : participant.getExperimentalRoles()) {
                log.debug("Checking if participant (id:" + participant.getId() + ") is a bait.");
                if (XrefUtils.hasPsiId(role.getXref(), BAIT_MI_REF)) {
                    log.debug("Yes it is.");
                    return true;
                }
                log.debug("No it is not.");
            }
        }
        return false;
    }

    protected Participant searchBaitParticipant(Collection<Participant> participants) {
        if (participants == null) {
            throw new IllegalArgumentException("Participants must not be null.");
        }
        for (Participant participant : participants) {
            if (!this.isBait(participant)) continue;
            return participant;
        }
        return null;
    }

    @Override
    public String getName() {
        return EXPANSION_NAME;
    }
}

