/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import psidev.psi.mi.tab.model.Parameter;

public class ParameterImpl
implements Parameter {
    private static final long serialVersionUID = 8967236664673865804L;
    private String type;
    private Double factor = 0.0;
    private Integer base = 10;
    private Integer exponent = 0;
    private String value;
    private String unit;
    private Double uncertainty = 0.0;

    public ParameterImpl(String type, String value) {
        this.type = type;
        this.setValue(value);
    }

    public ParameterImpl(String type, String value, String unit) {
        this.type = type;
        this.unit = unit;
        this.setValue(value);
    }

    public ParameterImpl(String type, double factor, int base, int exponent, double uncertainty, String unit) {
        this.type = type;
        this.factor = factor;
        this.base = base;
        this.exponent = exponent;
        this.unit = unit;
        this.uncertainty = uncertainty;
        this.value = this.getValue();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Double getFactor() {
        return this.factor;
    }

    public void setFactor(Double factor) {
        this.factor = factor;
    }

    public Integer getBase() {
        return this.base;
    }

    public void setBase(Integer base) {
        this.base = base;
    }

    public Integer getExponent() {
        return this.exponent;
    }

    public void setExponent(Integer exponent) {
        this.exponent = exponent;
    }

    public String getValue() {
        this.value = String.valueOf(this.factor);
        if (this.exponent != 0 || this.base != 10) {
            this.value = this.factor + "x" + this.base + "^" + this.exponent;
        }
        if (this.uncertainty != 0.0) {
            this.value = this.value + " ~" + this.uncertainty;
        }
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        value = value.replaceAll(" ", "");
        Pattern pattern = Pattern.compile("([-+]?[0-9]+\\.?[0-9]*)+x?([-+]?[0-9]*\\.?[0-9]*)?\\^?([-+]?[0-9]*\\.?[0-9]*)?~?([-+]?[0-9]*\\.?[0-9]*)?");
        Matcher matcher = pattern.matcher(value);
        try {
            if (matcher.matches()) {
                switch (matcher.groupCount()) {
                    case 4: {
                        if (!matcher.group(4).isEmpty()) {
                            this.uncertainty = Double.parseDouble(matcher.group(4));
                        }
                    }
                    case 3: {
                        if (!matcher.group(3).isEmpty()) {
                            this.exponent = Integer.parseInt(matcher.group(3));
                        }
                    }
                    case 2: {
                        if (!matcher.group(2).isEmpty()) {
                            this.base = Integer.parseInt(matcher.group(2));
                        }
                    }
                    case 1: {
                        if (matcher.group(1).isEmpty()) break;
                        this.factor = Double.parseDouble(matcher.group(1));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The value of the parameter is bad formatted: " + value + " Exception: " + e);
        }
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Double getUncertainty() {
        return this.uncertainty;
    }

    public void setUncertainty(Double uncertainty) {
        this.uncertainty = uncertainty;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Parameter");
        sb.append("{type='").append(this.type).append('\'');
        sb.append(", value='").append(this.value).append('\'');
        if (this.unit != null) {
            sb.append(", unit='").append(this.unit).append('\'');
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterImpl that = (ParameterImpl)o;
        if (!this.type.equals(that.type)) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 29 * result + this.value.hashCode();
        return result;
    }
}

