/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.cpdetector.io;

import java.io.File;
import java.io.FileFilter;
import java.util.StringTokenizer;

public final class FileFilterExtensions
implements FileFilter {
    private String[] m_extensions;

    public FileFilterExtensions(String[] extensionsWithoutDot) throws IllegalArgumentException {
        this.verify(extensionsWithoutDot);
        this.m_extensions = extensionsWithoutDot;
    }

    private void verify(String[] extensions) throws IllegalArgumentException {
        StringBuffer msg = new StringBuffer();
        int i = extensions.length - 1;
        while (i >= 0) {
            String current = extensions[i];
            if (current == null) {
                msg.append("Extension at index " + i + " is null!\n");
            } else if (current.indexOf(46) != -1) {
                msg.append("Extension \"" + current + "\" contains a dot!\n");
            }
            --i;
        }
        if (msg.length() > 0) {
            throw new IllegalArgumentException(msg.toString());
        }
    }

    public boolean accept(File pathname) {
        boolean ret = false;
        StringTokenizer tokenizer = new StringTokenizer(pathname.getAbsolutePath(), ".");
        String extension = "no.txt";
        while (tokenizer.hasMoreElements()) {
            extension = tokenizer.nextToken();
        }
        int i = this.m_extensions.length - 1;
        while (i >= 0) {
            if (this.m_extensions[i].equals(extension)) {
                ret = true;
                break;
            }
            --i;
        }
        return ret;
    }
}

