/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.impl.level3.InteractionImpl;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.ControlType;
import org.biopax.paxtools.model.level3.Controller;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.util.BPCollections;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

public class ControlImpl
extends InteractionImpl
implements Control {
    private ControlType controlType;
    private Set<Pathway> pathwayController = BPCollections.I.createSafeSet();
    private Set<PhysicalEntity> peController = BPCollections.I.createSafeSet();
    private Set<Process> controlled = BPCollections.I.createSafeSet();

    public Class<? extends Control> getModelInterface() {
        return Control.class;
    }

    @Override
    public ControlType getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(ControlType ControlType2) {
        this.controlType = ControlType2;
    }

    @Override
    public Set<Process> getControlled() {
        return this.controlled;
    }

    @Override
    public void addControlled(Process process2) {
        if (process2 != null) {
            if (!this.checkControlled(process2)) {
                throw new IllegalBioPAXArgumentException("Illegal argument. Attempting to set " + process2.getUri() + " to " + this.getUri());
            }
            this.controlled.add(process2);
            process2.getControlledOf().add(this);
            super.addParticipant(process2);
        }
    }

    @Override
    public void removeControlled(Process controlled) {
        if (controlled != null) {
            super.removeParticipant(controlled);
            controlled.getControlledOf().remove(this);
            this.controlled.remove(controlled);
        }
    }

    @Override
    public Set<Controller> getController() {
        HashSet<PhysicalEntity> controller = new HashSet<PhysicalEntity>(this.getPeController());
        controller.addAll(this.getPathwayController());
        return Collections.unmodifiableSet(controller);
    }

    @Override
    public void addController(Controller controller) {
        if (controller != null) {
            if (controller instanceof Pathway) {
                this.pathwayController.add((Pathway)controller);
            } else {
                this.peController.add((PhysicalEntity)controller);
            }
            controller.getControllerOf().add(this);
            super.addParticipant(controller);
        }
    }

    @Override
    public void removeController(Controller controller) {
        if (controller != null) {
            super.removeParticipant(controller);
            controller.getControllerOf().remove(this);
            if (controller instanceof Pathway) {
                this.pathwayController.remove(controller);
            } else if (controller instanceof PhysicalEntity) {
                this.peController.remove(controller);
            } else {
                throw new IllegalBioPAXArgumentException("removeController: argument " + controller.getUri() + " is neither Pathway nor PE - " + controller.getModelInterface().getSimpleName());
            }
        }
    }

    protected boolean checkControlled(Process Controlled) {
        return true;
    }

    protected Set<Pathway> getPathwayController() {
        return this.pathwayController;
    }

    protected Set<PhysicalEntity> getPeController() {
        return this.peController;
    }
}

