/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.cose;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.ivis.layout.LEdge;
import org.ivis.layout.LGraph;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LNode;
import org.ivis.layout.Layout;
import org.ivis.layout.LayoutOptionsPack;
import org.ivis.layout.cose.CoSEEdge;
import org.ivis.layout.cose.CoSEGraph;
import org.ivis.layout.cose.CoSEGraphManager;
import org.ivis.layout.cose.CoSENode;
import org.ivis.layout.fd.FDLayout;
import org.ivis.util.PointD;
import org.ivis.util.Transform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoSELayout
extends FDLayout {
    private static final Logger log = LoggerFactory.getLogger(CoSELayout.class);
    public boolean useMultiLevelScaling = false;
    private int level;
    private int noOfLevels;
    ArrayList<CoSEGraphManager> MList;

    @Override
    protected LGraphManager newGraphManager() {
        CoSEGraphManager gm = new CoSEGraphManager(this);
        this.graphManager = gm;
        return gm;
    }

    @Override
    public LGraph newGraph(Object vGraph) {
        return new CoSEGraph(null, this.graphManager, vGraph);
    }

    @Override
    public LNode newNode(Object vNode) {
        return new CoSENode(this.graphManager, vNode);
    }

    @Override
    public LEdge newEdge(Object vEdge) {
        return new CoSEEdge(null, null, vEdge);
    }

    @Override
    public void initParameters() {
        super.initParameters();
        if (!this.isSubLayout) {
            LayoutOptionsPack.CoSE layoutOptionsPack = LayoutOptionsPack.getInstance().getCoSE();
            this.idealEdgeLength = layoutOptionsPack.idealEdgeLength < 10 ? 10.0 : (double)layoutOptionsPack.idealEdgeLength;
            this.useSmartIdealEdgeLengthCalculation = layoutOptionsPack.smartEdgeLengthCalc;
            this.useMultiLevelScaling = layoutOptionsPack.multiLevelScaling;
            this.springConstant = CoSELayout.transform(layoutOptionsPack.springStrength, 0.45, 5.0, 5.0);
            this.repulsionConstant = CoSELayout.transform(layoutOptionsPack.repulsionStrength, 4500.0, 5.0, 5.0);
            this.gravityConstant = CoSELayout.transform(layoutOptionsPack.gravityStrength, 0.4);
            this.compoundGravityConstant = CoSELayout.transform(layoutOptionsPack.compoundGravityStrength, 1.0);
            this.gravityRangeFactor = CoSELayout.transform(layoutOptionsPack.gravityRange, 2.0);
            this.compoundGravityRangeFactor = CoSELayout.transform(layoutOptionsPack.compoundGravityRange, 1.5);
        }
    }

    @Override
    public boolean layout() {
        boolean createBendsAsNeeded = LayoutOptionsPack.getInstance().getGeneral().createBendsAsNeeded;
        if (createBendsAsNeeded) {
            this.createBendpoints();
            this.graphManager.resetAllEdges();
        }
        if (this.useMultiLevelScaling && !this.incremental) {
            return this.multiLevelScalingLayout();
        }
        this.level = 0;
        return this.classicLayout();
    }

    private boolean multiLevelScalingLayout() {
        CoSEGraphManager gm = (CoSEGraphManager)this.graphManager;
        this.MList = gm.coarsenGraph();
        this.level = this.noOfLevels = this.MList.size() - 1;
        while (this.level >= 0) {
            gm = this.MList.get(this.level);
            this.graphManager = gm;
            this.classicLayout();
            this.incremental = true;
            if (this.level >= 1) {
                this.uncoarsen();
            }
            this.totalIterations = 0;
            --this.level;
        }
        this.incremental = false;
        return true;
    }

    protected boolean classicLayout() {
        this.calculateNodesToApplyGravitationTo();
        this.calcNoOfChildrenForAllNodes();
        this.graphManager.calcLowestCommonAncestors();
        this.graphManager.calcInclusionTreeDepths();
        this.graphManager.getRoot().calcEstimatedSize();
        this.calcIdealEdgeLengths();
        if (!this.incremental) {
            List<List<LNode>> forest = this.getFlatForest();
            if (forest.size() > 0) {
                this.positionNodesRadially(forest);
            } else {
                this.positionNodesRandomly();
            }
        }
        this.initSpringEmbedder();
        this.runSpringEmbedder();
        log.info("Classic CoSE layout finished after " + this.totalIterations + " iterations");
        return true;
    }

    public void runSpringEmbedder() {
        do {
            ++this.totalIterations;
            if (this.totalIterations % 100 == 0) {
                if (this.isConverged()) break;
                this.coolingFactor = this.initialCoolingFactor * ((double)(this.maxIterations - this.totalIterations) / (double)this.maxIterations);
            }
            this.totalDisplacement = 0.0;
            this.calcSpringForces();
            this.calcRepulsionForces();
            this.calcGravitationalForces();
            this.moveNodes();
            this.graphManager.updateBounds();
            this.animate();
        } while (this.totalIterations < this.maxIterations);
        this.graphManager.updateBounds();
    }

    public void calculateNodesToApplyGravitationTo() {
        LinkedList nodeList = new LinkedList();
        for (Object obj : this.graphManager.getGraphs()) {
            LGraph graph = (LGraph)obj;
            graph.updateConnected();
            if (graph.isConnected()) continue;
            nodeList.addAll(graph.getNodes());
        }
        this.graphManager.setAllNodesToApplyGravitation(nodeList);
    }

    public void calcNoOfChildrenForAllNodes() {
        for (Object obj : this.graphManager.getAllNodes()) {
            LNode node = (LNode)obj;
            node.noOfChildren = node.getNoOfChildren();
        }
    }

    private void createBendpoints() {
        ArrayList<Object> edges = new ArrayList<Object>();
        edges.addAll(Arrays.asList(this.graphManager.getAllEdges()));
        HashSet<LEdge> visited = new HashSet<LEdge>();
        for (int i = 0; i < edges.size(); ++i) {
            LEdge edge = (LEdge)edges.get(i);
            if (!visited.contains(edge)) {
                LNode target;
                LNode source = edge.getSource();
                if (source == (target = edge.getTarget())) {
                    edge.getBendpoints().add(new PointD());
                    edge.getBendpoints().add(new PointD());
                    this.createDummyNodesForBendpoints(edge);
                    visited.add(edge);
                } else {
                    ArrayList edgeList = new ArrayList();
                    edgeList.addAll(source.getEdgeListToNode(target));
                    edgeList.addAll(target.getEdgeListToNode(source));
                    if (!visited.contains(edgeList.get(0))) {
                        if (edgeList.size() > 1) {
                            for (int k = 0; k < edgeList.size(); ++k) {
                                LEdge multiEdge = (LEdge)edgeList.get(k);
                                multiEdge.getBendpoints().add(new PointD());
                                this.createDummyNodesForBendpoints(multiEdge);
                            }
                        }
                        visited.addAll(edgeList);
                    }
                }
            }
            if (visited.size() == edges.size()) break;
        }
    }

    protected void positionNodesRadially(List<List<LNode>> forest) {
        Point currentStartingPoint = new Point(0, 0);
        int numberOfColumns = (int)Math.ceil(Math.sqrt(forest.size()));
        int height = 0;
        int currentY = 0;
        int currentX = 0;
        PointD point = new PointD(0.0, 0.0);
        for (int i = 0; i < forest.size(); ++i) {
            if (i % numberOfColumns == 0) {
                currentX = 0;
                currentY = height;
                if (i != 0) {
                    currentY += 60;
                }
                height = 0;
            }
            List<LNode> tree = forest.get(i);
            LNode centerNode = Layout.findCenterOfTree(tree);
            currentStartingPoint.x = currentX;
            currentStartingPoint.y = currentY;
            point = CoSELayout.radialLayout(tree, centerNode, currentStartingPoint);
            if (point.y > (double)height) {
                height = (int)point.y;
            }
            currentX = (int)(point.x + 60.0);
        }
        this.transform(new PointD(1200.0 - point.x / 2.0, 900.0 - point.y / 2.0));
    }

    private static PointD radialLayout(List<LNode> tree, LNode centerNode, Point startingPoint) {
        double radialSep = Math.max(CoSELayout.maxDiagonalInTree(tree), 50.0);
        CoSELayout.branchRadialLayout(centerNode, null, 0.0, 359.0, 0.0, radialSep);
        Rectangle bounds = LGraph.calculateBounds(tree);
        Transform transform = new Transform();
        transform.setDeviceOrgX(bounds.getMinX());
        transform.setDeviceOrgY(bounds.getMinY());
        transform.setWorldOrgX(startingPoint.x);
        transform.setWorldOrgY(startingPoint.y);
        for (int i = 0; i < tree.size(); ++i) {
            LNode node = tree.get(i);
            node.transform(transform);
        }
        PointD bottomRight = new PointD(bounds.getMaxX(), bounds.getMaxY());
        return transform.inverseTransformPoint(bottomRight);
    }

    private static void branchRadialLayout(LNode node, LNode parentOfNode, double startAngle, double endAngle, double distance, double radialSeparation) {
        int startIndex;
        double halfInterval = (endAngle - startAngle + 1.0) / 2.0;
        if (halfInterval < 0.0) {
            halfInterval += 180.0;
        }
        double nodeAngle = (halfInterval + startAngle) % 360.0;
        double teta = nodeAngle * (Math.PI * 2) / 360.0;
        double x = distance * Math.cos(teta);
        double y = distance * Math.sin(teta);
        node.setCenter(x, y);
        LinkedList neighborEdges = new LinkedList(node.getEdges());
        int childCount = neighborEdges.size();
        if (parentOfNode != null) {
            --childCount;
        }
        int branchCount = 0;
        int incEdgesCount = neighborEdges.size();
        List<LEdge> edges = node.getEdgesBetween(parentOfNode);
        while (edges.size() > 1) {
            neighborEdges.remove(edges.remove(0));
            --incEdgesCount;
            --childCount;
        }
        if (parentOfNode != null) {
            assert (edges.size() == 1);
            startIndex = (neighborEdges.indexOf(edges.get(0)) + 1) % incEdgesCount;
        } else {
            startIndex = 0;
        }
        double stepAngle = Math.abs(endAngle - startAngle) / (double)childCount;
        int i = startIndex;
        while (branchCount != childCount) {
            LNode currentNeighbor = ((LEdge)neighborEdges.get(i)).getOtherEnd(node);
            if (currentNeighbor != parentOfNode) {
                double childStartAngle = (startAngle + (double)branchCount * stepAngle) % 360.0;
                double childEndAngle = (childStartAngle + stepAngle) % 360.0;
                CoSELayout.branchRadialLayout(currentNeighbor, node, childStartAngle, childEndAngle, distance + radialSeparation, radialSeparation);
                ++branchCount;
            }
            ++i;
            i %= incEdgesCount;
        }
    }

    private static double maxDiagonalInTree(List<LNode> tree) {
        double maxDiagonal = Double.MIN_VALUE;
        for (int i = 0; i < tree.size(); ++i) {
            LNode node = tree.get(i);
            double diagonal = node.getDiagonal();
            if (!(diagonal > maxDiagonal)) continue;
            maxDiagonal = diagonal;
        }
        return maxDiagonal;
    }

    public void uncoarsen() {
        for (Object obj : this.graphManager.getAllNodes()) {
            CoSENode v = (CoSENode)obj;
            v.getPred1().setLocation(v.getLeft(), v.getTop());
            if (v.getPred2() == null) continue;
            v.getPred2().setLocation(v.getLeft() + this.idealEdgeLength, v.getTop() + this.idealEdgeLength);
        }
    }

    @Override
    protected double calcRepulsionRange() {
        return (double)(2 * (this.level + 1)) * this.idealEdgeLength;
    }
}

