/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.util;

import java.awt.Point;
import java.awt.geom.Line2D;
import org.ivis.util.PointD;
import org.ivis.util.RectangleD;

public abstract class IGeometry {
    public static final double HALF_PI = 1.5707963267948966;
    public static final double ONE_AND_HALF_PI = 4.71238898038469;
    public static final double TWO_PI = Math.PI * 2;
    public static final double THREE_PI = Math.PI * 3;

    public static void calcSeparationAmount(RectangleD rectA, RectangleD rectB, double[] overlapAmount, double separationBuffer) {
        assert (rectA.intersects(rectB));
        double[] directions = new double[2];
        IGeometry.decideDirectionsForOverlappingNodes(rectA, rectB, directions);
        overlapAmount[0] = Math.min(rectA.getRight(), rectB.getRight()) - Math.max(rectA.x, rectB.x);
        overlapAmount[1] = Math.min(rectA.getBottom(), rectB.getBottom()) - Math.max(rectA.y, rectB.y);
        if (rectA.getX() <= rectB.getX() && rectA.getRight() >= rectB.getRight()) {
            overlapAmount[0] = overlapAmount[0] + Math.min(rectB.getX() - rectA.getX(), rectA.getRight() - rectB.getRight());
        } else if (rectB.getX() <= rectA.getX() && rectB.getRight() >= rectA.getRight()) {
            overlapAmount[0] = overlapAmount[0] + Math.min(rectA.getX() - rectB.getX(), rectB.getRight() - rectA.getRight());
        }
        if (rectA.getY() <= rectB.getY() && rectA.getBottom() >= rectB.getBottom()) {
            overlapAmount[1] = overlapAmount[1] + Math.min(rectB.getY() - rectA.getY(), rectA.getBottom() - rectB.getBottom());
        } else if (rectB.getY() <= rectA.getY() && rectB.getBottom() >= rectA.getBottom()) {
            overlapAmount[1] = overlapAmount[1] + Math.min(rectA.getY() - rectB.getY(), rectB.getBottom() - rectA.getBottom());
        }
        double slope = Math.abs((rectB.getCenterY() - rectA.getCenterY()) / (rectB.getCenterX() - rectA.getCenterX()));
        if (rectB.getCenterY() == rectA.getCenterY() && rectB.getCenterX() == rectA.getCenterX()) {
            slope = 1.0;
        }
        double moveByY = slope * overlapAmount[0];
        double moveByX = overlapAmount[1] / slope;
        if (overlapAmount[0] < moveByX) {
            moveByX = overlapAmount[0];
        } else {
            moveByY = overlapAmount[1];
        }
        overlapAmount[0] = -1.0 * directions[0] * (moveByX / 2.0 + separationBuffer);
        overlapAmount[1] = -1.0 * directions[1] * (moveByY / 2.0 + separationBuffer);
    }

    private static void decideDirectionsForOverlappingNodes(RectangleD rectA, RectangleD rectB, double[] directions) {
        directions[0] = rectA.getCenterX() < rectB.getCenterX() ? -1.0 : 1.0;
        directions[1] = rectA.getCenterY() < rectB.getCenterY() ? -1.0 : 1.0;
    }

    public static boolean getIntersection(RectangleD rectA, RectangleD rectB, double[] result) {
        double p1x = rectA.getCenterX();
        double p1y = rectA.getCenterY();
        double p2x = rectB.getCenterX();
        double p2y = rectB.getCenterY();
        if (rectA.intersects(rectB)) {
            result[0] = p1x;
            result[1] = p1y;
            result[2] = p2x;
            result[3] = p2y;
            return true;
        }
        double topLeftAx = rectA.getX();
        double topLeftAy = rectA.getY();
        double topRightAx = rectA.getRight();
        double bottomLeftAx = rectA.getX();
        double bottomLeftAy = rectA.getBottom();
        double bottomRightAx = rectA.getRight();
        double halfWidthA = rectA.getWidthHalf();
        double halfHeightA = rectA.getHeightHalf();
        double topLeftBx = rectB.getX();
        double topLeftBy = rectB.getY();
        double topRightBx = rectB.getRight();
        double bottomLeftBx = rectB.getX();
        double bottomLeftBy = rectB.getBottom();
        double bottomRightBx = rectB.getRight();
        double halfWidthB = rectB.getWidthHalf();
        double halfHeightB = rectB.getHeightHalf();
        boolean clipPointAFound = false;
        boolean clipPointBFound = false;
        if (p1x == p2x) {
            if (p1y > p2y) {
                result[0] = p1x;
                result[1] = topLeftAy;
                result[2] = p2x;
                result[3] = bottomLeftBy;
                return false;
            }
            if (p1y < p2y) {
                result[0] = p1x;
                result[1] = bottomLeftAy;
                result[2] = p2x;
                result[3] = topLeftBy;
                return false;
            }
        } else if (p1y == p2y) {
            if (p1x > p2x) {
                result[0] = topLeftAx;
                result[1] = p1y;
                result[2] = topRightBx;
                result[3] = p2y;
                return false;
            }
            if (p1x < p2x) {
                result[0] = topRightAx;
                result[1] = p1y;
                result[2] = topLeftBx;
                result[3] = p2y;
                return false;
            }
        } else {
            int cardinalDirectionB;
            int cardinalDirectionA;
            double slopeA = rectA.height / rectA.width;
            double slopeB = rectB.height / rectB.width;
            double slopePrime = (p2y - p1y) / (p2x - p1x);
            if (-slopeA == slopePrime) {
                if (p1x > p2x) {
                    result[0] = bottomLeftAx;
                    result[1] = bottomLeftAy;
                    clipPointAFound = true;
                } else {
                    result[0] = topRightAx;
                    result[1] = topLeftAy;
                    clipPointAFound = true;
                }
            } else if (slopeA == slopePrime) {
                if (p1x > p2x) {
                    result[0] = topLeftAx;
                    result[1] = topLeftAy;
                    clipPointAFound = true;
                } else {
                    result[0] = bottomRightAx;
                    result[1] = bottomLeftAy;
                    clipPointAFound = true;
                }
            }
            if (-slopeB == slopePrime) {
                if (p2x > p1x) {
                    result[2] = bottomLeftBx;
                    result[3] = bottomLeftBy;
                    clipPointBFound = true;
                } else {
                    result[2] = topRightBx;
                    result[3] = topLeftBy;
                    clipPointBFound = true;
                }
            } else if (slopeB == slopePrime) {
                if (p2x > p1x) {
                    result[2] = topLeftBx;
                    result[3] = topLeftBy;
                    clipPointBFound = true;
                } else {
                    result[2] = bottomRightBx;
                    result[3] = bottomLeftBy;
                    clipPointBFound = true;
                }
            }
            if (clipPointAFound && clipPointBFound) {
                return false;
            }
            if (p1x > p2x) {
                if (p1y > p2y) {
                    cardinalDirectionA = IGeometry.getCardinalDirection(slopeA, slopePrime, 4);
                    cardinalDirectionB = IGeometry.getCardinalDirection(slopeB, slopePrime, 2);
                } else {
                    cardinalDirectionA = IGeometry.getCardinalDirection(-slopeA, slopePrime, 3);
                    cardinalDirectionB = IGeometry.getCardinalDirection(-slopeB, slopePrime, 1);
                }
            } else if (p1y > p2y) {
                cardinalDirectionA = IGeometry.getCardinalDirection(-slopeA, slopePrime, 1);
                cardinalDirectionB = IGeometry.getCardinalDirection(-slopeB, slopePrime, 3);
            } else {
                cardinalDirectionA = IGeometry.getCardinalDirection(slopeA, slopePrime, 2);
                cardinalDirectionB = IGeometry.getCardinalDirection(slopeB, slopePrime, 4);
            }
            if (!clipPointAFound) {
                switch (cardinalDirectionA) {
                    case 1: {
                        double tempPointAx;
                        double tempPointAy = topLeftAy;
                        result[0] = tempPointAx = p1x + -halfHeightA / slopePrime;
                        result[1] = tempPointAy;
                        break;
                    }
                    case 2: {
                        double tempPointAx = bottomRightAx;
                        double tempPointAy = p1y + halfWidthA * slopePrime;
                        result[0] = tempPointAx;
                        result[1] = tempPointAy;
                        break;
                    }
                    case 3: {
                        double tempPointAx;
                        double tempPointAy = bottomLeftAy;
                        result[0] = tempPointAx = p1x + halfHeightA / slopePrime;
                        result[1] = tempPointAy;
                        break;
                    }
                    case 4: {
                        double tempPointAx = bottomLeftAx;
                        double tempPointAy = p1y + -halfWidthA * slopePrime;
                        result[0] = tempPointAx;
                        result[1] = tempPointAy;
                    }
                }
            }
            if (!clipPointBFound) {
                switch (cardinalDirectionB) {
                    case 1: {
                        double tempPointBx;
                        double tempPointBy = topLeftBy;
                        result[2] = tempPointBx = p2x + -halfHeightB / slopePrime;
                        result[3] = tempPointBy;
                        break;
                    }
                    case 2: {
                        double tempPointBx = bottomRightBx;
                        double tempPointBy = p2y + halfWidthB * slopePrime;
                        result[2] = tempPointBx;
                        result[3] = tempPointBy;
                        break;
                    }
                    case 3: {
                        double tempPointBx;
                        double tempPointBy = bottomLeftBy;
                        result[2] = tempPointBx = p2x + halfHeightB / slopePrime;
                        result[3] = tempPointBy;
                        break;
                    }
                    case 4: {
                        double tempPointBx = bottomLeftBx;
                        double tempPointBy = p2y + -halfWidthB * slopePrime;
                        result[2] = tempPointBx;
                        result[3] = tempPointBy;
                    }
                }
            }
        }
        return false;
    }

    private static int getCardinalDirection(double slope, double slopePrime, int line) {
        if (slope > slopePrime) {
            return line;
        }
        return 1 + line % 4;
    }

    public static Point getIntersection(Point s1, Point s2, Point f1, Point f2) {
        int x1 = s1.x;
        int y1 = s1.y;
        int x2 = s2.x;
        int y2 = s2.y;
        int x3 = f1.x;
        int y3 = f1.y;
        int x4 = f2.x;
        int y4 = f2.y;
        int a1 = y2 - y1;
        int b1 = x1 - x2;
        int c1 = x2 * y1 - x1 * y2;
        int a2 = y4 - y3;
        int b2 = x3 - x4;
        int c2 = x4 * y3 - x3 * y4;
        int denom = a1 * b2 - a2 * b1;
        if (denom == 0) {
            return null;
        }
        int x = (b1 * c2 - b2 * c1) / denom;
        int y = (a2 * c1 - a1 * c2) / denom;
        return new Point(x, y);
    }

    public static double angleOfVector(double Cx, double Cy, double Nx, double Ny) {
        double C_angle;
        if (Cx != Nx) {
            C_angle = Math.atan((Ny - Cy) / (Nx - Cx));
            if (Nx < Cx) {
                C_angle += Math.PI;
            } else if (Ny < Cy) {
                C_angle += Math.PI * 2;
            }
        } else {
            C_angle = Ny < Cy ? 4.71238898038469 : 1.5707963267948966;
        }
        return C_angle;
    }

    public static double radian2degree(double rad) {
        return 180.0 * rad / Math.PI;
    }

    public static boolean doIntersect(PointD p1, PointD p2, PointD p3, PointD p4) {
        boolean result = Line2D.linesIntersect(p1.x, p1.y, p2.x, p2.y, p3.x, p3.y, p4.x, p4.y);
        return result;
    }

    public static double calculateAngle(PointD targetPnt, PointD centerPnt, PointD node) {
        PointD point1 = new PointD(targetPnt.x - centerPnt.x, targetPnt.y - centerPnt.y);
        PointD point2 = new PointD(node.x - centerPnt.x, node.y - centerPnt.y);
        if (Math.abs(point1.x) < 0.0) {
            point1.x = 1.0E-4;
        }
        if (Math.abs(point1.y) < 0.0) {
            point1.y = 1.0E-4;
        }
        double angleValue = (point1.x * point2.x + point1.y * point2.y) / (Math.sqrt(point1.x * point1.x + point1.y * point1.y) * Math.sqrt(point2.x * point2.x + point2.y * point2.y));
        return Math.abs(Math.toDegrees(Math.acos(angleValue)));
    }
}

