/*
 * Decompiled with CFR 0.152.
 */
package org.sbgn.schematron;

public class Issue {
    private final Severity severity;
    private final String message;
    private final String diagnosticId;
    private final String ruleId;

    Issue(String role, String ruleId, String diagnosticId, String message) {
        this.message = message.trim();
        this.diagnosticId = diagnosticId;
        this.ruleId = ruleId;
        this.severity = role.equalsIgnoreCase("error") ? Severity.ERROR : Severity.WARNING;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getRuleDescription() {
        return this.message;
    }

    public String getAboutId() {
        return this.diagnosticId;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public String toString() {
        return (Object)((Object)this.severity) + " at id=" + this.diagnosticId + ": " + this.message;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        WARNING,
        ERROR;

    }
}

