/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.mock;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import psidev.psi.mi.tab.model.Alias;
import psidev.psi.mi.tab.model.AliasImpl;
import psidev.psi.mi.tab.model.Author;
import psidev.psi.mi.tab.model.AuthorImpl;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.BinaryInteractionImpl;
import psidev.psi.mi.tab.model.Confidence;
import psidev.psi.mi.tab.model.ConfidenceImpl;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.CrossReferenceImpl;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.tab.model.Organism;
import psidev.psi.mi.tab.model.OrganismImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsimiTabMockBuilder {
    private static final String VOWELS = "aeiouy";
    private static final String CONSONANTS = "qwrtpsdfghjklzxcvbnm";
    private static final String INTEGERS = "0123456789";
    private static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static List<CrossReference> sourceDatabases = new ArrayList<CrossReference>();
    private static List<CrossReference> interactionTypes = new ArrayList<CrossReference>();
    private static List<CrossReference> interactionDetectionMethods = new ArrayList<CrossReference>();
    private static List<String> confidenceTypes = new ArrayList<String>();
    private static List<Organism> organisms = new ArrayList<Organism>();
    private int sequence = 0;

    protected Interactor buildInteractor() {
        return new Interactor();
    }

    public Interactor createInteractor(int taxid, String db, String id, String txt) {
        CrossReferenceImpl cr = new CrossReferenceImpl(db, id, txt);
        Interactor interactor = this.buildInteractor();
        interactor.setIdentifiers(this.createList(cr));
        OrganismImpl o = new OrganismImpl(taxid);
        interactor.setOrganism(o);
        return interactor;
    }

    public Interactor createInteractor(int taxid, String db, String id) {
        return this.createInteractor(taxid, db, id, null);
    }

    public Interactor createProteinInteractorRandom() {
        Interactor interactor = this.buildInteractor();
        interactor.setAliases(this.createAliasRandom(this.boundRandom(1, 4), "uniprotkb"));
        interactor.setAlternativeIdentifiers(this.createUniprotCrossReferenceList(this.boundRandom(0, 4)));
        interactor.setIdentifiers(this.createList(this.createCrossReference("uniprotkb", this.randomUniprotAc())));
        interactor.setOrganism(this.pickRandom(organisms));
        return interactor;
    }

    public List<Alias> createAliasRandom(int aliasCount, String db) {
        ArrayList<Alias> aliases = new ArrayList<Alias>(aliasCount);
        for (int i = 0; i < aliasCount; ++i) {
            aliases.add(new AliasImpl(db, this.randomString()));
        }
        return aliases;
    }

    public Organism createOrganismRandom() {
        return new OrganismImpl(this.nextInt(), this.randomString());
    }

    protected BinaryInteraction buildInteraction(Interactor a, Interactor b) {
        return new BinaryInteractionImpl(a, b);
    }

    public BinaryInteraction createInteraction(Interactor a, Interactor b) {
        BinaryInteraction bi = this.buildInteraction(a, b);
        bi.getDetectionMethods().add(new CrossReferenceImpl("psi-mi", "MI:0071", "molecular sieving"));
        return bi;
    }

    public BinaryInteraction createInteractionRandom() {
        BinaryInteraction bi = this.buildInteraction(this.createProteinInteractorRandom(), this.createProteinInteractorRandom());
        CrossReference source = this.pickRandom(sourceDatabases);
        bi.setAuthors(this.createList(this.createAuthorRandom()));
        bi.setConfidenceValues(this.createList(this.createConfidenceRandom()));
        bi.setDetectionMethods(this.createList(this.createInteractionDetectionMethodRandom()));
        bi.setInteractionAcs(this.createList(this.createCrossReference(source.getDatabase(), source.getText() + this.nextId())));
        bi.setInteractionTypes(this.createList(this.createInteractionTypeRandom()));
        bi.setPublications(this.createList(this.createCrossReference("pubmed", String.valueOf(this.boundRandom(100000, 999999)))));
        bi.setSourceDatabases(this.createList(source));
        return bi;
    }

    public CrossReference createInteractionTypeRandom() {
        return this.pickRandom(interactionTypes);
    }

    public CrossReference createInteractionDetectionMethodRandom() {
        return this.pickRandom(interactionDetectionMethods);
    }

    public Confidence createConfidenceRandom() {
        String confidenceType = this.pickRandom(confidenceTypes);
        return new ConfidenceImpl(confidenceType, String.valueOf(this.boundRandomDouble(0.0, 1.0)));
    }

    public Author createAuthorRandom() {
        int year = 2000 + new Random().nextInt(8);
        return new AuthorImpl(this.randomString(this.boundRandom(5, 10)) + " et al." + " (" + year + ")");
    }

    public List<CrossReference> createUniprotCrossReferenceList(int crossRefCount) {
        ArrayList<CrossReference> references = new ArrayList<CrossReference>(crossRefCount);
        for (int i = 0; i < crossRefCount; ++i) {
            references.add(this.createCrossReference("uniprotkb", this.randomUniprotAc()));
        }
        return null;
    }

    public CrossReference createCrossReference(String db, String id, String text) {
        return new CrossReferenceImpl(db, id, text);
    }

    public CrossReference createCrossReference(String db, String id) {
        return new CrossReferenceImpl(db, id);
    }

    public CrossReference createUniprotCrossReference(String id) {
        return new CrossReferenceImpl("uniprotkb", id);
    }

    protected String nextString() {
        return this.randomString();
    }

    protected String nextString(String prefix) {
        return prefix + "_" + this.randomString();
    }

    protected int nextInt() {
        return new Random().nextInt(10000);
    }

    protected int nextId() {
        return ++this.sequence;
    }

    protected int boundRandom(int min, int max) {
        if (min == max) {
            return max;
        }
        return new Random().nextInt(max - min) + min;
    }

    protected double boundRandomDouble(double min, double max) {
        if (min == max) {
            return max;
        }
        double random = new Random().nextDouble();
        double x = random * max;
        if (x < min) {
            x += max - min;
        }
        return x;
    }

    public String randomString() {
        return this.randomString(this.boundRandom(4, 10));
    }

    public char randomChar(String alphabet) {
        return alphabet.charAt((int)(Math.random() * (double)alphabet.length()));
    }

    public String randomString(int returnLength) {
        StringBuilder random = new StringBuilder(returnLength);
        Random rdm = new Random(System.currentTimeMillis());
        for (int j = 0; j < returnLength; ++j) {
            boolean nextIsVowel = rdm.nextBoolean();
            if (nextIsVowel) {
                random.append(this.randomChar(VOWELS));
                continue;
            }
            random.append(this.randomChar(CONSONANTS));
        }
        return random.toString();
    }

    protected String randomExperimentLabel() {
        int year = 2000 + new Random().nextInt(8);
        return this.randomString() + "-" + year + "-" + (new Random().nextInt(7) + 1);
    }

    public String randomUniprotAc() {
        StringBuilder sb = new StringBuilder(5);
        sb.append(this.randomChar("OPQ"));
        sb.append(this.randomChar(INTEGERS));
        sb.append(this.randomChar(ALPHABET));
        sb.append(this.randomChar(INTEGERS));
        sb.append(this.randomChar(INTEGERS));
        return sb.toString();
    }

    protected <T> T pickRandom(List<T> list) {
        return list.get(this.boundRandom(0, list.size() - 1));
    }

    protected <T> List<T> createList(T ... objects) {
        ArrayList<T> result = new ArrayList<T>(objects.length);
        for (T object : objects) {
            result.add(object);
        }
        return result;
    }

    static {
        sourceDatabases.add(new CrossReferenceImpl("intact", "MI:0469", "EBI-"));
        sourceDatabases.add(new CrossReferenceImpl("mint", "MI:0471", "MINT-"));
        sourceDatabases.add(new CrossReferenceImpl("dip", "MI:0465", "DIP"));
        interactionTypes.add(new CrossReferenceImpl("psi-mi", "MI:0914", "association"));
        interactionTypes.add(new CrossReferenceImpl("psi-mi", "MI:0915", "physical association"));
        interactionTypes.add(new CrossReferenceImpl("psi-mi", "MI:0403", "colocalization"));
        interactionDetectionMethods.add(new CrossReferenceImpl("psi-mi", "MI:0435", "protease assay"));
        interactionDetectionMethods.add(new CrossReferenceImpl("psi-mi", "MI:0055", "fluorescent resonance energy transfer"));
        interactionDetectionMethods.add(new CrossReferenceImpl("psi-mi", "MI:0018", "2 hybrid"));
        interactionDetectionMethods.add(new CrossReferenceImpl("psi-mi", "MI:0115", "yeast display"));
        interactionDetectionMethods.add(new CrossReferenceImpl("psi-mi", "MI:0027", "cosedimentation"));
        interactionDetectionMethods.add(new CrossReferenceImpl("psi-mi", "MI:0397", "two hybrid array"));
        confidenceTypes.add("intact confidence");
        confidenceTypes.add("psi-score");
        organisms.add(new OrganismImpl(9606, "human"));
        organisms.add(new OrganismImpl(4932, "yeast"));
        organisms.add(new OrganismImpl(3702, "arath"));
        organisms.add(new OrganismImpl(6239, "caeel"));
        organisms.add(new OrganismImpl(8355, "xenla"));
    }
}

