/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.cpdetector;

import info.monitorenter.cpdetector.ACmdLineArgsInheritor;
import info.monitorenter.cpdetector.io.CodepageDetectorProxy;
import info.monitorenter.cpdetector.io.FileFilterExtensions;
import info.monitorenter.cpdetector.io.ICodepageDetector;
import info.monitorenter.cpdetector.io.JChardetFacade;
import info.monitorenter.cpdetector.io.ParsingDetector;
import info.monitorenter.cpdetector.io.UnsupportedCharset;
import info.monitorenter.cpdetector.reflect.SingletonLoader;
import info.monitorenter.cpdetector.util.FileUtil;
import jargs.gnu.CmdLineParser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;

public class CodepageProcessor
extends ACmdLineArgsInheritor {
    protected File collectionRoot = null;
    protected CodepageDetectorProxy detector = CodepageDetectorProxy.getInstance();
    private Charset[] parseCodepages;
    private static String fileseparator = System.getProperty("file.separator");
    private FileFilter extensionFilter;
    private File outputDir;
    private boolean moveUnknown = false;
    private boolean printCharsets = false;
    private boolean verbose = false;
    private long wait = 0L;
    private Charset targetCodepage = null;
    private static char[] transcodeBuffer = new char[1024];
    private static byte[] rawtransportBuffer = new byte[1024];

    public CodepageProcessor() {
        this.addCmdLineOption("documents", new CmdLineParser.Option.StringOption('r', "documents"));
        this.addCmdLineOption("extensions", new CmdLineParser.Option.StringOption('e', "extensions"));
        this.addCmdLineOption("outputDir", new CmdLineParser.Option.StringOption('o', "outputDir"));
        this.addCmdLineOption("moveUnknown", new CmdLineParser.Option.BooleanOption('m', "moveUnknown"));
        this.addCmdLineOption("verbose", new CmdLineParser.Option.BooleanOption('v', "verbose"));
        this.addCmdLineOption("wait", new CmdLineParser.Option.IntegerOption('w', "wait"));
        this.addCmdLineOption("transform", new CmdLineParser.Option.StringOption('t', "transform"));
        this.addCmdLineOption("detectors", new CmdLineParser.Option.StringOption('d', "detectors"));
        this.addCmdLineOption("charsets", new CmdLineParser.Option.BooleanOption('c', "charsets"));
    }

    /*
     * Unable to fully structure code
     */
    public void parseArgs(String[] cmdLineArgs) throws Exception {
        super.parseArgs(cmdLineArgs);
        collectionOption = this.getParsedCmdLineOption("documents");
        extensionsOption = this.getParsedCmdLineOption("extensions");
        outputDirOption = this.getParsedCmdLineOption("outputDir");
        moveUnknownOption = this.getParsedCmdLineOption("moveUnknown");
        verboseOption = this.getParsedCmdLineOption("verbose");
        waitOption = this.getParsedCmdLineOption("wait");
        transformOption = this.getParsedCmdLineOption("transform");
        detectorOption = this.getParsedCmdLineOption("detectors");
        charsetsOption = this.getParsedCmdLineOption("charsets");
        if (charsetsOption != null) {
            this.printCharsets = (Boolean)charsetsOption;
        } else {
            block18: {
                if (collectionOption == null) {
                    this.usage();
                    throw new MissingResourceException("Parameter for collection root directory is missing.", "String", "-r");
                }
                this.collectionRoot = new File(collectionOption.toString());
                if (outputDirOption == null) {
                    this.usage();
                    throw new MissingResourceException("Parameter for output directory is missing.", "String", "-o");
                }
                this.outputDir = new File(outputDirOption.toString());
                this.extensionFilter = extensionsOption != null ? new FileFilterExtensions(this.parseCSVList(extensionsOption.toString())) : new FileFilter(){

                    public boolean accept(File f) {
                        return true;
                    }
                };
                if (moveUnknownOption != null) {
                    this.moveUnknown = true;
                }
                if (verboseOption != null && ((Boolean)verboseOption).booleanValue()) {
                    this.verbose = true;
                }
                if (waitOption != null) {
                    this.wait = (Integer)waitOption * 1000;
                }
                if (transformOption != null) {
                    charset = (String)transformOption;
                    try {
                        this.targetCodepage = Charset.forName(charset);
                        break block18;
                    }
                    catch (Exception e) {
                        msg = new StringBuffer();
                        msg.append("Given charset name: \"");
                        msg.append(charset);
                        msg.append("\" for option -t is illegal: \n");
                        msg.append("  ");
                        msg.append(e.getMessage());
                        msg.append("\n");
                        msg.append("   Legal values are: \n");
                        i = 0;
                        ** while (i < this.parseCodepages.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        msg.append("    ");
                        msg.append(this.parseCodepages[i].name());
                        msg.append("\n");
                        ++i;
                        continue;
                    }
lbl60:
                    // 1 sources

                    throw new IllegalArgumentException(msg.toString());
                }
            }
            if (detectorOption != null) {
                detectors = this.parseCSVList((String)detectorOption);
                if (detectors.length == 0) {
                    msg = new StringBuffer();
                    msg.append("You specified the codepage detector argument \"-d\" but ommited any comma-separated fully qualified class-name.");
                    throw new IllegalArgumentException(msg.toString());
                }
                cpDetector = null;
                i = 0;
                while (i < detectors.length) {
                    try {
                        cpDetector = (ICodepageDetector)SingletonLoader.getInstance().newInstance(detectors[i]);
                        if (cpDetector != null) {
                            this.detector.add(cpDetector);
                        }
                    }
                    catch (InstantiationException ie) {
                        System.err.println("Could not instantiate custom ICodepageDetector: " + detectors[i] + " (argument \"-c\"): " + ie.getMessage());
                    }
                    ++i;
                }
            } else {
                this.detector.add(new ParsingDetector(this.verbose));
                this.detector.add(JChardetFacade.getInstance());
            }
            this.loadCodepages();
        }
    }

    private void printCharsets() {
        if (this.parseCodepages == null || this.parseCodepages.length == 0) {
            this.loadCodepages();
        }
        int n = 0;
        while (n < this.parseCodepages.length) {
            Charset charset = this.parseCodepages[n];
            System.out.println("  " + charset.name() + ":");
            Set<String> set = charset.aliases();
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                System.out.println("    " + iterator.next().toString());
            }
            ++n;
        }
    }

    private final String[] parseCSVList(String string) {
        if (string == null) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";,");
        while (stringTokenizer.hasMoreElements()) {
            linkedList.add(stringTokenizer.nextToken());
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    private void processRecursive(File file) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("File argument is null!");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException(String.valueOf(file.getAbsolutePath()) + " does not exist.");
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length - 1;
            while (n >= 0) {
                this.processRecursive(fileArray[n]);
                --n;
            }
        } else if (this.extensionFilter.accept(file)) {
            this.process(file);
        }
    }

    public final void process() throws Exception {
        if (this.printCharsets) {
            this.printCharsets();
        } else {
            this.verifyFiles();
            this.describe();
            this.processRecursive(this.collectionRoot);
        }
        System.out.println("No exceptional program flow occured!");
    }

    protected void verifyFiles() throws IllegalArgumentException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.collectionRoot == null) {
            stringBuffer.append("-> Collection root directory is null!\n");
        } else if (!this.collectionRoot.exists()) {
            stringBuffer.append("-> Collection root directory:\"");
            stringBuffer.append(this.collectionRoot.getAbsolutePath());
            stringBuffer.append("\" does not exist!\n");
        }
        if (this.outputDir == null) {
            stringBuffer.append("-> Output directory is null!\n");
        } else {
            this.outputDir.mkdirs();
            if (!this.outputDir.isDirectory()) {
                stringBuffer.append("-> Output directory has to be a directory, no File!\n");
            }
        }
        if (stringBuffer.length() > 0) {
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        System.out.println("All parameters are valid.");
    }

    private void process(File file) throws Exception {
        Charset charset = null;
        try {
            Thread.sleep(this.wait);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Map.Entry entry = FileUtil.cutDirectoryInformation(file.getAbsolutePath());
        String string = file.getAbsolutePath();
        int n = string.lastIndexOf(fileseparator);
        int n2 = this.collectionRoot.getAbsolutePath().length();
        string = n2 > n ? "" : string.substring(this.collectionRoot.getAbsolutePath().length(), n + 1);
        if (this.verbose) {
            System.out.println("Processing document: " + string + "/" + entry.getValue());
        }
        if ((charset = this.detector.detectCodepage(file.toURL())) == null) {
            if (this.verbose) {
                System.out.println("  Charset not detected.");
            }
            if (!this.moveUnknown) {
                if (this.verbose) {
                    System.out.println("  Dropping document.");
                }
                return;
            }
            charset = UnsupportedCharset.forName("unknown");
        }
        if (this.targetCodepage != null) {
            File file2 = string.length() > 0 ? new File(String.valueOf(this.outputDir.getAbsolutePath()) + "/" + this.targetCodepage.name() + "/" + string + "/") : new File(String.valueOf(this.outputDir.getAbsolutePath()) + "/" + this.targetCodepage.name() + "/");
            if (file2.mkdirs() && this.verbose) {
                System.out.println("  Created directory : " + file2.getAbsolutePath());
            }
            file2 = new File(String.valueOf(file2.getAbsolutePath()) + "/" + entry.getValue());
            if (this.verbose) {
                System.out.println("  Moving to \"" + file2.getAbsolutePath() + "\".");
            }
            if (file2.exists() && file2.length() == file.length()) {
                if (this.verbose) {
                    System.out.println("  File already exists and has same size. Skipping move.");
                }
            } else {
                int n3;
                file2.createNewFile();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), this.targetCodepage));
                int n4 = transcodeBuffer.length;
                while ((n3 = ((Reader)bufferedReader).read(transcodeBuffer, 0, n4)) != -1) {
                    ((Writer)bufferedWriter).write(transcodeBuffer, 0, n3);
                }
                ((Reader)bufferedReader).close();
                ((Writer)bufferedWriter).close();
            }
        } else {
            File file3 = string.length() > 0 ? new File(String.valueOf(this.outputDir.getAbsolutePath()) + "/" + charset.name().toLowerCase() + "/" + string + "/") : new File(String.valueOf(this.outputDir.getAbsolutePath()) + "/" + charset.name().toLowerCase() + "/");
            if (file3.mkdirs() && this.verbose) {
                System.out.println("Created directory : " + file3.getAbsolutePath());
            }
            file3 = new File(String.valueOf(file3.getAbsolutePath()) + "/" + entry.getValue());
            if (this.verbose) {
                System.out.println("  Moving to \"" + file3.getAbsolutePath() + "\".");
            }
            this.rawCopy(file, file3);
        }
    }

    private void rawCopy(File from, File to) throws IOException {
        int len;
        if (to.exists()) {
            if (from.length() == to.length()) {
                return;
            }
        } else {
            to.createNewFile();
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(from));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(to));
        int toRead = rawtransportBuffer.length;
        while ((len = ((InputStream)in).read(rawtransportBuffer, 0, toRead)) != -1) {
            ((OutputStream)out).write(rawtransportBuffer, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    protected void describe() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Setup:\n");
        stringBuffer.append("  Collection-Root        : ");
        stringBuffer.append(this.collectionRoot.getAbsolutePath());
        stringBuffer.append("\n");
        stringBuffer.append("  Output-Dir             : ");
        stringBuffer.append(this.outputDir.getAbsolutePath());
        stringBuffer.append("\n");
        stringBuffer.append("  Move unknown           : ");
        stringBuffer.append(this.moveUnknown);
        stringBuffer.append("\n");
        stringBuffer.append("  verbose                : ");
        stringBuffer.append(this.verbose);
        stringBuffer.append("\n");
        stringBuffer.append("  wait                   : ");
        stringBuffer.append(this.wait);
        stringBuffer.append("\n");
        if (this.targetCodepage != null) {
            stringBuffer.append("  transform to codepage  : ");
            stringBuffer.append(this.targetCodepage.name());
            stringBuffer.append("\n");
        }
        stringBuffer.append("  detection algorithm    : ");
        stringBuffer.append("\n");
        stringBuffer.append(this.detector.toString());
        System.out.println(stringBuffer.toString());
    }

    protected void usage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("usage: java -jar codepageProcessor.jar [options]");
        stringBuffer.append("\n");
        stringBuffer.append("options: \n");
        stringBuffer.append("\n  Optional:\n");
        stringBuffer.append("  -c              : Only print available charsets on this system.\n");
        stringBuffer.append("  -e <extensions> : A comma- or semicolon- separated string for document extensions like \"-e txt,dat\" (without dot or space!).\n");
        stringBuffer.append("  -m              : Move files with unknown charset to directory \"unknown\".\n");
        stringBuffer.append("  -v              : Verbose output.\n");
        stringBuffer.append("  -w <int>        : Wait <int> seconds before trying next document (good, if you want to work on the very same machine).\n");
        stringBuffer.append("  -t <charset>    : Try to transform the document to given charset (codepage) name. \n");
        stringBuffer.append("                    This is only possible for documents that are detected to have a  \n");
        stringBuffer.append("                    codepage that is supported by the current java VM. If not possible \n");
        stringBuffer.append("                    sorting will be done as normal. \n");
        stringBuffer.append("  -d              : Semicolon-separated list of fully qualified classnames. \n");
        stringBuffer.append("                    These classes will be casted to ICodepageDetector instances \n");
        stringBuffer.append("                    and used in the order specified.\n");
        stringBuffer.append("                    If this argument is ommited, a HTMLCodepageDetector followed by .\n");
        stringBuffer.append("                    a JChardetFacade is used by default.\n");
        stringBuffer.append("  Mandatory (if no -c option given) :\n");
        stringBuffer.append("  -r            : Root directory containing the collection (recursive).\n");
        stringBuffer.append("  -o            : Output directory containing the sorted collection.\n");
        System.out.print(stringBuffer.toString());
    }

    void loadCodepages() {
        SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
        Iterator<Map.Entry<String, Charset>> iterator = sortedMap.entrySet().iterator();
        if (this.verbose) {
            System.out.println("Loading system codepages...");
        }
        this.parseCodepages = new Charset[sortedMap.size()];
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, Charset> entry = iterator.next();
            Charset charset = entry.getValue();
            if (this.verbose) {
                System.out.println("Charset: " + charset.name());
                Set<String> set = charset.aliases();
                System.out.println("  Aliases: ");
                Iterator<String> iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    System.out.println("    " + iterator2.next().toString());
                }
            }
            this.parseCodepages[n] = charset;
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        CodepageProcessor codepageProcessor = new CodepageProcessor();
        try {
            codepageProcessor.parseArgs(stringArray);
            try {
                codepageProcessor.process();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        catch (Exception exception) {
            System.err.println("\nError: " + exception.getMessage());
            exception.printStackTrace(System.err);
        }
    }
}

