/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import org.biopax.paxtools.impl.level3.PhysicalEntityImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.Stoichiometry;
import org.biopax.paxtools.util.BPCollections;
import org.biopax.paxtools.util.SetEquivalenceChecker;

public class ComplexImpl
extends PhysicalEntityImpl
implements Complex {
    private Set<PhysicalEntity> component = BPCollections.I.createSafeSet();
    private Set<Stoichiometry> componentStoichiometry = BPCollections.I.createSafeSet();

    public Class<? extends Complex> getModelInterface() {
        return Complex.class;
    }

    @Override
    public Set<PhysicalEntity> getComponent() {
        return this.component;
    }

    @Override
    public void addComponent(PhysicalEntity component) {
        if (component != null) {
            this.component.add(component);
            component.getComponentOf().add(this);
        }
    }

    @Override
    public void removeComponent(PhysicalEntity component) {
        if (component != null) {
            this.component.remove(component);
            component.getComponentOf().remove(this);
        }
    }

    protected void setComponent(Set<PhysicalEntity> component) {
        this.component = component;
    }

    @Override
    public Set<Stoichiometry> getComponentStoichiometry() {
        return this.componentStoichiometry;
    }

    @Override
    public void addComponentStoichiometry(Stoichiometry stoichiometry) {
        if (stoichiometry != null) {
            this.componentStoichiometry.add(stoichiometry);
        }
    }

    @Override
    public void removeComponentStoichiometry(Stoichiometry stoichiometry) {
        if (stoichiometry != null) {
            this.componentStoichiometry.remove(stoichiometry);
        }
    }

    protected void setComponentStoichiometry(Set<Stoichiometry> stoichiometry) {
        this.componentStoichiometry = stoichiometry;
    }

    @Override
    public Set<SimplePhysicalEntity> getSimpleMembers() {
        return this.getSimpleMembers(BPCollections.I.createSet());
    }

    protected Set<SimplePhysicalEntity> getSimpleMembers(Set<SimplePhysicalEntity> set) {
        for (PhysicalEntity pe : this.getComponent()) {
            this.collectSimpleMembersRecursive(pe, set);
        }
        return set;
    }

    protected void collectSimpleMembersRecursive(PhysicalEntity pe, Set<SimplePhysicalEntity> set) {
        if (pe instanceof ComplexImpl && pe != this) {
            ((ComplexImpl)pe).collectSimpleMembersRecursive(pe, set);
        } else if (pe instanceof SimplePhysicalEntity) {
            set.add((SimplePhysicalEntity)pe);
        }
        for (PhysicalEntity mem : pe.getMemberPhysicalEntity()) {
            this.collectSimpleMembersRecursive(mem, set);
        }
    }

    @Override
    public Set<EntityReference> getMemberReferences() {
        Set<EntityReference> set = BPCollections.I.createSet();
        for (SimplePhysicalEntity spe : this.getSimpleMembers()) {
            EntityReference er = spe.getEntityReference();
            if (er == null) continue;
            set.add(er);
        }
        return set;
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        return element instanceof Complex && SetEquivalenceChecker.isEquivalent(this.getComponent(), ((Complex)element).getComponent()) && super.semanticallyEquivalent(element);
    }
}

