/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.txt2tab.behaviour;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import psidev.psi.mi.tab.converter.txt2tab.MitabLineException;
import psidev.psi.mi.tab.converter.txt2tab.behaviour.UnparseableLineBehaviour;

public class WriteToFileUnparseableLine
implements UnparseableLineBehaviour {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private File file;
    private BufferedWriter out;
    private boolean quietMode = true;

    public WriteToFileUnparseableLine(File file) {
        if (file == null) {
            throw new IllegalArgumentException("You must give a non null file.");
        }
        if (file.exists() && !file.canWrite()) {
            throw new IllegalArgumentException("Cannot write file: " + file.getAbsolutePath());
        }
        this.file = file;
    }

    public WriteToFileUnparseableLine(File file, boolean quietMode) {
        this(file);
        this.quietMode = quietMode;
    }

    public void closeFile() {
        block2: {
            try {
                this.out.close();
            }
            catch (IOException e) {
                if (this.quietMode) break block2;
                throw new RuntimeException("Error upon closing file: " + this.file.getAbsolutePath(), e);
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public void respond(String line, MitabLineException t) throws MitabLineException {
        block3: {
            try {
                if (this.out == null) {
                    this.out = new BufferedWriter(new FileWriter(this.file));
                }
                this.out.write(line);
                this.out.write(NEW_LINE);
                this.out.flush();
            }
            catch (IOException e) {
                if (this.quietMode) break block3;
                throw new RuntimeException("Error upon writing unparseable line to file: " + this.file.getAbsolutePath(), e);
            }
        }
    }

    public boolean propagateException() {
        return false;
    }
}

