/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.xml2tab;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.converter.IdentifierGenerator;
import psidev.psi.mi.tab.converter.tab2xml.XmlConversionException;
import psidev.psi.mi.tab.converter.xml2tab.CvConverter;
import psidev.psi.mi.tab.converter.xml2tab.InteractorConverter;
import psidev.psi.mi.tab.converter.xml2tab.NullCrossReference;
import psidev.psi.mi.tab.converter.xml2tab.PublicationConverter;
import psidev.psi.mi.tab.converter.xml2tab.TabConversionException;
import psidev.psi.mi.tab.converter.xml2tab.XrefUtils;
import psidev.psi.mi.tab.model.Annotation;
import psidev.psi.mi.tab.model.AnnotationImpl;
import psidev.psi.mi.tab.model.AuthorImpl;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.Checksum;
import psidev.psi.mi.tab.model.ChecksumImpl;
import psidev.psi.mi.tab.model.ConfidenceImpl;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.CrossReferenceImpl;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.tab.model.ParameterImpl;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.Bibref;
import psidev.psi.mi.xml.model.Confidence;
import psidev.psi.mi.xml.model.DbReference;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.InteractionDetectionMethod;
import psidev.psi.mi.xml.model.InteractionType;
import psidev.psi.mi.xml.model.Names;
import psidev.psi.mi.xml.model.Organism;
import psidev.psi.mi.xml.model.Parameter;
import psidev.psi.mi.xml.model.Participant;
import psidev.psi.mi.xml.model.Unit;
import psidev.psi.mi.xml.model.Xref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InteractionConverter<T extends BinaryInteraction<?>> {
    public static final String IDENTITY = "identity";
    public static final String IDENTITY_REF = "MI:0356";
    private static final Log log = LogFactory.getLog(InteractionConverter.class);
    private PublicationConverter pubConverter = new PublicationConverter();
    private Collection<CrossReference> sourceDatabases;
    private CvConverter cvConverter = new CvConverter();
    private Pattern FIRST_AUTHOR_REGEX = Pattern.compile("(\\w+(?:\\P{Ps}+)?)(?:\\((\\d{4})\\))?");
    private static final List<String> checksumNames = new ArrayList<String>(Arrays.asList("checksum", "smiles string", "standard inchi", "inchi key", "standard inchi key", "rogid", "rigid", "crogid", "crc", "crc64"));
    protected static final String IREFINDEX = "irefindex";
    private Collection<ExperimentDescription> experimentList = new ArrayList<ExperimentDescription>();
    private Collection<Interaction> interactions = null;

    public Collection<CrossReference> getSourceDatabase() {
        if (this.sourceDatabases == null) {
            this.sourceDatabases = new ArrayList<CrossReference>();
        }
        return this.sourceDatabases;
    }

    public void addSourceDatabase(CrossReference sourceDatabase) {
        if (sourceDatabase == null) {
            throw new IllegalArgumentException("You must give a non null source database.");
        }
        this.getSourceDatabase().add(sourceDatabase);
    }

    public BinaryInteraction toMitab(Interaction interaction2) throws TabConversionException {
        String text;
        int expCount;
        Iterator<Participant> pi;
        if (interaction2.getParticipants().size() > 2) {
            log.error("interaction (id:" + interaction2.getId() + ") could not be converted to MITAB25 as it does not have exactly 1 or 2 participants.");
            return null;
        }
        Participant pA = null;
        Participant pB = null;
        Interactor interactorA = null;
        Interactor interactorB = null;
        if (interaction2.getParticipants().size() == 1 && interaction2.isIntraMolecular()) {
            pi = interaction2.getParticipants().iterator();
            pA = pi.next();
            interactorA = this.getInteractorConverter().toMitab(pA);
        } else if (interaction2.getParticipants().size() == 1 && !interaction2.isIntraMolecular()) {
            pi = interaction2.getParticipants().iterator();
            pB = pA = pi.next();
            interactorA = this.getInteractorConverter().toMitab(pA);
            interactorB = this.getInteractorConverter().toMitab(pB);
            if (interactorA.getStoichiometry() != null && !interactorA.getStoichiometry().isEmpty()) {
                interactorB.setStoichiometry(Collections.singletonList(0));
                List<Annotation> annotations = interactorB.getAnnotations();
                ArrayList<Annotation> filterAnnotations = new ArrayList<Annotation>();
                for (Annotation annotation : annotations) {
                    if (annotation.getText().contains("Stoichiometry: ")) continue;
                    filterAnnotations.add(annotation);
                }
                interactorB.setAnnotations(filterAnnotations);
            }
        } else {
            pi = interaction2.getParticipants().iterator();
            pA = pi.next();
            pB = pi.next();
            interactorA = this.getInteractorConverter().toMitab(pA);
            interactorB = this.getInteractorConverter().toMitab(pB);
        }
        BinaryInteraction bi = this.newBinaryInteraction(interactorA, interactorB);
        if (this.sourceDatabases == null || this.sourceDatabases.isEmpty()) {
            if (interaction2.hasXref()) {
                Collection<DbReference> sourceRefs = XrefUtils.searchByType(interaction2.getXref(), "source reference", "MI:0685");
                String text2 = null;
                for (Attribute attr : interaction2.getAttributes()) {
                    if (!"source reference:label".equals(attr.getName())) continue;
                    text2 = attr.getValue();
                    break;
                }
                for (DbReference sourceRef : sourceRefs) {
                    String db = "unknown";
                    if (sourceRef.getId() != null && sourceRef.getId().startsWith("MI:")) {
                        db = "psi-mi";
                    }
                    CrossReferenceImpl xref2 = new CrossReferenceImpl(db, sourceRef.getId(), text2);
                    bi.getSourceDatabases().add(xref2);
                }
            }
        } else if (bi.getSourceDatabases().isEmpty()) {
            bi.getSourceDatabases().addAll(this.sourceDatabases);
        }
        if (interaction2.hasXref()) {
            Collection<DbReference> interactionAcs = XrefUtils.searchByType(interaction2.getXref(), IDENTITY, IDENTITY_REF);
            Iterator<DbReference> interactionAcsIter = interactionAcs.iterator();
            block3: while (interactionAcsIter.hasNext()) {
                DbReference identityRef = interactionAcsIter.next();
                for (CrossReference sourceDatabase : bi.getSourceDatabases()) {
                    if (sourceDatabase.getIdentifier().equals(identityRef.getDb()) || sourceDatabase.getIdentifier().equals(identityRef.getDbAc())) continue;
                    interactionAcsIter.remove();
                    continue block3;
                }
            }
            if (interactionAcs.isEmpty() && interaction2.hasXref()) {
                interactionAcs.add(interaction2.getXref().getPrimaryRef());
                log.warn("The interaction identifiers provided is not an identity in the original XML");
            }
            ArrayList<CrossReferenceImpl> refs = new ArrayList<CrossReferenceImpl>();
            for (DbReference interactionAc : interactionAcs) {
                refs.add(new CrossReferenceImpl(interactionAc.getDb(), interactionAc.getId()));
            }
            bi.getInteractionAcs().addAll(refs);
        }
        if (interaction2.hasInteractionTypes()) {
            ArrayList<CrossReference> types = new ArrayList<CrossReference>(interaction2.getInteractionTypes().size());
            for (InteractionType interactionType : interaction2.getInteractionTypes()) {
                CrossReference type = this.cvConverter.toMitab(interactionType);
                if (type != null) {
                    types.add(type);
                    continue;
                }
                log.warn("Failed to convert interaction type: " + interactionType);
            }
            if (!types.isEmpty()) {
                bi.setInteractionTypes(types);
            }
        }
        if ((expCount = interaction2.getExperiments().size()) > 0) {
            ArrayList<CrossReference> publications = new ArrayList<CrossReference>(expCount);
            bi.setPublications(publications);
            ArrayList<CrossReference> detections = new ArrayList<CrossReference>(expCount);
            bi.setDetectionMethods(detections);
            for (ExperimentDescription experiment : interaction2.getExperiments()) {
                CrossReference pub;
                CrossReference detection = this.cvConverter.toMitab(experiment.getInteractionDetectionMethod());
                if (detection != null) {
                    bi.getDetectionMethods().add(detection);
                }
                if (experiment.getBibref() != null && (pub = this.pubConverter.toMitab(experiment.getBibref())) != null) {
                    bi.getPublications().add(pub);
                }
                if (experiment.getAttributes() == null) continue;
                String authorName = "-";
                String pubYear = "";
                for (Attribute attribute : experiment.getAttributes()) {
                    if ("author-list".equals(attribute.getName())) {
                        authorName = attribute.getValue();
                        if (!authorName.contains(",")) continue;
                        authorName = authorName.split(" ")[0].concat(" et al");
                        continue;
                    }
                    if (!"publication year".equals(attribute.getName())) continue;
                    pubYear = "(" + attribute.getValue() + ")";
                }
                String authorNameYear = authorName + " " + pubYear;
                AuthorImpl author = new AuthorImpl(authorNameYear.trim());
                bi.getAuthors().add(author);
            }
        }
        for (Confidence confidence2 : interaction2.getConfidences()) {
            Unit unit = confidence2.getUnit();
            String type = null;
            String value = confidence2.getValue();
            text = null;
            if (unit != null) {
                if (unit.getNames() != null) {
                    type = unit.getNames().getShortLabel();
                    text = unit.getNames().getFullName();
                }
            } else {
                type = "unknown";
            }
            ConfidenceImpl tabConfidence = new ConfidenceImpl(type, value, text);
            bi.getConfidenceValues().add(tabConfidence);
        }
        ArrayList<Annotation> iAnnotations = new ArrayList<Annotation>();
        ArrayList<Checksum> iChecksums = new ArrayList<Checksum>();
        for (Attribute attribute : interaction2.getAttributes()) {
            String name = attribute.getName();
            text = attribute.getValue();
            if (checksumNames.contains(name.toLowerCase())) {
                iChecksums.add(new ChecksumImpl(name, text));
                continue;
            }
            iAnnotations.add(new AnnotationImpl(name, text));
        }
        if (!iAnnotations.isEmpty()) {
            bi.setAnnotations(iAnnotations);
        }
        if (!iChecksums.isEmpty()) {
            bi.setChecksums(iChecksums);
        }
        ArrayList<psidev.psi.mi.tab.model.Parameter> iParameters = new ArrayList<psidev.psi.mi.tab.model.Parameter>();
        for (Parameter parameter : interaction2.getParameters()) {
            iParameters.add(new ParameterImpl(parameter.getTerm(), parameter.getFactor(), parameter.getBase(), parameter.getExponent(), parameter.getUncertainty(), parameter.getUnit()));
        }
        if (!iParameters.isEmpty()) {
            bi.setParameters(iParameters);
        }
        bi.setNegativeInteraction(interaction2.isNegative());
        return bi;
    }

    public Collection<ExperimentDescription> getExperimentList() {
        return this.experimentList;
    }

    private DbReference getPrimaryRef(CrossReference interactionAc, CrossReference sourceReference) {
        DbReference primaryRef = null;
        if (interactionAc != null) {
            String id = interactionAc.getIdentifier();
            String db = interactionAc.getDatabase();
            primaryRef = new DbReference(id, db);
            if (sourceReference != null) {
                primaryRef.setDbAc(sourceReference.getIdentifier());
            }
            primaryRef.setRefType(IDENTITY);
            primaryRef.setRefTypeAc(IDENTITY_REF);
        }
        return primaryRef;
    }

    private Names getInteractionName(Interaction interaction2) {
        Names interactionName = null;
        Collection<Participant> participants = interaction2.getParticipants();
        for (Participant participant : participants) {
            if (interactionName != null) {
                String shortLabel = interactionName.getShortLabel().concat("-");
                shortLabel = shortLabel.concat(participant.getInteractor().getNames().getShortLabel().split("_")[0]);
                interactionName.setShortLabel(shortLabel);
            }
            if (interactionName != null) continue;
            interactionName = new Names();
            interactionName.setShortLabel(participant.getInteractor().getNames().getShortLabel().split("_")[0]);
        }
        if (interactionName == null) {
            log.warn("Interaction don't have a name");
        }
        return interactionName;
    }

    private Collection<ExperimentDescription> getExperimentDescriptions(T binaryInteraction, int index) throws XmlConversionException {
        String firstAuthor;
        ArrayList<ExperimentDescription> experimentDescriptions = new ArrayList<ExperimentDescription>();
        ExperimentDescription experimentDescription = null;
        Bibref bibref = null;
        Xref ref = null;
        Xref imexPrimary = null;
        if (binaryInteraction.getPublications().size() <= index) {
            log.warn("Size of InteractionAcs is " + binaryInteraction.getInteractionAcs().size() + " but we have only " + binaryInteraction.getPublications().size() + " publication(s)! -> We could not know which publication dependents on which InteractionAcs");
        } else {
            for (CrossReference xref2 : binaryInteraction.getPublications()) {
                if (xref2.getDatabase() != null && xref2.getDatabase().equalsIgnoreCase("pubmed") && bibref == null) {
                    bibref = this.pubConverter.fromMitab(xref2);
                    continue;
                }
                if (xref2.getDatabase() != null && xref2.getDatabase().equalsIgnoreCase("imex") && imexPrimary == null) {
                    imexPrimary = this.pubConverter.imexPrimaryFromMitab(xref2);
                    continue;
                }
                if (ref == null) {
                    DbReference primaryRef = new DbReference(xref2.getIdentifier(), xref2.getDatabase());
                    ref = new Xref(primaryRef);
                    continue;
                }
                DbReference secondaryRef = new DbReference(xref2.getIdentifier(), xref2.getDatabase());
                ref.getSecondaryRef().add(secondaryRef);
            }
        }
        InteractionDetectionMethod detectionMethod = null;
        if (binaryInteraction.getDetectionMethods().size() <= index) {
            log.warn("Size of InteractionAcs is " + binaryInteraction.getInteractionAcs().size() + " but we have only " + binaryInteraction.getDetectionMethods().size() + " detectionMethod(s)! -> We could not know which detectionMethode dependents on which InteractionAcs");
        } else {
            CrossReference binaryDetectionMethod = binaryInteraction.getDetectionMethods().get(index);
            detectionMethod = this.cvConverter.fromMitab(binaryDetectionMethod, InteractionDetectionMethod.class);
        }
        if (bibref != null && detectionMethod != null) {
            experimentDescription = new ExperimentDescription(bibref, detectionMethod);
            experimentDescription.setId(IdentifierGenerator.getInstance().nextId());
        }
        if (imexPrimary != null) {
            if (bibref == null) {
                experimentDescription = new ExperimentDescription(new Bibref(imexPrimary), detectionMethod);
                experimentDescription.setId(IdentifierGenerator.getInstance().nextId());
            } else {
                experimentDescription.setXref(imexPrimary);
            }
        }
        if (ref != null) {
            if (bibref == null) {
                experimentDescription = new ExperimentDescription(new Bibref(ref), detectionMethod);
                experimentDescription.setId(IdentifierGenerator.getInstance().nextId());
            } else if (imexPrimary == null) {
                experimentDescription.setXref(ref);
            } else {
                experimentDescription.getXref().getSecondaryRef().addAll(ref.getAllDbReferences());
            }
        }
        if (index < binaryInteraction.getAuthors().size() && !(firstAuthor = binaryInteraction.getAuthors().get(index).getName()).equals("-")) {
            String shortLabel;
            Names names = new Names();
            Matcher matcher = this.FIRST_AUTHOR_REGEX.matcher(firstAuthor);
            if (matcher.matches()) {
                firstAuthor = matcher.group(1).trim();
                shortLabel = firstAuthor.split(" ")[0];
                if (matcher.groupCount() > 1) {
                    String year = matcher.group(2);
                    shortLabel = shortLabel + "-" + year;
                    Attribute pubYear = new Attribute("publication year", year);
                    experimentDescription.getAttributes().add(pubYear);
                }
            } else {
                shortLabel = firstAuthor.split(" ")[0];
            }
            shortLabel = shortLabel.toLowerCase();
            names.setShortLabel(shortLabel);
            experimentDescription.setNames(names);
            Attribute authorList = new Attribute("author-list", firstAuthor);
            if (!experimentDescription.getAttributes().contains(authorList)) {
                experimentDescription.getAttributes().add(authorList);
            }
        }
        if (binaryInteraction.hasHostOrganism()) {
            CrossReference first;
            psidev.psi.mi.tab.model.Organism o = binaryInteraction.getHostOrganism();
            Iterator<CrossReference> idIterator = o.getIdentifiers().iterator();
            String shortlabel = null;
            if (idIterator.hasNext() && (first = idIterator.next()).hasText()) {
                shortlabel = first.getText();
            }
            int ncbiTaxId = 0;
            Organism xmlOrganism = null;
            if (o.getTaxid() != null) {
                try {
                    ncbiTaxId = Integer.parseInt(o.getTaxid());
                }
                catch (NumberFormatException e) {
                    String msg = "Could not parse taxid " + o.getTaxid() + ", it doesn't seem to be a valid integer value.";
                    throw new XmlConversionException(msg);
                }
                Names names = new Names();
                if (shortlabel != null) {
                    names.setShortLabel(shortlabel);
                } else {
                    switch (ncbiTaxId) {
                        case -1: {
                            names.setShortLabel("in vitro");
                            break;
                        }
                        case -2: {
                            names.setShortLabel("chemical synthesis");
                            break;
                        }
                        case -3: {
                            names.setShortLabel("unknown");
                            break;
                        }
                        case -4: {
                            names.setShortLabel("in vivo");
                            break;
                        }
                        case -5: {
                            names.setShortLabel("in silico");
                            break;
                        }
                        default: {
                            names.setShortLabel(String.valueOf(ncbiTaxId));
                        }
                    }
                }
                xmlOrganism = new Organism();
                xmlOrganism.setNcbiTaxId(ncbiTaxId);
                xmlOrganism.setNames(names);
            }
            if (xmlOrganism != null) {
                experimentDescription.getHostOrganisms().add(xmlOrganism);
            }
        } else {
            log.warn("The id of the host organism is not a NCBI id ");
        }
        if (!experimentDescriptions.contains(experimentDescription) && experimentDescription != null) {
            experimentDescriptions.add(experimentDescription);
        }
        return experimentDescriptions;
    }

    protected abstract BinaryInteraction newBinaryInteraction(Interactor var1, Interactor var2);

    public abstract InteractorConverter<?> getInteractorConverter();

    private Collection<InteractionType> getInteractionTypes(BinaryInteraction binaryInteraction) {
        ArrayList<InteractionType> types = null;
        if (binaryInteraction.getInteractionTypes() != null) {
            types = new ArrayList<InteractionType>(binaryInteraction.getInteractionTypes().size());
            List<CrossReference> tabInteractionTypes = binaryInteraction.getInteractionTypes();
            for (CrossReference interactionType : tabInteractionTypes) {
                InteractionType type = null;
                try {
                    type = this.cvConverter.fromMitab(interactionType, InteractionType.class);
                }
                catch (XmlConversionException e) {
                    e.printStackTrace();
                }
                if (type != null) {
                    if (types.contains(type)) continue;
                    types.add(type);
                    continue;
                }
                log.warn("Failed to convert interaction type: " + type);
            }
        }
        return types;
    }

    public Collection<Interaction> fromMitab(BinaryInteraction<?> binaryInteraction, Map<String, Collection<Participant>> interactionMap) throws IllegalAccessException, XmlConversionException {
        this.interactions = new ArrayList<Interaction>();
        HashSet<String> interactionAcs = new HashSet<String>();
        int numberOfInteraction = 1;
        List<CrossReference> acs = binaryInteraction.getInteractionAcs();
        if (acs.isEmpty()) {
            acs.add(new NullCrossReference(binaryInteraction));
        }
        StringBuilder interactionIdBuilder = new StringBuilder();
        CrossReference interactionAc = acs.get(0);
        interactionIdBuilder.append(interactionAc.getIdentifier());
        interactionIdBuilder.append("_");
        Object A = binaryInteraction.getInteractorA();
        Object B = binaryInteraction.getInteractorB();
        Object pA = null;
        Object pB = null;
        if (A != null && B != null) {
            interactionIdBuilder.append(((Interactor)binaryInteraction.getInteractorA()).getIdentifiers().iterator().next().getIdentifier());
            interactionIdBuilder.append("_");
            interactionIdBuilder.append(((Interactor)binaryInteraction.getInteractorB()).getIdentifiers().iterator().next().getIdentifier());
        } else if (A != null && !((Interactor)A).isEmpty()) {
            interactionIdBuilder.append(((Interactor)binaryInteraction.getInteractorA()).getIdentifiers().iterator().next().getIdentifier());
        } else if (B != null && !((Interactor)B).isEmpty()) {
            interactionIdBuilder.append(((Interactor)binaryInteraction.getInteractorB()).getIdentifiers().iterator().next().getIdentifier());
        } else {
            new XmlConversionException("Both interactors are null or empty , we can not convert the interaction");
        }
        String interactionId = interactionIdBuilder.toString();
        if (!interactionAcs.contains(interactionId)) {
            Boolean negativeInteraction;
            List<Checksum> checksums;
            List<psidev.psi.mi.tab.model.Parameter> parameters;
            List<Annotation> annotations;
            interactionAcs.add(interactionId);
            CrossReference source = binaryInteraction.getSourceDatabases().get(0);
            Interaction interaction2 = new Interaction();
            interaction2.setId(IdentifierGenerator.getInstance().nextId());
            boolean hasFoundImex = false;
            Xref xref2 = null;
            for (CrossReference ac : binaryInteraction.getInteractionAcs()) {
                DbReference secondaryRef;
                String database = ac.getDatabase();
                String id = ac.getIdentifier();
                if (database.equalsIgnoreCase("imex") && !hasFoundImex) {
                    hasFoundImex = true;
                    secondaryRef = new DbReference(database, "MI:0670", id, "imex-primary", "MI:0662");
                    if (xref2 == null) {
                        xref2 = new Xref(secondaryRef);
                        continue;
                    }
                    xref2.getSecondaryRef().add(secondaryRef);
                    continue;
                }
                secondaryRef = new DbReference(database, source.getIdentifier(), id, IDENTITY, IDENTITY_REF);
                if (xref2 == null) {
                    xref2 = new Xref(secondaryRef);
                    continue;
                }
                xref2.getSecondaryRef().add(secondaryRef);
            }
            interaction2.setXref(xref2);
            for (CrossReference sourceXref : binaryInteraction.getSourceDatabases()) {
                String id = sourceXref.getIdentifier();
                String refDbMi = null;
                String refDb = null;
                if (id.startsWith("MI:")) {
                    refDbMi = "MI:0488";
                    refDb = "psi-mi";
                }
                DbReference sourceReference = new DbReference(refDb, refDbMi, id, "source reference", "MI:0685");
                if (interaction2.getXref() == null) {
                    interaction2.setXref(new Xref(sourceReference));
                    continue;
                }
                interaction2.getXref().getSecondaryRef().add(sourceReference);
            }
            if (interactionMap.get(interactionId).size() >= 1) {
                for (Participant participant : interactionMap.get(interactionId)) {
                    interaction2.getParticipants().add(participant);
                }
            }
            if (this.getInteractionName(interaction2) != null) {
                Names interactionName = this.getInteractionName(interaction2);
                String shortLabel = interactionName.getShortLabel().concat("-".concat(String.valueOf(numberOfInteraction)));
                ++numberOfInteraction;
                interactionName.setShortLabel(shortLabel);
                interaction2.setNames(interactionName);
            }
            if (!this.getInteractionTypes(binaryInteraction).isEmpty()) {
                interaction2.getInteractionTypes().addAll(this.getInteractionTypes(binaryInteraction));
            }
            Collection<ExperimentDescription> experiments = this.getExperimentDescriptions(binaryInteraction, 0);
            for (ExperimentDescription experimentDescription : experiments) {
                interaction2.getExperiments().add(experimentDescription);
            }
            for (psidev.psi.mi.tab.model.Confidence tabConfidence : binaryInteraction.getConfidenceValues()) {
                Unit unit = new Unit();
                unit.setNames(new Names());
                unit.getNames().setShortLabel(tabConfidence.getType());
                if (tabConfidence.getText() != null) {
                    unit.getNames().setFullName(tabConfidence.getText());
                }
                Confidence confidence2 = new Confidence(unit, tabConfidence.getValue());
                interaction2.getConfidences().add(confidence2);
            }
            List<CrossReference> xrefs = binaryInteraction.getXrefs();
            if (xrefs != null && !xrefs.isEmpty()) {
                ArrayList<DbReference> secondaryRefs = new ArrayList<DbReference>();
                for (CrossReference xref22 : xrefs) {
                    String database = xref22.getDatabase();
                    String id = xref22.getIdentifier();
                    DbReference secondaryRef = new DbReference(database, null, id, null, null);
                    secondaryRefs.add(secondaryRef);
                }
                if (!secondaryRefs.isEmpty()) {
                    if (interaction2.getXref() == null) {
                        interaction2.setXref(new Xref());
                    }
                    interaction2.getXref().getSecondaryRef().addAll(secondaryRefs);
                }
            }
            if ((annotations = binaryInteraction.getAnnotations()) != null && !annotations.isEmpty()) {
                for (Annotation annotation : annotations) {
                    Attribute attribute = new Attribute(annotation.getTopic(), annotation.getText());
                    interaction2.getAttributes().add(attribute);
                }
            }
            if ((parameters = binaryInteraction.getParameters()) != null && !parameters.isEmpty()) {
                for (psidev.psi.mi.tab.model.Parameter parameter : parameters) {
                    String unit;
                    Parameter xmlParameter = new Parameter();
                    String parameterType = parameter.getType();
                    if (parameterType != null) {
                        xmlParameter.setTerm(parameter.getType());
                        if (parameterType.equalsIgnoreCase("kd")) {
                            xmlParameter.setTermAc("MI:0646");
                        } else if (parameterType.equalsIgnoreCase("ic50")) {
                            xmlParameter.setTermAc("MI:0641");
                        } else if (parameterType.equalsIgnoreCase("kcat")) {
                            xmlParameter.setTermAc("MI:0645");
                        }
                    }
                    if (parameter.getBase() != null) {
                        xmlParameter.setBase(parameter.getBase());
                    }
                    if (parameter.getExponent() != null) {
                        xmlParameter.setExponent(parameter.getExponent());
                    }
                    if (parameter.getFactor() != null) {
                        xmlParameter.setFactor(parameter.getFactor());
                    }
                    if ((unit = parameter.getUnit()) != null) {
                        xmlParameter.setUnit(parameter.getUnit());
                        if (unit.equalsIgnoreCase("molar")) {
                            xmlParameter.setUnitAc("MI:0648");
                        } else if (unit.equalsIgnoreCase("second -1")) {
                            xmlParameter.setUnitAc("IA:1721");
                        }
                    }
                    if (!interaction2.getExperiments().isEmpty()) {
                        xmlParameter.setExperiment(interaction2.getExperiments().iterator().next());
                    }
                    if (parameter.getUncertainty() != 0.0) {
                        xmlParameter.setUncertainty(parameter.getUncertainty());
                    }
                    interaction2.getParameters().add(xmlParameter);
                }
            }
            if ((checksums = binaryInteraction.getChecksums()) != null && !checksums.isEmpty()) {
                for (Checksum checksum : checksums) {
                    Attribute attribute = new Attribute(checksum.getMethodName(), checksum.getChecksum());
                    interaction2.getAttributes().add(attribute);
                }
            }
            if ((negativeInteraction = Boolean.valueOf(binaryInteraction.isNegativeInteraction())).booleanValue()) {
                interaction2.setNegative(negativeInteraction);
            }
            this.populateInteractionFromMitab(interaction2, binaryInteraction, 0);
            this.interactions.add(interaction2);
            Boolean intraMolecular = this.isIntraMolecular(binaryInteraction);
            if (intraMolecular.booleanValue()) {
                interaction2.setIntraMolecular(true);
            }
        }
        return this.interactions;
    }

    private Boolean isIntraMolecular(BinaryInteraction<?> binaryInteraction) {
        Object A = binaryInteraction.getInteractorA();
        Object B = binaryInteraction.getInteractorB();
        if (A == null && B != null && !((Interactor)B).isEmpty()) {
            return true;
        }
        if (B == null && A != null && !((Interactor)A).isEmpty()) {
            return true;
        }
        return false;
    }

    protected abstract void populateInteractionFromMitab(Interaction var1, BinaryInteraction<?> var2, int var3);
}

